/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IActivity;
import com.ti.debug.engine.IActivityProvider;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.IProfProperties;
import com.ti.debug.engine.events.data.IActivityEnableCompleteData;
import com.ti.debug.engine.events.data.IActivityEnabledEventData;
import com.ti.debug.engine.events.data.IProfStatusEventData;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.profileactivities.ActivityEnableCompleteEventData;
import com.ti.debug.engine.profileactivities.ActivityManagedObjectEvent;
import com.ti.debug.engine.profileactivities.ActivityOptionSet;
import com.ti.debug.engine.profileactivities.ActivityProviderServer;
import com.ti.debug.engine.profileactivities.ProfileActivityPropertySet;
import com.ti.debug.engine.profileactivities.ProfileActivityProvider;
import com.ti.debug.genericproperties.IProperties;
import com.ti.debug.genericproperties.IPropertyOperations;
import java.util.AbstractList;
import java.util.Vector;

public class ProfileActivity
implements IActivity,
ISimpleEventListener,
IObjectEventListener<IProfStatusEventData> {
    private ActivityOptionSet myActivityOptions;
    private boolean isActivityEnabled = false;
    private boolean isCollectorConnected = false;
    private IProfCollector myCollectorInstance = null;
    private IProfProperties myCollectorProps = null;
    ProfileActivityPropertySet activityProperties = null;
    private ProfileActivityProvider myProvider = null;
    private IDspUser myDspUser = null;
    private ActivityEnabledEventData activityEnabledEventData = null;
    ActivityManagedObjectEvent<IActivityEnableCompleteData> managedOnActivityEnableComplete = new ActivityManagedObjectEvent();

    ProfileActivity(IDspTask dspTask, IProfCollector collectorToUse, ActivityOptionSet activityOptions) {
        this.myDspUser = dspTask.createDspUser();
        this.myCollectorInstance = collectorToUse;
        this.myActivityOptions = activityOptions;
        this.updateConnectedStatus();
        this.myDspUser.onConnected().addISimpleEventListener(this);
        this.myDspUser.onDisconnected().addISimpleEventListener(this);
        try {
            this.myCollectorProps = this.myCollectorInstance.getProperties();
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            // empty catch block
        }
        this.activityEnabledEventData = this.extractMetaData(this.myActivityOptions.getMetaData());
        this.myCollectorInstance.onStatusChanged().addIObjectEventListener(this);
        this.activityProperties = new ProfileActivityPropertySet(this.myCollectorInstance, this.myActivityOptions.getEventClass(), this.myActivityOptions.getRequiredEvents());
        this.initializeActivityEvents();
    }

    @Override
    public void onEvent() {
        this.updateConnectedStatus();
        if (this.isConnected() && !this.activityProperties.initialized()) {
            this.initializeActivityEvents();
            if (!this.canEnable()) {
                this.detachFromDebugger();
            }
        }
    }

    @Override
    public void onEvent(IProfStatusEventData data) {
        if (!this.isEnabled()) {
            return;
        }
        IProfStatusEventData profData = data;
        if ((profData.getOldStatus() & 1) != 1 && (profData.getNewStatus() & 1) == 1 && profData.getErrorId() != 0) {
            String[] errors = this.myCollectorInstance.getErrorStringStack();
            for (int i = 0; i < errors.length; ++i) {
                errors[i].toLowerCase();
                if (!errors[i].toLowerCase().contains(this.myActivityOptions.getEventClass())) continue;
                this.disableActivity("Error configuring Activity on target: for this reason, the activity has been disabled.  No activity data will be collected");
                break;
            }
        }
    }

    private void initializeActivityEvents() {
        if (!this.isConnected()) {
            return;
        }
        if (this.activityProperties.initialized()) {
            return;
        }
        this.myActivityOptions.restrictOptionsToCurrentCollector(this.myCollectorInstance);
        this.activityProperties.initialize(this.myActivityOptions.getProperties(), this.myActivityOptions.getRequiredEvents());
    }

    private ActivityEnabledEventData extractMetaData(AbstractList<ActivityOptionSet.PropertyInfo> metaData) {
        String collectionType = "";
        String analysisType = "";
        for (ActivityOptionSet.PropertyInfo curPair : metaData) {
            if (curPair.getName().contentEquals("collectionType")) {
                collectionType = curPair.getValue();
                continue;
            }
            if (!curPair.getName().contentEquals("analysisType")) continue;
            analysisType = curPair.getValue();
        }
        return new ActivityEnabledEventData(this.myActivityOptions.getName(), collectionType, analysisType);
    }

    public String getAnalysisType() {
        return this.activityEnabledEventData.analysisType;
    }

    public AbstractList<String> getRequiredEvents() {
        return new Vector<String>(this.myActivityOptions.getRequiredEvents());
    }

    public void associateWithProvider(ProfileActivityProvider provider) {
        this.myProvider = provider;
        this.activityEnabledEventData.setProviderName(this.myProvider.getName());
    }

    @Override
    public boolean canEnable() {
        if (this.myCollectorInstance == null || !this.isConnected() || this.myActivityOptions.getRequiredEvents().size() == 0) {
            return false;
        }
        if (this.getCollectorStatus((short)2)) {
            return false;
        }
        return this.myProvider.canClaimDatatype(this.myActivityOptions.getEventClass());
    }

    private void updateConnectedStatus() {
        this.isCollectorConnected = this.getCollectorStatus((short)8);
        if (this.isConnected() && this.isEnabled()) {
            this.enableActivity();
        }
    }

    @Override
    public void enable(boolean toEnable) throws IActivity.ActivityException {
        if (toEnable == this.isEnabled()) {
            this.onActivityEnableComplete(this.isEnabled(), "Call to " + (this.isEnabled() ? "enable " : "disable ") + "activity succeeded");
            return;
        }
        if (!this.isConnected()) {
            this.onActivityEnableComplete(this.isEnabled(), "Unable to " + (this.isEnabled() ? "enable " : "disable ") + "status while disconnected from target ");
            return;
        }
        if (toEnable) {
            this.enableActivity();
        } else {
            this.disableActivity(null);
        }
    }

    private boolean isConnected() {
        return this.isCollectorConnected;
    }

    @Override
    public String getDescription() {
        return this.myActivityOptions.getDescription();
    }

    @Override
    public String getName() {
        return this.myActivityOptions.getName();
    }

    @Override
    public boolean isEnabled() {
        return this.isActivityEnabled;
    }

    private void setEnabled(boolean enabled) {
        this.isActivityEnabled = enabled;
    }

    public boolean getCollectorStatus(short statusToCheck) {
        int collectorStatus = 0;
        try {
            if (this.myCollectorInstance != null) {
                collectorStatus = this.myCollectorInstance.getCollectorStatus();
            }
        }
        catch (IProfCollectorServer.CollectorServerException collectorServerException) {
            // empty catch block
        }
        return (collectorStatus & statusToCheck) == statusToCheck;
    }

    private void enableActivity() {
        if (this.myCollectorInstance == null || this.myCollectorProps == null) {
            this.onActivityEnableComplete(this.isEnabled(), "Underlying debugger instance has been disposed");
            return;
        }
        if (!this.canEnable()) {
            this.onActivityEnableComplete(this.isEnabled(), "Unable to enable activity");
            return;
        }
        if (!this.myProvider.canClaimDatatype(this.myActivityOptions.getEventClass())) {
            this.onActivityEnableComplete(this.isEnabled(), "An activity of the same type is already in use");
            return;
        }
        if (this.getCollectorStatus((short)1)) {
            String strMessage = "Another activity is currently collecting data on the target.  This activity cannot be enabled until either that activity's data collection is complete or the activity is disabled.";
            this.onActivityEnableComplete(this.isEnabled(), strMessage);
            return;
        }
        try {
            this.activityProperties.applyPropertiesToCollector();
            if (!this.activityProperties.applyCollectorEvents(true)) {
                this.onActivityEnableComplete(this.isEnabled(), "Unable to enable activity: configured set of events unable to be applied");
                return;
            }
            this.myProvider.enableCollector();
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            this.onActivityEnableComplete(this.isEnabled(), "Unable to enable activity: " + e.getMessage());
        }
        this.myProvider.claimDatatype(this.myActivityOptions.getEventClass());
        this.setEnabled(true);
        this.onActivityEnableComplete(this.isEnabled(), "Activity successfully configured");
        this.activityEnabledEventData.setActivityEnabled(this.isEnabled());
        ActivityProviderServer.getActivityProviderServer().notifyListenersOfEnabledActivity(this.activityEnabledEventData);
    }

    private void disableActivity(String customMessage) {
        if (this.myCollectorInstance == null) {
            this.onActivityEnableComplete(this.isEnabled(), "Underlying debugger instance has been disposed");
            return;
        }
        if (!this.isConnected()) {
            this.onActivityEnableComplete(this.isEnabled(), "Unable to disable activity when target disconnected");
            return;
        }
        if (this.myActivityOptions.getRequiredEvents().size() == 0) {
            this.onActivityEnableComplete(this.isEnabled(), "Unable to disable activity: no target events available");
            return;
        }
        try {
            this.myProvider.disableCollector();
            this.activityProperties.applyCollectorEvents(false);
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            this.onActivityEnableComplete(this.isEnabled(), "Problem disabling activity: " + e.getMessage());
        }
        this.myProvider.unclaimDatatype(this.myActivityOptions.getEventClass());
        this.setEnabled(false);
        this.onActivityEnableComplete(this.isEnabled(), customMessage == null ? "Activity successfully disabled" : customMessage);
        this.activityEnabledEventData.setActivityEnabled(this.isEnabled());
        ActivityProviderServer.getActivityProviderServer().notifyListenersOfEnabledActivity(this.activityEnabledEventData);
    }

    public void detachFromDebugger() {
        if (this.myProvider != null) {
            try {
                this.myProvider.removeActivity(this);
            }
            catch (IActivityProvider.ActivityProviderException activityProviderException) {
                // empty catch block
            }
        }
        this.myDspUser.onDisconnected().removeISimpleEventListener(this);
        this.myDspUser.onConnected().removeISimpleEventListener(this);
        this.myCollectorInstance.onStatusChanged().removeIObjectEventListener(this);
        this.myCollectorInstance = null;
        this.myCollectorProps = null;
        this.myProvider = null;
        this.myDspUser = null;
        this.activityProperties.detachFromDebugger();
    }

    public void onActivityEnableComplete(boolean currentEnableState, String feedback) {
        ActivityEnableCompleteEventData eventData = new ActivityEnableCompleteEventData(currentEnableState, feedback, this);
        this.managedOnActivityEnableComplete.onEvent(eventData);
    }

    @Override
    public IObjectEvent onActivityEnableComplete() {
        return this.managedOnActivityEnableComplete;
    }

    @Override
    public boolean equalTo(IProperties otherProps) {
        return false;
    }

    @Override
    public void setProperties(IProperties properties) throws IPropertyOperations.PropertyException {
        this.activityProperties.setProperties(properties, this.isEnabled());
    }

    @Override
    public IProperties getProperties() {
        return this.activityProperties.getProperties();
    }

    private class ActivityEnabledEventData
    implements IActivityEnabledEventData {
        private final String dataSourceType = "ProfileDataSource";
        private String activityName;
        private String providerName;
        private String collectionType;
        private String analysisType;
        private boolean isEnabled = false;

        ActivityEnabledEventData(String activityName, String collectionType, String analysisType) {
            this.activityName = activityName;
            this.collectionType = collectionType;
            this.analysisType = analysisType;
        }

        public void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public void setActivityEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public boolean activityEnabled() {
            return this.isEnabled;
        }

        @Override
        public String activityName() {
            return this.activityName;
        }

        @Override
        public String activityProviderName() {
            return this.providerName;
        }

        @Override
        public String analysisType() {
            return this.analysisType;
        }

        @Override
        public String collectionType() {
            return this.collectionType;
        }

        @Override
        public String dataSourceType() {
            return "ProfileDataSource";
        }
    }
}

