/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IActivityProvider;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.profileactivities.ActivityOptionSet;
import com.ti.debug.engine.profileactivities.ProfileActivity;
import com.ti.debug.engine.profileactivities.ProfileActivityHelper;
import com.ti.debug.engine.profileactivities.ProfileActivityProvider;
import com.ti.utility.filesystem.DirectoryService;
import java.io.File;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ProfileActivityFactory {
    static ProfileActivityFactory INSTANCE;
    private final String sStoredActivityExtension = ".prof_ini";

    private ProfileActivityFactory() {
    }

    static ProfileActivityFactory getFactory() {
        if (INSTANCE == null) {
            INSTANCE = new ProfileActivityFactory();
        }
        return INSTANCE;
    }

    public void generateActivities(IDspTask dspTask, ProfileActivityProvider provider) {
        File activityDirectory = new File(DirectoryService.instance().getProfileActivitiesDir());
        Set<Map.Entry<String, AbstractList<ProfileActivity>>> allActivities = this.generateAllActivities(dspTask, activityDirectory);
        this.removeDuplicateActivities(provider, allActivities);
    }

    private Set<Map.Entry<String, AbstractList<ProfileActivity>>> generateAllActivities(IDspTask dspTask, File activityDirectory) {
        HashMap<String, Vector<ProfileActivity>> validActivityMap = new HashMap<String, Vector<ProfileActivity>>();
        String[] children = activityDirectory.list();
        if (children == null) {
            return validActivityMap.entrySet();
        }
        for (int i = 0; i < children.length; ++i) {
            ActivityOptionSet curActivity;
            if (!children[i].endsWith(".prof_ini") || (curActivity = new ActivityOptionSet(new File(activityDirectory + File.separator + children[i]))).isEmpty()) continue;
            try {
                ProfileActivity activity = this.generateActivity(dspTask, curActivity);
                Vector<ProfileActivity> activities = (Vector<ProfileActivity>)validActivityMap.get(activity.getAnalysisType());
                if (activities == null) {
                    activities = new Vector<ProfileActivity>();
                    validActivityMap.put(activity.getAnalysisType(), activities);
                }
                ((AbstractList)activities).add(activity);
                continue;
            }
            catch (ProfileActivityFactoryException e) {
                // empty catch block
            }
        }
        return validActivityMap.entrySet();
    }

    private void removeDuplicateActivities(ProfileActivityProvider provider, Set<Map.Entry<String, AbstractList<ProfileActivity>>> allActivities) {
        for (Map.Entry<String, AbstractList<ProfileActivity>> curSet : allActivities) {
            this.reduceActivitySet(curSet);
            assert (curSet.getValue().size() == 1);
            ProfileActivity remainingActivity = curSet.getValue().get(0);
            try {
                provider.addActivity(remainingActivity);
            }
            catch (IActivityProvider.ActivityProviderException e) {
                continue;
            }
            remainingActivity.associateWithProvider(provider);
        }
    }

    private void reduceActivitySet(Map.Entry<String, AbstractList<ProfileActivity>> activitySet) {
        String strFunctionProfiling = "Function Profile";
        String activityType = activitySet.getKey();
        AbstractList<ProfileActivity> activityList = activitySet.getValue();
        if (activityList.size() == 1) {
            return;
        }
        assert (activityList.size() > 1);
        if (activityType.contentEquals("Function Profile")) {
            String[] eventPrecedence;
            for (String curPreferredEvent : eventPrecedence = new String[]{"cycle.Total", "cycle.CPU", "CPU.instruction.decoded"}) {
                for (ProfileActivity curActivity : activityList) {
                    AbstractList<String> activityEvents = curActivity.getRequiredEvents();
                    for (String curEvent : activityEvents) {
                        if (!curEvent.contains(curPreferredEvent)) continue;
                        for (ProfileActivity toDispose : activityList) {
                            if (toDispose == curActivity) continue;
                            toDispose.detachFromDebugger();
                        }
                        activityList.clear();
                        activityList.add(curActivity);
                        return;
                    }
                }
            }
            assert (false);
        }
        ProfileActivity holdActivity = activityList.get(0);
        for (int i = 1; i < activityList.size(); ++i) {
            activityList.get(i).detachFromDebugger();
        }
        activityList.clear();
        activityList.add(holdActivity);
    }

    private ProfileActivity generateActivity(IDspTask dspTask, ActivityOptionSet activityOptions) throws ProfileActivityFactoryException {
        if (activityOptions.isEmpty()) {
            return null;
        }
        AbstractList<String> events = activityOptions.getEvents();
        if (events.size() == 0) {
            throw new ProfileActivityFactoryException("Cannot generate activity: no events available");
        }
        if (!activityOptions.supportsISA(dspTask)) {
            throw new ProfileActivityFactoryException("Cannot generate activity: activity not supported on current ISA");
        }
        IProfCollector curCollector = null;
        try {
            curCollector = ProfileActivityHelper.getProfCollector(dspTask, (short)0);
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            return null;
        }
        if (activityOptions.isHardwareSpecific()) {
            return new ProfileActivity(dspTask, curCollector, activityOptions);
        }
        activityOptions.restrictOptionsToCurrentCollector(curCollector);
        if (!activityOptions.isActivityOptionSetValid()) {
            throw new ProfileActivityFactoryException("Cannot generate activity: activity options not valid on current target");
        }
        return new ProfileActivity(dspTask, curCollector, activityOptions);
    }

    private final class ProfileActivityFactoryException
    extends Exception {
        private static final long serialVersionUID = 3102500555958678095L;

        public ProfileActivityFactoryException(String message) {
            super(message);
        }
    }
}

