/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.IProfProperties;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Vector;

public class ProfileActivityHelper {
    public static IProfCollector getProfCollector(IDspTask dspTask, short configMode) throws IProfCollectorServer.CollectorServerException {
        IProfCollectorServer profCollectorServer = null;
        IProfCollector holdCollector = null;
        profCollectorServer = dspTask.getCollectorServer();
        try {
            holdCollector = profCollectorServer.openConnection(configMode);
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            profCollectorServer.dispose();
            throw e;
        }
        profCollectorServer.dispose();
        return holdCollector;
    }

    public static AbstractList<String> generateCollectorEvents(IProfProperties propEvents) {
        Vector<String> events = new Vector<String>(200, 20);
        try {
            IProfProperties.PropertyKeyValuePair[] datatypes = propEvents.readProperty("dataclass", (short)0);
            for (int i = 0; datatypes != null && i < datatypes.length; ++i) {
                events.addAll(ProfileActivityHelper.extractAllChildren("dataclass." + datatypes[i].getPropertyKeyName() + ".events", propEvents));
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            events.clear();
        }
        events.trimToSize();
        Collections.sort(events);
        return events;
    }

    public static AbstractList<String> generateCollectorEvents(IProfProperties propEvents, String dataclass) {
        Vector<String> events = new Vector<String>(200, 20);
        events.addAll(ProfileActivityHelper.extractAllChildren("dataclass." + dataclass + ".events", propEvents));
        events.trimToSize();
        Collections.sort(events);
        return events;
    }

    private static AbstractList<String> extractAllChildren(String currentNode, IProfProperties props) {
        Vector<String> events = new Vector<String>(10, 10);
        try {
            IProfProperties.PropertyKeyValuePair[] children = props.readProperty(currentNode, (short)0);
            for (int i = 0; children != null && i < children.length; ++i) {
                events.addAll(ProfileActivityHelper.extractAllChildren(currentNode + "." + children[i].getPropertyKeyName(), props));
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            // empty catch block
        }
        try {
            IProfProperties.PropertyKeyValuePair[] nodeEvents = props.readProperty(currentNode, (short)8);
            for (int i = 0; nodeEvents != null && i < nodeEvents.length; ++i) {
                events.add(currentNode + "." + nodeEvents[i].getPropertyKeyName());
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            // empty catch block
        }
        events.trimToSize();
        return events;
    }
}

