/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.IProfProperties;
import com.ti.debug.engine.genericproperties.impl.ActivityBooleanProperty;
import com.ti.debug.engine.genericproperties.impl.ActivityProperties;
import com.ti.debug.engine.genericproperties.impl.ActivityProperty;
import com.ti.debug.engine.profileactivities.ActivityOptionSet;
import com.ti.debug.engine.profileactivities.CollectorPropertyConverter;
import com.ti.debug.engine.profileactivities.ProfileActivityHelper;
import com.ti.debug.engine.profileactivities.ProfileCollectorProperty;
import com.ti.debug.genericproperties.IBooleanProperty;
import com.ti.debug.genericproperties.IIntegerProperty;
import com.ti.debug.genericproperties.IProperties;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IPropertyOperations;
import com.ti.debug.genericproperties.IStringProperty;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ProfileActivityPropertySet {
    private static final String DATACLASS_NODE = "dataclass";
    private static final String EVENTS_NODE = "events";
    private Map<String, PropertyPOD> activityAttribs = null;
    private boolean bAmInitialized = false;
    private IProfProperties myCollectorProps = null;
    private IProfCollector myCollectorInstance = null;
    private AbstractList<String> configuredEvents = null;
    private AbstractList<String> availableEvents = null;
    private AbstractList<String> requiredEvents = null;
    private final String eventPropertyRoot = "Events";
    private final String attributePropertyRoot = "Collection Options";
    private final String myEventClass;

    ProfileActivityPropertySet(IProfCollector collectorInstance, String strEventClass, AbstractList<String> requiredEvents) {
        this.myCollectorInstance = collectorInstance;
        this.myEventClass = strEventClass;
        this.requiredEvents = new Vector<String>(requiredEvents.size());
        this.requiredEvents.addAll(requiredEvents);
        this.configuredEvents = new Vector<String>(requiredEvents.size());
        this.configuredEvents.addAll(this.requiredEvents);
        try {
            this.myCollectorProps = this.myCollectorInstance.getProperties();
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            // empty catch block
        }
    }

    public void detachFromDebugger() {
        this.myCollectorInstance = null;
    }

    public boolean initialized() {
        return this.bAmInitialized && this.myCollectorInstance != null;
    }

    public void initialize(AbstractList<ActivityOptionSet.PropertyInfo> activityProperties, AbstractList<String> requiredEvents) {
        if (this.initialized()) {
            return;
        }
        this.requiredEvents = new Vector<String>(requiredEvents.size());
        this.requiredEvents.addAll(requiredEvents);
        this.configuredEvents = new Vector<String>(requiredEvents.size());
        this.configuredEvents.addAll(this.requiredEvents);
        this.availableEvents = ProfileActivityHelper.generateCollectorEvents(this.myCollectorProps, this.myEventClass);
        this.activityAttribs = new HashMap<String, PropertyPOD>();
        AbstractList<ProfileCollectorProperty> allAttributes = this.generateCollectorAttributesProps(this.myCollectorProps);
        block0: for (ActivityOptionSet.PropertyInfo curActivityAttrib : activityProperties) {
            for (ProfileCollectorProperty holdProperty : allAttributes) {
                if (!holdProperty.getFullPropertyPath().contentEquals(curActivityAttrib.getName())) continue;
                if (curActivityAttrib.hasValue()) {
                    holdProperty.setValue(curActivityAttrib.getValue());
                }
                holdProperty.setReadOnly(!curActivityAttrib.canModifyValue());
                this.activityAttribs.put(holdProperty.getName(), new PropertyPOD(holdProperty));
                continue block0;
            }
        }
        block2: for (ActivityOptionSet.PropertyInfo curAttribute : activityProperties) {
            String strDependent = curAttribute.getDependent();
            if (strDependent == null) continue;
            Collection<PropertyPOD> activityAttributes = this.activityAttribs.values();
            PropertyPOD dependee = null;
            for (PropertyPOD curActivityAttribute : activityAttributes) {
                if (!curActivityAttribute.getProfileCollectorProperty().getFullPropertyPath().contentEquals(curAttribute.getName())) continue;
                dependee = curActivityAttribute;
                break;
            }
            if (dependee == null) continue;
            for (PropertyPOD curActivityAttribute : activityAttributes) {
                if (!curActivityAttribute.getProfileCollectorProperty().getFullPropertyPath().contentEquals(strDependent)) continue;
                dependee.setDependent(curActivityAttribute.getProfileCollectorProperty().getName());
                continue block2;
            }
        }
        this.bAmInitialized = true;
    }

    public void setProperties(IProperties properties, boolean bIsActivityEnabled) throws IPropertyOperations.PropertyException {
        if (!this.initialized() || properties == null) {
            return;
        }
        for (int i = 0; i < properties.getCount(); ++i) {
            try {
                IProperty curProp = properties.getItem(i);
                if (curProp.getName().contentEquals("Events")) {
                    this.applyProfileEvents(curProp, bIsActivityEnabled);
                    continue;
                }
                if (!curProp.getName().contentEquals("Collection Options")) continue;
                this.applyAttributes(curProp);
                continue;
            }
            catch (IPropertyOperations.PropertyException e) {
                // empty catch block
            }
        }
    }

    public IProperties getProperties() {
        ActivityProperties rootNode;
        block12: {
            block11: {
                rootNode = new ActivityProperties();
                if (!this.initialized()) {
                    return rootNode;
                }
                ActivityProperty eventRootNode = new ActivityProperty("Events", "Target events for which data can be collected", null, false, false);
                this.generateEventProperties(eventRootNode, "dataclass." + this.myEventClass + '.' + EVENTS_NODE);
                if (eventRootNode.getSubProperties().getCount() != 0) {
                    try {
                        rootNode.addProperty(eventRootNode);
                    }
                    catch (IPropertyOperations.PropertyException e) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError();
                    }
                }
            }
            ActivityProperty attributeRootNode = new ActivityProperty("Collection Options", "Options available for customizing data collection for the Profiling Activity", null, false, false);
            if (this.activityAttribs.size() != 0) {
                boolean bIsCollecting = this.getCollectorStatus((short)1);
                for (Map.Entry<String, PropertyPOD> curActivityAttrib : this.activityAttribs.entrySet()) {
                    try {
                        PropertyPOD dependentProp;
                        PropertyPOD curProperty = curActivityAttrib.getValue();
                        String strDependentProp = curProperty.getDependent();
                        if (strDependentProp != null && (dependentProp = this.activityAttribs.get(strDependentProp)) != null && dependentProp.getProfileCollectorProperty().getValue().contentEquals("0")) continue;
                        attributeRootNode.addProperty(CollectorPropertyConverter.collectorPropToActivityProp(bIsCollecting, curActivityAttrib.getValue().getProfileCollectorProperty(), attributeRootNode));
                    }
                    catch (IPropertyOperations.PropertyException e) {}
                }
                if (attributeRootNode.getSubProperties().getCount() != 0) {
                    try {
                        rootNode.addProperty(attributeRootNode);
                    }
                    catch (IPropertyOperations.PropertyException e) {
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError();
                    }
                }
            }
        }
        return rootNode;
    }

    public boolean applyPropertiesToCollector() {
        if (!this.initialized()) {
            return false;
        }
        for (Map.Entry<String, PropertyPOD> curActivityAttrib : this.activityAttribs.entrySet()) {
            ProfileCollectorProperty curProp = curActivityAttrib.getValue().getProfileCollectorProperty();
            this.setCollectorPropertyValue(curProp, curProp.getValue());
        }
        return true;
    }

    public boolean applyCollectorEvents(boolean bAddEvents) {
        return this.applyCollectorEvents(bAddEvents, this.configuredEvents);
    }

    private void applyProfileEvents(IProperty eventPropertyRoot, boolean bIsActivityEnabled) {
        if (this.getCollectorStatus((short)1)) {
            return;
        }
        Vector<String> enabledEvents = new Vector<String>();
        Vector<String> disabledEvents = new Vector<String>();
        this.extractProfileEvents(eventPropertyRoot, enabledEvents, disabledEvents);
        try {
            if (bIsActivityEnabled && this.applyCollectorEvents(false, disabledEvents) && this.applyCollectorEvents(true, enabledEvents) || !bIsActivityEnabled && this.myCollectorInstance.isProfileEventSetValid(this.generateProfileEventsFromStrings(enabledEvents))) {
                this.configuredEvents.clear();
                this.configuredEvents.addAll(enabledEvents);
                Collections.sort(this.configuredEvents);
            }
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            // empty catch block
        }
    }

    private void extractProfileEvents(IProperty eventPropertyRoot, AbstractList<String> enabledEvents, AbstractList<String> disabledEvents) {
        IProperties subProps = eventPropertyRoot.getSubProperties();
        for (int i = 0; i < subProps.getCount(); ++i) {
            IProperty curSubProp;
            try {
                curSubProp = subProps.getItem(i);
            }
            catch (IPropertyOperations.PropertyException e) {
                continue;
            }
            this.extractEventsFromTree(curSubProp, "dataclass." + this.myEventClass + '.' + EVENTS_NODE, enabledEvents, disabledEvents);
        }
        Collections.sort(enabledEvents);
        Vector<String> requiredEventsToAdd = new Vector<String>();
        for (String strRequiredEvent : this.requiredEvents) {
            if (Collections.binarySearch(enabledEvents, strRequiredEvent) >= 0) continue;
            requiredEventsToAdd.add(strRequiredEvent);
        }
        enabledEvents.addAll(requiredEventsToAdd);
    }

    private void extractEventsFromTree(IProperty curEventProp, String strParentRoot, AbstractList<String> enabledEvents, AbstractList<String> disabledEvents) {
        IProperties subProps = curEventProp.getSubProperties();
        if (subProps.getCount() != 0) {
            for (int i = 0; i < subProps.getCount(); ++i) {
                IProperty curSubProp;
                try {
                    curSubProp = subProps.getItem(i);
                }
                catch (IPropertyOperations.PropertyException e) {
                    continue;
                }
                this.extractEventsFromTree(curSubProp, strParentRoot + '.' + curEventProp.getName(), enabledEvents, disabledEvents);
            }
        } else if (curEventProp instanceof IBooleanProperty) {
            IBooleanProperty eventNode = (IBooleanProperty)curEventProp;
            String strFullEventString = strParentRoot + '.' + eventNode.getName();
            if (Collections.binarySearch(this.availableEvents, strFullEventString) >= 0) {
                if (eventNode.getValue()) {
                    enabledEvents.add(strFullEventString);
                } else {
                    disabledEvents.add(strFullEventString);
                }
            }
        }
    }

    private boolean applyCollectorEvents(boolean bAddEvents, AbstractList<String> eventsToApply) {
        if (!this.initialized()) {
            return false;
        }
        try {
            short desiredAction = bAddEvents ? (short)0 : 1;
            IProfCollector.ProfileEvent[] propertyEventArray = this.generateProfileEventsFromStrings(eventsToApply);
            if (bAddEvents && !this.myCollectorInstance.isProfileEventSetValid(propertyEventArray)) {
                return false;
            }
            this.myCollectorInstance.modifyProfileEvents(desiredAction, propertyEventArray);
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            return false;
        }
        return true;
    }

    private void applyAttributes(IProperty attributePropertyRoot) {
        ProfileCollectorProperty knownProperty;
        PropertyPOD knownPropertyPOD = this.activityAttribs.get(attributePropertyRoot.getName());
        ProfileCollectorProperty profileCollectorProperty = knownProperty = knownPropertyPOD == null ? null : knownPropertyPOD.getProfileCollectorProperty();
        if (knownProperty != null && !knownProperty.isReadOnly()) {
            String strValueToSet;
            IProperty castProp;
            String knownValidValue = knownProperty.getValidValue();
            if (knownValidValue.charAt(0) == 'i' && attributePropertyRoot instanceof IIntegerProperty) {
                castProp = (IIntegerProperty)attributePropertyRoot;
                strValueToSet = Long.toString(castProp.getValue());
                if (this.setCollectorPropertyValue(knownProperty, strValueToSet)) {
                    knownProperty.setValue(strValueToSet);
                }
            } else if (knownValidValue.charAt(0) == 'b' && attributePropertyRoot instanceof IBooleanProperty) {
                castProp = (IBooleanProperty)attributePropertyRoot;
                String string = strValueToSet = castProp.getValue() ? "1" : "0";
                if (this.setCollectorPropertyValue(knownProperty, strValueToSet)) {
                    knownProperty.setValue(strValueToSet);
                }
            } else if (knownValidValue.charAt(0) == 's' && attributePropertyRoot instanceof IStringProperty && this.setCollectorPropertyValue(knownProperty, strValueToSet = (castProp = (IStringProperty)attributePropertyRoot).getValue())) {
                knownProperty.setValue(strValueToSet);
            }
        }
        IProperties subProps = attributePropertyRoot.getSubProperties();
        for (int i = 0; i < subProps.getCount(); ++i) {
            try {
                this.applyAttributes(subProps.getItem(i));
                continue;
            }
            catch (IPropertyOperations.PropertyException e) {
                // empty catch block
            }
        }
    }

    private boolean setCollectorPropertyValue(ProfileCollectorProperty propToSet, String strNewValue) {
        if (this.myCollectorProps == null) {
            return false;
        }
        if (this.getCollectorStatus((short)1)) {
            return false;
        }
        IProfProperties.PropertyKeyValuePair[] toSet = new IProfProperties.PropertyKeyValuePair[]{new IProfProperties.PropertyKeyValuePair(propToSet.getName(), strNewValue)};
        try {
            this.myCollectorProps.setProperty(propToSet.getParent(), (short)8, toSet);
        }
        catch (IProfProperties.ProfPropertiesException e) {
            return false;
        }
        return true;
    }

    private boolean getCollectorStatus(short statusToCheck) {
        int collectorStatus = 0;
        try {
            if (this.myCollectorInstance != null) {
                collectorStatus = this.myCollectorInstance.getCollectorStatus();
            }
        }
        catch (IProfCollectorServer.CollectorServerException collectorServerException) {
            // empty catch block
        }
        return (collectorStatus & statusToCheck) == statusToCheck;
    }

    private void generateEventProperties(ActivityProperty parentProperty, String currentNode) {
        if (this.myCollectorProps == null) {
            return;
        }
        IProfProperties.PropertyKeyValuePair[] children = null;
        try {
            for (IProfProperties.PropertyKeyValuePair curPair : children = this.myCollectorProps.readProperty(currentNode, (short)0)) {
                String curChildNodePath = currentNode + "." + curPair.getPropertyKeyName();
                ActivityProperty newProperty = new ActivityProperty(curPair.getPropertyKeyName(), "Expand the property subtree to see the full list of Profile Events available under this node", parentProperty, false, false);
                this.generateEventProperties(newProperty, curChildNodePath);
                if (newProperty.getSubProperties().getCount() == 0) {
                    newProperty.setEditable(true);
                }
                try {
                    parentProperty.addProperty(newProperty);
                }
                catch (IPropertyOperations.PropertyException e) {
                    // empty catch block
                }
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            // empty catch block
        }
        try {
            IProfProperties.PropertyKeyValuePair[] endNodes;
            for (IProfProperties.PropertyKeyValuePair curPropPair : endNodes = this.myCollectorProps.readProperty(currentNode, (short)8)) {
                String curChildNodePath = currentNode + "." + curPropPair.getPropertyKeyName();
                ActivityBooleanProperty newProperty = null;
                try {
                    boolean bEventSelected;
                    String propDescription = currentNode + "." + curPropPair.getPropertyKeyName();
                    propDescription = propDescription.substring(propDescription.indexOf(46) + 1, propDescription.length());
                    propDescription = propDescription.substring(propDescription.indexOf(46) + 1, propDescription.length());
                    propDescription = propDescription.substring(propDescription.indexOf(46) + 1, propDescription.length());
                    propDescription = "Profile the target for the " + propDescription + " event.  ";
                    boolean bModifiable = true;
                    boolean bIsRequiredEvent = Collections.binarySearch(this.requiredEvents, curChildNodePath) >= 0;
                    boolean bl = bEventSelected = Collections.binarySearch(this.configuredEvents, curChildNodePath) >= 0;
                    if (this.getCollectorStatus((short)1)) {
                        bModifiable = false;
                        String cannotModifyWhileCollecting = "\nActivity properties cannot be modified while profiling is occuring: disable this activity if you wish to modify the property.";
                        propDescription = propDescription + "\nActivity properties cannot be modified while profiling is occuring: disable this activity if you wish to modify the property.";
                    } else if (bIsRequiredEvent) {
                        bModifiable = false;
                        propDescription = propDescription + "\nThis event is required for profiling and cannot be modified.";
                    } else if (this.areMaximumEventsSelected() && !bEventSelected) {
                        bModifiable = false;
                        propDescription = propDescription + "\nThe maximum number of events that can be profiled at one time has been reached.  Please disable another selected event if you wish to enable this event.";
                    }
                    boolean bValue = bIsRequiredEvent || bEventSelected;
                    newProperty = new ActivityBooleanProperty(curPropPair.getPropertyKeyName(), propDescription, parentProperty, !bModifiable, bModifiable, bValue);
                }
                catch (IPropertyOperations.PropertyException e) {
                    continue;
                }
                try {
                    parentProperty.addProperty(newProperty);
                }
                catch (IPropertyOperations.PropertyException e) {
                    // empty catch block
                }
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            // empty catch block
        }
    }

    boolean areMaximumEventsSelected() {
        PropertyPOD maxEvent = this.activityAttribs.get("Maximum Events");
        if (maxEvent == null) {
            return false;
        }
        return this.configuredEvents.size() >= Integer.parseInt(maxEvent.getProfileCollectorProperty().getValue());
    }

    public AbstractList<ProfileCollectorProperty> generateCollectorAttributesProps(IProfProperties propAttributes) {
        Vector<ProfileCollectorProperty> attributes = new Vector<ProfileCollectorProperty>(200, 20);
        try {
            IProfProperties.PropertyKeyValuePair[] datatypes = propAttributes.readProperty(DATACLASS_NODE, (short)0);
            for (int i = 0; datatypes != null && i < datatypes.length; ++i) {
                IProfProperties.PropertyKeyValuePair[] nodeValues = propAttributes.readProperty("dataclass." + datatypes[i].getPropertyKeyName(), (short)8);
                IProfProperties.PropertyKeyValuePair[] nodeDescriptions = propAttributes.readProperty("dataclass." + datatypes[i].getPropertyKeyName(), (short)10);
                IProfProperties.PropertyKeyValuePair[] nodeValidValues = propAttributes.readProperty("dataclass." + datatypes[i].getPropertyKeyName(), (short)11);
                for (int j = 0; nodeValues != null && j < nodeValues.length; ++j) {
                    attributes.add(new ProfileCollectorProperty(nodeValues[j].getPropertyKeyName(), "dataclass." + datatypes[i].getPropertyKeyName(), nodeDescriptions[j].getPropertyValue(), nodeValues[j].getPropertyValue(), nodeValidValues[j].getPropertyValue(), false));
                }
            }
        }
        catch (IProfProperties.ProfPropertiesException e) {
            attributes.clear();
        }
        attributes.trimToSize();
        return attributes;
    }

    public AbstractList<String> getConfiguredEvents() {
        return this.configuredEvents;
    }

    public IProfCollector.ProfileEvent[] generateProfileEventsFromStrings(AbstractList<String> stringEvents) {
        IProfCollector.ProfileEvent[] profEvents = new IProfCollector.ProfileEvent[stringEvents.size()];
        for (int i = 0; i < stringEvents.size(); ++i) {
            String strEvent = stringEvents.get(i);
            strEvent = strEvent.substring(strEvent.indexOf(46) + 1, strEvent.length());
            int nextPeriod = strEvent.indexOf(46);
            int eventPosition = strEvent.indexOf("events.") + 7;
            profEvents[i] = new IProfCollector.ProfileEvent(strEvent.substring(0, nextPeriod), strEvent.substring(eventPosition, strEvent.length()));
        }
        return profEvents;
    }

    private class PropertyPOD {
        private ProfileCollectorProperty currentProp = null;
        private String dependent = null;

        PropertyPOD(ProfileCollectorProperty associatedProp) {
            this.currentProp = associatedProp;
        }

        ProfileCollectorProperty getProfileCollectorProperty() {
            return this.currentProp;
        }

        public void setDependent(String strDependent) {
            this.dependent = strDependent;
        }

        public String getDependent() {
            return this.dependent;
        }
    }
}

