/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IActivity;
import com.ti.debug.engine.IActivityProvider;
import com.ti.debug.engine.IActivityProviderServer;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IProfCollector;
import com.ti.debug.engine.IProfCollectorServer;
import com.ti.debug.engine.events.impl.StringEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.events.types.IStringEvent;
import com.ti.debug.engine.profileactivities.ActivityProviderServer;
import com.ti.debug.engine.profileactivities.BreakpointBasedControlPoints;
import com.ti.debug.engine.profileactivities.ProfileActivity;
import com.ti.debug.engine.profileactivities.ProfileActivityFactory;
import com.ti.debug.engine.profileactivities.ProfileActivityHelper;
import com.ti.debug.genericproperties.IProperties;
import java.util.AbstractList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;

public class ProfileActivityProvider
extends BreakpointBasedControlPoints
implements IActivityProvider {
    private Vector<ProfileActivity> activitySet = new Vector(10, 5);
    private IDspUser myDspUser = null;
    private IDspTask myDspTask = null;
    private IProfCollector myCollector = null;
    private String myName = null;
    private String myTaskName = null;
    private AbstractList<String> datatypesInUse = new LinkedList<String>();
    private StringEvent managedOnActivityAdded;
    private StringEvent managedOnActivityRemoved;
    private InternalActivityEnabledListener myActivityEnabledListener;
    private ConnectedListener myConnectedListener = null;
    private boolean bInitialized = false;
    private int collectorEnableCount = 0;

    boolean claimDatatype(String strDatatype) {
        if (this.canClaimDatatype(strDatatype)) {
            this.datatypesInUse.add(strDatatype);
            Collections.sort(this.datatypesInUse);
            return true;
        }
        return false;
    }

    boolean canClaimDatatype(String strDatatype) {
        return Collections.binarySearch(this.datatypesInUse, strDatatype) < 0;
    }

    void unclaimDatatype(String strDatatype) {
        int index = Collections.binarySearch(this.datatypesInUse, strDatatype);
        if (index >= 0) {
            this.datatypesInUse.remove(index);
        }
    }

    public ProfileActivityProvider(IDspTask dspTask) {
        super(dspTask);
        this.myDspTask = dspTask;
        this.myDspUser = this.myDspTask.createDspUser();
        try {
            this.myCollector = ProfileActivityHelper.getProfCollector(dspTask, (short)0);
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            e.printStackTrace();
        }
        this.myName = this.myDspTask.getFullPathName() + " Provider";
        this.myTaskName = this.myDspTask.getFullPathName();
        this.myConnectedListener = new ConnectedListener();
        this.myDspUser.onConnected().addISimpleEventListener(this.myConnectedListener);
        this.managedOnActivityAdded = new StringEvent();
        this.managedOnActivityRemoved = new StringEvent();
        this.myActivityEnabledListener = new InternalActivityEnabledListener();
        ActivityProviderServer.getActivityProviderServer().onActivityEnabled().addIObjectEventListener(this.myActivityEnabledListener);
    }

    private boolean isInitialized() {
        return this.bInitialized;
    }

    private void ensureInitialized() {
        if (this.isInitialized()) {
            return;
        }
        ProfileActivityFactory.getFactory().generateActivities(this.myDspTask, this);
        this.bInitialized = true;
    }

    public int addActivity(ProfileActivity activity) throws IActivityProvider.ActivityProviderException {
        for (int i = 0; i < this.activitySet.size(); ++i) {
            if (!this.activitySet.get(i).getName().equals(activity.getName())) continue;
            throw new IActivityProvider.ActivityProviderException("Activity '" + activity.getName() + "' already exists within the provider");
        }
        this.activitySet.add(activity);
        this.onActivityAdded(activity.getName());
        return this.activitySet.size() - 1;
    }

    @Override
    public int addActivity(IActivity activity) throws IActivityProvider.ActivityProviderException {
        throw new IActivityProvider.ActivityProviderException("Not implemented");
    }

    private void updateControlPointEnabledStatus() {
        boolean bActivitiesEnabled;
        boolean bControlPointsUsable = this.myDspUser.areControlPointsUsable();
        boolean bl = bActivitiesEnabled = this.datatypesInUse.size() != 0;
        if (bControlPointsUsable != bActivitiesEnabled) {
            this.myDspUser.areControlPointsUsable(bActivitiesEnabled);
        }
    }

    private boolean isCollectorConnected() {
        if (this.myCollector == null) {
            return false;
        }
        int curStatus = 0;
        try {
            curStatus = this.myCollector.getCollectorStatus();
        }
        catch (IProfCollectorServer.CollectorServerException e) {
            return false;
        }
        return (curStatus &= 8) == 8;
    }

    @Override
    public boolean canConfigure() {
        this.ensureInitialized();
        return this.isCollectorConnected();
    }

    @Override
    public IActivity getActivity(int activityNum) throws IActivityProvider.ActivityProviderException {
        this.ensureInitialized();
        if (activityNum < 0 || activityNum >= this.activitySet.size()) {
            throw new IActivityProvider.ActivityProviderException("Activity index outside number of activities");
        }
        return this.activitySet.get(activityNum);
    }

    @Override
    public int getActivityCount() {
        this.ensureInitialized();
        return this.activitySet.size();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public IProperties getProperties() {
        return null;
    }

    @Override
    public void removeActivity(IActivity activity) throws IActivityProvider.ActivityProviderException {
        throw new IActivityProvider.ActivityProviderException("Not implemented");
    }

    public void removeActivity(ProfileActivity activity) throws IActivityProvider.ActivityProviderException {
        for (int i = 0; i < this.activitySet.size(); ++i) {
            if (!this.activitySet.get(i).getName().equals(activity.getName())) continue;
            this.activitySet.remove(i);
            this.onActivityRemoved(activity.getName());
            return;
        }
        throw new IActivityProvider.ActivityProviderException("Activity '" + activity.getName() + "' does not exist exist within the provider");
    }

    @Override
    public void detachFromDebugger() {
        super.detachFromDebugger();
        ActivityProviderServer myAPS = ActivityProviderServer.getActivityProviderServer();
        myAPS.onActivityEnabled().removeIObjectEventListener(this.myActivityEnabledListener);
        try {
            myAPS.removeActivityProvider(this);
        }
        catch (IActivityProviderServer.ActivityProviderServerException e) {
            e.printStackTrace();
        }
        this.myDspUser.onConnected().removeISimpleEventListener(this.myConnectedListener);
        this.myCollector.dispose();
        this.myCollector = null;
        this.myDspUser.dispose();
        this.myDspUser = null;
        this.myDspTask.dispose();
        this.myDspTask = null;
        while (this.activitySet.size() != 0) {
            this.activitySet.get(0).detachFromDebugger();
        }
        assert (this.activitySet.size() == 0);
    }

    @Override
    public String getAssociatedTaskName() {
        return this.myTaskName;
    }

    public void onActivityAdded(String activityName) {
        this.managedOnActivityAdded.fireEvent(activityName);
    }

    public void onActivityRemoved(String activityName) {
        this.managedOnActivityRemoved.fireEvent(activityName);
    }

    @Override
    public IStringEvent onActivityAdded() {
        return this.managedOnActivityAdded;
    }

    @Override
    public IStringEvent onActivityRemoved() {
        return this.managedOnActivityRemoved;
    }

    public void enableCollector() throws IProfCollectorServer.CollectorServerException {
        if (this.collectorEnableCount == 0) {
            this.myCollector.enableProfiling(true);
        }
        ++this.collectorEnableCount;
    }

    public void disableCollector() throws IProfCollectorServer.CollectorServerException {
        if (this.collectorEnableCount == 0) {
            return;
        }
        --this.collectorEnableCount;
        if (this.collectorEnableCount == 0) {
            this.myCollector.enableProfiling(false);
        }
    }

    private class ConnectedListener
    implements ISimpleEventListener {
        private ConnectedListener() {
        }

        @Override
        public void onEvent() {
            assert (ProfileActivityProvider.this.isCollectorConnected());
        }
    }

    private class InternalActivityEnabledListener
    implements IObjectEventListener {
        private InternalActivityEnabledListener() {
        }

        public void onEvent(Object data) {
            ProfileActivityProvider.this.updateControlPointEnabledStatus();
        }
    }
}

