/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.profileactivities;

import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspBoard;
import com.ti.debug.engine.IDspBoards;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspTasks;
import com.ti.debug.engine.profileactivities.ActivityProviderServer;
import com.ti.debug.engine.profileactivities.ProfileActivityProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ProfileActivityProviderFactory {
    private static ProfileActivityProviderFactory INSTANCE;
    protected Set<ProfileActivityProvider> wrappedActivityProviders = Collections.synchronizedSet(new HashSet());

    private ProfileActivityProviderFactory() {
    }

    public static ProfileActivityProviderFactory getFactory() {
        if (INSTANCE == null) {
            INSTANCE = new ProfileActivityProviderFactory();
        }
        return INSTANCE;
    }

    public void generateActivityProviders(IApplication currentApp) {
        ProfileActivityProviderFactory factory = ProfileActivityProviderFactory.getFactory();
        ActivityProviderServer myAPS = ActivityProviderServer.getActivityProviderServer();
        try {
            IDspBoards myBoards = currentApp.getDspBoards();
            for (int i = 0; myBoards != null && i < myBoards.getCount(); ++i) {
                IDspBoard curBoard = myBoards.getItem(i);
                IDspTasks curTaskSet = curBoard.getDspTasks();
                for (int taskCount = 0; taskCount < curTaskSet.getCount(); ++taskCount) {
                    IDspTask curTask = curTaskSet.getItem(taskCount);
                    try {
                        ProfileActivityProvider provider = factory.generateProvider(curTask);
                        myAPS.addActivityProvider(provider);
                        this.wrappedActivityProviders.add(provider);
                        continue;
                    }
                    catch (ProfileActivityProviderFactoryException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyActivityProviders() {
        Set<ProfileActivityProvider> set = this.wrappedActivityProviders;
        synchronized (set) {
            for (ProfileActivityProvider curProv : this.wrappedActivityProviders) {
                curProv.detachFromDebugger();
            }
            this.wrappedActivityProviders.clear();
        }
    }

    public ProfileActivityProvider generateProvider(IDspTask dspTask) throws ProfileActivityProviderFactoryException {
        if (dspTask == null) {
            assert (false);
            throw new ProfileActivityProviderFactoryException("Cannot create Activity Provider with null task");
        }
        return new ProfileActivityProvider(dspTask);
    }

    private final class ProfileActivityProviderFactoryException
    extends Exception {
        private static final long serialVersionUID = -5435635088654391449L;

        public ProfileActivityProviderFactoryException(String message) {
            super(message);
        }
    }
}

