/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.cce.CCEPropertiesEngine;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.properties.IDebugProperties;
import com.ti.debug.properties.IDebugPropertiesManager;
import com.ti.debug.properties.IStringProperty;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class APIContainer {
    protected ScriptingEnvironment environment;
    protected DebugSession session;
    protected Logger traceLog;

    public APIContainer(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        try {
            if (session == null || environment == null) {
                throw new NullPointerException();
            }
            this.session = session;
            this.environment = environment;
        }
        catch (NullPointerException e) {
            throw new ScriptingException(4001, "ScriptingEnvironment or Session not initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForHaltIfPropertySet(String propertyName) throws ScriptingException {
        block8: {
            OnHaltListener haltListener = null;
            try {
                if (!this.session.options.getBoolean(propertyName)) break block8;
                haltListener = new OnHaltListener();
                this.session.getDspUser().onHalt().addIObjectEventListener(haltListener);
                boolean[] unused = new boolean[1];
                if (1 != this.session.getDspUser().getTaskRunningState3(unused, unused)) break block8;
                this.traceLog.log(Level.FINER, "Waiting for halt", this.session);
                try {
                    haltListener.waitUntil();
                }
                catch (ScriptingException timedOut) {
                    IDebugPropertiesManager propertiesManager = null;
                    try {
                        propertiesManager = CCEPropertiesEngine.createInstance();
                    }
                    catch (Exception e) {
                        throw timedOut;
                    }
                    IDebugProperties properties = propertiesManager.getDebugProperties(this.session.getDspTask().getFullPathName(), this.session.getDspTask().getTargetType());
                    IStringProperty property = (IStringProperty)properties.getProperty("AutoRunToLabelName");
                    throw new ScriptingException(timedOut.getErrorID(), timedOut.getMessage() + " while waiting for target to halt after an auto-run to \"" + property.getCurValue());
                }
            }
            finally {
                if (null != haltListener) {
                    this.session.getDspUser().onHalt().removeIObjectEventListener(haltListener);
                }
            }
        }
    }

    protected String loggableArray(long[] values) {
        StringBuffer result;
        if (values == null) {
            result = new StringBuffer("");
        } else if (values.length == 1) {
            result = new StringBuffer("0x" + Long.toHexString(values[0]));
        } else if (values.length < 8) {
            result = new StringBuffer("[0]=0x" + Long.toHexString(values[0]));
            for (int i = 1; i < values.length; ++i) {
                result.append(", [" + String.valueOf(i) + "]=0x" + Long.toHexString(values[i]));
            }
        } else {
            int i;
            result = new StringBuffer("");
            for (i = 0; i < 2; ++i) {
                result.append("[" + String.valueOf(i) + "]=0x" + Long.toHexString(values[i]) + ", ");
            }
            result.append(" ...(" + String.valueOf(values.length - 4) + " hidden values)...");
            for (i = values.length - 2; i < values.length; ++i) {
                result.append(", [" + String.valueOf(i) + "]=0x" + Long.toHexString(values[i]));
            }
        }
        return result.toString();
    }

    protected String loggableArray(String[] values) {
        StringBuffer result;
        if (values == null) {
            result = new StringBuffer("");
        } else if (values.length == 0) {
            result = new StringBuffer();
        } else if (values.length == 1) {
            result = new StringBuffer("\"" + values[0] + "\"");
        } else if (values.length < 8) {
            result = new StringBuffer("[0]=\"" + values[0] + "\"");
            for (int i = 1; i < values.length; ++i) {
                result.append(", [" + String.valueOf(i) + "]=" + "\"" + values[i] + "\"");
            }
        } else {
            int i;
            result = new StringBuffer("");
            for (i = 0; i < 2; ++i) {
                result.append("[" + String.valueOf(i) + "]=" + "\"" + values[i] + "\"" + ", ");
            }
            result.append(" ...(" + String.valueOf(values.length - 4) + " hidden values)...");
            for (i = values.length - 2; i < values.length; ++i) {
                result.append(", [" + String.valueOf(i) + "]=" + "\"" + values[i] + "\"");
            }
        }
        return result.toString();
    }

    static long unsignedIntToLong(int n) {
        if (n < 0) {
            return (long)n + 0x100000000L;
        }
        return n;
    }

    protected void ensureTargetIsConnected() throws ScriptingException {
        if (this.session.getDspTask().getTargetConnection().getConnectionStatus() != ITargetConnection.ConnectionStatus.CONNECTED) {
            throw new ScriptingException(4003, "Cannot perform operation, target is not connected.");
        }
    }

    class OnRunningListener
    extends AbstractListener
    implements ISimpleEventListener {
        OnRunningListener() {
            super(APIContainer.this.traceLog, APIContainer.this.session);
        }

        @Override
        public void onEvent() {
            this.log("Target is now running");
            this.eventReceived();
        }
    }

    class OnCompleteWithErrorInfo
    extends AbstractListener
    implements IStringEventListener {
        private String errorMessage;

        OnCompleteWithErrorInfo() {
            super(APIContainer.this.traceLog, APIContainer.this.session);
        }

        @Override
        public void onEvent(String result) {
            this.errorMessage = result;
            this.eventReceived();
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    class OnHaltListener
    extends AbstractListener
    implements IObjectEventListener<IEventData<IDspValue>> {
        private IDspValue data;

        OnHaltListener() {
            super(APIContainer.this.traceLog, APIContainer.this.session);
        }

        @Override
        public void onEvent(IEventData<IDspValue> result) {
            this.data = result.getEventData();
            this.log("Target has halted at " + this.data.toStringCStyleHex());
            this.eventReceived();
        }

        public IDspValue getData() {
            return this.data;
        }
    }
}

