/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ccstudio.scripting.environment.ScriptingTimeout;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractListener {
    private final Logger traceLog;
    private final ScriptingTimeout scriptingTimeout;
    private boolean eventReceived = false;

    protected AbstractListener(Logger logger, ScriptingTimeout scriptingTimeout) {
        this.traceLog = logger;
        this.scriptingTimeout = scriptingTimeout;
    }

    protected void log(String message) {
        if (!this.eventReceived) {
            this.traceLog.log(Level.FINER, message, this.scriptingTimeout);
        }
    }

    protected synchronized void eventReceived() {
        this.eventReceived = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntil(long timeout) throws ScriptingException {
        String myName = "waitUntil";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.scriptingTimeout, "timeout: " + (timeout != -1L ? timeout + " (ms)" : "infinite")});
        }
        try {
            AbstractListener abstractListener = this;
            synchronized (abstractListener) {
                if (!this.eventReceived) {
                    if (-1L == timeout) {
                        this.wait();
                    } else {
                        this.wait(timeout);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw new ScriptingException(1001, "Interrupted by another thread");
        }
        if (!this.eventReceived) {
            throw new ScriptingException(1001, "Timed out after " + timeout + "ms");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.scriptingTimeout);
        }
    }

    public void waitUntil() throws ScriptingException {
        this.waitUntil(this.scriptingTimeout.getScriptTimeout());
    }
}

