/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IBreakpoint;
import com.ti.debug.engine.IBreakpointLocation;
import com.ti.debug.engine.IBreakpointManager;
import com.ti.debug.engine.IBreakpoints;
import com.ti.debug.engine.ILValue;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.BreakpointProperties;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.xpcom.XPCOMException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Breakpoint
extends APIContainer {
    private HashMap<Integer, IBreakpoint> breakpointMap;

    Breakpoint(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.breakpointMap = new HashMap(20);
    }

    public BreakpointProperties createProperties(int nType) throws ScriptingException {
        String myName = "createProperties";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nType: " + nType});
        }
        String[] types = this.getTypes();
        if (nType < 0 || nType > types.length - 1) {
            String msg = "Cannot create BreakpointProperties.  Specified type: " + String.valueOf(nType) + " is invalid.  Valid types are:";
            for (int i = 0; i < types.length; ++i) {
                msg = msg + "\nnType=" + String.valueOf(i) + " (\"" + types[i] + "\")";
            }
            throw new ScriptingException(4004, msg);
        }
        BreakpointProperties bp = new BreakpointProperties(this.environment, this.session, nType);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, bp.toString()});
        }
        return bp;
    }

    public BreakpointProperties createProperties() throws ScriptingException {
        return this.createProperties(0);
    }

    public void loadConfig(String sFile) throws ScriptingException {
        String myName = "loadConfig";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFile: " + sFile});
        }
        if (sFile == null || sFile.length() < 1) {
            throw new ScriptingException(1002, "Specified path name is invalid.");
        }
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        sFile = this.environment.toAbsolutePath(sFile);
        try {
            bkptMgr.restoreConfiguration(sFile);
        }
        catch (IBreakpointManager.BreakpointException e) {
            throw new ScriptingException(4004, (Throwable)e);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void saveConfig(String sFile) throws ScriptingException {
        String myName = "saveConfig";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFile: " + sFile});
        }
        if (sFile == null || sFile.length() < 1) {
            throw new ScriptingException(1002, "Specified path name is invalid.");
        }
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        sFile = this.environment.toAbsolutePath(sFile);
        try {
            bkptMgr.saveConfiguration(sFile);
        }
        catch (IBreakpointManager.BreakpointException e) {
            throw new ScriptingException(4004, (Throwable)e);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int nID) throws ScriptingException {
        IBreakpoint bkpt;
        String myName = "remove";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nID: " + nID});
        }
        if ((bkpt = this.breakpointMap.get(nID)) == null) {
            throw new ScriptingException(4005, "Specified breakpoint ID " + nID + " does not exist.");
        }
        this.breakpointMap.remove(nID);
        this.traceLog.log(Level.FINER, "Getting breakpoint manager", this.session);
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        this.traceLog.log(Level.FINER, "Disabling breakpoint", this.session);
        try {
            if (bkpt.isEnabled()) {
                bkptMgr.disable(bkpt);
            }
        }
        catch (IBreakpointManager.BreakpointException e) {
            throw new ScriptingException(4004, "Specified breakpoint " + bkpt + " not disabled: " + e.getMessage());
        }
        catch (XPCOMException e) {
        }
        finally {
            if (bkpt.isAdded() && !bkpt.isEnabled()) {
                this.traceLog.log(Level.FINER, "Removing breakpoint", this.session);
                bkptMgr.remove(bkpt);
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void removeAll() throws ScriptingException {
        String myName = "removeAll";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        this.traceLog.log(Level.FINER, "Getting breakpoint manager", this.session);
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        this.breakpointMap.clear();
        IBreakpoints userBreakpoints = bkptMgr.getUserBreakpoints(2);
        int userBreakpointsCount = userBreakpoints.getCount();
        this.traceLog.log(Level.FINER, "Removing " + userBreakpointsCount + " breakpoint(s)", this.session);
        if (userBreakpointsCount > 0) {
            for (int i = 0; i < userBreakpointsCount; ++i) {
                IBreakpoint bkpt = userBreakpoints.getItem(i);
                try {
                    if (bkpt.isEnabled()) {
                        bkptMgr.disable(bkpt);
                    }
                }
                catch (IBreakpointManager.BreakpointException e) {
                    throw new ScriptingException(4004, "Specified breakpoint " + bkpt + " not disabled: " + e.getMessage());
                }
                bkptMgr.remove(bkpt);
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public int add(BreakpointProperties breakpointProperties) throws ScriptingException {
        String myName = "add";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "breakpointProperties: " + breakpointProperties});
        }
        if (breakpointProperties == null) {
            throw new ScriptingException(1002, "Cannot add breakpoint.  Specific Breakpoint Properties is null");
        }
        int bkptId = -1;
        this.traceLog.log(Level.FINER, "Reading breakpoint properties", this.session);
        IBreakpoint bkpt = breakpointProperties.getBreakpoint();
        if (bkpt == null) {
            throw new ScriptingException(4004, "Cannot create a new breakpoint");
        }
        this.addAndEnable(bkpt);
        bkptId = bkpt.getIdentifier();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, String.valueOf(bkptId)});
        }
        return bkptId;
    }

    public int add(long nAddress) throws ScriptingException {
        String myName = "add";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + String.valueOf(nAddress)});
        }
        if (nAddress < 0L) {
            throw new ScriptingException(4004, "Cannot add breakpoint");
        }
        IBreakpointManager bkptMgr = null;
        int bkptId = -1;
        this.traceLog.log(Level.FINER, "Getting breakpoint manager", this.session);
        bkptMgr = this.session.getDspTask().getBreakpointManager();
        if (bkptMgr.getNumBreakpointTypes() == 0 || bkptMgr.isHardware(0)) {
            throw new ScriptingException(4004, "Target does not support software breakpoints");
        }
        this.traceLog.log(Level.FINER, "Assigning address location", this.session);
        IBreakpointLocation location = bkptMgr.createLocation();
        location.setAddressLocation(nAddress);
        IBreakpoint bkpt = this.createAtLocation(location, 0);
        this.addAndEnable(bkpt);
        bkptId = bkpt.getIdentifier();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, String.valueOf(bkptId)});
        }
        return bkptId;
    }

    public int add(String sSymbol) throws ScriptingException {
        String myName = "add";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sSymbol: " + sSymbol});
        }
        if (sSymbol == null) {
            throw new ScriptingException(4004, "Cannot add breakpoint, specified symbol is null");
        }
        IBreakpointManager bkptMgr = null;
        int bkptId = -1;
        this.traceLog.log(Level.FINER, "Getting breakpoint manager", this.session);
        bkptMgr = this.session.getDspTask().getBreakpointManager();
        if (bkptMgr.getNumBreakpointTypes() == 0 || bkptMgr.isHardware(0)) {
            throw new ScriptingException(4004, "Target does not support software breakpoints");
        }
        IBreakpointLocation location = bkptMgr.createLocation();
        this.traceLog.log(Level.FINER, "Assigning symbolic location", this.session);
        ILValue result = this.session.expression.eval(sSymbol).getLValue();
        location.setSymbolicLocation(sSymbol, result);
        IBreakpoint bkpt = this.createAtLocation(location, 0);
        this.addAndEnable(bkpt);
        bkptId = bkpt.getIdentifier();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, String.valueOf(bkptId)});
        }
        return bkptId;
    }

    public int add(String sFile, int nLine) throws ScriptingException {
        String myName = "add";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFile: " + sFile, "nLine: " + String.valueOf(nLine)});
        }
        if (sFile == null) {
            throw new ScriptingException(4004, "Cannot add breakpoint, specified source filename is null");
        }
        IBreakpointManager bkptMgr = null;
        int bkptId = -1;
        this.traceLog.log(Level.FINER, "Getting breakpoint manager", this.session);
        bkptMgr = this.session.getDspTask().getBreakpointManager();
        if (bkptMgr.getNumBreakpointTypes() == 0 || bkptMgr.isHardware(0)) {
            throw new ScriptingException(4004, "Target does not support software breakpoints");
        }
        IBreakpointLocation location = bkptMgr.createLocation();
        this.traceLog.log(Level.FINER, "Assigning source-line location", this.session);
        location.setSourceLocation(nLine, sFile);
        IBreakpoint bkpt = this.createAtLocation(location, 0);
        this.addAndEnable(bkpt);
        bkptId = bkpt.getIdentifier();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, String.valueOf(bkptId)});
        }
        return bkptId;
    }

    public String[] getTypes() throws ScriptingException {
        String myName = "getTypes";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        this.traceLog.log(Level.FINER, "Getting breakpoint manager", this.session);
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        this.traceLog.log(Level.FINER, "Getting breakpoint type count", this.session);
        int typeCount = bkptMgr.getNumBreakpointTypes();
        this.traceLog.log(Level.FINER, "Getting breakpoint types", this.session);
        String[] types = new String[typeCount];
        for (int i = 0; i < typeCount; ++i) {
            types[i] = bkptMgr.getBreakpointType(i);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, this.loggableArray(types)});
        }
        return types;
    }

    private IBreakpoint createAtLocation(IBreakpointLocation location, int nType) throws ScriptingException {
        int bkptId = -1;
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        this.traceLog.log(Level.FINER, "Creating new breakpoint", this.session);
        IBreakpoint bkpt = bkptMgr.createBreakpoint(nType);
        bkpt.setPrecisePCBreak(location);
        bkptId = bkpt.getIdentifier();
        if (bkptId == -1) {
            String errorMessage = "Cannot create breakpoint";
            if (location.isAddressBased()) {
                errorMessage = "Cannot create breakpoint at address 0x" + Long.toHexString(location.getAddressLocation(0L));
            } else if (location.isSymbolicBased()) {
                errorMessage = "Cannot create symbolic breakpoint at " + location.getSymbolicLocation(0L);
            } else {
                assert (location.isSourceBased());
                int[] lineNo = new int[1];
                String[] symbolFile = new String[1];
                String file = location.getSourceLocation(lineNo, symbolFile);
                errorMessage = "Cannot create source-line breakpoint at line " + String.valueOf(lineNo[0]) + " in file " + file;
            }
            throw new ScriptingException(4004, errorMessage);
        }
        return bkpt;
    }

    private void addAndEnable(IBreakpoint bkpt) throws ScriptingException {
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        if (bkpt != null) {
            int bkptId = bkpt.getIdentifier();
            this.traceLog.log(Level.FINER, "Adding breakpoint", this.session);
            bkptMgr.add(bkpt);
            this.traceLog.log(Level.FINER, "Enabling breakpoint", this.session);
            try {
                bkptMgr.enable(bkpt);
            }
            catch (IBreakpointManager.BreakpointException e) {
                if (bkpt.isAdded()) {
                    bkptMgr.remove(bkpt);
                }
                throw new ScriptingException(4004, "Breakpoint " + bkptId + " could not be enabled. " + e.getMessage());
            }
            this.breakpointMap.put(bkptId, bkpt);
        }
    }

    int addHW(String sSymbol) throws ScriptingException {
        throw new UnsupportedOperationException("The addHW() API methods should not be used.  Use BreakpointProperties instead.");
    }

    int addHW(long nAddress) throws ScriptingException {
        throw new UnsupportedOperationException("The addHW() API methods should not be used.  Use BreakpointProperties instead.");
    }

    int addHW(String sFile, int nLine) throws ScriptingException {
        throw new UnsupportedOperationException("The addHW() API methods should not be used.  Use BreakpointProperties instead.");
    }
}

