/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IBreakpoint;
import com.ti.debug.engine.IBreakpointBooleanProperty;
import com.ti.debug.engine.IBreakpointFileProperty;
import com.ti.debug.engine.IBreakpointIntegerProperty;
import com.ti.debug.engine.IBreakpointLocation;
import com.ti.debug.engine.IBreakpointLocationProperty;
import com.ti.debug.engine.IBreakpointManager;
import com.ti.debug.engine.IBreakpointProperties;
import com.ti.debug.engine.IBreakpointProperty;
import com.ti.debug.engine.IBreakpointStringProperty;
import com.ti.debug.engine.ILValue;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Logger;

public class BreakpointProperties
extends APIContainer {
    private IBreakpoint breakpoint;
    private final String FORMAT = "| %1$-65s %2$-20s %3$-30s \n";

    BreakpointProperties(ScriptingEnvironment environment, DebugSession session, int type) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        IBreakpointManager bkptMgr = session.getDspTask().getBreakpointManager();
        this.breakpoint = bkptMgr.createBreakpoint(type);
        if (this.breakpoint == null) {
            throw new ScriptingException(4004, "Unable to create new breakpoint properties");
        }
    }

    IBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    void setBooleanProperty(String propertyName, boolean value) throws ScriptingException {
        this.setBoolean(propertyName, value);
    }

    boolean getBooleanProperty(String propertyName) throws ScriptingException {
        return this.getBoolean(propertyName);
    }

    void setFileProperty(String propertyName, String value) throws ScriptingException {
        this.setString(propertyName, value);
    }

    String getFileProperty(String propertyName) throws ScriptingException {
        return this.getString(propertyName);
    }

    void setIntegerProperty(String propertyName, long value) throws ScriptingException {
        this.setNumeric(propertyName, value);
    }

    long getIntegerProperty(String propertyName) throws ScriptingException {
        return this.getNumeric(propertyName);
    }

    void setStringProperty(String propertyName, String value) throws ScriptingException {
        this.setString(propertyName, value);
    }

    String getStringProperty(String propertyName) throws ScriptingException {
        return this.getString(propertyName);
    }

    void setLocationProperty(String propertyName, IBreakpointLocation value) throws ScriptingException {
        IBreakpointProperty prop = null;
        IBreakpointProperties props = null;
        IBreakpointLocationProperty locProp = null;
        if (value == null) {
            throw new ScriptingException(4004, "Value to set property to was null");
        }
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path was null");
        }
        try {
            props = this.breakpoint.getProperties();
            if (props == null) {
                throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
            }
            prop = this.getPropertyByName(propertyName, props);
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            locProp = (IBreakpointLocationProperty)prop;
            locProp.setValue(value);
            this.breakpoint.setProperties(props);
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Unable to set property: " + e);
        }
    }

    IBreakpointLocation getLocationProperty(String propertyName) throws ScriptingException {
        IBreakpointProperty prop = null;
        IBreakpointLocationProperty locProp = null;
        IBreakpointLocation result = null;
        try {
            prop = this.getPropertyByName(propertyName);
            locProp = (IBreakpointLocationProperty)prop;
            result = locProp.getValue();
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Unable to get property: " + e);
        }
        return result;
    }

    public void setSourceLocation(String propertyName, String sourceFile, int lineNumber) throws ScriptingException {
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path is null");
        }
        if (sourceFile == null) {
            throw new ScriptingException(4004, "Source file is null");
        }
        if (lineNumber < 1) {
            throw new ScriptingException(4004, "Line number is zero or negative");
        }
        IBreakpointProperties props = null;
        IBreakpointProperty prop = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        IBreakpointLocationProperty locationProp = null;
        IBreakpointLocation location = null;
        try {
            try {
                locationProp = (IBreakpointLocationProperty)prop;
            }
            catch (ClassCastException xe) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not a location property");
            }
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            location = locationProp.getValue();
            location.setSourceLocation(lineNumber, sourceFile);
            locationProp.setValue(location);
            this.breakpoint.setProperties(props);
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Unable to create Location property for breakpoint at " + sourceFile + ":" + lineNumber + " : " + e);
        }
    }

    public boolean getBoolean(String propertyName) throws ScriptingException {
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path is null");
        }
        IBreakpointProperty prop = null;
        IBreakpointProperties props = null;
        IBreakpointBooleanProperty boolProp = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        try {
            try {
                boolProp = (IBreakpointBooleanProperty)prop;
            }
            catch (ClassCastException e) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not a boolean property");
            }
            boolean result = boolProp.getValue();
            return result;
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Boolean property " + propertyName + " could not be read: " + e.getMessage());
        }
    }

    public long getNumeric(String propertyName) throws ScriptingException {
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path is null");
        }
        IBreakpointProperty prop = null;
        IBreakpointProperties props = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        IBreakpointLocationProperty locationProp = null;
        IBreakpointLocation location = null;
        try {
            locationProp = (IBreakpointLocationProperty)prop;
            location = locationProp.getValue();
            long result = location.getAddressLocation(0L);
            return result;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Location Property " + propertyName + " could not be read. " + e.getMessage());
        }
        IBreakpointIntegerProperty integerProperty = null;
        try {
            integerProperty = (IBreakpointIntegerProperty)prop;
            long result = integerProperty.getValue();
            return result;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Integer Property " + propertyName + " could not be set. " + e.getMessage());
        }
        throw new ScriptingException(4004, "Property " + propertyName + " is neither an address-based location property nor an integer property");
    }

    public String getString(String propertyName) throws ScriptingException {
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path is null");
        }
        IBreakpointProperty prop = null;
        IBreakpointProperties props = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        try {
            String result;
            IBreakpointLocationProperty locationProp = null;
            IBreakpointLocation location = null;
            locationProp = (IBreakpointLocationProperty)prop;
            location = locationProp.getValue();
            if (location.isSymbolicBased()) {
                result = location.getSymbolicLocation(0L);
            } else if (location.isAddressBased()) {
                result = "0x" + Long.toHexString(location.getAddressLocation(0L));
            } else if (location.isSourceBased()) {
                int[] lineNo = new int[1];
                String[] symbolFile = new String[1];
                String file = location.getSourceLocation(lineNo, symbolFile);
                result = file + ":" + Integer.toString(lineNo[0]);
            } else {
                throw new ScriptingException(4004, "Property " + propertyName + "is not a symbolic, address or source-line location property");
            }
            return result;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Location Property " + propertyName + " could not be read. " + e.getMessage());
        }
        IBreakpointFileProperty fileProperty = null;
        try {
            fileProperty = (IBreakpointFileProperty)prop;
            String result = fileProperty.getValue();
            return result;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "File Property " + propertyName + " could not be read. " + e.getMessage());
        }
        IBreakpointStringProperty stringProp = null;
        try {
            stringProp = (IBreakpointStringProperty)prop;
            String result = stringProp.getValue();
            return result;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "String Property " + propertyName + " could not be read. " + e.getMessage());
        }
        throw new ScriptingException(4004, "Property " + propertyName + " is not a string, file or symbolic location property");
    }

    public void setString(String propertyName, String value) throws ScriptingException {
        if (value == null) {
            throw new ScriptingException(4004, "Value to set property to was null");
        }
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path was null");
        }
        IBreakpointProperty prop = null;
        IBreakpointProperties props = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        IBreakpointLocationProperty locationProp = null;
        IBreakpointLocation location = null;
        ILValue result = null;
        try {
            locationProp = (IBreakpointLocationProperty)prop;
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            location = locationProp.getValue();
            result = this.session.expression.eval(value).getLValue();
            location.setSymbolicLocation(value, result);
            locationProp.setValue(location);
            this.breakpoint.setProperties(props);
            return;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Location Property " + propertyName + " could not be set. " + e.getMessage());
        }
        IBreakpointFileProperty fileProperty = null;
        try {
            fileProperty = (IBreakpointFileProperty)prop;
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            fileProperty.setValue(value);
            this.breakpoint.setProperties(props);
            return;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "File Property " + propertyName + " could not be set. " + e.getMessage());
        }
        IBreakpointStringProperty stringProp = null;
        try {
            stringProp = (IBreakpointStringProperty)prop;
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            stringProp.setValue(value);
            this.breakpoint.setProperties(props);
            return;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "String Property " + propertyName + " could not be set. " + e.getMessage());
        }
        throw new ScriptingException(4004, "Property " + propertyName + " is not a string, file or symbolic location property");
    }

    public void setNumeric(String propertyName, long value) throws ScriptingException {
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property path was null");
        }
        IBreakpointProperty prop = null;
        IBreakpointProperties props = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        try {
            IBreakpointLocationProperty locationProp = null;
            IBreakpointLocation location = null;
            locationProp = (IBreakpointLocationProperty)prop;
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            location = locationProp.getValue();
            location.setAddressLocation(value);
            locationProp.setValue(location);
            this.breakpoint.setProperties(props);
            return;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Location Property " + propertyName + " could not be set. " + e.getMessage());
        }
        IBreakpointIntegerProperty integerProperty = null;
        try {
            integerProperty = (IBreakpointIntegerProperty)prop;
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
            integerProperty.setValue(value);
            this.breakpoint.setProperties(props);
            return;
        }
        catch (ClassCastException xe) {
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Integer Property " + propertyName + " could not be set. " + e.getMessage());
        }
        throw new ScriptingException(4004, "Property " + propertyName + " is neither an address-based location property nor an integer property");
    }

    public void setBoolean(String propertyName, boolean value) throws ScriptingException {
        if (propertyName == null) {
            throw new ScriptingException(4004, "Property is null");
        }
        IBreakpointProperties props = null;
        IBreakpointProperty prop = null;
        IBreakpointBooleanProperty boolProp = null;
        props = this.breakpoint.getProperties();
        if (props == null) {
            throw new ScriptingException(4004, "Breakpoint's getProperties returned a null property set");
        }
        prop = this.getPropertyByName(propertyName, props);
        try {
            try {
                boolProp = (IBreakpointBooleanProperty)prop;
            }
            catch (ClassCastException e) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not a boolean property");
            }
            boolProp.setValue(value);
            this.breakpoint.setProperties(props);
            if (!prop.editable()) {
                throw new ScriptingException(4004, "Property " + propertyName + " is not editable and cannot be set");
            }
        }
        catch (Exception e) {
            throw new ScriptingException(4004, "Unable to set property " + propertyName + ": " + e.getMessage());
        }
    }

    IBreakpointProperty getPropertyByName(String path) throws ScriptingException {
        return this.getPropertyByName(path, this.breakpoint.getProperties());
    }

    IBreakpointProperty getPropertyByName(String path, IBreakpointProperties properties) throws ScriptingException {
        String[] patharray = path.split("[.]");
        String currentpath = patharray[0];
        StringBuffer remainingpath = null;
        for (int i = 0; i < properties.getCount(); ++i) {
            IBreakpointProperty currentProp = properties.getItem(i);
            if (currentProp == null) {
                throw new ScriptingException(4004, "Error getting property: " + path);
            }
            if (!currentpath.equals(currentProp.getName())) continue;
            if (patharray.length == 1) {
                return currentProp;
            }
            for (int j = 1; j < patharray.length; ++j) {
                if (remainingpath == null) {
                    remainingpath = new StringBuffer(patharray[j]);
                    continue;
                }
                remainingpath.append(".");
                remainingpath.append(patharray[j]);
            }
            IBreakpointProperties subProps = currentProp.getSubProperties();
            return this.getPropertyByName(remainingpath.toString(), subProps);
        }
        throw new ScriptingException(4004, "Could not find property " + currentpath);
    }

    public void printProperties() throws ScriptingException {
        long nType = this.breakpoint.getType();
        long nID = this.breakpoint.getIdentifier();
        IBreakpointManager bkptMgr = this.session.getDspTask().getBreakpointManager();
        String sType = bkptMgr.getBreakpointType((int)nType);
        System.out.println("|=================================================================================================================");
        System.out.println("| TYPE:  " + sType);
        System.out.println("| ID:    " + String.valueOf(nID));
        System.out.println("|-----------------------------------------------------------------------------------------------------------------");
        System.out.format("| %1$-65s %2$-20s %3$-30s \n", "PROPERTY", "VALUE", "ALLOWED VALUES");
        System.out.format("| %1$-65s %2$-20s %3$-30s \n", "--------", "-----", "--------------");
        IBreakpointProperties props = this.breakpoint.getProperties();
        this.printProperties(props, "");
        System.out.println("|=================================================================================================================");
    }

    void printProperties(IBreakpointProperties properties, String parentName) throws ScriptingException {
        if (properties != null) {
            for (int i = 0; i < properties.getCount(); ++i) {
                IBreakpointProperty currentProperty = properties.getItem(i);
                String fullName = parentName.equals("") ? currentProperty.getName() : parentName + "." + currentProperty.getName();
                String value = "";
                String allowedValues = "";
                try {
                    IBreakpointStringProperty stringProp = (IBreakpointStringProperty)currentProperty;
                    value = stringProp.getValue();
                    String[] allowedValueAr = stringProp.getAllowedValues();
                    if (allowedValueAr.length > 0) {
                        allowedValues = allowedValues + allowedValueAr[0];
                        for (int j = 1; j < allowedValueAr.length; ++j) {
                            allowedValues = allowedValues + ", " + allowedValueAr[j];
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    IBreakpointIntegerProperty intProp = (IBreakpointIntegerProperty)currentProperty;
                    class LongFormatter {
                        private final IBreakpointIntegerProperty.DisplaySuggestion eSuggestion;

                        public LongFormatter(IBreakpointIntegerProperty.DisplaySuggestion eSuggestion) {
                            this.eSuggestion = eSuggestion;
                        }

                        public String toString(long value) {
                            switch (this.eSuggestion) {
                                default: {
                                    return "0x" + Long.toHexString(value);
                                }
                                case DEC: 
                            }
                            return Long.toString(value);
                        }
                    }
                    LongFormatter formatter = new LongFormatter(intProp.getDisplaySuggestion());
                    value = formatter.toString(intProp.getValue());
                    long[] min = new long[]{0L};
                    long[] max = new long[]{0L};
                    long[] allowedValueAr = intProp.getAllowedValues();
                    if (allowedValueAr.length > 0) {
                        allowedValues = formatter.toString(allowedValueAr[0]);
                        for (int j = 1; j < allowedValueAr.length; ++j) {
                            allowedValues = allowedValues + ", " + formatter.toString(allowedValueAr[j]);
                        }
                    } else if (intProp.hasAllowedRange(min, max)) {
                        allowedValues = formatter.toString(min[0]) + " to " + formatter.toString(max[0]);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    value = Boolean.toString(((IBreakpointBooleanProperty)currentProperty).getValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    IBreakpointLocation loc = ((IBreakpointLocationProperty)currentProperty).getValue();
                    if (loc.isAddressBased()) {
                        value = "0x" + Long.toHexString(loc.getAddressLocation(0L));
                    }
                    if (loc.isSourceBased()) {
                        int[] lineNo = new int[1];
                        String[] symbolFile = new String[1];
                        String file = loc.getSourceLocation(lineNo, symbolFile);
                        value = file + ", line " + Integer.toString(lineNo[0]);
                    }
                    if (loc.isSymbolicBased()) {
                        value = loc.getSymbolicLocation(0L);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    value = ((IBreakpointFileProperty)currentProperty).getValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (currentProperty.editable()) {
                    System.out.format("| %1$-65s %2$-20s %3$-30s \n", fullName, value, allowedValues);
                }
                IBreakpointProperties currentSubProperties = currentProperty.getSubProperties();
                this.printProperties(currentSubProperties, fullName);
            }
        }
    }
}

