/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ccstudio.scripting.environment.ScriptingTimeout;
import com.ti.debug.engine.ICallStack;
import com.ti.debug.engine.ICallStacks;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.ICallStackEventData;
import com.ti.debug.engine.events.data.IStackAnalysisEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CallStack
extends APIContainer {
    CallStack(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public void print() throws ScriptingException {
        String myName = "print";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        System.out.print(this.getCallStack());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void analyzeStackMemory(long address, int page, int length, boolean printDiagnosticInfo) throws ScriptingException {
        String myName = "analyzeStackMemory";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (0 > page || this.session.getDspUser().numberOfMemoryPages() <= page) {
            throw new ScriptingException(4021, "Invalid page number specified");
        }
        AnalysisListener listener = new AnalysisListener();
        this.session.getDspTask().getStackAnalysis().analyze(this.session.getDspUser().createDspValue(IDspValue.Type.POINTER, address), length, (short)page, printDiagnosticInfo, listener);
        listener.waitUntil();
        IStackAnalysisEventData data = listener.getData();
        if (0 != data.getErrorMessage().length()) {
            throw new ScriptingException(4021, data.getErrorMessage());
        }
        ICallStacks result = data.getResult();
        int count = result.getCount();
        for (int i = 0; i < count; ++i) {
            System.out.print(result.getItem(i));
            System.out.print("\n\n");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void analyzeStackMemory(long address, int page, int length) throws ScriptingException {
        this.analyzeStackMemory(address, page, length, false);
    }

    private ICallStack getCallStack() throws ScriptingException {
        class CallStackListener
        extends AbstractListener
        implements IObjectEventListener<ICallStackEventData> {
            private ICallStack callstack;
            private String errorMessage;

            CallStackListener() {
                super(CallStack.this.traceLog, (ScriptingTimeout)CallStack.this.environment);
                this.callstack = null;
                this.errorMessage = null;
            }

            @Override
            public void onEvent(ICallStackEventData data) {
                this.errorMessage = data.getErrorMessage();
                this.callstack = data.getCallStack();
                this.eventReceived();
            }

            public ICallStack getCallStack() throws ScriptingException {
                this.waitUntil();
                if (this.errorMessage != null && 0 != this.errorMessage.length()) {
                    throw new ScriptingException(4021, "Unable to build call stack: " + this.errorMessage);
                }
                return this.callstack;
            }
        }
        CallStackListener callStackChangedListener = new CallStackListener();
        this.session.getDspTask().getCallStackRequestor().requestCallStack(callStackChangedListener);
        return callStackChangedListener.getCallStack();
    }

    private class AnalysisListener
    extends AbstractListener
    implements IObjectEventListener<IStackAnalysisEventData> {
        IStackAnalysisEventData data;

        private AnalysisListener() {
            super(CallStack.this.traceLog, CallStack.this.session);
            this.data = null;
        }

        private IStackAnalysisEventData getData() {
            return this.data;
        }

        @Override
        public void onEvent(IStackAnalysisEventData data) {
            this.data = data;
            this.eventReceived();
        }
    }
}

