/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.ScriptServer;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ccstudio.scripting.environment.ScriptingTimeout;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspBoard;
import com.ti.debug.engine.IDspBoards;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspTasks;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.IRegisterServer;
import com.ti.debug.engine.cce.CCEDebugEngine;
import com.ti.debug.engine.cce.CCEPropertiesEngine;
import com.ti.debug.engine.cce.LicenseEngine;
import com.ti.debug.engine.dialogs.IBaseDialog;
import com.ti.debug.engine.dialogs.IMessageDialog;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.IDebugServerEventListener;
import com.ti.debug.engine.scripting.Simultaneous;
import com.ti.debug.engine.scripting.TargetConfigurationGenerator;
import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.SystemSetupEditor;
import com.ti.debug.engine.scripting.setup.SystemSetupReader;
import com.ti.license.ILicenseAction;
import com.ti.license.ILicenseManager;
import com.ti.utility.filesystem.DirectoryService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugServer
extends ScriptServer {
    public final Simultaneous simultaneous;
    private IApplication application;
    private DialogListener dialogListener;
    private String cachedChoice = "";
    private ILicenseManager lm;
    private final String PRODUCT_VERSION = "2.0";
    static String RTDX_SERVER = "RTDXServer.1";
    private ArrayList<Device> deviceList;
    private ArrayList<IDebugServerEventListener> serverListeners;
    private String userSetConfiguration;
    private String currentlyUsedConfiguration;
    private static DebugServer debugServer = null;

    public static ScriptServer instance(String sServerName, ScriptingEnvironment environment) throws ScriptingException {
        if (null == debugServer) {
            debugServer = new DebugServer(sServerName, environment);
        }
        return debugServer;
    }

    private DebugServer(String sServerName, ScriptingEnvironment environment) throws ScriptingException {
        super(sServerName, environment);
        this.traceLog = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.serverListeners = new ArrayList();
        this.simultaneous = new Simultaneous(this);
    }

    public synchronized void addListener(IDebugServerEventListener listener) {
        this.serverListeners.add(listener);
    }

    public synchronized void removeListener(IDebugServerEventListener listener) {
        this.serverListeners.remove(listener);
    }

    synchronized void fireOnServerStarting(DebugServer server) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onServerStarting(server);
        }
    }

    synchronized void fireOnServerStarted(DebugServer server) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onServerStarted(server);
        }
    }

    synchronized void fireOnServerStopping(DebugServer server) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onServerStopping(server);
        }
    }

    synchronized void fireOnServerStopped(DebugServer server) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onServerStopped(server);
        }
    }

    synchronized void fireOnSessionOpening(String name, String config) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onSessionOpening(name, config);
        }
    }

    synchronized void fireOnSessionOpened(DebugSession session) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onSessionOpened(session);
        }
    }

    synchronized void fireOnSessionTerminating(DebugSession session) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onSessionTerminating(session);
        }
    }

    synchronized void fireOnSessionTerminated(DebugSession session) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            i.next().onSessionTerminated(session);
        }
    }

    void start() throws ScriptingException {
        String myName = "start";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        if (!this.environment.isRegistered(this.getName())) {
            this.environment.registerServer((ScriptServer)this);
        }
        if (this.application == null) {
            this.traceLog.finer("Firing: onServerStarting()");
            this.fireOnServerStarting(this);
            this.traceLog.finer("Connecting to XPCOM DebugServer");
            try {
                this.application = CCEDebugEngine.instance();
            }
            catch (Exception e) {
                this.application = null;
                throw new ScriptingException(4001, "Can not connect to DebugServer. " + e.getMessage());
            }
            if (this.cachedChoice.length() > 0) {
                if (this.dialogListener == null) {
                    this.dialogListener = new DialogListener();
                    this.application.onMessageDialog().addIObjectEventListener(this.dialogListener);
                }
                this.dialogListener.setDefaultChoice(this.cachedChoice);
            }
            this.currentlyUsedConfiguration = this.getConfigInternal();
            if (!this.application.isConfigured()) {
                Callback callback = new Callback();
                this.traceLog.finer("Initializing DebugServer using specified configuration: \"" + this.currentlyUsedConfiguration + "\"");
                this.application.configure(this.currentlyUsedConfiguration, callback);
                callback.waitForConfigure();
            }
            this.traceLog.finer("Firing: onServerStarted()");
            this.fireOnServerStarted(this);
        }
        if (this.application != null) {
            this.traceLog.finer("Searching for devices");
            this.listDevices();
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }

    public void stop() throws ScriptingException {
        String myName = "stop";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        if (this.application != null) {
            int sessionCount = this.getSessionCount();
            if (sessionCount > 0) {
                this.traceLog.finer(String.valueOf(sessionCount) + " Debug Session(s) still active.");
                String[] openSessions = this.getSessionNames();
                for (int i = 0; i < sessionCount; ++i) {
                    String name = openSessions[i];
                    this.traceLog.finer("Terminating DebugSession: " + name);
                    DebugSession session = (DebugSession)this.getSession(name);
                    session.terminate();
                }
            } else {
                this.openSessionFailure();
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }

    void disposeLicenseManager() {
        if (this.lm != null) {
            this.lm = null;
        }
    }

    synchronized void waitForSafeStart(DebugSession session) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            long maxWaitTime = this.environment.getScriptTimeout();
            long actualWaitTime = 0L;
            long startTime = System.currentTimeMillis();
            IDebugServerEventListener listener = i.next();
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                actualWaitTime = System.currentTimeMillis() - startTime;
            } while ((maxWaitTime < 0L || actualWaitTime <= maxWaitTime) && !listener.isSafeToStart(session));
        }
    }

    synchronized void waitForSafeTermination(DebugSession session) {
        Iterator<IDebugServerEventListener> i = this.serverListeners.iterator();
        while (i.hasNext()) {
            long maxWaitTime = this.environment.getScriptTimeout();
            long actualWaitTime = 0L;
            long startTime = System.currentTimeMillis();
            IDebugServerEventListener listener = i.next();
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                actualWaitTime = System.currentTimeMillis() - startTime;
            } while ((maxWaitTime < 0L || actualWaitTime <= maxWaitTime) && !listener.isSafeToTerminate(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeAndUnload() throws ScriptingException {
        if (this.application != null) {
            try {
                if (this.environment.isRegistered(RTDX_SERVER)) {
                    IScriptServer rtdxServer = this.environment.getServer(RTDX_SERVER);
                    rtdxServer.stop();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            int sessionCount = this.getSessionCount();
            if (sessionCount == 0) {
                this.traceLog.finer("Firing: onServerStopping()");
                this.fireOnServerStopping(this);
                IApplication iApplication = this.application;
                synchronized (iApplication) {
                    try {
                        this.traceLog.finer("Stopping DebugServer");
                        if (this.application.isConfigured()) {
                            Callback callback = new Callback();
                            this.application.deConfigure(callback);
                            callback.waitForConfigure();
                        }
                        if (null != this.deviceList) {
                            this.deviceList.clear();
                        }
                        this.traceLog.finer("Firing: onServerStopped()");
                        this.fireOnServerStopped(this);
                    }
                    catch (Exception e) {
                        throw new ScriptingException(4002, "Cannot shut down DebugServer: " + e.getMessage());
                    }
                    finally {
                        this.application = null;
                        this.environment.unregisterServer((IScriptServer)this);
                    }
                }
            }
        }
    }

    private void listDevices() {
        int boardCount;
        String myName = "listDevices";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        this.deviceList = new ArrayList();
        IDspBoards boards = this.getApplication().getDspBoards();
        if (boards != null && (boardCount = boards.getCount()) > 0) {
            for (int i = 0; i < boardCount; ++i) {
                int taskCount;
                IDspTasks nonDebugTasks;
                int taskCount2;
                IDspBoard board = boards.getItem(i);
                if (board == null) continue;
                IDspTasks tasks = board.getDspTasks();
                if (tasks != null && (taskCount2 = tasks.getCount()) > 0) {
                    for (int j = 0; j < taskCount2; ++j) {
                        IDspTask task = tasks.getItem(j);
                        if (task == null) continue;
                        String name = task.getFullPathName();
                        String boardName = board.getName();
                        String cpuName = task.getName();
                        int majorISA = task.getProcessorInfo().getTargetSubFamilyID();
                        int minorISA = task.getProcessorInfo().getTargetRev();
                        int platform = task.getProcessorInfo().getTargetType();
                        this.traceLog.finer("Found debuggable device: " + name);
                        this.deviceList.add(new Device(name, boardName, cpuName, majorISA, minorISA, platform, i, j, true));
                    }
                }
                if ((nonDebugTasks = board.getNonDebugTasks()) == null || (taskCount = nonDebugTasks.getCount()) <= 0) continue;
                for (int j = 0; j < taskCount; ++j) {
                    IDspTask task = nonDebugTasks.getItem(j);
                    if (task == null) continue;
                    String name = task.getFullPathName();
                    String boardName = board.getName();
                    String cpuName = task.getName();
                    int majorISA = task.getProcessorInfo().getTargetSubFamilyID();
                    int minorISA = task.getProcessorInfo().getTargetSubFamilyID();
                    int platform = task.getProcessorInfo().getTargetType();
                    this.traceLog.finer("Found non-debuggable device: " + name);
                    this.deviceList.add(new Device(name, boardName, cpuName, majorISA, minorISA, platform, i, j, true));
                }
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }

    public DebugSession openSession() throws ScriptingException {
        return this.openSession(".*");
    }

    public DebugSession openSession(String sPattern) throws ScriptingException {
        String myName = "openSession";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{"sPattern: " + sPattern});
        }
        SessionFactory factory = new SessionFactory();
        this.traceLog.finer("Searching for device exactly matching name: " + sPattern);
        Device match = factory.matchByName(sPattern);
        if (match == null) {
            this.traceLog.finer("No exact name matches found.  Searching for device matching regular expression: " + sPattern);
            match = factory.matchByRegularExpression(sPattern);
        }
        if (match == null) {
            if (this.getSessionCount() == 0) {
                this.openSessionFailure();
            }
            throw new ScriptingException(4003, "Could not open session. No devices found matching: " + sPattern);
        }
        DebugSession session = factory.open(match, this.environment, this);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, session.getName());
        }
        return session;
    }

    private void openSessionFailure() throws ScriptingException {
        int i;
        boolean reCreateLM = false;
        boolean reCreateDP = false;
        int refCountLM = 0;
        int refCountDP = 0;
        this.disposeAndUnload();
        if (reCreateLM) {
            for (i = 1; i <= refCountLM; ++i) {
                LicenseEngine.createInstance();
            }
        }
        if (reCreateDP) {
            try {
                for (i = 1; i <= refCountDP; ++i) {
                    CCEPropertiesEngine.createInstance();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public DebugSession openSession(int nMajorISA, int nMinorISA, int nCPUIndex, int nPlatform) throws ScriptingException {
        SessionFactory factory;
        Device match;
        String myName = "openSession";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{"nMajorISA: " + nMajorISA, "nMinorISA: " + nMinorISA, "nCPUIndex: " + nCPUIndex, "nPlatform: " + nPlatform});
        }
        if ((match = (factory = new SessionFactory()).matchByISA(nMajorISA, nMinorISA, nCPUIndex, nPlatform)) == null) {
            if (this.getSessionCount() == 0) {
                this.openSessionFailure();
            }
            this.environment.errorHandler.raise(new ScriptingException(4003, "Could not open session. No matching devices found."));
            return null;
        }
        DebugSession session = factory.open(match, this.environment, this);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, session.getName());
        }
        return session;
    }

    public DebugSession openSession(String sBoardName, String sCPUName) throws ScriptingException {
        SessionFactory factory;
        Device match;
        String myName = "debuggerOpen";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{"sBoardName: " + sBoardName, "sCPUName: " + sCPUName});
        }
        if ((match = (factory = new SessionFactory()).matchByBoardAndCPUName(sBoardName, sCPUName)) == null) {
            if (this.getSessionCount() == 0) {
                this.openSessionFailure();
            }
            throw new ScriptingException(4003, "Could not open session. No matching devices found.");
        }
        DebugSession session = factory.open(match, this.environment, this);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, session.getName());
        }
        return session;
    }

    public void setConfig(String sConfigurationFile) {
        String myName = "setConfig";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{"sConfigurationFile: " + (sConfigurationFile == null ? "null" : sConfigurationFile)});
        }
        String string = this.userSetConfiguration = sConfigurationFile == null ? null : this.environment.toAbsolutePath(sConfigurationFile);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }

    public String getConfig() {
        String myName = "getConfig";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        String toReturn = this.userSetConfiguration;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, toReturn == null ? "null" : toReturn);
        }
        return toReturn;
    }

    public String getScriptingDirectory() throws ScriptingException {
        String myName = "getScriptingDirectory";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName);
        }
        String path = DirectoryService.instance().getScriptingDir();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, path);
        }
        return path;
    }

    public void listRegisters(String sFileName) throws ScriptingException {
        String myName = "listRegisters";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{"sFileName: " + sFileName});
        }
        if (null == this.application) {
            throw new ScriptingException(1002, "Cannot dump list of registers to file. Must call openSession() first to initialize a valid DebugSession.");
        }
        PrintWriter registerPrintWriter = null;
        try {
            registerPrintWriter = new PrintWriter(this.environment.toAbsolutePath(sFileName));
        }
        catch (FileNotFoundException e) {
            throw new ScriptingException(1002, "Cannot dump list of registers to file. File \"" + sFileName + "\" does not exist");
        }
        registerPrintWriter.println(ScriptingEnvironment.arrayToString((Object[])new String[]{"DebugSession", "RegisterGroup", "RegisterName", "RegisterAlias", "RegisterPage", "RegisterAddress", "RegisterID", "Bitfields"}, (String)","));
        for (Device device : this.deviceList) {
            String deviceName = "\"" + device.getName() + "\"";
            this.traceLog.finer("Getting register list for: " + deviceName);
            DebugSession session = (DebugSession)this.application.getComponent(device.getName(), DebugSession.class.toString());
            IRegisterServer registerServer = session.getDspTask().getRegisterServer();
            int groupCount = registerServer.getNumGroups();
            for (int i = 0; i < groupCount; ++i) {
                String groupName = registerServer.getGroupName(i);
                int regCount = registerServer.getNumRegistersInGroup(i);
                this.traceLog.finer("Processing " + String.valueOf(regCount) + " registers in group " + groupName);
                for (int j = 0; j < regCount; ++j) {
                    String sAddress;
                    String sPage;
                    String sID;
                    IRegister register = registerServer.getRegisterInGroup(i, j);
                    String registerName = register.getName();
                    String registerAlias = register.getAlias();
                    int page = register.getPage();
                    int address = register.getAddress();
                    if (page != 121) {
                        sID = "-";
                        sPage = String.valueOf(page);
                        sAddress = "0x" + Integer.toHexString(address);
                    } else {
                        sID = String.valueOf(address);
                        sPage = "-";
                        sAddress = "-";
                    }
                    int numBitfields = register.getNumBitfields();
                    String sBitfields = "";
                    if (numBitfields > 0) {
                        for (int bitfieldIndex = 0; bitfieldIndex < numBitfields; ++bitfieldIndex) {
                            sBitfields = sBitfields + "<" + register.getBitfieldName(bitfieldIndex) + "> ";
                        }
                    } else {
                        sBitfields = "-";
                    }
                    registerPrintWriter.println(ScriptingEnvironment.arrayToString((Object[])new String[]{deviceName, groupName, registerName, registerAlias, sPage, sAddress, sID, sBitfields}, (String)","));
                }
            }
        }
        registerPrintWriter.flush();
        registerPrintWriter.close();
        registerPrintWriter = null;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName);
        }
    }

    IApplication getApplication() {
        return this.application;
    }

    public TargetConfigurationGenerator createTargetConfigurationGenerator() {
        return new TargetConfigurationGenerator();
    }

    public String[] getListOfCPUs() {
        ArrayList<SystemSetupReader.Cpu> cpuList;
        String currentConfiguration = this.getConfigNoThrow();
        if (null == currentConfiguration) {
            return null;
        }
        SystemSetupEditor systemSetupReader = this.createSystemSetupReader();
        try {
            cpuList = systemSetupReader.getListOfCpus(currentConfiguration, true);
        }
        catch (HardwareDbException e) {
            return null;
        }
        String[] cpuPath = new String[cpuList.size()];
        int i = 0;
        for (SystemSetupReader.Cpu cpu : cpuList) {
            cpuPath[i] = cpu.getBoardName() + "/" + cpu.getName();
            ++i;
        }
        return cpuPath;
    }

    private SystemSetupEditor createSystemSetupReader() {
        SystemSetupEditor systemSetupReader = new SystemSetupEditor();
        String defaultTargetDBPath = DirectoryService.instance().getTargetDBDir();
        systemSetupReader.setInstallDirectory(defaultTargetDBPath);
        systemSetupReader.setUserDirectory(defaultTargetDBPath);
        return systemSetupReader;
    }

    public void testConnection() throws ScriptingException {
        InputStream pipe = null;
        try {
            Process diagnosticUtility = CCEDebugEngine.instance().testConnection(this.getConfigInternal(), 0, this.getDiagnosticUtility());
            pipe = diagnosticUtility.getInputStream();
            this.pipeToStdout(pipe);
            diagnosticUtility.waitFor();
        }
        catch (Exception e) {
            throw new ScriptingException(4001, e.getMessage());
        }
        finally {
            try {
                pipe.close();
            }
            catch (IOException e) {}
        }
    }

    public void setDefaultDialogResponse(String choice) throws ScriptingException {
        String myName = "setDefaultDialogResponse";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, new Object[]{this, "Default Choice: " + choice});
        }
        if (this.application == null) {
            this.cachedChoice = choice;
        } else {
            if (this.dialogListener == null) {
                this.dialogListener = new DialogListener();
                this.application.onMessageDialog().addIObjectEventListener(this.dialogListener);
            }
            this.dialogListener.setDefaultChoice(choice);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, (Object)this);
        }
    }

    public void unsetDefaultDialogResponse() {
        String myName = "unsetDefaultDialogResponse";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(((Object)((Object)this)).getClass().getName(), myName, (Object)this);
        }
        this.cachedChoice = "";
        if (this.dialogListener != null) {
            this.application.onMessageDialog().removeIObjectEventListener(this.dialogListener);
            this.dialogListener = null;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(((Object)((Object)this)).getClass().getName(), myName, (Object)this);
        }
    }

    private String getDiagnosticUtility() throws HardwareDbException, FileNotFoundException, ScriptingException {
        SystemSetupEditor reader = this.createSystemSetupReader();
        reader.load(new FileInputStream(new File(this.getConfigInternal())), this.getConfigInternal());
        ArrayList<SystemSetupEditor.AbstractProperty> properties = reader.getProperties(reader.getChildren(reader.getRoot())[0], false);
        String diagnosticCommand = null;
        for (SystemSetupEditor.AbstractProperty property : properties) {
            if (!property.description.equals("Diagnostic Command")) continue;
            diagnosticCommand = (String)reader.getProperty(property.id);
            break;
        }
        if (null == diagnosticCommand) {
            throw new FileNotFoundException("No diagnostic utility exists for the connection type defined " + this.getConfigInternal());
        }
        return diagnosticCommand;
    }

    private void pipeToStdout(final InputStream pipe) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader stdout = new BufferedReader(new InputStreamReader(pipe));
                try {
                    while (true) {
                        String line;
                        if (null == (line = stdout.readLine())) {
                            continue;
                        }
                        System.out.println(line);
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }).start();
    }

    private String getConfigInternal() throws ScriptingException {
        String currentConfiguration = this.getConfigNoThrow();
        if (null == currentConfiguration) {
            throw new ScriptingException(4001, "No configuration was supplied");
        }
        return currentConfiguration;
    }

    private String getConfigNoThrow() {
        String currentConfiguration = this.userSetConfiguration;
        if (null == currentConfiguration && null != this.application && null == (currentConfiguration = this.application.getConfiguration())) {
            currentConfiguration = System.getProperty("DEFAULT_CCS_TARGET_CONFIGURATION");
        }
        return currentConfiguration;
    }

    private class DialogListener
    implements IObjectEventListener<IBaseDialog> {
        private String defaultChoice;
        private int retryCount = 0;

        DialogListener() {
        }

        void setDefaultChoice(String choice) {
            this.defaultChoice = choice;
        }

        @Override
        public void onEvent(IBaseDialog data) {
            if (data instanceof IMessageDialog) {
                IMessageDialog curDialog = (IMessageDialog)data;
                int choiceIndex = -1;
                int cancelIndex = -1;
                for (int index = 0; index < curDialog.getNumButtons(); ++index) {
                    if (curDialog.getButtonLabel(index).equals(this.defaultChoice)) {
                        choiceIndex = index;
                        continue;
                    }
                    if (!curDialog.getButtonLabel(index).equals("Cancel")) continue;
                    cancelIndex = index;
                }
                if (!curDialog.isDisplayed() && choiceIndex != -1) {
                    curDialog.setDisplayed();
                    this.retryCount = this.defaultChoice.equals("Retry") ? ++this.retryCount : 0;
                    String customChoice = this.defaultChoice;
                    if (this.retryCount >= 10) {
                        choiceIndex = cancelIndex;
                        customChoice = "Cancel";
                        this.retryCount = 0;
                    }
                    curDialog.setButtonResponse(choiceIndex);
                    DebugServer.this.traceLog.log(Level.INFO, "Dialog " + curDialog.getTitle() + " has been set to response: " + customChoice);
                } else if (choiceIndex == -1) {
                    DebugServer.this.traceLog.log(Level.FINER, "Choice: " + this.defaultChoice + " not found for current dialog.");
                }
            }
        }
    }

    private class Callback
    extends AbstractListener
    implements IObjectEventListener<IApplication.InitializationException>,
    ISimpleEventListener {
        private IApplication.InitializationException data;

        private Callback() {
            super(DebugServer.this.traceLog, (ScriptingTimeout)ScriptingEnvironment.instance());
            this.data = null;
        }

        @Override
        public void onEvent(IApplication.InitializationException data) {
            this.data = data;
            this.eventReceived();
        }

        @Override
        public void onEvent() {
            this.eventReceived();
        }

        private void waitForConfigure() throws ScriptingException {
            this.waitUntil();
            if (null != this.data) {
                throw new ScriptingException(4001, this.data.getMessage());
            }
        }
    }

    class SessionFactory {
        SessionFactory() throws ScriptingException {
            try {
                DebugServer.this.start();
            }
            catch (ScriptingException e) {
                DebugServer.this.stop();
                throw new ScriptingException(1006, "Could not start server: " + DebugServer.this.getName() + ": " + e.getMessage());
            }
        }

        Device processMatches(ArrayList<Device> matches, String pattern) throws ScriptingException {
            if (matches.size() == 1) {
                return matches.get(0);
            }
            if (matches.size() == 0) {
                return null;
            }
            if (matches.size() > 1) {
                Object[] tooManyMatches = new String[matches.size()];
                Iterator<Device> iterator = matches.iterator();
                for (int i = 0; i < matches.size(); ++i) {
                    tooManyMatches[i] = iterator.next().getName();
                }
                if (DebugServer.this.getSessionCount() == 0) {
                    DebugServer.this.disposeAndUnload();
                }
                throw new ScriptingException(4003, "Could not open session. Found " + Integer.toString(matches.size()) + " devices matching: " + pattern + "\n" + ScriptingEnvironment.arrayToString((Object[])tooManyMatches, (String)"\n"));
            }
            return null;
        }

        Device matchByName(String name) throws ScriptingException {
            ArrayList<Device> matches = new ArrayList<Device>();
            for (Device device : DebugServer.this.deviceList) {
                String currentName = device.getName();
                if (!currentName.equals(name)) continue;
                matches.add(device);
            }
            return this.processMatches(matches, name);
        }

        Device matchByRegularExpression(String regEx) throws ScriptingException {
            ArrayList<Device> matches = new ArrayList<Device>();
            try {
                for (Device device : DebugServer.this.deviceList) {
                    String name = device.getName();
                    if (!name.matches(regEx)) continue;
                    matches.add(device);
                }
            }
            catch (Exception e) {
                DebugServer.this.traceLog.warning("Invalid regular expression: " + e.getMessage());
            }
            return this.processMatches(matches, regEx);
        }

        Device matchByBoardAndCPUName(String boardName, String cpuName) {
            String currentBoardName;
            if (boardName.equals("*") && cpuName.equals("*")) {
                return (Device)DebugServer.this.deviceList.get(0);
            }
            if (boardName.equals("*")) {
                for (Device device : DebugServer.this.deviceList) {
                    String currentCpuName = device.getCpuName();
                    if (!currentCpuName.equals(cpuName)) continue;
                    return device;
                }
            }
            if (cpuName.equals("*")) {
                for (Device device : DebugServer.this.deviceList) {
                    currentBoardName = device.getBoardName();
                    if (!currentBoardName.equals(boardName)) continue;
                    return device;
                }
            }
            for (Device device : DebugServer.this.deviceList) {
                currentBoardName = device.getBoardName();
                String currentCPUName = device.getCpuName();
                if (!currentBoardName.equals(boardName) || !currentCPUName.equals(cpuName)) continue;
                return device;
            }
            return null;
        }

        Device matchByISA(int majorISA, int minorISA, int cpuIndex, int platform) {
            int currentIndex = 0;
            for (Device device : DebugServer.this.deviceList) {
                if (device.getPlatform() != platform || device.getMajorISA() != majorISA) continue;
                if (cpuIndex == currentIndex) {
                    return device;
                }
                ++currentIndex;
            }
            return null;
        }

        DebugSession open(Device device, ScriptingEnvironment environment, DebugServer server) throws ScriptingException {
            DebugSession session = null;
            session = (DebugSession)DebugServer.this.getSession(device.getName());
            if (session == null) {
                try {
                    DebugServer.this.fireOnSessionOpening(device.getName(), DebugServer.this.currentlyUsedConfiguration);
                    DebugServer.this.lm = LicenseEngine.createInstance();
                    this.licenseCheck("2.0");
                    try {
                        session = (DebugSession)server.application.getComponent(device.getName(), DebugSession.class.toString());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    session.setServer(server);
                    session.setConfig(DebugServer.this.currentlyUsedConfiguration);
                    DebugServer.this.registerSession(session);
                    DebugServer.this.fireOnSessionOpened(session);
                }
                catch (ScriptingException e) {
                    if (session != null) {
                        session.terminate();
                        session = null;
                    }
                    throw new ScriptingException(1007, "Could not open DebugSession : " + device.getName() + ": " + e.getMessage());
                }
                if (!System.getProperty("os.name").contains("Linux")) {
                    DebugServer.this.traceLog.finer("Initializing RTDX: \"" + RTDX_SERVER + "\"");
                    try {
                        IScriptServer rtdxServer = environment.getServer(RTDX_SERVER);
                        rtdxServer.openSession(session.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            DebugServer.this.waitForSafeStart(session);
            return session;
        }

        private void licenseCheck(String version) {
            ILicenseAction la = DebugServer.this.lm.acquireLicense(version);
            if (la.isInitialized() && !la.isLicensed()) {
                StringBuffer sb = new StringBuffer();
                sb.append(la.getStatusMessage());
                sb.append("\n");
                sb.append(la.getDialogMessage());
                DebugServer.this.traceLog.warning(sb.toString());
            }
        }
    }

    static class Device {
        private String name;
        private String boardName;
        private String cpuName;
        private int majorISA;
        private int minorISA;
        private int platform;
        private boolean debuggable;
        private int boardIndex;
        private int cpuIndex;

        Device(String name, String boardName, String cpuName, int majorISA, int minorISA, int platform, int boardIndex, int cpuIndex, boolean debuggable) {
            this.name = name;
            this.boardName = boardName;
            this.cpuName = cpuName;
            this.majorISA = majorISA;
            this.minorISA = minorISA;
            this.platform = platform;
            this.boardIndex = boardIndex;
            this.cpuIndex = cpuIndex;
            this.debuggable = debuggable;
        }

        int getBoardIndex() {
            return this.boardIndex;
        }

        int getCpuIndex() {
            return this.cpuIndex;
        }

        String getName() {
            return this.name;
        }

        boolean isDebuggable() {
            return this.debuggable;
        }

        String getBoardName() {
            return this.boardName;
        }

        String getCpuName() {
            return this.cpuName;
        }

        int getMajorISA() {
            return this.majorISA;
        }

        int getMinorISA() {
            return this.minorISA;
        }

        int getPlatform() {
            return this.platform;
        }
    }
}

