/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.IScriptServer;
import com.ti.ccstudio.scripting.IScriptSession;
import com.ti.ccstudio.scripting.ScriptSession;
import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ccstudio.scripting.environment.ScriptingTimeout;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IGenericComponent;
import com.ti.debug.engine.IPinConnect;
import com.ti.debug.engine.IPortConnect;
import com.ti.debug.engine.dialogs.IBaseDialog;
import com.ti.debug.engine.dialogs.IMessageDialog;
import com.ti.debug.engine.events.IServerListener;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.scripting.ArmAdvancedFeatures;
import com.ti.debug.engine.scripting.Breakpoint;
import com.ti.debug.engine.scripting.CallStack;
import com.ti.debug.engine.scripting.DebugServer;
import com.ti.debug.engine.scripting.Expression;
import com.ti.debug.engine.scripting.Flash;
import com.ti.debug.engine.scripting.GlobalBreakpoint;
import com.ti.debug.engine.scripting.Memory;
import com.ti.debug.engine.scripting.Options;
import com.ti.debug.engine.scripting.PageTable;
import com.ti.debug.engine.scripting.Pin;
import com.ti.debug.engine.scripting.Port;
import com.ti.debug.engine.scripting.ProfileClock;
import com.ti.debug.engine.scripting.ProfileSetup;
import com.ti.debug.engine.scripting.Symbol;
import com.ti.debug.engine.scripting.Target;
import com.ti.debug.engine.scripting.events.internal.EventHandler;
import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.IFlatSystemSetupFile;
import com.ti.debug.engine.scripting.setup.SystemSetupReader;
import com.ti.utility.filesystem.DirectoryService;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugSession
extends ScriptSession
implements IGenericComponent,
ScriptingTimeout {
    private boolean bTerminated = true;
    private IStringEventListener stdOutListener;
    private IStringEventListener stdErrListener;
    private PrintWriter cioPrintWriter;
    private IStringEventListener fatalListener;
    private IStringEventListener errorListener;
    private IStringEventListener warningListener;
    private IStringEventListener infoListener;
    private DialogListener dialogListener;
    private String boardName;
    private String cpuName;
    private String partNum;
    private String sessionName;
    private String targetConfig;
    private IDspTask dspTask;
    private IDspUser dspUser;
    private IApplication application;
    private HashMap<Integer, IDspMemory> dspMemory;
    private IPinConnect pinConnect;
    private IPortConnect portConnect;
    private int debuggerTimeout = -1;
    private boolean bHasTimeout = false;
    public final Breakpoint breakpoint;
    public final GlobalBreakpoint globalBreakpoint;
    public final Expression expression;
    public final Memory memory;
    public final Pin pin;
    public final Port port;
    public final Symbol symbol;
    public final Target target;
    public final ProfileClock clock;
    public final Options options;
    public final ArmAdvancedFeatures armAdvancedFeatures;
    public final Flash flash;
    public final ProfileSetup profileSetup;
    public final PageTable pageTable;
    EventHandler eventHandler;
    public final CallStack callStack;

    public DebugSession(IApplication application, IDspTask task) throws ScriptingException {
        super(ScriptingEnvironment.instance());
        this.application = application;
        this.dspMemory = new HashMap();
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.breakpoint = new Breakpoint(this.environment, this);
        this.globalBreakpoint = new GlobalBreakpoint(this.environment, this);
        this.expression = new Expression(this.environment, this);
        this.memory = new Memory(this.environment, this);
        this.pin = new Pin(this.environment, this);
        this.port = new Port(this.environment, this);
        this.symbol = new Symbol(this.environment, this);
        this.target = new Target(this.environment, this);
        this.clock = new ProfileClock(this.environment, this);
        this.callStack = new CallStack(this.environment, this);
        this.pageTable = new PageTable(this.environment, this);
        this.boardName = "";
        this.cpuName = "";
        this.sessionName = "";
        this.stdOutListener = new CIOStdOutListener(this);
        this.stdErrListener = new CIOStdErrListener(this);
        this.fatalListener = new DebuggerFatalListener(this);
        this.errorListener = new DebuggerErrorListener(this);
        this.warningListener = new DebuggerWarningListener(this);
        this.infoListener = new DebuggerInfoListener(this);
        this.cpuName = task.getName();
        this.traceLog.finer("CPU Name: " + this.cpuName);
        this.partNum = task.getPartnum();
        this.traceLog.finer("PartNum: " + this.partNum);
        this.dspTask = task;
        this.dspUser = task.createDspUser();
        if (this.dspUser == null) {
            throw new ScriptingException(4004, "Task's createDspUser returned a null DspUser");
        }
        this.traceLog.finer("Family: " + Integer.toString(this.dspTask.getProcessorInfo().getTargetFamilyID()));
        this.traceLog.finer("SubFamily/MajorISA: " + Integer.toHexString(this.dspTask.getProcessorInfo().getTargetSubFamilyID()));
        this.traceLog.finer("Revision/MinorISA: " + Integer.toString(this.dspTask.getProcessorInfo().getTargetRev()));
        this.traceLog.finer("Platform: " + Target.Platform.lookupPlatform(this.dspTask.getProcessorInfo().getTargetType()));
        int nProcessorId = this.dspTask.getProcessorInfo().getProcessorID();
        this.traceLog.finer("Processor ID: " + Integer.toString(nProcessorId));
        this.dspUser.onStdOut().addIStringEventListener(this.stdOutListener);
        this.dspUser.onStdErr().addIStringEventListener(this.stdErrListener);
        this.dspUser.onFatal().addIStringEventListener(this.fatalListener);
        this.dspUser.onError().addIStringEventListener(this.errorListener);
        this.dspUser.onWarning().addIStringEventListener(this.warningListener);
        this.dspUser.onInfo().addIStringEventListener(this.infoListener);
        this.sessionName = this.dspTask.getFullPathName();
        this.boardName = this.sessionName.substring(0, this.sessionName.lastIndexOf("/" + this.cpuName));
        this.eventHandler = new EventHandler(this.getDspUser());
        this.options = new Options(this.environment, this);
        this.armAdvancedFeatures = new ArmAdvancedFeatures(this.environment, this);
        this.flash = new Flash(this.environment, this, this.partNum, this.options);
        this.profileSetup = new ProfileSetup(this.environment, application, this);
    }

    void setConfig(String config) {
        this.targetConfig = config;
        if (!(this.targetConfig == null || System.getProperty("eclipse.application") != null && System.getProperty("eclipse.application").equals("org.eclipse.ui.ide.workbench"))) {
            try {
                TargetConfigurationReader configReader = new TargetConfigurationReader(this.targetConfig, this.dspTask.getName());
                HashMap<String, String> attributes = new HashMap<String, String>();
                Map<String, String> deviceProp = configReader.getDeviceProperties();
                Map<String, String> cpuProp = configReader.getCpuProperties();
                if (deviceProp != null) {
                    attributes.putAll(deviceProp);
                }
                if (cpuProp != null) {
                    attributes.putAll(cpuProp);
                }
                if (!this.partNum.equals("")) {
                    attributes.put("partnum", this.partNum);
                }
                if (attributes.size() > 0) {
                    this.options.setAttributes(attributes);
                }
            }
            catch (HardwareDbException hardwareDbException) {
                // empty catch block
            }
        }
    }

    public String getConfig() {
        return this.targetConfig;
    }

    public void setDefaultDialogResponse(String choice) {
        String myName = "setDefaultDialogResponse";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this, "Default Choice: " + choice});
        }
        if (this.dialogListener == null) {
            this.dialogListener = new DialogListener(this);
            this.application.onMessageDialog().addIObjectEventListener(this.dialogListener);
        }
        this.dialogListener.setDefaultChoice(choice);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    public void unsetDefaultDialogResponse() {
        String myName = "unsetDefaultDialogResponse";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this);
        }
        if (this.dialogListener != null) {
            this.application.onMessageDialog().removeIObjectEventListener(this.dialogListener);
            this.dialogListener = null;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    public int getScriptTimeout() {
        if (this.bHasTimeout) {
            return this.debuggerTimeout;
        }
        return this.environment.getScriptTimeout();
    }

    public void setScriptTimeout(int nTimeout) {
        String myName = "setScriptTimeout";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this, "nTimeout: " + nTimeout});
        }
        if (nTimeout < 0) {
            this.debuggerTimeout = -1;
            this.traceLog.log(Level.FINER, "Timeout is infinite", this);
        } else {
            this.debuggerTimeout = nTimeout;
            this.traceLog.log(Level.FINER, "Timeout is " + nTimeout + "ms", this);
        }
        this.bHasTimeout = true;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    public void resetScriptTimeout() {
        String myName = "resetScriptTimeout";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this);
        }
        this.debuggerTimeout = -1;
        this.bHasTimeout = false;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    void setDspMemory(IDspMemory dspMemory) {
        int page = dspMemory.getPageNumber();
        this.dspMemory.put(page, dspMemory);
    }

    void setDspTask(IDspTask dspTask) {
        this.dspTask = dspTask;
    }

    void setDspUser(IDspUser dspUser) {
        this.dspUser = dspUser;
    }

    void setPinConnect(IPinConnect pinConnect) {
        this.pinConnect = pinConnect;
    }

    void setPortConnect(IPortConnect portConnect) {
        this.portConnect = portConnect;
    }

    void setName(String name) {
        this.sessionName = name;
    }

    synchronized void setServer(DebugServer server) {
        this.bTerminated = false;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() throws ScriptingException {
        String myName = "terminate";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this);
        }
        boolean doTerminate = false;
        DebugSession debugSession = this;
        synchronized (debugSession) {
            if (!this.bTerminated) {
                doTerminate = true;
                this.bTerminated = true;
            }
        }
        if (doTerminate) {
            ((DebugServer)this.server).waitForSafeTermination(this);
            this.traceLog.log(Level.FINER, "Firing: onSessionTerminating()", this);
            ((DebugServer)this.server).fireOnSessionTerminating(this);
            try {
                IScriptSession rtdxSession;
                IScriptServer rtdxServer;
                if (this.environment.isRegistered(DebugServer.RTDX_SERVER) && null != (rtdxServer = this.environment.getServer(DebugServer.RTDX_SERVER)) && null != (rtdxSession = rtdxServer.getSession(this.sessionName))) {
                    this.traceLog.log(Level.FINER, "Terminating RTDXSession: " + this.sessionName, this);
                    rtdxSession.terminate();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.traceLog.log(Level.FINER, "Unregistering this session from the DebugServer", this);
            boolean bNoMoreSessions = this.server.unregisterSession((IScriptSession)this);
            this.traceLog.log(Level.FINER, "Firing: onSessionTerminated()", this);
            ((DebugServer)this.server).fireOnSessionTerminated(this);
            ((DebugServer)this.server).disposeLicenseManager();
            if (bNoMoreSessions) {
                ((DebugServer)this.server).disposeAndUnload();
            }
            this.server = null;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    synchronized boolean isTerminated() {
        return this.bTerminated;
    }

    public String getBoardName() throws ScriptingException {
        return this.boardName;
    }

    public String getCPUName() throws ScriptingException {
        return this.cpuName;
    }

    public int getFamily() throws ScriptingException {
        return this.dspTask.getProcessorInfo().getTargetFamilyID();
    }

    public int getMajorISA() throws ScriptingException {
        return this.dspTask.getProcessorInfo().getTargetSubFamilyID();
    }

    public int getMinorISA() throws ScriptingException {
        return this.dspTask.getProcessorInfo().getTargetRev();
    }

    public int getPlatform() throws ScriptingException {
        return this.dspTask.getProcessorInfo().getTargetType();
    }

    public String getPartnum() throws ScriptingException {
        return this.partNum;
    }

    IDspMemory getDspMemory(int nPage) {
        if (this.dspMemory.containsKey(nPage)) {
            return this.dspMemory.get(nPage);
        }
        IDspValue startAddress = this.getDspUser().createDspValue(IDspValue.Type.UINT, 0L);
        IDspMemory currentMemory = this.getDspTask().getMemoryAccess().createDspMemory(startAddress, 1, (short)nPage);
        this.dspMemory.put(nPage, currentMemory);
        return currentMemory;
    }

    IDspTask getDspTask() {
        return this.dspTask;
    }

    IDspUser getDspUser() {
        return this.dspUser;
    }

    IPinConnect getPinConnect() {
        if (this.pinConnect == null) {
            this.pinConnect = this.dspTask.getPinConnect();
            return this.pinConnect;
        }
        return this.pinConnect;
    }

    IPortConnect getPortConnect() {
        if (this.portConnect == null) {
            this.portConnect = this.dspTask.getPortConnect();
            return this.portConnect;
        }
        return this.portConnect;
    }

    public String getStdOut() {
        return ((CIOStdOutListener)this.stdOutListener).getBuffer();
    }

    public String getStdErr() {
        return ((CIOStdErrListener)this.stdErrListener).getBuffer();
    }

    public void beginCIOLogging(String sFileName) throws ScriptingException {
        String myName = "beginCIOLogging";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this, "sFileName: " + sFileName});
        }
        if (this.cioPrintWriter != null) {
            this.cioPrintWriter.flush();
            this.cioPrintWriter.close();
            this.cioPrintWriter = null;
        }
        try {
            this.cioPrintWriter = new PrintWriter(this.environment.toAbsolutePath(sFileName));
        }
        catch (FileNotFoundException e) {
            throw new ScriptingException(1002, "Cannot log CIO to file. File \"" + sFileName + "\" does not exist");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    public void endCIOLogging() {
        String myName = "endCIOLogging";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this);
        }
        if (this.cioPrintWriter != null) {
            this.cioPrintWriter.flush();
            this.cioPrintWriter.close();
            this.cioPrintWriter = null;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this);
        }
    }

    public String getName() throws ScriptingException {
        return this.sessionName;
    }

    class DebuggerInfoListener
    implements IStringEventListener {
        private DebugSession mySession;

        DebuggerInfoListener(DebugSession session) {
            this.mySession = session;
        }

        @Override
        public void onEvent(String data) {
            DebugSession.this.traceLog.log(Level.INFO, data, this.mySession);
        }
    }

    class DebuggerWarningListener
    implements IStringEventListener {
        private DebugSession mySession;

        DebuggerWarningListener(DebugSession session) {
            this.mySession = session;
        }

        @Override
        public void onEvent(String data) {
            DebugSession.this.traceLog.log(Level.WARNING, data, this.mySession);
        }
    }

    class DebuggerErrorListener
    implements IStringEventListener {
        private DebugSession mySession;

        DebuggerErrorListener(DebugSession session) {
            this.mySession = session;
        }

        @Override
        public void onEvent(String data) {
            DebugSession.this.traceLog.log(Level.SEVERE, data, this.mySession);
        }
    }

    class DebuggerFatalListener
    implements IStringEventListener {
        private DebugSession mySession;

        DebuggerFatalListener(DebugSession session) {
            this.mySession = session;
        }

        @Override
        public void onEvent(String data) {
            DebugSession.this.traceLog.log(Level.SEVERE, data, this.mySession);
        }
    }

    class CIOStdErrListener
    implements IStringEventListener {
        private String buffer = "";
        private DebugSession mySession;

        CIOStdErrListener(DebugSession session) {
            this.mySession = session;
        }

        public String getBuffer() {
            return this.buffer;
        }

        @Override
        public void onEvent(String data) {
            this.buffer = data;
            if (DebugSession.this.cioPrintWriter != null) {
                DebugSession.this.cioPrintWriter.print(this.buffer);
                DebugSession.this.cioPrintWriter.flush();
            }
            DebugSession.this.traceLog.log(Level.SEVERE, this.buffer, this.mySession);
        }
    }

    class CIOStdOutListener
    implements IStringEventListener {
        private String buffer = "";
        private DebugSession mySession;

        CIOStdOutListener(DebugSession session) {
            this.mySession = session;
        }

        public String getBuffer() {
            return this.buffer;
        }

        @Override
        public void onEvent(String data) {
            this.buffer = data;
            if (DebugSession.this.cioPrintWriter != null) {
                DebugSession.this.cioPrintWriter.print(this.buffer);
                DebugSession.this.cioPrintWriter.flush();
            }
            DebugSession.this.traceLog.log(Level.INFO, this.buffer, this.mySession);
        }
    }

    class DebuggerErrorEventListener
    implements IServerListener {
        DebuggerErrorEventListener() {
        }
    }

    private class DialogListener
    implements IObjectEventListener<IBaseDialog> {
        private DebugSession mySession;
        private String defaultChoice;
        private int retryCount = 0;

        DialogListener(DebugSession session) {
            this.mySession = session;
        }

        void setDefaultChoice(String choice) {
            this.defaultChoice = choice;
        }

        @Override
        public void onEvent(IBaseDialog data) {
            IMessageDialog curDialog;
            if (data instanceof IMessageDialog && !(curDialog = (IMessageDialog)data).isDisplayed()) {
                curDialog.setDisplayed();
                String customChoice = this.defaultChoice;
                this.retryCount = this.defaultChoice.equals("Retry") ? ++this.retryCount : 0;
                if (this.retryCount >= 10) {
                    customChoice = "Cancel";
                    this.retryCount = 0;
                }
                for (int index = 0; index < curDialog.getNumButtons(); ++index) {
                    if (customChoice.equals(curDialog.getButtonLabel(index))) {
                        curDialog.setButtonResponse(index);
                        DebugSession.this.traceLog.log(Level.INFO, "Dialog " + curDialog.getTitle() + " has been set to response: " + customChoice, this.mySession);
                        break;
                    }
                    if (index != curDialog.getNumButtons() - 1) continue;
                    DebugSession.this.traceLog.log(Level.FINER, "Choice: " + customChoice + " not found for current dialog.", this.mySession);
                    curDialog.dismiss();
                }
            }
        }
    }

    private class TargetConfigurationReader {
        private IFlatSystemSetupFile systemSetupFile;
        private SystemSetupReader.Cpu cpu;

        public TargetConfigurationReader(String ccxml, String taskName) throws HardwareDbException {
            SystemSetupReader setupReader = new SystemSetupReader();
            String defaultTargetDBPath = DirectoryService.instance().getTargetDBDir();
            setupReader.setInstallDirectory(defaultTargetDBPath);
            setupReader.setUserDirectory(defaultTargetDBPath);
            this.systemSetupFile = setupReader.openFlatSystemSetupFile(ccxml);
            ArrayList<SystemSetupReader.Cpu> cpulist = this.systemSetupFile.getListofCpus(true);
            for (SystemSetupReader.Cpu curCPU : cpulist) {
                if (!curCPU.getName().equals(taskName)) continue;
                this.cpu = curCPU;
                break;
            }
        }

        public Map<String, String> getDeviceProperties() {
            return this.systemSetupFile.getDeviceProperties(this.cpu);
        }

        public Map<String, String> getCpuProperties() {
            return this.systemSetupFile.getCpuProperties(this.cpu);
        }
    }
}

