/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class ExecutionOperation
extends APIContainer {
    private final String sClass;
    private final String sFunction;

    ExecutionOperation(ScriptingEnvironment environment, DebugSession session, String sClass, String sFunction) throws ScriptingException {
        super(environment, session);
        this.sClass = sClass;
        this.sFunction = sFunction;
        this.traceLog = Logger.getLogger(sClass);
    }

    protected abstract boolean isCapable();

    protected abstract void issueExecution();

    void go() throws ScriptingException {
        try {
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.sClass, this.sFunction, this.session);
            }
            this.ensureTargetIsConnected();
            if (!this.isCapable()) {
                throw new ScriptingException(1003, "operation not allowed at current location");
            }
            APIContainer.OnHaltListener haltListener = new APIContainer.OnHaltListener();
            this.session.getDspUser().onHalt().addIObjectEventListener(haltListener);
            this.traceLog.log(Level.FINER, "Requesting target execution", this.session);
            this.issueExecution();
            haltListener.waitUntil();
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.sClass, this.sFunction, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), this.sClass + "." + this.sFunction + "(): " + e.getMessage());
        }
    }
}

