/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Expression
extends APIContainer {
    Expression(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    IExpressionEvaluationData eval(String sExpression) throws ScriptingException {
        try {
            this.traceLog.log(Level.FINER, "Requesting evaluation of expression: \"" + sExpression + "\"", this.session);
            ExprEvalListener exprEvalListener = new ExprEvalListener();
            this.session.getDspTask().getExpressionEvaluator().requestEvaluation(sExpression, exprEvalListener, false);
            exprEvalListener.waitUntil();
            String errorMsg = exprEvalListener.getData().getErrorMessage();
            if (0 != errorMsg.length()) {
                throw new ScriptingException(4007, errorMsg);
            }
            return exprEvalListener.getData();
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error evaluating \"" + sExpression + "\": " + e.getMessage());
        }
    }

    public long evaluate(String sExpression) throws ScriptingException {
        String myName = "evaluate";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sExpression: " + sExpression});
        }
        long rawResult_ULong = 0L;
        IExpressionEvaluationData result = this.eval(sExpression);
        IDspValue dspValue = result.getTargetData();
        rawResult_ULong = dspValue.toLongLong();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, "0x" + Long.toHexString(rawResult_ULong)});
        }
        return rawResult_ULong;
    }

    class ExprEvalListener
    extends AbstractListener
    implements IObjectEventListener<IExpressionEvaluationData> {
        private IExpressionEvaluationData data;

        private ExprEvalListener() {
            super(Expression.this.traceLog, Expression.this.session);
        }

        @Override
        public void onEvent(IExpressionEvaluationData result) {
            this.data = result;
            Expression.this.traceLog.log(Level.FINER, "Evaluated expression: " + this.data.getExpression(), Expression.this.session);
            this.eventReceived();
        }

        public IExpressionEvaluationData getData() {
            return this.data;
        }
    }
}

