/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IFlashProgrammerManager;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.Options;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Flash
extends APIContainer {
    private IFlashProgrammerManager flashProgrammerManager;
    public Options options;

    public Flash(ScriptingEnvironment environment, DebugSession session, String variantName, Options opt) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        try {
            this.flashProgrammerManager = session.getDspTask().getFlashProgrammerManager();
            this.options = opt;
        }
        catch (Exception e) {
            this.flashProgrammerManager = null;
            throw new ScriptingException(4020, "Could not access flash manager");
        }
    }

    public boolean isFlashSupported() {
        String myName = "isFlashSupported";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName);
        }
        boolean retVal = this.flashProgrammerManager.getTargetSupported();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, myName});
        }
        return retVal;
    }

    public void performOperation(String opCode) throws ScriptingException {
        String myName = "performOperation";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "opCode: " + opCode});
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation(opCode);
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void listSupportedOperations() throws ScriptingException {
        String myName = "listSupportedOperations";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        String opListStr = this.flashProgrammerManager.listSupportedOperation();
        System.out.println("Supported Opcodes:");
        System.out.println(opListStr);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void erase() throws ScriptingException {
        String myName = "erase";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("Erase");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void calculateChecksum() throws ScriptingException {
        String myName = "calculateChecksum";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("CalculateChecksum");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        int flashChecksum = this.flashProgrammerManager.getData("FLASHCHECKSUM");
        int OTPChecksum = this.flashProgrammerManager.getData("OTPCHECKSUM");
        String flashCSStr = "Flash Checksum: " + Integer.toHexString(flashChecksum);
        String optCSStr = "OTP Checksum: " + Integer.toHexString(OTPChecksum);
        System.out.println(flashCSStr);
        System.out.println(optCSStr);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1} {2}", new Object[]{this.session, flashCSStr, optCSStr});
        }
    }

    public int getFlashChecksum() throws ScriptingException {
        String myName = "getFlashChecksum";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("CalculateChecksum");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        int result = this.flashProgrammerManager.getData("FLASHCHECKSUM");
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public int getOTPChecksum() throws ScriptingException {
        String myName = "getOTPChecksum";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("CalculateChecksum");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        int result = this.flashProgrammerManager.getData("OTPCHECKSUM");
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public void depletionRecovery() throws ScriptingException {
        String myName = "depletionRecovery";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("DepletionRecovery");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void programPassword() throws ScriptingException {
        String myName = "programPassword";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("ProgramPassword");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void lock() throws ScriptingException {
        String myName = "lock";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("Lock");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void unlock() throws ScriptingException {
        String myName = "unlock";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("Unlock");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void startFrequencyTest() throws ScriptingException {
        String myName = "startFrequencyTest";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("FrequencyTest");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void endFrequencyTest() throws ScriptingException {
        String myName = "endFrequencyTest";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        boolean retVal = this.flashProgrammerManager.performOperation("EndFrequencyTest");
        if (!retVal) {
            throw new ScriptingException(4020, "Error executing Flash operation.");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void multiloadStart() throws ScriptingException {
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        this.flashProgrammerManager.multiLoadMode(true);
    }

    public void multiloadEnd() throws ScriptingException {
        if (!this.flashProgrammerManager.getTargetSupported()) {
            throw new ScriptingException(4020, "Target is not connected or does not support current Flash operation.");
        }
        this.flashProgrammerManager.multiLoadMode(false);
    }
}

