/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalBreakpoint
extends APIContainer {
    static final String ON_GLOBALBP_CHANGED = "onGlobalBPChanged";

    GlobalBreakpoint(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public boolean isEnabled() throws ScriptingException {
        return this.session.getDspUser().getGlobalBreakpoints();
    }

    public void enable() throws ScriptingException {
        this.change(true);
    }

    public void disable() throws ScriptingException {
        this.change(false);
    }

    private void change(boolean enable) throws ScriptingException {
        try {
            String myName;
            String string = myName = enable ? "enable" : "disable";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            if (!this.session.getDspUser().capableGlobalBreakpoints()) {
                throw new ScriptingException(4004, "Target does not support global breakpoints");
            }
            this.ensureTargetIsConnected();
            if (this.isEnabled() == enable) {
                throw new ScriptingException(4004, "Global breakpoints are already " + myName + "d");
            }
            this.traceLog.log(Level.FINER, "Requesting global breakpoint " + myName, this.session);
            OnGlobalBreakpointChanged globalBPListener = new OnGlobalBreakpointChanged();
            this.session.getDspUser().onGlobalBreakpointsChanged().addIBooleanEventListener(globalBPListener);
            this.session.getDspUser().setGlobalBreakpoints(enable);
            globalBPListener.waitUntil();
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error " + (enable ? "enabling" : "disabling") + " global breakpoints: " + e.getMessage());
        }
    }

    class OnGlobalBreakpointChanged
    extends AbstractListener
    implements IBooleanEventListener {
        private OnGlobalBreakpointChanged() {
            super(GlobalBreakpoint.this.traceLog, GlobalBreakpoint.this.session);
        }

        @Override
        public void onEvent(boolean data) {
            this.log("Global Breakpoint status has changed");
            this.eventReceived();
        }
    }
}

