/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.IMemoryAccess;
import com.ti.debug.engine.IRegister;
import com.ti.debug.engine.IRegisterServer;
import com.ti.debug.engine.ISectionInfo;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.data.IMemoryAccessEventData;
import com.ti.debug.engine.events.data.IRegisterAccessEventData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.IStringEventListener;
import com.ti.debug.engine.impl.DspUser;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.MemoryMap;
import com.ti.debug.engine.scripting.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Memory
extends APIContainer {
    private static final int MAX_BUFFER_SIZE = 32752;
    public final MemoryMap map;
    private Long bssInitValue;

    Memory(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.map = new MemoryMap(environment, session);
    }

    static String generateFileLoadErrorMessage(long errorCode) {
        int iErrorCode = (int)errorCode;
        switch (iErrorCode) {
            case 0: {
                return "Success";
            }
            case 1: {
                return "Invalid file name";
            }
            case 2: {
                return "No listing file";
            }
            case 3: {
                return "No tag file";
            }
            case 4: {
                return "Listing file too old";
            }
            case 5: {
                return "File not available";
            }
            case 6: {
                return "Invalid file format";
            }
            case 7: {
                return "User abort";
            }
            case 8: {
                return "Reload error";
            }
            case 9: {
                return "Program loader busy";
            }
            case 10: {
                return "CL data error";
            }
            case 11: {
                return "Invalid endianess";
            }
            case 12: {
                return "File size error";
            }
            case 13: {
                return "Target error";
            }
            case 14: {
                return "Memory not writable";
            }
        }
        return "Unknown error";
    }

    public int getPage(int nPage) {
        String myName = "getPage";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + nPage});
        }
        int nValidPage = nPage;
        int pageCountTgt = this.getPageCount();
        if (nPage < 0 || nPage > pageCountTgt - 1) {
            nValidPage = 0;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, nValidPage});
        }
        return nValidPage;
    }

    public int getPageCount() {
        String myName = "getPageCount";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        short pageCountTgt = this.session.getDspUser().numberOfMemoryPages();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, (int)pageCountTgt});
        }
        return pageCountTgt;
    }

    public void fill(long nAddress, int nPage, int nLength, long nValue) throws ScriptingException {
        String myName = "fill";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: 0x" + Long.toHexString(nAddress), "nPage: " + nPage, "nLength: 0x" + Long.toHexString(nLength), "nValue: 0x" + Long.toHexString(nValue)});
        }
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        IDspValue value = access.createDspValue(IDspValue.Type.UDATA64, nValue);
        value.typeCast(value.bestMatchedUDataTypeType(this.session.getDspUser().wordSizeInBits((short)nPage), (short)nPage), 0);
        access.requestMemoryFill(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, value, callback);
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void fill(String sSectionName, long nValue) throws ScriptingException {
        String myName = "fill";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        this.traceLog.log(Level.FINER, "Looking-up section", this.session);
        ISectionInfo section = this.session.symbol.getSection(sSectionName);
        this.traceLog.log(Level.FINER, "Looking-up start addess, size, and page of section", this.session);
        long address = Memory.unsignedIntToLong(section.getLoadLocation());
        short page = (short)this.getPage(section.isData() ? 1 : 0);
        int sizeInBytes = section.getLength();
        int sizeInWords = sizeInBytes / (this.session.getDspUser().wordSizeInBits(page) / 8);
        this.traceLog.log(Level.FINER, "Initializing section: " + sSectionName, this.session);
        this.fill(address, page, sizeInWords, nValue);
    }

    public void save(long nAddress, int nPage, int nLength, String sFile, int nIOFormat, boolean bAppend) throws ScriptingException {
        String myName = "save";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + nAddress, "nPage: " + nPage, "nLength: " + nLength, "sFile: " + sFile, "nIOFormat: " + nIOFormat, "bAppend: " + bAppend});
        }
        String sFileName = this.environment.toAbsolutePath(sFile).replaceAll("\\\\", "\\\\\\\\");
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        if (5 == nIOFormat) {
            if (bAppend) {
                throw new ScriptingException(4009, "COFF files cannot be appended to");
            }
            access.requestMemorySaveCoff(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, sFileName, callback);
        } else {
            access.requestMemorySave(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, sFileName, this.convert(nIOFormat), bAppend, callback);
        }
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    private IMemoryAccess.FileFormat convert(int nIOFormat) throws ScriptingException {
        switch (nIOFormat) {
            case 1: {
                return IMemoryAccess.FileFormat.FIO_CSTYLEHEX;
            }
            case 2: {
                return IMemoryAccess.FileFormat.FIO_SIGNINT;
            }
            case 3: {
                return IMemoryAccess.FileFormat.FIO_SIGNLONG;
            }
            case 4: {
                return IMemoryAccess.FileFormat.FIO_FLOAT;
            }
        }
        throw new ScriptingException(4008, "Invalid file format specified");
    }

    public void load(long nAddress, int nPage, int nLength, String sFile) throws ScriptingException {
        String myName = "load";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + nAddress, "nPage: " + nPage, "nLength: " + nLength, "sFile: " + sFile});
        }
        String sFileName = this.environment.toAbsolutePath(sFile).replaceAll("\\\\", "\\\\\\\\");
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        access.requestMemoryLoad(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, sFileName, callback);
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadData2(long nAddress, int nPage, int nLength, String sFile) throws ScriptingException {
        String myName = "load";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + nAddress, "nPage: " + nPage, "nLength: " + nLength, "sFile: " + sFile});
        }
        String sFileName = this.environment.toAbsolutePath(sFile).replaceAll("\\\\", "\\\\\\\\");
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        access.requestMemoryLoadData(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, sFileName, callback);
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void saveData2(long nAddress, int nPage, int nLength, String sFile, int format, boolean bAppend) throws ScriptingException {
        String myName = "save";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + nAddress, "nPage: " + nPage, "nLength: " + nLength, "sFile: " + sFile, "format: " + format, "bAppend: " + bAppend});
        }
        String sFileName = this.environment.toAbsolutePath(sFile).replaceAll("\\\\", "\\\\\\\\");
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        access.requestMemorySaveData(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, sFileName, format, bAppend, callback);
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public String[] getSupportedTypes(int nPage) throws ScriptingException {
        String myName = "save";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + nPage});
        }
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        List<IDspValue.SupportedType> supportedTypes = access.getSupportedTypes(nPage);
        String[] toReturn = new String[supportedTypes.size()];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = supportedTypes.get((int)i).DisplayString;
            ScriptingEnvironment.instance().traceWrite(i + " - " + toReturn[i]);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
        return toReturn;
    }

    public void loadBinaryProgram(String sFileName, long startAddr) throws ScriptingException {
        try {
            String myName = "loadBinaryProgram";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFileName: " + sFileName});
            }
            if (null == sFileName) {
                throw new NullPointerException();
            }
            this.loadBinary(sFileName, startAddr);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error loading \"" + sFileName + "\": " + e.getMessage());
        }
    }

    private void loadBinary(String sFileName, long startAddr) throws ScriptingException {
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo programLoadedListener = new APIContainer.OnCompleteWithErrorInfo();
        this.traceLog.log(Level.FINER, "Requesting program load", this.session);
        if (null == sFileName) {
            throw new ScriptingException(4011, "file name = null");
        }
        sFileName = this.environment.toAbsolutePath(sFileName);
        this.session.getDspTask().getSymbolManager().requestBinFileProgramLoad(sFileName, startAddr, programLoadedListener);
        programLoadedListener.waitUntil();
        String result = programLoadedListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4011, result);
        }
        this.traceLog.log(Level.FINER, "Program load successful", this.session);
        this.waitForHaltIfPropertySet("AutoRunToLabelOnRestart");
        if (this.bssInitValue != null) {
            this.traceLog.log(Level.FINER, "Initializing .bss section", this.session);
            this.session.memory.fill(".bss", this.bssInitValue);
        }
    }

    public void loadProgram(String sFileName) throws ScriptingException {
        try {
            String myName = "loadProgram";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFileName: " + sFileName});
            }
            if (null == sFileName) {
                throw new NullPointerException();
            }
            this.load(sFileName);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error loading \"" + sFileName + "\": " + e.getMessage());
        }
    }

    private void load(String sFileName) throws ScriptingException {
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo programLoadedListener = new APIContainer.OnCompleteWithErrorInfo();
        this.traceLog.log(Level.FINER, "Requesting program load", this.session);
        if (null == sFileName) {
            this.session.getDspTask().getSymbolManager().requestFileReload(programLoadedListener);
        } else {
            sFileName = this.environment.toAbsolutePath(sFileName);
            this.session.getDspTask().getSymbolManager().requestFileLoad(sFileName, programLoadedListener);
        }
        programLoadedListener.waitUntil();
        String result = programLoadedListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4011, result);
        }
        this.traceLog.log(Level.FINER, "Program load successful", this.session);
        this.waitForHaltIfPropertySet("AutoRunToLabelOnRestart");
        if (this.bssInitValue != null) {
            this.traceLog.log(Level.FINER, "Initializing .bss section", this.session);
            this.session.memory.fill(".bss", this.bssInitValue);
        }
    }

    public void loadProgram(String sFileName, Object[] args) throws ScriptingException {
        boolean autoRunToLabelOnRestart;
        String myName = "loadProgram";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFileName: " + sFileName, "args: " + ScriptingEnvironment.arrayToString((Object[])args, (String)", ")});
        }
        if (autoRunToLabelOnRestart = this.session.options.getBoolean("AutoRunToLabelOnRestart")) {
            this.session.options.setBoolean("AutoRunToLabelOnRestart", false);
        }
        boolean autoRunToLabelOnReset = false;
        if (this.session.getFamily() == 430 && this.session.options.getBoolean("AutoRunToLabelOnReset")) {
            autoRunToLabelOnReset = true;
            this.session.options.setBoolean("AutoRunToLabelOnReset", false);
        }
        this.traceLog.log(Level.FINER, "Loading program with arguments", this.session);
        this.loadProgram(sFileName);
        this.traceLog.log(Level.FINER, "Writing arguments", this.session);
        this.setArgs(args);
        if (autoRunToLabelOnRestart) {
            this.session.options.setBoolean("AutoRunToLabelOnRestart", true);
            this.session.target.restart();
        }
        if (autoRunToLabelOnReset) {
            this.session.options.setBoolean("AutoRunToLabelOnReset", true);
            this.session.target.reset();
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadHostedProgram(String sFileName, String args) throws ScriptingException {
        String myName = "loadHostedProgram";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFileName: " + sFileName, "args: " + args});
        }
        this.setSemihostingMainArgs(args);
        this.loadProgram(sFileName);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void reloadProgram() throws ScriptingException {
        try {
            String myName = "reloadProgram";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            this.load(null);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error reloading: " + e.getMessage());
        }
    }

    public void setBssInitValue(Long nInitValue) {
        String myName = "setBssInitValue";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nInitValue: " + nInitValue});
        }
        this.bssInitValue = nInitValue;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public long readRegister(String sRegister) throws ScriptingException {
        return this.readRegister(sRegister, false);
    }

    public synchronized long readRegister(String sRegister, boolean bSigned) throws ScriptingException {
        String myName = "readRegister";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sRegister: " + sRegister});
        }
        long nResult = 0L;
        if (this.session.getMajorISA() == 84 && (sRegister.equals("A") || sRegister.equals("B"))) {
            long nHighVal;
            long nLowVal;
            this.traceLog.log(Level.FINER, "Reading accumulators as separate halves", this.session);
            this.traceLog.log(Level.FINER, "Reading register as a memory read", this.session);
            if (sRegister.equals("A")) {
                this.traceLog.log(Level.FINER, "Reading C54 accumulator A as separate halves: AL and AH");
                nLowVal = this.readRegister("AL");
                nHighVal = this.readRegister("AH");
            } else {
                this.traceLog.log(Level.FINER, "Writing C54 accumulator B as separate halves: BL and BH", this.session);
                nLowVal = this.readRegister("BL");
                nHighVal = this.readRegister("BH");
            }
            nResult = nHighVal << 16 | nLowVal;
        }
        IRegisterServer registerServer = this.session.getDspTask().getRegisterServer();
        this.traceLog.log(Level.FINER, "Getting register information", this.session);
        IRegister register = registerServer.findRegisterByName(sRegister);
        if (register == null) {
            throw new ScriptingException(4010, "Register " + sRegister + " not found.");
        }
        int page = register.getPage();
        int bits = register.getBitLength();
        int pageCountTgt = this.getPageCount();
        if (page > pageCountTgt - 1) {
            this.traceLog.log(Level.FINER, sRegister + " is a " + String.valueOf(bits) + " bit core register", this.session);
            IExpressionEvaluationData result = this.session.expression.eval(sRegister);
            IDspValue dspValue = result.getTargetData();
            nResult = bSigned ? Long.parseLong(dspValue.toStringSignedInt()) : Long.parseLong(dspValue.toStringUnsignedInt());
        } else {
            int rawAddress_UInt = register.getAddress();
            long rawAddress_ULong = Memory.unsignedIntToLong(rawAddress_UInt);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.log(Level.FINER, sRegister + " is a " + String.valueOf(bits) + " bit memory-mapped register at " + "Address 0x" + Long.toHexString(rawAddress_ULong) + " on Page " + String.valueOf(page), this.session);
            }
            nResult = this.readData(page, rawAddress_ULong, bits, bSigned);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, "0x" + Long.toHexString(nResult)});
        }
        return nResult;
    }

    public synchronized void writeRegister(String sRegister, long nValue) throws ScriptingException {
        String myName = "writeRegister";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sRegister: " + sRegister, "nValue: 0x" + Long.toHexString(nValue)});
        }
        if (this.session.getMajorISA() == 84 && (sRegister.equals("A") || sRegister.equals("B"))) {
            long nLowVal = nValue & 0xFFFFL;
            long nHighVal = nValue >> 16 & 0xFFFFL;
            if (sRegister.equals("A")) {
                this.traceLog.log(Level.FINER, "Writing C54 accumulator A as separate halves: AL and AH", this.session);
                this.writeRegister("AL", nLowVal);
                this.writeRegister("AH", nHighVal);
            } else {
                this.traceLog.log(Level.FINER, "Writing C54 accumulator B as separate halves: BL and BH", this.session);
                this.writeRegister("BL", nLowVal);
                this.writeRegister("BH", nHighVal);
            }
        }
        IRegisterServer registerServer = this.session.getDspTask().getRegisterServer();
        this.traceLog.log(Level.FINER, "Getting register information", this.session);
        IRegister register = registerServer.findRegisterByName(sRegister);
        if (register == null) {
            throw new ScriptingException(4010, "Register " + sRegister + " not found.");
        }
        int page = register.getPage();
        int bits = register.getBitLength();
        int pageCountTgt = this.getPageCount();
        if (page > pageCountTgt - 1) {
            this.traceLog.log(Level.FINER, sRegister + " is a " + String.valueOf(bits) + " bit core register", this.session);
            this.session.expression.eval(sRegister + "=0x" + Long.toHexString(nValue));
        } else {
            int rawAddress_UInt = register.getAddress();
            long rawAddress_ULong = Memory.unsignedIntToLong(rawAddress_UInt);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.log(Level.FINER, sRegister + " is a " + String.valueOf(bits) + " bit memory-mapped register at " + "Address 0x" + Long.toHexString(rawAddress_ULong) + " on Page " + String.valueOf(page), this.session);
            }
            this.writeData(page, rawAddress_ULong, nValue, bits);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public long readData(int nPage, long nAddress, int nTypeSize) throws ScriptingException {
        return this.readData(nPage, nAddress, nTypeSize, 1, false)[0];
    }

    public long readData(int nPage, long nAddress, int nTypeSize, boolean bSigned) throws ScriptingException {
        return this.readData(nPage, nAddress, nTypeSize, 1, bSigned)[0];
    }

    public long[] readData(int nPage, long nAddress, int nTypeSize, int nNumValues) throws ScriptingException {
        return this.readData(nPage, nAddress, nTypeSize, nNumValues, false);
    }

    public synchronized long[] readData(int nPage, long nAddress, int nTypeSize, int nNumValues, boolean bSigned) throws ScriptingException {
        try {
            int i;
            String myName = "readData";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress), "nTypeSize: " + String.valueOf(nTypeSize), "nNumValues: " + String.valueOf(nNumValues), "bSigned: " + bSigned});
            }
            if (nNumValues < 0) {
                throw new ScriptingException(1002, "nNumValues: " + String.valueOf(nNumValues) + " out of range.");
            }
            this.traceLog.log(Level.FINER, "Validating page", this.session);
            int pageCountTgt = this.getPageCount();
            if (nPage < 0 || nPage > pageCountTgt - 1) {
                throw new ScriptingException(1002, "nPage: " + String.valueOf(nPage) + " out of range.");
            }
            if (!Target.DSP_VALUE_TYPE.bValidIntegerSize(nTypeSize)) {
                throw new ScriptingException(1002, "nTypeSize: " + Target.DSP_VALUE_TYPE.getInvalidIntegerSizeMessage(nTypeSize));
            }
            this.traceLog.log(Level.FINER, "Validating start address", this.session);
            int addressSizeArg = Long.bitCount(nAddress);
            int addressSizeTgt = this.session.getDspUser().addrSizeInBits((short)nPage);
            if (addressSizeArg > addressSizeTgt) {
                throw new ScriptingException(1002, "nAddress: 0x" + Long.toHexString(nAddress) + " out of range.");
            }
            IDspValue startAddress = this.session.getDspUser().createDspValue(IDspValue.Type.UDATA32, nAddress);
            IDspValue.Type dataType = bSigned ? startAddress.bestMatchedSignedDataTypeType(nTypeSize, (short)nPage) : startAddress.bestMatchedUDataTypeType(nTypeSize, (short)nPage);
            IDspValue dspValue = this.session.getDspUser().createDspValue(dataType, 0L);
            int addrUnits = dspValue.sizeOf2((short)nPage);
            int maxValuesPerBuffer = 32752 / addrUnits;
            if (nNumValues > maxValuesPerBuffer) {
                long[] bigArray = new long[nNumValues];
                int count = nNumValues / maxValuesPerBuffer;
                if (nNumValues % maxValuesPerBuffer != 0) {
                    ++count;
                }
                for (int i2 = 0; i2 < count; ++i2) {
                    int startPosition = i2 * maxValuesPerBuffer;
                    int length = maxValuesPerBuffer;
                    if (startPosition + length - 1 > nNumValues) {
                        length = nNumValues - startPosition;
                    }
                    long newAddress = nAddress + (long)(i2 * 32752);
                    long[] subsetArray = this.readData(nPage, newAddress, nTypeSize, length, bSigned);
                    System.arraycopy(subsetArray, 0, bigArray, startPosition, length);
                }
                if (this.traceLog.isLoggable(Level.FINER)) {
                    this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, this.loggableArray(bigArray)});
                }
                return bigArray;
            }
            this.traceLog.log(Level.FINER, "Getting memory object from debug session", this.session);
            IDspMemory dspMemory = this.session.getDspMemory(nPage);
            this.traceLog.log(Level.FINER, "Setting start address: 0x" + Long.toHexString(nAddress), this.session);
            dspMemory.changeStartAddress(startAddress);
            int bufferLength = nNumValues * addrUnits;
            this.traceLog.log(Level.FINER, "Setting buffer length: " + String.valueOf(bufferLength), this.session);
            dspMemory.setLength(bufferLength);
            OnMemoryRequestCompleteListener memoryRequestCompleteListener = new OnMemoryRequestCompleteListener();
            this.traceLog.log(Level.FINER, "Requeting memory read of " + String.valueOf(nNumValues) + " value(s) from target", this.session);
            this.session.getDspTask().getMemoryAccess().requestMemoryRead(dspMemory, memoryRequestCompleteListener);
            memoryRequestCompleteListener.waitUntil();
            this.traceLog.log(Level.FINER, "Generating " + nNumValues + " element Java array from raw memory buffer", this.session);
            ArrayList<String> memErrors = new ArrayList<String>();
            long[][] parameterArray = new long[][]{new long[nNumValues]};
            long[] processedArray = new long[nNumValues];
            int[] errorArray = dspMemory.getValues(dspValue, 0, parameterArray);
            HashMap<Integer, Integer> errorMap = new HashMap<Integer, Integer>();
            if (errorArray != null) {
                for (i = 0; i < errorArray.length; ++i) {
                    errorMap.put(errorArray[i], errorArray[i]);
                }
            }
            for (i = 0; i < nNumValues; ++i) {
                int offset = i * addrUnits;
                if (errorMap.containsKey(i)) {
                    dspMemory.getDspValue(dspValue, offset);
                    int errorCode = ((IDspMemory2)dspMemory).getErrorCode(offset);
                    if (errorCode == 0) continue;
                    memErrors.add(this.generateDspMemory2ErrMsg(nAddress + (long)offset, errorCode));
                    continue;
                }
                long rawData = parameterArray[0][i];
                if (rawData < 0L && !bSigned) {
                    throw new ScriptingException(4008, "Unsigned value overflow. Maximum 64 bit unsigned value supported is 0x7FFFFFFFFFFFFFFF. Attempt to to read 0x" + Long.toHexString(rawData));
                }
                processedArray[i] = rawData;
            }
            if (!memErrors.isEmpty()) {
                String e = ScriptingEnvironment.arrayToString((Object[])memErrors.toArray(), (String)"|");
                throw new ScriptingException(4008, "Errors during memory.readData(): " + e);
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, this.loggableArray(processedArray)});
            }
            return processedArray;
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error reading memory: " + e.getMessage());
        }
    }

    public long readWord(int nPage, long nAddress) throws ScriptingException {
        return this.readWord(nPage, nAddress, 1, false)[0];
    }

    public long readWord(int nPage, long nAddress, boolean bSigned) throws ScriptingException {
        return this.readWord(nPage, nAddress, 1, bSigned)[0];
    }

    public long[] readWord(int nPage, long nAddress, int nNumWords) throws ScriptingException {
        return this.readWord(nPage, nAddress, nNumWords, false);
    }

    public long[] readWord(int nPage, long nAddress, int nNumWords, boolean bSigned) throws ScriptingException {
        String myName = "readWord";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress), "nNumWords: " + String.valueOf(nNumWords), "bSigned: " + bSigned});
        }
        int pageCountTgt = this.getPageCount();
        if (nPage < 0 || nPage > pageCountTgt - 1) {
            throw new ScriptingException(1002, "nPage: " + String.valueOf(nPage) + " out of range.");
        }
        this.traceLog.log(Level.FINER, "Calculating size of a Word", this.session);
        int wordSize = this.session.getDspUser().wordSizeInBits((short)nPage);
        this.traceLog.log(Level.FINER, "Word Size: " + String.valueOf(wordSize) + " bits", this.session);
        long[] data = this.readData(nPage, nAddress, wordSize, nNumWords, bSigned);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, this.loggableArray(data)});
        }
        return data;
    }

    String generateDspMemory2ErrMsg(long nAddress, int errorCode) {
        String errMsg = "Address: 0x" + Long.toHexString(nAddress) + " Error: 0x" + Integer.toHexString(errorCode);
        return errMsg;
    }

    public void writeData(int nPage, long nAddress, long nValue, int nTypeSize) throws ScriptingException {
        this.writeData(nPage, nAddress, new long[]{nValue}, nTypeSize);
    }

    public synchronized void writeData(int nPage, long nAddress, long[] nValues, int nTypeSize) throws ScriptingException {
        try {
            String myName = "writeData";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress), "nValues: " + this.loggableArray(nValues), "nTypeSize: " + String.valueOf(nTypeSize)});
            }
            this.traceLog.log(Level.FINER, "Validating page", this.session);
            DspUser dspUser = (DspUser)this.session.getDspUser();
            short pageCountTgt = dspUser.numberOfMemoryPages();
            if (nPage < 0 || nPage > pageCountTgt - 1) {
                throw new ScriptingException(1002, "nPage: " + String.valueOf(nPage) + " out of range.");
            }
            if (!Target.DSP_VALUE_TYPE.bValidIntegerSize(nTypeSize)) {
                throw new ScriptingException(1002, "nTypeSize: " + Target.DSP_VALUE_TYPE.getInvalidIntegerSizeMessage(nTypeSize));
            }
            this.traceLog.log(Level.FINER, "Validating start address", this.session);
            int addressSizeArg = Long.bitCount(nAddress);
            int addressSizeTgt = dspUser.addrSizeInBits((short)nPage);
            if (addressSizeArg > addressSizeTgt) {
                throw new ScriptingException(1002, "nAddress: 0x" + Long.toHexString(nAddress) + " out of range.");
            }
            IDspValue startAddress = dspUser.createDspValue(IDspValue.Type.DATA64, nAddress);
            IDspValue.Type dataType = startAddress.bestMatchedUDataTypeType(nTypeSize, (short)nPage);
            IDspValue dspValue = dspUser.createDspValue(dataType, 0);
            int addrUnits = dspValue.sizeOf2((short)nPage);
            int maxValuesPerBuffer = 32752 / addrUnits;
            if (nValues.length > maxValuesPerBuffer) {
                int count = nValues.length / maxValuesPerBuffer;
                if (nValues.length % maxValuesPerBuffer != 0) {
                    ++count;
                }
                long[] nSubset = new long[maxValuesPerBuffer];
                for (int i = 0; i < count; ++i) {
                    int startPosition = i * maxValuesPerBuffer;
                    int length = maxValuesPerBuffer;
                    if (startPosition + length - 1 > nValues.length) {
                        length = nValues.length - startPosition;
                        nSubset = new long[length];
                    }
                    System.arraycopy(nValues, startPosition, nSubset, 0, length);
                    long newAddress = nAddress + (long)(i * 32752);
                    this.writeData(nPage, newAddress, nSubset, nTypeSize);
                }
            } else {
                this.traceLog.log(Level.FINER, "Getting memory object from debug session", this.session);
                IDspMemory dspMemory = this.session.getDspMemory(nPage);
                this.traceLog.log(Level.FINER, "Setting start address: 0x" + Long.toHexString(nAddress), this.session);
                dspMemory.changeStartAddress(startAddress);
                int bufferLength = nValues.length * addrUnits;
                this.traceLog.log(Level.FINER, "Setting buffer length: " + String.valueOf(bufferLength), this.session);
                dspMemory.setLength(bufferLength);
                this.traceLog.log(Level.FINER, "Filling buffer", this.session);
                for (int i = 0; i < nValues.length; ++i) {
                    int offset = i * addrUnits;
                    dspValue.assignLongLong(nValues[i]);
                    dspMemory.setDspValue(dspValue, offset);
                }
                this.traceLog.log(Level.FINER, "Writing " + String.valueOf(nValues.length) + " value(s) to target", this.session);
                OnMemoryRequestCompleteListener memoryRequestCompleteListener = new OnMemoryRequestCompleteListener();
                this.traceLog.log(Level.FINER, "Requesting memory write of " + String.valueOf(nValues.length) + " value(s) to target", this.session);
                this.session.getDspTask().getMemoryAccess().requestMemoryWrite(dspMemory, memoryRequestCompleteListener);
                memoryRequestCompleteListener.waitUntil();
                ArrayList<String> memErrors = new ArrayList<String>();
                for (int i = 0; i < nValues.length; ++i) {
                    int offset = i * addrUnits;
                    int errorCode = ((IDspMemory2)dspMemory).getErrorCode(offset);
                    if (errorCode == 0) continue;
                    memErrors.add(this.generateDspMemory2ErrMsg(nAddress + (long)offset, errorCode));
                }
                if (!memErrors.isEmpty()) {
                    String e = ScriptingEnvironment.arrayToString((Object[])memErrors.toArray(), (String)"|");
                    throw new ScriptingException(4009, "Errors during memory.writeData(): " + e);
                }
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error writing memory: " + e.getMessage());
        }
    }

    public void writeWord(int nPage, long nAddress, long nValue) throws ScriptingException {
        this.writeWord(nPage, nAddress, new long[]{nValue});
    }

    public void writeWord(int nPage, long nAddress, long[] nValues) throws ScriptingException {
        String myName = "writeWord";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress), "nValues: " + this.loggableArray(nValues)});
        }
        int pageCountTgt = this.getPageCount();
        if (nPage < 0 || nPage > pageCountTgt - 1) {
            throw new ScriptingException(1002, "nPage: " + String.valueOf(nPage) + " out of range.");
        }
        this.traceLog.log(Level.FINER, "Calculating size of a Word", this.session);
        int wordSize = this.session.getDspUser().wordSizeInBits((short)nPage);
        this.traceLog.log(Level.FINER, "Word Size: " + String.valueOf(wordSize) + " bits", this.session);
        this.writeData(nPage, nAddress, nValues, wordSize);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadRaw(int nPage, long nAddress, String sFilename, int nTypeSize, boolean bByteSwap) throws ScriptingException {
        String myName = "loadRaw";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress), "sFilename: " + sFilename, "nTypeSize: " + String.valueOf(nTypeSize), "bByteSwap: " + String.valueOf(bByteSwap)});
        }
        String sFileName = this.environment.toAbsolutePath(sFilename).replaceAll("\\\\", "\\\\\\\\");
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        access.requestMemoryLoadRaw(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, sFileName, nTypeSize, bByteSwap, callback);
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void saveRaw(int nPage, long nAddress, String sFilename, int nLength, int nTypeSize, boolean bByteSwap) throws ScriptingException {
        String myName = "saveRaw";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress), "sFilename: " + sFilename, "nLength: " + String.valueOf(nLength), "nTypeSize: " + String.valueOf(nTypeSize), "bByteSwap: " + String.valueOf(bByteSwap)});
        }
        if (nLength <= 0) {
            throw new ScriptingException(1002, "Error saving zero sized data.");
        }
        String sFileName = this.environment.toAbsolutePath(sFilename).replaceAll("\\\\", "\\\\\\\\");
        IMemoryAccess access = this.session.getDspTask().getMemoryAccess();
        APIContainer.OnCompleteWithErrorInfo callback = new APIContainer.OnCompleteWithErrorInfo();
        access.requestMemorySaveRaw(access.createDspValue(IDspValue.Type.UDATA32, nAddress), nPage, nLength, sFileName, nTypeSize, bByteSwap, callback);
        callback.waitUntil();
        if (0 != callback.getErrorMessage().length()) {
            throw new ScriptingException(4009, callback.getErrorMessage());
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadData(int nPage, long nAddress, String sFilename, int nLength) throws ScriptingException {
        this.load(nAddress, nPage, nLength, sFilename);
    }

    public void saveData(int nPage, long nAddress, String sFilename, int nLength, int nIOFormat, boolean bAppend) throws ScriptingException {
        this.save(nAddress, nPage, nLength, sFilename, nIOFormat, bAppend);
    }

    public void loadCoff(int nPage, long nAddress, String sFilename, int nLength) throws ScriptingException {
        this.load(nAddress, nPage, nLength, sFilename);
    }

    public void saveCoff(int nPage, long nAddress, String sFilename, int nLength) throws ScriptingException {
        this.save(nAddress, nPage, nLength, sFilename, 5, false);
    }

    void setArgs(Object[] args) throws ScriptingException {
        String myName = "setArgs";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "args: " + ScriptingEnvironment.arrayToString((Object[])args, (String)",")});
        }
        String ARGS_SECTION = ".args";
        String ARGS_SYMBOL = "___c_args__";
        if (this.session.symbol.exists("__c_args__")) {
            ARGS_SYMBOL = "__c_args__";
        }
        if (args == null || args.length == 0) {
            this.traceLog.log(Level.FINER, "No arguments provided", this.session);
        } else {
            this.traceLog.log(Level.FINER, "Looking-up start addess of args buffer", this.session);
            long argsStartAddress = this.session.symbol.getAddress(ARGS_SYMBOL);
            if (argsStartAddress != 0xFFFFFFFFL) {
                IDspValue dspValueChar = this.session.getDspUser().createDspValue(IDspValue.Type.CHAR, 0L);
                IDspValue dspValueInt = this.session.getDspUser().createDspValue(IDspValue.Type.INT, 0L);
                IDspValue dspValuePointer = this.session.getDspUser().createDspValue(IDspValue.Type.POINTER, 0L);
                int sizeOfChar = dspValueChar.bitSizeOf();
                int sizeOfInt = dspValueInt.bitSizeOf();
                int sizeOfPointer = dspValuePointer.bitSizeOf();
                if (this.session.getMajorISA() == 40) {
                    sizeOfChar = 16;
                    sizeOfInt = 32;
                    sizeOfPointer = 32;
                }
                int intOffset = sizeOfInt / sizeOfChar;
                int pointerOffset = sizeOfPointer / sizeOfChar;
                int charOffset = dspValueChar.sizeOf2((short)this.getPage(1));
                this.traceLog.log(Level.FINER, "Calculating size required for arguments", this.session);
                int sizeNeeded = intOffset + pointerOffset * args.length + pointerOffset;
                for (int i = 0; i < args.length; ++i) {
                    String currentArgument = args[i].toString() + "\u0000";
                    char[] charArray = currentArgument.toCharArray();
                    sizeNeeded += charArray.length;
                }
                this.traceLog.log(Level.FINER, sizeNeeded + " bytes required", this.session);
                this.traceLog.log(Level.FINER, "Calculating size of .args section", this.session);
                int argsSectionSize = this.session.symbol.getSectionSize(ARGS_SECTION);
                this.traceLog.log(Level.FINER, argsSectionSize + " bytes available", this.session);
                if (sizeNeeded > argsSectionSize) {
                    this.traceLog.log(Level.SEVERE, ".args section is too small (" + argsSectionSize + " bytes allocated) " + "to contain argument buffer (" + sizeNeeded + " bytes required). " + "Arguments will be written, but will write past end of .args boundry.", this.session);
                }
                long argVPointerAddress = argsStartAddress + (long)(sizeOfInt / sizeOfChar);
                long argVContentAddress = argsStartAddress + (long)intOffset + (long)(args.length * pointerOffset) + (long)pointerOffset;
                this.traceLog.log(Level.FINE, "Writing argc: 0x" + Long.toHexString(argsStartAddress) + " = " + args.length, this.session);
                this.writeData(this.getPage(1), argsStartAddress, args.length, sizeOfInt);
                for (int i = 0; i < args.length; ++i) {
                    this.traceLog.log(Level.FINE, "Writing argv[" + i + "] pointer: 0x" + Long.toHexString(argVPointerAddress) + " = 0x" + Long.toHexString(argVContentAddress), this.session);
                    this.writeData(this.getPage(1), argVPointerAddress, argVContentAddress, sizeOfPointer);
                    StringBuffer currentArgument = new StringBuffer(args[i].toString());
                    this.traceLog.log(Level.FINE, "Writing argv " + i + " value:    0x" + Long.toHexString(argVContentAddress) + " = " + currentArgument, this.session);
                    currentArgument.append("\u0000");
                    char[] charArray = currentArgument.toString().toCharArray();
                    for (int j = 0; j < charArray.length; ++j) {
                        this.writeData(this.getPage(1), argVContentAddress, charArray[j], sizeOfChar);
                        argVContentAddress += (long)charOffset;
                    }
                    argVPointerAddress += (long)(sizeOfPointer / sizeOfChar);
                }
                this.traceLog.log(Level.FINE, "Writing NULL pointer:    0x" + Long.toHexString(argVPointerAddress) + " = 0x0", this.session);
                this.writeData(this.getPage(1), argVPointerAddress, 0L, sizeOfPointer);
            } else {
                throw new ScriptingException(4011, ARGS_SYMBOL + " not defined.  Use \"--args=n\" when linking target executable " + "to allocate n bytes for arguments.");
            }
        }
    }

    void setSemihostingMainArgs(String args) {
        if (args == null) {
            args = "";
        }
        this.session.getDspTask().getSymbolManager().requestSetSemihostingMainArgs(args.trim(), new IStringEventListener(){

            @Override
            public void onEvent(String data) {
            }
        });
    }

    class OnRegisterRequestCompleteListener
    extends AbstractListener
    implements IObjectEventListener<IRegisterAccessEventData> {
        private IRegisterAccessEventData data;

        private OnRegisterRequestCompleteListener() {
            super(Memory.this.traceLog, Memory.this.session);
        }

        @Override
        public void onEvent(IRegisterAccessEventData result) {
            this.data = result;
            this.eventReceived();
        }

        public IRegisterAccessEventData getData() {
            return this.data;
        }
    }

    class OnMemoryRequestCompleteListener
    extends AbstractListener
    implements IObjectEventListener<IMemoryAccessEventData> {
        private OnMemoryRequestCompleteListener() {
            super(Memory.this.traceLog, Memory.this.session);
        }

        @Override
        public void onEvent(IMemoryAccessEventData data) {
            Memory.this.traceLog.log(Level.FINER, "Memory request complete", Memory.this.session);
            this.eventReceived();
        }
    }

    public static class IOFormat {
        public static final int HEX = 1;
        public static final int INT = 2;
        public static final int LONG = 3;
        public static final int FLOAT = 4;
        public static final int COFF = 5;

        private IOFormat() {
        }
    }

    public static class Page {
        public static final int NONE = 65535;
        public static final int PROGRAM = 0;
        public static final int DATA = 1;
        public static final int IO = 2;
        public static final int DATA_BYTE = 3;
        public static final int IO_BYTE = 4;

        private Page() {
        }
    }
}

