/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryMap
extends APIContainer {
    MemoryMap(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public void enable(boolean bMapOn) throws ScriptingException {
        String myName = "enable";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "bMapOn: " + bMapOn});
        }
        if (!bMapOn) {
            this.traceLog.log(Level.FINER, "Disabling memory mapping", this.session);
        } else {
            this.traceLog.log(Level.FINER, "Enabling memory mapping", this.session);
        }
        this.session.getDspUser().enableMemoryMap(bMapOn);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void add(long nAddress, int nPage, long nLength, boolean bReadable, boolean bWritable) throws ScriptingException {
        String myName = "add";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + nAddress, "nPage: " + nPage, "nLength: " + nLength, "bReadable: " + bReadable, "bWritable: " + bWritable});
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_MapAdd(");
        sCommand.append(nAddress);
        sCommand.append(",");
        sCommand.append(nPage);
        sCommand.append(",");
        sCommand.append(nLength);
        sCommand.append(",");
        if (bReadable) {
            sCommand.append(1);
        } else {
            sCommand.append(0);
        }
        sCommand.append(",");
        if (bWritable) {
            sCommand.append(1);
        } else {
            sCommand.append(0);
        }
        sCommand.append(")");
        this.traceLog.log(Level.FINER, "Adding memory map", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void remove(long nAddress, int nPage) throws ScriptingException {
        String myName = "delete";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: " + nAddress, "nPage: " + nPage});
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_MapDelete(");
        sCommand.append(nAddress);
        sCommand.append(",");
        sCommand.append(nPage);
        sCommand.append(")");
        this.traceLog.log(Level.FINER, "Deleting memory map", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void reset() throws ScriptingException {
        String myName = "reset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_MapReset()");
        this.traceLog.log(Level.FINER, "Resetting memory map", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }
}

