/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.cce.CCEPropertiesEngine;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.properties.IBooleanProperty;
import com.ti.debug.properties.IChoiceListProperty;
import com.ti.debug.properties.IDebugProperties;
import com.ti.debug.properties.IDebugPropertiesManager;
import com.ti.debug.properties.IGroup;
import com.ti.debug.properties.INode;
import com.ti.debug.properties.INumericProperty;
import com.ti.debug.properties.IProperties;
import com.ti.debug.properties.IProperty;
import com.ti.debug.properties.IStringListProperty;
import com.ti.debug.properties.IStringProperty;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Options
extends APIContainer {
    private IDebugPropertiesManager debugPropertiesManager;
    private IDebugProperties debugProperties;

    Options(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        try {
            this.debugPropertiesManager = CCEPropertiesEngine.createInstance();
            this.debugProperties = this.debugPropertiesManager.getDebugProperties(session.getDspTask().getFullPathName(), session.getDspTask().getTargetType());
        }
        catch (Exception e) {
            throw new ScriptingException(1006, "Could not access user preferences");
        }
    }

    Options(ScriptingEnvironment environment, DebugSession session, String dbName) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        try {
            this.debugPropertiesManager = CCEPropertiesEngine.createInstance();
            this.debugProperties = this.debugPropertiesManager.getDebugPropertiesWithDB(session.getDspTask().getFullPathName(), session.getDspTask().getTargetType(), null, dbName, session.getDspTask());
            this.traceLog.log(Level.FINER, "DBName: " + dbName, session);
        }
        catch (Exception e) {
            throw new ScriptingException(1006, "Could not access user preferences");
        }
    }

    void setAttributes(Map<String, String> attributes) {
        if (this.debugProperties != null && this.debugPropertiesManager != null) {
            this.debugProperties = this.debugPropertiesManager.getDebugPropertiesWithAttribute(this.session.getDspTask().getFullPathName(), this.session.getDspTask().getTargetType(), attributes);
        }
    }

    public boolean optionExist(String id) {
        String myName = "optionExist";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id});
        }
        boolean rtnVal = false;
        IProperty prop = this.debugProperties.getProperty(id);
        boolean bl = rtnVal = prop != null;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, rtnVal});
        }
        return rtnVal;
    }

    public String getValueType(String id) {
        String myName = "getValueType";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        String rtnVal = "undefined";
        IProperty prop = this.debugProperties.getProperty(id);
        if (prop instanceof IBooleanProperty) {
            rtnVal = "boolean";
        } else if (prop instanceof IStringProperty) {
            rtnVal = "string";
        } else if (prop instanceof INumericProperty) {
            rtnVal = "numeric";
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
        return rtnVal;
    }

    public boolean getBoolean(String id) throws ScriptingException {
        IProperty prop;
        String myName = "getBoolean";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id});
        }
        if ((prop = this.debugProperties.getProperty(id)) == null) {
            throw new ScriptingException(4019, "Option not found");
        }
        if (!(prop instanceof IBooleanProperty)) {
            throw new ScriptingException(4019, "Option is not a Boolean");
        }
        boolean result = ((IBooleanProperty)prop).getCurValue();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public void setBoolean(String id, boolean value) throws ScriptingException {
        IProperty prop;
        String myName = "setBoolean";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id, "Value: " + value});
        }
        if ((prop = this.debugProperties.getProperty(id)) == null) {
            throw new ScriptingException(4019, "Option not found");
        }
        if (prop.getDisableStatus() || prop.getReadOnly()) {
            throw new ScriptingException(4019, "Option is disabled or readonly; unable to set value.");
        }
        if (!(prop instanceof IBooleanProperty)) {
            throw new ScriptingException(4019, "Option is not a Boolean");
        }
        ((IBooleanProperty)prop).setCurValue(value);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public long getNumeric(String id) throws ScriptingException {
        IProperty prop;
        String myName = "getNumeric";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id});
        }
        if ((prop = this.debugProperties.getProperty(id)) == null) {
            throw new ScriptingException(4019, "Option not found");
        }
        if (!(prop instanceof INumericProperty)) {
            throw new ScriptingException(4019, "Option is not a Numeric");
        }
        long result = ((INumericProperty)prop).getCurValue();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public void setNumeric(String id, long value) throws ScriptingException {
        IProperty prop;
        String myName = "setNumeric";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id, "Value: " + value});
        }
        if ((prop = this.debugProperties.getProperty(id)) == null) {
            throw new ScriptingException(4019, "Option not found");
        }
        if (prop.getDisableStatus() || prop.getReadOnly()) {
            throw new ScriptingException(4019, "Option is disabled or readonly; unable to set value.");
        }
        if (!(prop instanceof INumericProperty)) {
            throw new ScriptingException(4019, "Option is not a Numeric");
        }
        ((INumericProperty)prop).setCurValue((int)value);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public String getString(String id) throws ScriptingException {
        IProperty prop;
        String myName = "getString";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id});
        }
        if ((prop = this.debugProperties.getProperty(id)) == null) {
            throw new ScriptingException(4019, "Option not found");
        }
        if (!(prop instanceof IStringProperty)) {
            throw new ScriptingException(4019, "Option is not a String");
        }
        String result = ((IStringProperty)prop).getCurValue();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public void setString(String id, String value) throws ScriptingException {
        IProperty prop;
        String myName = "setString";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id, "Value: " + value});
        }
        if ((prop = this.debugProperties.getProperty(id)) == null) {
            throw new ScriptingException(4019, "Option not found");
        }
        if (prop.getDisableStatus() || prop.getReadOnly()) {
            throw new ScriptingException(4019, "Option is disabled or readonly; unable to set value.");
        }
        if (!(prop instanceof IStringProperty)) {
            throw new ScriptingException(4019, "Option is not a String");
        }
        ((IStringProperty)prop).setCurValue(value);
        if (!((IStringProperty)prop).getCurValue().equals(value)) {
            throw new ScriptingException(4019, "Value is not valid for current property");
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void printOptions(String regex) throws ScriptingException {
        String myName = "printOptions";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "Regex: " + regex});
        }
        IProperties props = null;
        try {
            props = this.debugProperties.getRootMenuElements();
            Pattern pattern = Pattern.compile(".*" + regex + ".*", 2);
            int n = props.getCount();
            for (int i = 0; i < n; ++i) {
                String qualifiedName;
                IProperty prop = props.getProperty(i);
                if (prop.getIden().equals("ProgramMemmoryLoadNode") || prop.getIden().equals("AutoRunAndLaunchNode") || prop.getIden().equals("MiscOtherNode")) {
                    qualifiedName = prop.getName();
                } else {
                    qualifiedName = this.session.getDspTask().getTargetType();
                    if (n > 2) {
                        qualifiedName = qualifiedName + "." + prop.getName();
                    }
                }
                this.searchProperty(prop, pattern, qualifiedName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void printOptionById(String id) throws ScriptingException {
        String myName = "printOptions";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "ID: " + id});
        }
        IProperty prop = this.debugProperties.getProperty(id);
        this.printOptionByIdHelper(prop);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadSessionSettings(String filePath) throws ScriptingException {
        String myName = "loadSessionSettings";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "filePath: " + filePath});
        }
        String loadString = "";
        try {
            File xmlFile = new File(filePath);
            if (!xmlFile.exists()) {
                throw new ScriptingException(4019, "Session file cannot be found.");
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList coreList = doc.getElementsByTagName("Core");
            for (int i = 0; i < coreList.getLength(); ++i) {
                Node dpNode;
                Node dpNode2;
                NodeList dpNodeList;
                Node nNode = coreList.item(i);
                if (nNode.getNodeType() != 1) continue;
                Element core = (Element)nNode;
                if (!this.session.getCPUName().equals(core.getAttribute("name")) || (dpNodeList = core.getElementsByTagName("DebugProperties")).getLength() <= 0 || (dpNode2 = (dpNode = dpNodeList.item(0)).getFirstChild()) == null) continue;
                loadString = dpNode2.getNodeValue();
                break;
            }
        }
        catch (Exception e) {
            throw new ScriptingException(4019, "Error loading session settings.");
        }
        if (!loadString.equals("")) {
            System.out.println(loadString);
            this.debugProperties.loadSettings(loadString);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    private void printOptionByIdHelper(IProperty prop) {
        if (prop == null) {
            return;
        }
        if (prop instanceof INode) {
            INode node = (INode)prop;
            IProperties childProps = node.getChildren();
            for (int i = 0; i < childProps.getCount(); ++i) {
                this.printOptionByIdHelper(childProps.getProperty(i));
            }
        } else if (prop instanceof IGroup) {
            IGroup node = (IGroup)prop;
            IProperties childProps = node.getChildren();
            for (int i = 0; i < childProps.getCount(); ++i) {
                this.printOptionByIdHelper(childProps.getProperty(i));
            }
        } else if (prop instanceof IBooleanProperty) {
            Boolean value = ((IBooleanProperty)prop).getCurValue();
            this.printCommonPropertyAttributes("Boolean", prop.getIden(), prop.getName(), value.toString());
        } else if (prop instanceof INumericProperty) {
            INumericProperty numericProp = (INumericProperty)prop;
            int value = numericProp.getCurValue();
            this.printCommonPropertyAttributes("Numeric", prop.getIden(), prop.getName(), Integer.toString(value));
            if (numericProp.getHasRange()) {
                System.out.println("    range: " + numericProp.getLowerRange() + " - " + numericProp.getUpperRange());
            }
        } else if (prop instanceof IStringProperty) {
            IStringProperty stringProp = (IStringProperty)prop;
            String value = stringProp.getCurValue();
            if (stringProp instanceof IChoiceListProperty) {
                this.printCommonPropertyAttributes("Radio Button", prop.getIden(), prop.getName(), value);
                System.out.println("    choices:");
                IChoiceListProperty choiceListProp = (IChoiceListProperty)stringProp;
                int num = choiceListProp.getNumAllowedValues();
                for (int i = 0; i < num; ++i) {
                    System.out.println("        " + choiceListProp.getAllowedValue(i));
                }
            } else if (stringProp instanceof IStringListProperty) {
                this.printCommonPropertyAttributes("Drop-down Menu", prop.getIden(), prop.getName(), value);
                System.out.println("    choices:");
                IStringListProperty stringListProp = (IStringListProperty)stringProp;
                int num = stringListProp.getNumAllowedValues();
                for (int i = 0; i < num; ++i) {
                    System.out.println("        " + stringListProp.getAllowedValue(i));
                }
            } else {
                this.printCommonPropertyAttributes("String", prop.getIden(), prop.getName(), value);
            }
        }
    }

    private void searchProperty(IProperty prop, Pattern pattern, String qualifiedName) {
        String id = prop.getIden();
        if (prop instanceof INode) {
            INode node = (INode)prop;
            IProperties props = node.getChildren();
            this.searchProperties(props, pattern, qualifiedName);
        } else if (prop instanceof IGroup) {
            IGroup group = (IGroup)prop;
            IProperties props = group.getChildren();
            this.searchProperties(props, pattern, qualifiedName);
        } else if (pattern.matcher(qualifiedName).matches() || pattern.matcher(id).matches()) {
            if (prop instanceof IBooleanProperty) {
                Boolean value = ((IBooleanProperty)prop).getCurValue();
                this.printCommonPropertyAttributes("Boolean", id, qualifiedName, value.toString());
            } else if (prop instanceof INumericProperty) {
                INumericProperty numericProp = (INumericProperty)prop;
                int value = numericProp.getCurValue();
                this.printCommonPropertyAttributes("Numeric", id, qualifiedName, Integer.toString(value));
                if (numericProp.getHasRange()) {
                    System.out.println("    range: " + numericProp.getLowerRange() + " - " + numericProp.getUpperRange());
                }
            } else if (prop instanceof IStringProperty) {
                IStringProperty stringProp = (IStringProperty)prop;
                String value = stringProp.getCurValue();
                if (stringProp instanceof IChoiceListProperty) {
                    this.printCommonPropertyAttributes("Radio Button", id, qualifiedName, value);
                    System.out.println("    choices:");
                    IChoiceListProperty choiceListProp = (IChoiceListProperty)stringProp;
                    int num = choiceListProp.getNumAllowedValues();
                    for (int i = 0; i < num; ++i) {
                        System.out.println("        " + choiceListProp.getAllowedValue(i));
                    }
                } else if (stringProp instanceof IStringListProperty) {
                    this.printCommonPropertyAttributes("Drop-down Menu", id, qualifiedName, value);
                    System.out.println("    choices:");
                    IStringListProperty stringListProp = (IStringListProperty)stringProp;
                    int num = stringListProp.getNumAllowedValues();
                    for (int i = 0; i < num; ++i) {
                        System.out.println("        " + stringListProp.getAllowedValue(i));
                    }
                } else {
                    this.printCommonPropertyAttributes("String", id, qualifiedName, value);
                }
            }
        }
    }

    private void searchProperties(IProperties props, Pattern pattern, String qualifiedName) {
        int n = props.getCount();
        for (int i = 0; i < n; ++i) {
            IProperty prop = props.getProperty(i);
            this.searchProperty(prop, pattern, qualifiedName + "." + prop.getName());
        }
    }

    private void printCommonPropertyAttributes(String type, String id, String qualifiedName, String value) {
        System.out.println(type + " Option:");
        System.out.println("    id: " + id);
        System.out.println("    name: " + qualifiedName);
        System.out.println("    value: " + value);
    }
}

