/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.pagetableviewer.IPageTableViewer;
import com.ti.pagetableviewer.impl.PageTableViewer;
import java.util.List;
import java.util.logging.Logger;

public class PageTable
extends APIContainer {
    private static String newLine = System.getProperty("line.separator");

    PageTable(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public String lookupAddress(long address) {
        IDspValue virtualAddress = this.session.getDspTask().getMemoryAccess().createDspValue(IDspValue.Type.UDATA64, address);
        IPageTableViewer pageTableViewer = PageTableViewer.getPageTableViewer(this.session.getDspTask());
        try {
            IPageTableViewer.AddressLookup lookup = pageTableViewer.lookupAddress(virtualAddress);
            return lookup.toString();
        }
        catch (IPageTableViewer.PageTableViewerException e) {
            return e.getLocalizedMessage();
        }
    }

    public String lookupPageTableEntries(int TTBRNum, int[] parentLevelIndices, int beginIndex, int endIndex) {
        IPageTableViewer pageTableViewer = PageTableViewer.getPageTableViewer(this.session.getDspTask());
        try {
            IPageTableViewer.PageTableEntriesLookup lookup = pageTableViewer.lookupPageTableEntries(TTBRNum, parentLevelIndices, beginIndex, endIndex);
            return lookup.toString();
        }
        catch (IPageTableViewer.PageTableViewerException e) {
            return e.getLocalizedMessage();
        }
    }

    public String reverseLookup(long address) {
        IDspValue phyiscalAddress = this.session.getDspTask().getMemoryAccess().createDspValue(IDspValue.Type.UDATA64, address);
        IPageTableViewer pageTableViewer = PageTableViewer.getPageTableViewer(this.session.getDspTask());
        try {
            IPageTableViewer.AddressLookup lookup = pageTableViewer.reverseLookup(phyiscalAddress);
            return lookup.toString();
        }
        catch (IPageTableViewer.PageTableViewerException e) {
            return e.getLocalizedMessage();
        }
    }

    public String reverseLookupAll(long address) {
        IDspValue phyiscalAddress = this.session.getDspTask().getMemoryAccess().createDspValue(IDspValue.Type.UDATA64, address);
        IPageTableViewer pageTableViewer = PageTableViewer.getPageTableViewer(this.session.getDspTask());
        try {
            StringBuilder sb = new StringBuilder();
            List<IPageTableViewer.AddressLookup> all = pageTableViewer.reverseLookupAll(phyiscalAddress);
            for (IPageTableViewer.AddressLookup lookup : all) {
                sb.append(lookup.toString());
            }
            return sb.toString();
        }
        catch (IPageTableViewer.PageTableViewerException e) {
            return e.getLocalizedMessage();
        }
    }

    public String currentMode() {
        IPageTableViewer pageTableViewer = PageTableViewer.getPageTableViewer(this.session.getDspTask());
        try {
            IPageTableViewer.MMUMode mode = pageTableViewer.currentMode();
            return mode.toString();
        }
        catch (IPageTableViewer.PageTableViewerException e) {
            return e.getMessage();
        }
    }

    public String summary() {
        IPageTableViewer pageTableViewer = PageTableViewer.getPageTableViewer(this.session.getDspTask());
        try {
            IPageTableViewer.Summary summary = pageTableViewer.summary();
            return summary.toString();
        }
        catch (IPageTableViewer.PageTableViewerException e) {
            return e.getLocalizedMessage();
        }
    }
}

