/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Pin
extends APIContainer {
    Pin(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public void connect(String sPinName, String sFile) throws ScriptingException {
        String myName = "connect";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sPinName: " + sPinName, "sFile: " + sFile});
        }
        if (!this.session.getPinConnect().isSupported()) {
            throw new ScriptingException(1003, "Pin connect not supported on this target");
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_PinConnect(");
        sCommand.append("\"");
        sCommand.append(sPinName);
        sCommand.append("\",");
        sCommand.append("\"");
        String sFileName = this.environment.toAbsolutePath(sFile).replaceAll("\\\\", "\\\\\\\\");
        sCommand.append(sFileName);
        sCommand.append("\"");
        sCommand.append(")");
        this.traceLog.log(Level.FINER, "Connecting file to pin", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void disconnect(String sPinName) throws ScriptingException {
        String myName = "diconnect";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sPinName: " + sPinName});
        }
        if (!this.session.getPinConnect().isSupported()) {
            throw new ScriptingException(1003, "Pin connect not supported on this target");
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_PinDisconnect(");
        sCommand.append("\"");
        sCommand.append(sPinName);
        sCommand.append("\"");
        sCommand.append(")");
        this.traceLog.log(Level.FINER, "Disconnecting file from pin", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public String list() throws ScriptingException {
        String myName = "list";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        StringBuffer sReport = new StringBuffer();
        if (this.session.getPinConnect().isSupported()) {
            int nPinCount = this.session.getPinConnect().getNumPins();
            if (nPinCount == 0) {
                sReport.append("No pins are connected");
                this.traceLog.log(Level.INFO, sReport.toString(), this.session);
            } else {
                for (int i = 0; i < nPinCount; ++i) {
                    String sPinName = this.session.getPinConnect().getPinName(i);
                    String sPinFile = this.session.getPinConnect().getPinFileName(i);
                    if (sPinFile == null || sPinFile == "") {
                        sPinFile = "Not connected";
                    }
                    sReport.append("PIN: ");
                    sReport.append(sPinName);
                    sReport.append(" FILE: ");
                    sReport.append(sPinFile);
                    this.traceLog.log(Level.INFO, sReport.toString(), this.session);
                }
            }
        } else {
            sReport.append("Pin connect not supported on this target");
            this.traceLog.log(Level.INFO, sReport.toString(), this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
        return sReport.toString();
    }
}

