/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Port
extends APIContainer {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int NOREWIND = 4;
    public static final int UPDATE = 8;
    public static final int EXTERN = 16;

    Port(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public void connect(long nAddress, int nPage, int nLength, int nAccessType, String sFile) throws ScriptingException {
        String myName = "connect";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: 0x" + Long.toHexString(nAddress), "nPage: " + nPage, "nLength: " + nLength, "nAccessType: " + nAccessType, "sFile: " + sFile});
        }
        if (!this.session.getPortConnect().isSupported()) {
            throw new ScriptingException(1003, "Port connect not supported on this target");
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_PortConnect(");
        sCommand.append(nAddress);
        sCommand.append(",");
        sCommand.append(nPage);
        sCommand.append(",");
        sCommand.append(nLength);
        sCommand.append(",");
        sCommand.append(nAccessType);
        sCommand.append(",");
        sCommand.append("\"");
        String sFileName = this.environment.toAbsolutePath(sFile).replaceAll("\\\\", "\\\\\\\\");
        sCommand.append(sFileName);
        sCommand.append("\"");
        sCommand.append(")");
        this.traceLog.log(Level.FINER, "Connecting memory address to file", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void disconnect(long nAddress, int nPage, int nLength, int nAccessType) throws ScriptingException {
        String myName = "disconnect";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nAddress: 0x" + Long.toHexString(nAddress), "nPage: " + nPage, "nLength: " + nLength, "nAccessType: " + nAccessType});
        }
        if (!this.session.getPortConnect().isSupported()) {
            throw new ScriptingException(1003, "Port connect not supported on this target");
        }
        StringBuffer sCommand = new StringBuffer();
        sCommand.append("GEL_PortDisconnect(");
        sCommand.append(nAddress);
        sCommand.append(",");
        sCommand.append(nPage);
        sCommand.append(",");
        sCommand.append(nLength);
        sCommand.append(",");
        sCommand.append(nAccessType);
        sCommand.append(")");
        this.traceLog.log(Level.FINER, "Disconnecting memory address from file", this.session);
        this.session.expression.evaluate(sCommand.toString());
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public String list() throws ScriptingException {
        String myName = "list";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        StringBuffer sReport = new StringBuffer();
        if (this.session.getPortConnect().isSupported()) {
            int nPortCount = this.session.getPortConnect().getNumPortsConnected();
            if (nPortCount == 0) {
                sReport.append("No ports are connected");
                this.traceLog.log(Level.INFO, sReport.toString(), this.session);
            } else {
                for (int i = 0; i < nPortCount; ++i) {
                    IDspValue portAddress = this.session.getDspUser().createDspValue(IDspValue.Type.DATA32, 0L);
                    this.session.getPortConnect().getAddress(i, portAddress);
                    int nLength = this.session.getPortConnect().getLength(i);
                    int nAccess = this.session.getPortConnect().getAccessType(i);
                    String sFile = this.session.getPortConnect().getFileName(i);
                    sReport.append("PORT: ");
                    sReport.append(portAddress.toStringCStyleHex());
                    sReport.append(" LENGTH: ");
                    sReport.append(nLength);
                    sReport.append(" ACCESS: ");
                    sReport.append(nAccess);
                    sReport.append(" FILE: ");
                    sReport.append(sFile);
                    this.traceLog.log(Level.INFO, sReport.toString(), this.session);
                }
            }
        } else {
            sReport.append("Port connect not supported on this target");
            this.traceLog.log(Level.INFO, sReport.toString(), this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
        return sReport.toString();
    }
}

