/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IActivity;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.Property;
import com.ti.debug.genericproperties.IBooleanProperty;
import com.ti.debug.genericproperties.IIntegerProperty;
import com.ti.debug.genericproperties.IProperties;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IStringProperty;
import java.util.logging.Logger;

public class ProfileActivity
extends APIContainer {
    private IActivity myActivity;
    private final String FORMAT = "| %1$-50s %2$-20s %3$-30s %4$-10s %5$-10s \n";

    public ProfileActivity(ScriptingEnvironment environment, DebugSession session, IActivity activity) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        try {
            this.myActivity = activity;
        }
        catch (Exception e) {
            throw new ScriptingException(4013, "Could not access activity");
        }
    }

    public String getName() {
        if (this.myActivity != null) {
            return this.myActivity.getName();
        }
        return "";
    }

    public String getDescription() {
        if (this.myActivity != null) {
            return this.myActivity.getDescription();
        }
        return "";
    }

    public boolean getStatus() {
        if (this.myActivity != null) {
            return this.myActivity.isEnabled();
        }
        return false;
    }

    public void setStatus(boolean value) throws ScriptingException {
        if (this.myActivity != null) {
            try {
                this.myActivity.enable(value);
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Could not set value of activity");
            }
        }
    }

    public void listProperties() throws ScriptingException {
        System.out.format("| %1$-50s %2$-20s %3$-30s %4$-10s %5$-10s \n", "PROPERTY", "VALUE", "ALLOWED VALUES", "DISABLED", "EDITABLE");
        System.out.format("| %1$-50s %2$-20s %3$-30s %4$-10s %5$-10s \n", "--------", "-----", "--------------", "--------", "--------");
        this.listChildrenProperty(this.myActivity.getProperties(), "");
        System.out.println("|========================================================================================================================");
    }

    public Property getProperty(String path) throws ScriptingException {
        IProperty curProp = null;
        IProperties holdRootProps = this.myActivity.getProperties();
        curProp = this.getPropertyByName(path, holdRootProps);
        return new Property(this.environment, this.session, this.myActivity, holdRootProps, curProp);
    }

    private void listChildrenProperty(IProperties curProps, String parentName) throws ScriptingException {
        if (curProps != null) {
            for (int i = 0; i < curProps.getCount(); ++i) {
                String fullName = parentName;
                try {
                    Object[] allowedValuesArr;
                    IProperty curProp = curProps.getItem(i);
                    fullName = parentName.equals("") ? curProp.getName() : parentName + "." + curProp.getName();
                    boolean disableStatus = curProp.disabled();
                    boolean editableStatus = curProp.editable();
                    String allowedValues = "";
                    if (curProp instanceof IBooleanProperty) {
                        IBooleanProperty boolProp = (IBooleanProperty)curProp;
                        System.out.format("| %1$-50s %2$-20s %3$-30s %4$-10s %5$-10s \n", fullName, boolProp.getValue(), allowedValues, disableStatus, editableStatus);
                        continue;
                    }
                    if (curProp instanceof IIntegerProperty) {
                        IIntegerProperty.IntegerValueRange valueRange;
                        IIntegerProperty intProp = (IIntegerProperty)curProp;
                        allowedValuesArr = intProp.getAllowedValues();
                        if (allowedValuesArr != null && allowedValuesArr.length > 0) {
                            allowedValues = allowedValues + allowedValuesArr[0];
                            for (int j = 1; j < allowedValuesArr.length; ++j) {
                                allowedValues = allowedValues + ", " + allowedValuesArr[j];
                            }
                        }
                        if ((valueRange = intProp.getAllowedRange()) != null) {
                            allowedValues = allowedValues + "[" + valueRange.getMinimumValue() + "," + valueRange.getMaximumValue() + "]";
                        }
                        System.out.format("| %1$-50s %2$-20s %3$-30s %4$-10s %5$-10s \n", fullName, intProp.getValue(), allowedValues, disableStatus, editableStatus);
                        continue;
                    }
                    if (curProp instanceof IStringProperty) {
                        IStringProperty strProp = (IStringProperty)curProp;
                        allowedValuesArr = strProp.getAllowedValues();
                        if (allowedValuesArr != null && allowedValuesArr.length > 0) {
                            allowedValues = allowedValues + (String)allowedValuesArr[0];
                            for (int j = 1; j < allowedValuesArr.length; ++j) {
                                allowedValues = allowedValues + ", " + (String)allowedValuesArr[j];
                            }
                        }
                        System.out.format("| %1$-50s %2$-20s %3$-30s %4$-10s %5$-10s \n", fullName, strProp.getValue(), allowedValues, disableStatus, editableStatus);
                        continue;
                    }
                    this.listChildrenProperty(curProp.getSubProperties(), fullName);
                    continue;
                }
                catch (Exception e) {
                    throw new ScriptingException(4013, "Could not get the list of properties");
                }
            }
        }
    }

    private IProperty getPropertyByName(String path, IProperties properties) throws ScriptingException {
        IProperty curProperty = null;
        String[] patharray = path.split("[.]");
        String currentpath = patharray[0];
        StringBuffer remainingpath = null;
        if (properties == null) {
            throw new ScriptingException(4013, "Error getting properties from an activity");
        }
        for (int i = 0; i < properties.getCount(); ++i) {
            try {
                curProperty = properties.getItem(i);
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Error getting a property.");
            }
            if (!currentpath.equals(curProperty.getName())) continue;
            if (patharray.length == 1) {
                return curProperty;
            }
            for (int j = 1; j < patharray.length; ++j) {
                if (remainingpath == null) {
                    remainingpath = new StringBuffer(patharray[j]);
                    continue;
                }
                remainingpath.append(".");
                remainingpath.append(patharray[j]);
            }
            IProperties subProps = curProperty.getSubProperties();
            return this.getPropertyByName(remainingpath.toString(), subProps);
        }
        return null;
    }
}

