/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IProfileClockManager;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProfileClock
extends APIContainer {
    ProfileClock(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    private String buildErrorList(String[] events) {
        StringBuffer errMsg = new StringBuffer("");
        for (int i = 0; i < events.length; ++i) {
            errMsg.append(Integer.toString(i));
            errMsg.append("=\"");
            errMsg.append(events[i]);
            errMsg.append("\"");
            if (i + 1 == events.length) continue;
            errMsg.append(", ");
        }
        return errMsg.toString();
    }

    public void disable() throws ScriptingException {
        IProfileClockManager clock;
        String myName = "disable";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if ((clock = this.session.getDspTask().getProfileClockManager()).getClockEnabled()) {
            clock.enableClock(false);
        } else {
            this.traceLog.log(Level.FINER, "Profile Clock is already disabled", this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void disableAutoreset() {
        IProfileClockManager clock;
        String myName = "disableAutoreset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if ((clock = this.session.getDspTask().getProfileClockManager()).getIsClockAutoReset()) {
            clock.setIsClockAutoReset(false);
        } else {
            this.traceLog.log(Level.FINER, "Profile Clock auto-reset is already disabled", this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void enable() throws ScriptingException {
        IProfileClockManager clock;
        String myName = "enable";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!(clock = this.session.getDspTask().getProfileClockManager()).getClockEnabled()) {
            clock.enableClock(true);
        } else {
            this.traceLog.log(Level.FINER, "Profile Clock is already enabled", this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void enableAutoreset() {
        IProfileClockManager clock;
        String myName = "enableAutoreset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        if (!(clock = this.session.getDspTask().getProfileClockManager()).getIsClockAutoReset()) {
            clock.setIsClockAutoReset(true);
        } else {
            this.traceLog.log(Level.FINER, "Profile Clock auto-reset is already enabled", this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public String getCurrentEvent() throws ScriptingException {
        String myName = "getCurrentEvent";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        String result = this.getCurrentEventName();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    private String getCurrentEventName() {
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        String[] events = clock.getClockEvents();
        int id = clock.getCurrentClockEvent();
        return events[id];
    }

    public int getEventCount() throws ScriptingException {
        String myName = "getEventCount";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        int result = clock.getNumClockEvents();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public int getEventID(String sEventName) throws ScriptingException {
        String myName = "getEventID";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sEventName: " + sEventName});
        }
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        Pattern pattern = Pattern.compile(sEventName, 18);
        String[] events = clock.getClockEvents();
        int nEventID = -1;
        for (int i = 0; i < events.length; ++i) {
            String inputStr = events[i];
            Matcher matcher = pattern.matcher(inputStr);
            if (!matcher.matches()) continue;
            nEventID = i;
            if (!this.traceLog.isLoggable(Level.FINER)) continue;
            this.traceLog.log(Level.FINER, "Found matching event: " + events[i] + "=" + Integer.toString(i), this.session);
        }
        if (nEventID < 0 && this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "No event found matching: " + sEventName, this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, nEventID});
        }
        return nEventID;
    }

    public String getEventName(int nEventID) throws ScriptingException {
        String myName = "getEventName";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nID: " + nEventID});
        }
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        String[] events = clock.getClockEvents();
        String result = "";
        if (nEventID < 0 || nEventID > events.length - 1) {
            throw new ScriptingException(4013, "Profile Clock event id <" + Integer.toString(nEventID) + "> is invalid.  Valid events are: " + this.buildErrorList(events));
        }
        result = events[nEventID];
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public long read() throws ScriptingException {
        String myName = "read";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        String name = this.getCurrentEventName();
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        long result = clock.readClockCount();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, name + "=" + Long.toString(result), this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public void reset() throws ScriptingException {
        String myName = "reset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        clock.resetClock();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public long runBenchmark() throws ScriptingException {
        String myName = "runBenchmark";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        int nEventID = clock.getCurrentClockEvent();
        long result = -1L;
        result = this.runBenchmark(nEventID);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public long runBenchmark(String sEventName) throws ScriptingException {
        String myName = "runBenchmark";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sEventName: " + sEventName});
        }
        int nEventID = this.getEventID(sEventName);
        long result = -1L;
        if (nEventID < 0) {
            throw new ScriptingException(4013, "Unable to run benchmark.  No Profile Clock event found matching \"" + sEventName + "\"");
        }
        result = this.runBenchmark(nEventID);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public long runBenchmark(int nEventID) throws ScriptingException {
        String myName = "runBenchmark";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nEventID: " + nEventID});
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "Setting Profile Clock count event", this.session);
        }
        this.setCurrentEvent(nEventID);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "Enabling Profile Clock event counting", this.session);
        }
        this.enable();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "Resetting the profile clock register", this.session);
        }
        this.reset();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "Running target", this.session);
        }
        this.session.target.run();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "Disabling Profile Clock event counting", this.session);
        }
        this.disable();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.log(Level.FINER, "Reading Profile Clock count event", this.session);
        }
        long got = this.read();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, String.valueOf(got)});
        }
        return got;
    }

    public void setCurrentEvent(int nEventID) throws ScriptingException {
        String myName = "setCurrentEvent";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nEventID: " + nEventID});
        }
        IProfileClockManager clock = this.session.getDspTask().getProfileClockManager();
        String[] events = clock.getClockEvents();
        if (nEventID < 0 || nEventID > events.length - 1) {
            throw new ScriptingException(4013, "Profile Clock event id <" + Integer.toString(nEventID) + "> is invalid.  Valid events are: " + this.buildErrorList(events));
        }
        if (nEventID == clock.getCurrentClockEvent()) {
            String name = this.getCurrentEventName();
            this.traceLog.log(Level.FINER, "Profile Clock is already configured to profile: " + name, this.session);
        } else {
            this.traceLog.log(Level.FINER, "Setting Profile Clock to " + events[nEventID], this.session);
            if (!clock.setCurrentClockEvent(nEventID)) {
                throw new ScriptingException(4013, "Unable to set Profile Clock to " + Integer.toString(nEventID) + "(" + events[nEventID] + ")");
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }
}

