/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IActivity;
import com.ti.debug.engine.IActivityProvider;
import com.ti.debug.engine.IActivityProviderServer;
import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.ProfileActivity;
import java.util.logging.Logger;

public class ProfileSetup
extends APIContainer {
    private IActivityProviderServer activityProviderServer;
    private final String FORMAT = "| %1$-100s %2$-20s \n";

    public ProfileSetup(ScriptingEnvironment environment, IApplication application, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        try {
            this.activityProviderServer = application.getActivityProviderServer();
        }
        catch (Exception e) {
            throw new ScriptingException(4013, "Could not access Activity Provider Server");
        }
    }

    public void printActivityList() throws ScriptingException {
        System.out.format("| %1$-100s %2$-20s \n", "ACTIVITIES", "VALUE");
        System.out.format("| %1$-100s %2$-20s \n", "----------", "-----");
        for (int i = 0; i < this.activityProviderServer.getNumActivityProviders(); ++i) {
            try {
                IActivityProvider curActivityProvider = this.activityProviderServer.getActivityProvider(i);
                if (!curActivityProvider.getAssociatedTaskName().equals(this.session.getDspTask().getFullPathName())) continue;
                for (int j = 0; j < curActivityProvider.getActivityCount(); ++j) {
                    IActivity curActivity = curActivityProvider.getActivity(j);
                    System.out.format("| %1$-100s %2$-20s \n", curActivity.getName(), curActivity.isEnabled());
                }
                continue;
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Could not access Activity Provider");
            }
        }
    }

    public ProfileActivity getActivity(String activityName) throws ScriptingException {
        for (int i = 0; i < this.activityProviderServer.getNumActivityProviders(); ++i) {
            try {
                IActivityProvider curActivityProvider = this.activityProviderServer.getActivityProvider(i);
                if (!curActivityProvider.getAssociatedTaskName().equals(this.session.getDspTask().getFullPathName())) continue;
                for (int j = 0; j < curActivityProvider.getActivityCount(); ++j) {
                    IActivity curActivity = curActivityProvider.getActivity(j);
                    if (!curActivity.getName().equals(activityName)) continue;
                    return new ProfileActivity(this.environment, this.session, curActivity);
                }
                continue;
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Could not access activity");
            }
        }
        return null;
    }
}

