/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IActivity;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.genericproperties.IBooleanProperty;
import com.ti.debug.genericproperties.IIntegerProperty;
import com.ti.debug.genericproperties.IProperties;
import com.ti.debug.genericproperties.IProperty;
import com.ti.debug.genericproperties.IStringProperty;
import java.util.logging.Logger;

public class Property
extends APIContainer {
    private IProperty myProperty;
    private IActivity myActivity;
    private IProperties myRootProperty;

    public Property(ScriptingEnvironment environment, DebugSession session, IActivity activity, IProperties propRoot, IProperty property) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.myProperty = property;
        this.myActivity = activity;
        this.myRootProperty = propRoot;
    }

    public boolean getBoolean() throws ScriptingException {
        IBooleanProperty boolProp = null;
        if (this.myProperty instanceof IBooleanProperty) {
            boolProp = (IBooleanProperty)this.myProperty;
            boolean result = boolProp.getValue();
            return result;
        }
        throw new ScriptingException(4013, "Property is not a boolean property");
    }

    public void setBoolean(boolean value) throws ScriptingException {
        IBooleanProperty boolProp = null;
        if (this.myProperty instanceof IBooleanProperty) {
            boolProp = (IBooleanProperty)this.myProperty;
            boolProp.setValue(value);
            if (boolProp.getValue() != value) {
                throw new ScriptingException(4013, "Setting value on property failed.");
            }
            try {
                this.myActivity.setProperties(this.myRootProperty);
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Could not set value of properties on the activity.");
            }
        } else {
            throw new ScriptingException(4013, "Property is not a boolean property");
        }
    }

    public long getNumeric() throws ScriptingException {
        IIntegerProperty integerProperty = null;
        if (this.myProperty instanceof IIntegerProperty) {
            integerProperty = (IIntegerProperty)this.myProperty;
            long result = integerProperty.getValue();
            return result;
        }
        throw new ScriptingException(4013, "Property is not a numeric property");
    }

    public void setNumeric(long value) throws ScriptingException {
        IIntegerProperty integerProperty = null;
        if (this.myProperty instanceof IIntegerProperty) {
            integerProperty = (IIntegerProperty)this.myProperty;
            integerProperty.setValue(value);
            if (integerProperty.getValue() != value) {
                throw new ScriptingException(4013, "Setting value on property failed.");
            }
            try {
                this.myActivity.setProperties(this.myRootProperty);
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Could not set value of properties on the activity.");
            }
        } else {
            throw new ScriptingException(4013, "Property is not a numeric property");
        }
    }

    public String getString() throws ScriptingException {
        IStringProperty stringProp = null;
        if (this.myProperty instanceof IStringProperty) {
            stringProp = (IStringProperty)this.myProperty;
            String result = stringProp.getValue();
            return result;
        }
        throw new ScriptingException(4013, "Property is not a string property");
    }

    public void setString(String value) throws ScriptingException {
        IStringProperty stringProp = null;
        if (this.myProperty instanceof IStringProperty) {
            stringProp = (IStringProperty)this.myProperty;
            stringProp.setValue(value);
            if (stringProp.getValue().equals(value)) {
                throw new ScriptingException(4013, "Setting value on property failed.");
            }
            try {
                this.myActivity.setProperties(this.myRootProperty);
            }
            catch (Exception e) {
                throw new ScriptingException(4013, "Could not set value of properties on the activity.");
            }
        } else {
            throw new ScriptingException(4013, "Property is not a string property");
        }
    }
}

