/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IAdvancedReset;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResetType
extends APIContainer {
    private IAdvancedReset advancedReset;

    ResetType(ScriptingEnvironment environment, DebugSession session, IAdvancedReset resetObj) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.advancedReset = resetObj;
    }

    public boolean isAllowed() {
        String myName = "isAllowed";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        boolean rtnVal = this.advancedReset.allowed();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, rtnVal});
        }
        return rtnVal;
    }

    public String getName() {
        String myName = "getName";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        String rtnVal = this.advancedReset.getName();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, rtnVal});
        }
        return rtnVal;
    }

    public String getDescription() {
        String myName = "getDescription";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        String rtnVal = this.advancedReset.getDescription();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, rtnVal});
        }
        return rtnVal;
    }

    public void issueReset() throws ScriptingException {
        try {
            String myName = "issueReset";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            if (!this.advancedReset.allowed()) {
                throw new ScriptingException(4015, "The reset type, " + this.advancedReset.getName() + ", is not currently allowed.");
            }
            this.traceLog.log(Level.FINER, "Requesting target reset: " + this.advancedReset.getName(), this.session);
            this.advancedReset.issueReset();
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error reseting target: " + e.getMessage());
        }
    }
}

