/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.ccstudio.scripting.environment.ScriptingTimeout;
import com.ti.debug.engine.IActionGroup;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.DebugServer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Simultaneous {
    private DebugServer debugServer;
    private Logger traceLog = Logger.getLogger(this.getClass().getName());

    Simultaneous(DebugServer debugServer) throws ScriptingException {
        this.debugServer = debugServer;
    }

    public void run() throws ScriptingException {
        this.run(this.getUnterminatedDebugSessions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(DebugSession[] sessions) throws ScriptingException {
        try {
            String myName = "run";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName);
            }
            this.verifySessions(sessions);
            this.verifySessionsHalted(sessions);
            IActionGroup syncGroup = this.debugServer.getApplication().createActionGroup();
            try {
                for (DebugSession session : sessions) {
                    syncGroup.add(session.getDspTask());
                }
                OnRunningListenerCollection onRunningListeners = new OnRunningListenerCollection(sessions);
                OnHaltListenerCollection onHaltListeners = new OnHaltListenerCollection(sessions);
                this.traceLog.finer("Requesting synchronous run on targets");
                syncGroup.run();
                onRunningListeners.waitUntil();
                this.traceLog.finer("All targets running, waiting for halt");
                onHaltListeners.waitUntil();
                this.traceLog.finer("All targets halted");
            }
            finally {
                for (DebugSession session : sessions) {
                    syncGroup.remove(session.getDspTask());
                }
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error performing simultaneous run: " + e.getMessage());
        }
    }

    private void verifySessionsHalted(DebugSession[] sessions) throws ScriptingException {
        List<DebugSession> unhaltedSessions = this.getUnhaltedSessions(sessions);
        if (!unhaltedSessions.isEmpty()) {
            throw new ScriptingException(4017, "The following target" + (unhaltedSessions.size() > 1 ? "s are" : " is") + " not halted: " + this.sessionListToString(unhaltedSessions));
        }
    }

    private void verifySessions(DebugSession[] sessions) throws ScriptingException {
        List<DebugSession> terminatedSessions = this.getTerminatedSessions(sessions);
        if (!terminatedSessions.isEmpty()) {
            throw new ScriptingException(4017, "The following session" + (terminatedSessions.size() > 1 ? "s are" : " is") + " terminated: " + this.sessionListToString(terminatedSessions));
        }
        List<DebugSession> unconnectedSessions = this.getUnconnectedSessions(sessions);
        if (!unconnectedSessions.isEmpty()) {
            throw new ScriptingException(4017, "The following target" + (unconnectedSessions.size() > 1 ? "s are" : " is") + " not connected: " + this.sessionListToString(unconnectedSessions));
        }
    }

    public void runAsynch() throws ScriptingException {
        this.runAsynch(this.getUnterminatedDebugSessions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsynch(DebugSession[] sessions) throws ScriptingException {
        try {
            String myName = "runAsynch";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName);
            }
            this.verifySessions(sessions);
            this.verifySessionsHalted(sessions);
            IActionGroup syncGroup = this.debugServer.getApplication().createActionGroup();
            try {
                for (DebugSession session : sessions) {
                    syncGroup.add(session.getDspTask());
                }
                OnRunningListenerCollection onRunningListeners = new OnRunningListenerCollection(sessions);
                this.traceLog.finer("Requesting synchronous run on targets");
                syncGroup.run();
                onRunningListeners.waitUntil();
                this.traceLog.finer("All targets running");
            }
            finally {
                for (DebugSession session : sessions) {
                    syncGroup.remove(session.getDspTask());
                }
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error performing simultaneous run: " + e.getMessage());
        }
    }

    public void halt() throws ScriptingException {
        this.halt(this.getUnterminatedDebugSessions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt(DebugSession[] sessions) throws ScriptingException {
        try {
            String myName = "halt";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName);
            }
            this.verifySessions(sessions);
            IActionGroup syncGroup = this.debugServer.getApplication().createActionGroup();
            try {
                for (DebugSession session : sessions) {
                    syncGroup.add(session.getDspTask());
                }
                OnHaltListenerCollection onHaltListeners = new OnHaltListenerCollection(sessions);
                this.traceLog.finer("Requesting synchronous target halt");
                syncGroup.halt();
                onHaltListeners.waitUntil();
                this.traceLog.finer("All targets halted");
            }
            finally {
                for (DebugSession session : sessions) {
                    syncGroup.remove(session.getDspTask());
                }
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error performing simultaneous halt: " + e.getMessage());
        }
    }

    public void asmStepInto() throws ScriptingException {
        this.asmStepInto(this.getUnterminatedDebugSessions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asmStepInto(DebugSession[] sessions) throws ScriptingException {
        try {
            String myName = "asmStepInto";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName);
            }
            this.verifySessions(sessions);
            this.verifySessionsHalted(sessions);
            IActionGroup syncGroup = this.debugServer.getApplication().createActionGroup();
            try {
                for (DebugSession session : sessions) {
                    syncGroup.add(session.getDspTask());
                }
                OnHaltListenerCollection onHaltListeners = new OnHaltListenerCollection(sessions);
                this.traceLog.finer("Requesting synchronous assembly step into");
                syncGroup.asmStepInto();
                onHaltListeners.waitUntil();
                this.traceLog.finer("Assembly step into complete, all targets halted");
            }
            finally {
                for (DebugSession session : sessions) {
                    syncGroup.remove(session.getDspTask());
                }
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error performing simultaneous assembly step into: " + e.getMessage());
        }
    }

    private DebugSession[] getUnterminatedDebugSessions() throws ScriptingException {
        ArrayList<DebugSession> sessions = new ArrayList<DebugSession>();
        String[] sessionNames = this.debugServer.getSessionNames();
        for (int i = 0; i < this.debugServer.getSessionCount(); ++i) {
            String name = sessionNames[i];
            DebugSession session = (DebugSession)this.debugServer.getSession(name);
            if (session.isTerminated()) continue;
            sessions.add(session);
        }
        return sessions.toArray(new DebugSession[0]);
    }

    private List<DebugSession> getTerminatedSessions(DebugSession[] sessions) {
        ArrayList<DebugSession> terminatedSessions = new ArrayList<DebugSession>();
        for (DebugSession session : sessions) {
            if (!session.isTerminated()) continue;
            terminatedSessions.add(session);
        }
        return terminatedSessions;
    }

    private List<DebugSession> getUnconnectedSessions(DebugSession[] sessions) {
        ArrayList<DebugSession> unconnectedSessions = new ArrayList<DebugSession>();
        for (DebugSession session : sessions) {
            if (!session.getDspTask().getTargetConnection().disconnectCapable() || session.getDspTask().getTargetConnection().getConnectionStatus() == ITargetConnection.ConnectionStatus.CONNECTED) continue;
            unconnectedSessions.add(session);
        }
        return unconnectedSessions;
    }

    private List<DebugSession> getUnhaltedSessions(DebugSession[] sessions) throws ScriptingException {
        ArrayList<DebugSession> unhaltedSessions = new ArrayList<DebugSession>();
        for (DebugSession session : sessions) {
            if (session.target.isHalted()) continue;
            unhaltedSessions.add(session);
        }
        return unhaltedSessions;
    }

    private String sessionListToString(List<DebugSession> sessions) throws ScriptingException {
        String s = "";
        Iterator<DebugSession> p = sessions.iterator();
        while (p.hasNext()) {
            s = s + p.next().getName();
            if (!p.hasNext()) continue;
            s = s + ", ";
        }
        return s;
    }

    private class OnHaltListenerCollection
    extends ListenerCollection {
        OnHaltListenerCollection(DebugSession[] sessions) {
            super(sessions);
        }

        @Override
        protected AbstractListener createListener(DebugSession session) {
            APIContainer.OnHaltListener listener = session.target.new APIContainer.OnHaltListener();
            session.getDspUser().onHalt().addIObjectEventListener(listener);
            return listener;
        }
    }

    private class OnRunningListenerCollection
    extends ListenerCollection {
        OnRunningListenerCollection(DebugSession[] sessions) {
            super(sessions);
        }

        @Override
        protected AbstractListener createListener(DebugSession session) {
            APIContainer.OnRunningListener listener = session.target.new APIContainer.OnRunningListener();
            session.getDspUser().onRunning().addISimpleEventListener(listener);
            return listener;
        }
    }

    private abstract class ListenerCollection
    extends AbstractListener {
        private final Map<AbstractListener, DebugSession> listenerMap;

        ListenerCollection(DebugSession[] sessions) {
            super(Simultaneous.this.traceLog, (ScriptingTimeout)ScriptingEnvironment.instance());
            this.listenerMap = new HashMap<AbstractListener, DebugSession>();
            for (DebugSession session : sessions) {
                this.listenerMap.put(this.createListener(session), session);
            }
        }

        protected abstract AbstractListener createListener(DebugSession var1);

        @Override
        public void waitUntil(long timeout) throws ScriptingException {
            long startTime = System.currentTimeMillis();
            long remainingTime = timeout;
            for (AbstractListener listener : this.listenerMap.keySet()) {
                try {
                    listener.waitUntil(remainingTime);
                }
                catch (ScriptingException e) {
                    throw new ScriptingException(1001, "Timed out after " + timeout + "ms on the target " + this.listenerMap.get(listener).getName());
                }
                remainingTime = -1L == timeout ? -1L : timeout - (System.currentTimeMillis() - startTime);
            }
        }
    }
}

