/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.ILValue;
import com.ti.debug.engine.ILocation;
import com.ti.debug.engine.ISectionInfo;
import com.ti.debug.engine.ISymbolInfo;
import com.ti.debug.engine.ISymbolInfoList;
import com.ti.debug.engine.ISymbolManager;
import com.ti.debug.engine.ISymbolPackage;
import com.ti.debug.engine.IValue;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.DebugSession;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Symbol
extends APIContainer {
    Symbol(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
    }

    public long getAddress(String sSymbol) throws ScriptingException {
        String myName = "getAddress";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sSymbol: " + sSymbol});
        }
        if (sSymbol == null) {
            throw new ScriptingException(1002, "Null symbol value");
        }
        long rawAddress_ULong = 0L;
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        this.traceLog.log(Level.FINER, "Looking-up symbol", this.session);
        ILValue symbolLValue = symbolPackage.lookupLValue(sSymbol);
        boolean hasValue = symbolLValue.hasValue();
        boolean hasLocation = symbolLValue.hasLocation();
        if (!hasValue && !hasLocation) {
            throw new ScriptingException(4012, "Unable to get address for symbol: " + sSymbol);
        }
        if (hasValue && !hasLocation) {
            this.traceLog.log(Level.FINER, "Getting address", this.session);
            IValue value = symbolLValue.getValue();
            IDspValue dspValue = value.getDspValue();
            int rawAddress_UInt = dspValue.toLong();
            rawAddress_ULong = Symbol.unsignedIntToLong(rawAddress_UInt);
        } else if (hasLocation) {
            this.traceLog.log(Level.FINER, "Getting address", this.session);
            ILocation location = symbolLValue.getLocation();
            IValue value = location.getAddress();
            IDspValue dspValue = value.getDspValue();
            int rawAddress_UInt = dspValue.toLong();
            rawAddress_ULong = Symbol.unsignedIntToLong(rawAddress_UInt);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, "0x" + Long.toHexString(rawAddress_ULong)});
        }
        return rawAddress_ULong;
    }

    public boolean exists(String sSymbol) throws ScriptingException {
        String myName = "exists";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sSymbol: " + sSymbol});
        }
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        this.traceLog.log(Level.FINER, "Looking-up symbol", this.session);
        boolean bExists = false;
        ILValue symbolLValue = symbolPackage.lookupLValue(sSymbol);
        boolean hasValue = symbolLValue.hasValue();
        boolean hasLocation = symbolLValue.hasLocation();
        if (hasValue || hasLocation) {
            this.traceLog.log(Level.FINER, "Symbol \"" + sSymbol + "\" exists", this.session);
            bExists = true;
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, bExists});
        }
        return bExists;
    }

    public int getSectionSize(String sSectionName) throws ScriptingException {
        String myName = "getSectionSize";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sSectionName: " + sSectionName});
        }
        ISectionInfo section = this.getSection(sSectionName);
        this.traceLog.log(Level.FINER, "Looking-up size of section " + sSectionName, this.session);
        int sectionSize = section.getLength();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, sectionSize});
        }
        return sectionSize;
    }

    ISectionInfo getSection(String sSectionName) throws ScriptingException {
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        ISectionInfo section = null;
        this.traceLog.log(Level.FINER, "Searching for section " + sSectionName, this.session);
        int sectionCount = symbolPackage.getNumSections();
        for (int i = 0; i < sectionCount; ++i) {
            section = symbolPackage.getSectionInfo(i);
            if (!sSectionName.equals(section.getName())) continue;
            this.traceLog.log(Level.FINER, "Section " + sSectionName + " found", this.session);
            break;
        }
        if (section == null) {
            throw new ScriptingException(4012, "Section \"" + sSectionName + "\" could not be found");
        }
        return section;
    }

    public void load(String sFileName) throws ScriptingException {
        try {
            String myName = "load";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "sFileName: " + sFileName});
            }
            this.ensureTargetIsConnected();
            APIContainer.OnCompleteWithErrorInfo programLoadedListener = new APIContainer.OnCompleteWithErrorInfo();
            this.traceLog.log(Level.FINER, "Requesting program load", this.session);
            sFileName = this.environment.toAbsolutePath(sFileName);
            this.session.getDspTask().getSymbolManager().requestSymbolLoad(sFileName, programLoadedListener);
            programLoadedListener.waitUntil();
            String result = programLoadedListener.getErrorMessage();
            if (0 != result.length()) {
                throw new ScriptingException(4011, result);
            }
            this.traceLog.log(Level.FINER, "Symbol load successful", this.session);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error loading \"" + sFileName + "\": " + e.getMessage());
        }
    }

    public String getSymbolFileName() {
        String myName = "getSymbolFileName";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        String fileName = "";
        if (symbolPackage.getNumSymbolFiles() > 0) {
            fileName = symbolPackage.getSymbolFileName(0);
        } else {
            this.traceLog.log(Level.WARNING, "Call to Symbol.getSymbolFileName() with no program loaded.  No action performed.", this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, fileName});
        }
        return fileName;
    }

    public String lookupSymbol(int nPage, long nAddress) {
        String myName = "lookupSymbol";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress)});
        }
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        String result = "";
        int[] offset = new int[]{0};
        ISymbolInfo info = symbolPackage.lookupSymbol((int)nAddress, nPage, true, offset);
        if (info != null) {
            if (info.getName().equals("")) {
                this.traceLog.log(Level.FINER, "No symbol at address: 0x" + Long.toHexString(nAddress) + ", Page: " + String.valueOf(nPage), this.session);
            } else {
                result = info.getName();
                this.traceLog.log(Level.FINER, "Found symbol: \"" + result + "\" at address: 0x" + Long.toHexString(nAddress) + ", Page: " + String.valueOf(nPage), this.session);
            }
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, result});
        }
        return result;
    }

    public String[] lookupSymbols(int nPage, long nAddress) {
        String myName = "lookupSymbols";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "nPage: " + String.valueOf(nPage), "nAddress: 0x" + Long.toHexString(nAddress)});
        }
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        ArrayList<String> result = new ArrayList<String>();
        ISymbolInfoList symbolList = symbolPackage.lookupSymbols((int)nAddress, (int)nAddress, nPage);
        int symbolCount = 0;
        if (symbolList != null) {
            symbolCount = symbolList.getCount();
            if (symbolCount > 0) {
                for (int i = 0; i < symbolCount; ++i) {
                    ISymbolInfo info = symbolList.getItem(i);
                    if (info.getName().equals("")) continue;
                    String currentSymbolName = info.getName();
                    this.traceLog.log(Level.FINER, "Found symbol: \"" + currentSymbolName + "\" at address: 0x" + Long.toHexString(nAddress) + ", Page: " + String.valueOf(nPage), this.session);
                    result.add(currentSymbolName);
                }
            } else {
                this.traceLog.log(Level.FINER, "No symbols at address: 0x" + Long.toHexString(nAddress) + ", Page: " + String.valueOf(nPage), this.session);
            }
        }
        String[] resultArray = new String[symbolCount];
        result.toArray(resultArray);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, this.loggableArray(resultArray)});
        }
        return resultArray;
    }

    public void unloadAllSymbols() throws ScriptingException {
        String myName = "unloadAllSymbols";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        this.session.getDspTask().getSymbolManager().requestSymbolUnload(symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbol unloaded successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void add(String fileName) throws ScriptingException {
        String myName = "add";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName});
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        fileName = this.environment.toAbsolutePath(fileName);
        this.session.getDspTask().getSymbolManager().requestSymbolAdd(fileName, symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbols added successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void remove(String fileName) throws ScriptingException {
        String myName = "remove";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName});
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        fileName = this.environment.toAbsolutePath(fileName);
        this.session.getDspTask().getSymbolManager().requestSymbolRemove(fileName, symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbols removed successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void addWithOffset(String fileName, long codeStart, long dataStart) throws ScriptingException {
        String myName = "addWithOffset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName, "codeOffset: " + codeStart, "dataOffset; " + dataStart});
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        fileName = this.environment.toAbsolutePath(fileName);
        this.session.getDspTask().getSymbolManager().requestSymbolAddWithOffset(fileName, codeStart, dataStart, symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbols added successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadWithOffset(String fileName, long codeStart, long dataStart) throws ScriptingException {
        String myName = "loadWithOffset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName, "codeOffset: " + codeStart, "dataOffset; " + dataStart});
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        fileName = this.environment.toAbsolutePath(fileName);
        this.session.getDspTask().getSymbolManager().requestSymbolLoadWithOffset(fileName, codeStart, dataStart, symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbols loaded successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void addWithRelativeOffset(String fileName, long codeOffset, long dataOffset) throws ScriptingException {
        String myName = "addWithRelativeOffset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName, "codeOffset: " + codeOffset, "dataOffset; " + dataOffset});
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        fileName = this.environment.toAbsolutePath(fileName);
        this.session.getDspTask().getSymbolManager().requestSymbolAddWithRelativeOffset(fileName, codeOffset, dataOffset, symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbols added successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void loadWithRelativeOffset(String fileName, long codeOffset, long dataOffset) throws ScriptingException {
        String myName = "loadWithRelativeOffset";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName, "codeOffset: " + codeOffset, "dataOffset; " + dataOffset});
        }
        this.ensureTargetIsConnected();
        APIContainer.OnCompleteWithErrorInfo symbolRequestListener = new APIContainer.OnCompleteWithErrorInfo();
        fileName = this.environment.toAbsolutePath(fileName);
        this.session.getDspTask().getSymbolManager().requestSymbolLoadWithRelativeOffset(fileName, codeOffset, dataOffset, symbolRequestListener);
        symbolRequestListener.waitUntil();
        String result = symbolRequestListener.getErrorMessage();
        if (0 != result.length()) {
            throw new ScriptingException(4012, result);
        }
        this.traceLog.log(Level.FINER, "Symbols loaded successfully", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void showSection(String fileName, String sectionName, int codeStart, int dataStart) throws ScriptingException {
        String myName = "showSection";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName, "sectionName: " + sectionName, "code_start: " + codeStart, "data_start; " + dataStart});
        }
        this.ensureTargetIsConnected();
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        symbolPackage.showSection(fileName, sectionName, codeStart, dataStart);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }

    public void hideSection(String fileName, String sectionName) throws ScriptingException {
        String myName = "hideSection";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, new Object[]{this.session, "fileName: " + fileName, "sectionName: " + sectionName});
        }
        this.ensureTargetIsConnected();
        this.traceLog.log(Level.FINER, "Getting symbol package", this.session);
        ISymbolManager symbolManager = this.session.getDspTask().getSymbolManager();
        ISymbolPackage symbolPackage = symbolManager.getSymbolPackage();
        symbolPackage.hideSection(fileName, sectionName);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), myName, this.session);
        }
    }
}

