/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingEnvironment;
import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.IAdvancedResets;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.ITargetConnection;
import com.ti.debug.engine.ITargetState;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.events.types.INumberEventListener;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.scripting.APIContainer;
import com.ti.debug.engine.scripting.AbstractListener;
import com.ti.debug.engine.scripting.AsmStep;
import com.ti.debug.engine.scripting.ContextStep;
import com.ti.debug.engine.scripting.DebugSession;
import com.ti.debug.engine.scripting.ExecutionOperation;
import com.ti.debug.engine.scripting.ResetType;
import com.ti.debug.engine.scripting.SourceStep;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Target
extends APIContainer {
    static final String ON_CONNECTED = "onConnected";
    static final String ON_DISCONNECTED = "onDisconnected";
    static final String ON_RESET = "onReset";
    static final String ON_RESTART = "onRestart";
    static final String ON_RUNNING = "onRunning";
    static final String CONNECTION_ERROR = "connectionError";
    public final SourceStep sourceStep;
    public final AsmStep asmStep;
    public final ContextStep contextStep;

    Target(ScriptingEnvironment environment, DebugSession session) throws ScriptingException {
        super(environment, session);
        this.traceLog = Logger.getLogger(this.getClass().getName());
        this.sourceStep = new SourceStep(environment, session);
        this.asmStep = new AsmStep(environment, session);
        this.contextStep = new ContextStep(environment, session);
    }

    public void halt() throws ScriptingException {
        try {
            String myName = "halt";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            this.ensureTargetIsConnected();
            if (this.session.getDspTask().getTargetState().getExecutionState() == ITargetState.ExecutionState.HALTED) {
                this.traceLog.log(Level.FINER, "Target already halted", this.session);
            } else {
                APIContainer.OnHaltListener haltListener = new APIContainer.OnHaltListener();
                this.session.getDspUser().onHalt().addIObjectEventListener(haltListener);
                this.traceLog.log(Level.FINER, "Requesting target halt", this.session);
                this.session.getDspUser().halt();
                haltListener.waitUntil();
                IDspValue address = haltListener.getData();
                this.traceLog.log(Level.FINER, "Target halted at 0x" + Long.toHexString(address.toLong()), this.session);
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error halting target: " + e.getMessage());
        }
    }

    public void reset() throws ScriptingException {
        try {
            String myName = "reset";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            this.ensureTargetIsConnected();
            OnResetListener resetListener = new OnResetListener();
            this.session.getDspUser().onReset().addINumberEventListener(resetListener);
            this.traceLog.log(Level.FINER, "Requesting target reset", this.session);
            this.session.getDspUser().reset();
            resetListener.waitUntil();
            long result = resetListener.getData();
            if (result != 0L) {
                throw new ScriptingException(4016, "Target reset failed. Error: " + String.valueOf(result));
            }
            this.traceLog.log(Level.FINER, "Target reset", this.session);
            this.waitForHaltIfPropertySet("AutoRunToLabelOnReset");
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error reseting target: " + e.getMessage());
        }
    }

    public int getNumResetTypes() {
        String myName = "getResetTypes";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        IAdvancedResets advancedResets = this.session.getDspTask().getResetManager().getAdvancedResets();
        int numResetTypes = advancedResets.getCount();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, numResetTypes});
        }
        return numResetTypes;
    }

    public ResetType getResetType(int resetIndex) throws ScriptingException {
        try {
            String myName = "getResetType";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            IAdvancedResets advancedResets = this.session.getDspTask().getResetManager().getAdvancedResets();
            if (resetIndex < 0 || resetIndex >= advancedResets.getCount()) {
                throw new ScriptingException(4007, "Error getting reset type; index out of range");
            }
            ResetType curResetType = new ResetType(this.environment, this.session, advancedResets.item(resetIndex));
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, curResetType});
            }
            return curResetType;
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error getting reset type: " + e.getMessage());
        }
    }

    public void restart() throws ScriptingException {
        try {
            String myName = "restart";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            this.ensureTargetIsConnected();
            OnRestartListener restartListener = new OnRestartListener();
            this.session.getDspUser().onRestart().addINumberEventListener(restartListener);
            this.traceLog.log(Level.FINER, "Requesting target restart", this.session);
            this.session.getDspUser().restart();
            restartListener.waitUntil();
            long result = restartListener.getData();
            if (result != 0L) {
                throw new ScriptingException(4016, "Target restart failed. Error: " + String.valueOf(result));
            }
            this.traceLog.log(Level.FINER, "Target restarted", this.session);
            this.waitForHaltIfPropertySet("AutoRunToLabelOnRestart");
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error restarting target: " + e.getMessage());
        }
    }

    public void run() throws ScriptingException {
        new ExecutionOperation(this.environment, this.session, this.getClass().getName(), "run"){

            @Override
            protected void issueExecution() {
                this.session.getDspUser().run();
            }

            @Override
            protected boolean isCapable() {
                return this.session.getDspUser().capableExecutionControl();
            }
        }.go();
    }

    public void runAsynch() throws ScriptingException {
        try {
            String myName = "runAsynch";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            this.ensureTargetIsConnected();
            if (this.session.getDspTask().getTargetState().getExecutionState() == ITargetState.ExecutionState.RUNNING || this.session.getDspTask().getTargetState().getExecutionState() == ITargetState.ExecutionState.FREE_RUNNING) {
                this.traceLog.log(Level.FINER, "Target already running", this.session);
            } else {
                APIContainer.OnRunningListener runningListener = new APIContainer.OnRunningListener();
                this.session.getDspUser().onRunning().addISimpleEventListener(runningListener);
                this.traceLog.log(Level.FINER, "Requesting target run", this.session);
                this.session.getDspUser().run();
                runningListener.waitUntil();
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error running target: " + e.getMessage());
        }
    }

    public void connect() throws ScriptingException {
        try {
            String myName = "connect";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            if (this.session.getDspTask().getTargetConnection().getConnectionStatus() != ITargetConnection.ConnectionStatus.CONNECTED) {
                OnConnectedListener connectedListener = new OnConnectedListener();
                this.traceLog.log(Level.FINER, "Requesting target connect", this.session);
                this.session.getDspTask().getTargetConnection().targetConnect(connectedListener);
                connectedListener.waitUntil();
                if (this.session.getDspTask().getTargetConnection().getConnectionStatus() != ITargetConnection.ConnectionStatus.CONNECTED) {
                    throw new ScriptingException(4001, "emulation failure occurred");
                }
            } else {
                this.traceLog.log(Level.FINER, "Target already connected", this.session);
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error connecting to the target: " + e.getMessage());
        }
    }

    public void disconnect() throws ScriptingException {
        try {
            String myName = "disconnect";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            if (this.session.getDspTask().getTargetConnection().disconnectCapable()) {
                if (this.session.getDspTask().getTargetConnection().getConnectionStatus() != ITargetConnection.ConnectionStatus.DISCONNECTED) {
                    OnDisconnectedListener disconnectedListener = new OnDisconnectedListener();
                    this.traceLog.log(Level.FINER, "Requesting target disconnect", this.session);
                    this.session.getDspTask().getTargetConnection().targetDisconnect(disconnectedListener);
                    disconnectedListener.waitUntil();
                } else {
                    this.traceLog.log(Level.FINER, "Target already disconnected", this.session);
                }
            } else {
                this.traceLog.log(Level.FINER, "Target does not support being disconnected");
            }
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error disconnecting from the target: " + e.getMessage());
        }
    }

    public boolean isConnected() throws ScriptingException {
        String myName = "isConnected";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        boolean bConnected = true;
        if (this.session.getDspTask().getTargetConnection().getConnectionStatus() != ITargetConnection.ConnectionStatus.CONNECTED) {
            this.traceLog.log(Level.FINER, "Target is not connected", this.session);
            bConnected = false;
        } else {
            this.traceLog.log(Level.FINER, "Target is connected", this.session);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, bConnected});
        }
        return bConnected;
    }

    public void waitForHalt() throws ScriptingException {
        try {
            String myName = "waitForHalt";
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.entering(this.getClass().getName(), myName, this.session);
            }
            APIContainer.OnHaltListener haltListener = null;
            haltListener = new APIContainer.OnHaltListener();
            this.session.getDspUser().onHalt().addIObjectEventListener(haltListener);
            if (this.session.getDspTask().getTargetState().getExecutionState() == ITargetState.ExecutionState.HALTED) {
                this.traceLog.log(Level.FINER, "Target is already halted", this.session);
                return;
            }
            this.traceLog.log(Level.FINER, "Waiting for halt", this.session);
            haltListener.waitUntil();
            this.traceLog.log(Level.FINER, "Target is halted", this.session);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), myName, this.session);
            }
        }
        catch (ScriptingException e) {
            throw new ScriptingException(e.getErrorID(), "Error waiting for the target to halt: " + e.getMessage());
        }
    }

    public boolean isHalted() throws ScriptingException {
        String myName = "isHalted";
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), myName, this.session);
        }
        boolean bHalted = this.session.getDspTask().getTargetState().getExecutionState() == ITargetState.ExecutionState.HALTED;
        this.traceLog.log(Level.FINER, "Target is" + (bHalted ? "" : " not") + " halted", this.session);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.logp(Level.FINER, this.getClass().getName(), myName, "RETURN {0} {1}", new Object[]{this.session, bHalted});
        }
        return bHalted;
    }

    class OnDisconnectedListener
    extends AbstractListener
    implements ISimpleEventListener {
        private OnDisconnectedListener() {
            super(Target.this.traceLog, Target.this.session);
        }

        @Override
        public void onEvent() {
            Target.this.traceLog.log(Level.FINER, "Target is now disconnected", Target.this.session);
            this.eventReceived();
        }
    }

    class OnConnectedListener
    extends AbstractListener
    implements IBooleanEventListener {
        private OnConnectedListener() {
            super(Target.this.traceLog, Target.this.session);
        }

        @Override
        public void onEvent(boolean successful) {
            if (!successful) {
                this.log("Error when connecting to target");
            } else {
                this.log("Target is now connected");
            }
            this.eventReceived();
        }
    }

    class OnRestartListener
    extends AbstractListener
    implements INumberEventListener {
        private long data;

        private OnRestartListener() {
            super(Target.this.traceLog, Target.this.session);
        }

        @Override
        public void onEvent(long result) {
            this.data = result;
            this.eventReceived();
        }

        public long getData() {
            return this.data;
        }
    }

    class OnResetListener
    extends AbstractListener
    implements INumberEventListener {
        private long data;

        private OnResetListener() {
            super(Target.this.traceLog, Target.this.session);
        }

        @Override
        public void onEvent(long result) {
            this.data = result;
            this.eventReceived();
        }

        public long getData() {
            return this.data;
        }
    }

    static class DSP_VALUE_TYPE {
        static final int DSP_CHAR = 0;
        static final int DSP_UCHAR = 1;
        static final int DSP_SHORT = 2;
        static final int DSP_USHORT = 3;
        static final int DSP_ENUM = 4;
        static final int DSP_INT = 6;
        static final int DSP_UINT = 7;
        static final int DSP_LONG = 8;
        static final int DSP_ULONG = 9;
        static final int DSP_POINTER = 11;
        static final int DSP_DATA8 = 12;
        static final int DSP_DATA16 = 14;
        static final int DSP_DATA24 = 16;
        static final int DSP_DATA32 = 18;
        static final int DSP_DATA40 = 20;
        static final int DSP_DATA48 = 22;
        static final int DSP_DATA64 = 24;
        static final int DSP_UDATA8 = 13;
        static final int DSP_UDATA16 = 15;
        static final int DSP_UDATA24 = 17;
        static final int DSP_UDATA32 = 19;
        static final int DSP_UDATA40 = 21;
        static final int DSP_UDATA48 = 23;
        static final int DSP_UDATA64 = 25;
        static final int DSP_FARPOINTER = 27;
        static final int DSP_NEARPOINTER = 29;
        static final int DSP_LONGLONG = 30;
        static final int DSP_ULONGLONG = 31;
        static final int DSP_FLOAT = 32;
        static final int DSP_IEEE_FLOAT = 34;
        static final int DSP_DOUBLE = 36;
        static final int DSP_IEEE_DOUBLE = 38;
        static final int DSP_LDOUBLE = 40;
        static final int DSP_LASTVAL_INDEX = 40;

        private DSP_VALUE_TYPE() {
        }

        static boolean bIsTypeUnsigned(int nType) {
            return (nType & 1) != 0;
        }

        static boolean bIsTypeSigned(int nType) {
            return (nType & 0x21) == 0;
        }

        static boolean bValidIntegerSize(int nTypeSize) {
            switch (nTypeSize) {
                case 8: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 24: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 40: {
                    return true;
                }
                case 48: {
                    return true;
                }
                case 64: {
                    return true;
                }
            }
            return false;
        }

        static String getInvalidIntegerSizeMessage(int nTypeSize) {
            if (!DSP_VALUE_TYPE.bValidIntegerSize(nTypeSize)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Invalid type size of ");
                sb.append(String.valueOf(nTypeSize));
                sb.append(" bits.  Supported integer type sizes are 8, 16, 24 and 32 bits.  ");
                sb.append(" Note:  Some type sizes may not valid for all targets.");
                return sb.toString();
            }
            return null;
        }
    }

    public static class ISA {
        public static final int NONE = 65535;
        public static final int C24 = 36;
        public static final int C27 = 39;
        public static final int C28 = 40;
        public static final int C54 = 84;
        public static final int C55 = 85;
        public static final int C56 = 86;
        public static final int C62 = 98;
        public static final int C64 = 100;
        public static final int C66 = 102;
        public static final int C67 = 103;
        public static final int ARM7 = 1;
        public static final int ARM9 = 2;
        public static final int ARM11 = 3;
        public static final int CORTEX_A8 = 12;
        public static final int CORTEX_A9 = 9;
        public static final int CORTEX_R4 = 13;
        public static final int CORTEX_M0 = 10;
        public static final int CORTEX_M3 = 14;
        public static final int CORTEX_A15 = 21;
        public static final int MSP430 = 430;
        public static final int TMS600 = 600;
        public static final int TMS700 = 700;

        private ISA() {
        }

        public static final String lookupISAName(int nISA) throws ScriptingException {
            switch (nISA) {
                case 65535: {
                    return "NONE";
                }
                case 36: {
                    return "C24";
                }
                case 39: {
                    return "C27";
                }
                case 40: {
                    return "C28";
                }
                case 84: {
                    return "C54";
                }
                case 85: {
                    return "C55";
                }
                case 86: {
                    return "C56";
                }
                case 98: {
                    return "C62";
                }
                case 100: {
                    return "C64";
                }
                case 102: {
                    return "C66";
                }
                case 103: {
                    return "C67";
                }
                case 1: {
                    return "ARM7";
                }
                case 2: {
                    return "ARM9";
                }
                case 3: {
                    return "ARM11";
                }
                case 12: {
                    return "CORTEX_A8";
                }
                case 9: {
                    return "CORTEX_A9";
                }
                case 13: {
                    return "CORTEX_R4";
                }
                case 14: {
                    return "CORTEX_M3";
                }
                case 10: {
                    return "CORTEX_M0";
                }
                case 21: {
                    return "CORTEX_A15";
                }
                case 430: {
                    return "MSP430";
                }
                case 600: {
                    return "TMS600";
                }
                case 700: {
                    return "TMS700";
                }
            }
            throw new ScriptingException(1002, "Invalid ISA ID, got " + String.valueOf(nISA));
        }

        public static final String lookupISAName(int nFamily, int nMajor) throws ScriptingException {
            return ISA.lookupISAName(ISA.lookupISA(nFamily, nMajor));
        }

        public static final int lookupISA(int nFamily, int nMajor) throws ScriptingException {
            switch (nFamily) {
                case 65535: {
                    return 65535;
                }
                case 320: {
                    switch (nMajor) {
                        case 65535: {
                            return 65535;
                        }
                        case 36: {
                            return 36;
                        }
                        case 39: {
                            return 39;
                        }
                        case 40: {
                            return 40;
                        }
                        case 84: {
                            return 84;
                        }
                        case 85: {
                            return 85;
                        }
                        case 86: {
                            return 86;
                        }
                        case 98: {
                            return 98;
                        }
                        case 100: {
                            return 100;
                        }
                        case 102: {
                            return 102;
                        }
                        case 103: {
                            return 103;
                        }
                    }
                    throw new ScriptingException(1002, "Invalid Major ISA revision, got " + String.valueOf(nMajor));
                }
                case 470: {
                    switch (nMajor) {
                        case 65535: {
                            return 65535;
                        }
                        case 1: {
                            return 1;
                        }
                        case 2: {
                            return 2;
                        }
                        case 3: {
                            return 3;
                        }
                        case 12: {
                            return 12;
                        }
                        case 9: {
                            return 9;
                        }
                        case 13: {
                            return 13;
                        }
                        case 14: {
                            return 14;
                        }
                        case 10: {
                            return 10;
                        }
                        case 21: {
                            return 21;
                        }
                    }
                    throw new ScriptingException(1002, "Invalid Major ISA revision, got " + String.valueOf(nMajor));
                }
                case 430: {
                    return 430;
                }
                case 600: {
                    return 600;
                }
                case 700: {
                    return 700;
                }
            }
            throw new ScriptingException(1002, "Invalid Family ID, got " + String.valueOf(nFamily));
        }
    }

    public static class Family {
        public static final int NONE = 65535;
        public static final int TMS320 = 320;
        public static final int TMS470 = 470;
        public static final int MSP430 = 430;
        public static final int TMS600 = 600;
        public static final int TMS700 = 700;

        private Family() {
        }

        public static final String lookupFamily(int nFamily) throws ScriptingException {
            switch (nFamily) {
                case 65535: {
                    return "NONE";
                }
                case 320: {
                    return "TMS320";
                }
                case 470: {
                    return "TMS470";
                }
                case 430: {
                    return "MSP430";
                }
                case 600: {
                    return "TMS600";
                }
                case 700: {
                    return "TMS700";
                }
            }
            throw new ScriptingException(1002, "Invalid Family ID, got " + String.valueOf(nFamily));
        }
    }

    public static class Platform {
        public static final int NONE = 65535;
        public static final int EMULATOR = 0;
        public static final int SIMULATOR = 1;

        private Platform() {
        }

        public static final String lookupPlatform(int nPlatform) {
            switch (nPlatform) {
                case 1: {
                    return "SIMULATOR";
                }
                case 0: {
                    return "EMULATOR";
                }
                case 65535: {
                    return "NONE";
                }
            }
            return "NONE";
        }
    }
}

