/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting;

import com.ti.ccstudio.scripting.environment.ScriptingException;
import com.ti.debug.engine.scripting.setup.SystemSetupWriter;
import com.ti.utility.filesystem.DirectoryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetConfigurationGenerator {
    private final SystemSetupWriter systemSetupWriter;
    private SystemSetupWriter.SetupItem cachedConnectionItem;
    private SystemSetupWriter.SetupItem cachedBoardOrDeviceItem;
    private Logger traceLog = Logger.getLogger(this.getClass().getName());

    public TargetConfigurationGenerator() {
        this.systemSetupWriter = new SystemSetupWriter();
        String defaultTargetDBPath = DirectoryService.instance().getTargetDBDir();
        this.systemSetupWriter.setInstallDirectory(defaultTargetDBPath);
        this.systemSetupWriter.setUserDirectory(defaultTargetDBPath);
    }

    public void setOutputDirectory(String dir) {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "setOutputDirectory", "UserDirectory: " + dir);
        }
        this.systemSetupWriter.setUserDirectory(dir);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "setOutputDirectory");
        }
    }

    public String getTargetDBDirectory() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getTargetDBDirectory");
        }
        String dir = this.systemSetupWriter.getTargetDbDirectory();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getTargetDBDirectory", dir);
        }
        return dir;
    }

    public String getOutputDirectory() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getOutputDirectory");
        }
        String dir = this.systemSetupWriter.getUserDirectory();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getOutputDirectory", dir);
        }
        return dir;
    }

    public void printListOfConnections() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "printListOfConnections");
        }
        this.printHelper(CONFIGTYPE.CONNECTION);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "printListOfConnections");
        }
    }

    public void printListOfBoards() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "printListOfBoards");
        }
        this.printHelper(CONFIGTYPE.BOARD);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "printListOfBoards");
        }
    }

    public void printListOfDevices() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "printListOfDevices");
        }
        this.printHelper(CONFIGTYPE.DEVICE);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "printListOfDevices");
        }
    }

    public void printListOfConfigurations() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "printListOfConfigurations");
        }
        this.printHelper(CONFIGTYPE.CONFIGURATION);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "printListOfConfigurations");
        }
    }

    public void printCombinedDeviceBoardsList() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "printCombinedDeivceBoardsList");
        }
        this.printListOfBoards();
        this.printListOfDevices();
        this.printListOfConfigurations();
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "printCombinedDeviceBoardsList");
        }
    }

    private void printHelper(CONFIGTYPE type) {
        SystemSetupWriter.IComponentList myComponentList;
        List<SystemSetupWriter.SetupItem> myComponent;
        String typeString = "";
        if (type.equals((Object)CONFIGTYPE.CONNECTION)) {
            if (this.cachedBoardOrDeviceItem != null) {
                myComponent = this.systemSetupWriter.getFilteredListOfConnections(this.cachedBoardOrDeviceItem);
            } else {
                myComponentList = this.systemSetupWriter.getListOfConnections();
                myComponent = myComponentList.getComponents();
            }
            typeString = "connection";
        } else {
            if (type.equals((Object)CONFIGTYPE.BOARD)) {
                myComponentList = this.systemSetupWriter.getListOfBoards();
                typeString = "board";
            } else if (type.equals((Object)CONFIGTYPE.DEVICE)) {
                myComponentList = this.systemSetupWriter.getListOfDevices();
                typeString = "device";
            } else {
                myComponentList = this.systemSetupWriter.getListOfConfigurations();
                typeString = "configuration";
            }
            myComponent = this.cachedConnectionItem != null ? myComponentList.getFilteredListOfComponents(null, this.cachedConnectionItem.connectionType) : myComponentList.getComponents();
        }
        System.out.println(" ------ Total number of " + typeString + " types: " + myComponent.size());
        for (int i = 0; i < myComponent.size(); ++i) {
            SystemSetupWriter.SetupItem curConnectionItem = myComponent.get(i);
            System.out.println(i + ": " + curConnectionItem.name);
        }
    }

    public String[] getListOfConnections() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getListOfConnections");
        }
        String[] connectionArr = this.getListHelper(CONFIGTYPE.CONNECTION);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getListOfConnections");
        }
        return connectionArr;
    }

    public String[] getListOfBoards() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getListOfBoards");
        }
        String[] boardArr = this.getListHelper(CONFIGTYPE.BOARD);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getListOfBoards");
        }
        return boardArr;
    }

    public String[] getListOfDevices() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getListOfDevices");
        }
        String[] deviceArr = this.getListHelper(CONFIGTYPE.DEVICE);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getListOfDevices");
        }
        return deviceArr;
    }

    public String[] getListOfConfigurations() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getListOfDevices");
        }
        String[] deviceArr = this.getListHelper(CONFIGTYPE.CONFIGURATION);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getListOfDevices");
        }
        return deviceArr;
    }

    public String[] getCombinedDeviceBoardsList() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getCombinedDeviceBoardsList");
        }
        String[] boardList = this.getListOfBoards();
        String[] deviceList = this.getListOfDevices();
        String[] configList = this.getListOfConfigurations();
        ArrayList combinedList = new ArrayList(boardList.length + deviceList.length + configList.length);
        Collections.addAll(combinedList, boardList);
        Collections.addAll(combinedList, deviceList);
        Collections.addAll(combinedList, configList);
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getCombinedDeviceBoardsList");
        }
        return combinedList.toArray(new String[combinedList.size()]);
    }

    private String[] getListHelper(CONFIGTYPE type) {
        SystemSetupWriter.IComponentList myComponentList;
        List<SystemSetupWriter.SetupItem> myComponent;
        if (type.equals((Object)CONFIGTYPE.CONNECTION)) {
            if (this.cachedBoardOrDeviceItem != null) {
                myComponent = this.systemSetupWriter.getFilteredListOfConnections(this.cachedBoardOrDeviceItem);
            } else {
                myComponentList = this.systemSetupWriter.getListOfConnections();
                myComponent = myComponentList.getComponents();
            }
        } else {
            myComponentList = type.equals((Object)CONFIGTYPE.BOARD) ? this.systemSetupWriter.getListOfBoards() : (type.equals((Object)CONFIGTYPE.DEVICE) ? this.systemSetupWriter.getListOfDevices() : this.systemSetupWriter.getListOfConfigurations());
            myComponent = this.cachedConnectionItem != null ? myComponentList.getFilteredListOfComponents(null, this.cachedConnectionItem.connectionType) : myComponentList.getComponents();
        }
        String[] rtnArr = new String[myComponent.size()];
        for (int i = 0; i < myComponent.size(); ++i) {
            SystemSetupWriter.SetupItem curItem = myComponent.get(i);
            rtnArr[i] = curItem.name;
        }
        return rtnArr;
    }

    public void setConnection(String connectStr) throws ScriptingException {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "setConnection", "connectStr: " + connectStr);
        }
        SystemSetupWriter.IComponentList connectionComponentList = this.systemSetupWriter.getListOfConnections();
        List<SystemSetupWriter.SetupItem> connectionComponent = connectionComponentList.getComponents();
        for (SystemSetupWriter.SetupItem curConnectionItem : connectionComponent) {
            if (!curConnectionItem.name.equals(connectStr)) continue;
            this.cachedConnectionItem = curConnectionItem;
            this.traceLog.finer("Connection set: " + this.cachedConnectionItem.name);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), "setConnection");
            }
            return;
        }
        throw new ScriptingException(4003, "Could not find the specified connection name.");
    }

    public String getConnection() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getConnection");
        }
        String connectName = this.cachedConnectionItem != null ? this.cachedConnectionItem.name : null;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getConnection", connectName);
        }
        return connectName;
    }

    public void setBoard(String boardStr) throws ScriptingException {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "setBoard", "boardStr: " + boardStr);
        }
        SystemSetupWriter.IComponentList boardsComponentList = this.systemSetupWriter.getListOfBoards();
        List<SystemSetupWriter.SetupItem> boardComponents = this.cachedConnectionItem != null ? boardsComponentList.getFilteredListOfComponents(null, this.cachedConnectionItem.connectionType) : boardsComponentList.getComponents();
        for (SystemSetupWriter.SetupItem curBoardItem : boardComponents) {
            if (!curBoardItem.name.equals(boardStr)) continue;
            this.cachedBoardOrDeviceItem = curBoardItem;
            this.traceLog.finer("Board set: " + this.cachedBoardOrDeviceItem.name);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), "setBoard");
            }
            return;
        }
        throw new ScriptingException(4003, "Could not find the specified board name.");
    }

    public void setDevice(String deviceStr) throws ScriptingException {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "setDevice", "deviceStr: " + deviceStr);
        }
        SystemSetupWriter.IComponentList deviceComponentList = this.systemSetupWriter.getListOfDevices();
        List<SystemSetupWriter.SetupItem> deviceComponents = this.cachedConnectionItem != null ? deviceComponentList.getFilteredListOfComponents(null, this.cachedConnectionItem.connectionType) : deviceComponentList.getComponents();
        for (SystemSetupWriter.SetupItem curDeviceItem : deviceComponents) {
            if (!curDeviceItem.name.equals(deviceStr)) continue;
            this.cachedBoardOrDeviceItem = curDeviceItem;
            this.traceLog.finer("Device set: " + this.cachedBoardOrDeviceItem.name);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), "setDevice");
            }
            return;
        }
        throw new ScriptingException(4003, "Could not find the specified device name.");
    }

    public void setConfiguration(String configStr) throws ScriptingException {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "setBoard", "simStr: " + configStr);
        }
        SystemSetupWriter.IComponentList configList = this.systemSetupWriter.getListOfConfigurations();
        List<SystemSetupWriter.SetupItem> simulators = this.cachedConnectionItem != null ? configList.getFilteredListOfComponents(null, this.cachedConnectionItem.connectionType) : configList.getComponents();
        for (SystemSetupWriter.SetupItem curSimItem : simulators) {
            if (!curSimItem.name.equals(configStr)) continue;
            this.cachedBoardOrDeviceItem = curSimItem;
            this.traceLog.finer("Board set: " + this.cachedBoardOrDeviceItem.name);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), "setBoard");
            }
            return;
        }
        throw new ScriptingException(4003, "Could not find the specified board name.");
    }

    public void setBoardDevice(String setStr) throws ScriptingException {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "setBoardDevice", "Given Str: " + setStr);
        }
        try {
            this.setDevice(setStr);
            if (this.traceLog.isLoggable(Level.FINER)) {
                this.traceLog.exiting(this.getClass().getName(), "setBoardDevice");
            }
            return;
        }
        catch (ScriptingException e) {
            try {
                this.setConfiguration(setStr);
                if (this.traceLog.isLoggable(Level.FINER)) {
                    this.traceLog.exiting(this.getClass().getName(), "setBoardDevice");
                }
                return;
            }
            catch (ScriptingException e2) {
                try {
                    this.setBoard(setStr);
                    if (this.traceLog.isLoggable(Level.FINER)) {
                        this.traceLog.exiting(this.getClass().getName(), "setBoardDevice");
                    }
                    return;
                }
                catch (ScriptingException e3) {
                    throw new ScriptingException(4003, "Could not find the specified device/board name.");
                }
            }
        }
    }

    public String getBoardDevice() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "getBoardDevice");
        }
        String rtnName = this.cachedBoardOrDeviceItem != null ? this.cachedBoardOrDeviceItem.name : null;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "getBoardDevice", rtnName);
        }
        return rtnName;
    }

    public void createConfiguration(String xmlName) throws ScriptingException {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "createConfiguration", "xmlName: " + xmlName);
        }
        if (this.cachedConnectionItem == null || this.cachedBoardOrDeviceItem == null) {
            throw new ScriptingException(4003, "Could not create Target Configuration file. Missing connection or device/board information.");
        }
        String xmlFullPath = this.systemSetupWriter.getUserDirectory() + "/" + xmlName;
        String errMsg = this.systemSetupWriter.createNewConfiguration(xmlFullPath, this.cachedConnectionItem, this.cachedBoardOrDeviceItem);
        if (errMsg != null) {
            throw new ScriptingException(4003, "Error creating target configuration file: " + errMsg);
        }
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "createConfiguration");
        }
    }

    public void unsetConnection() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "unsetConnection");
        }
        this.cachedConnectionItem = null;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "unsetConnection");
        }
    }

    public void unsetDeviceBoard() {
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.entering(this.getClass().getName(), "unsetDeviceBoard");
        }
        this.cachedBoardOrDeviceItem = null;
        if (this.traceLog.isLoggable(Level.FINER)) {
            this.traceLog.exiting(this.getClass().getName(), "unsetDeviceBoard");
        }
    }

    public static enum CONFIGTYPE {
        CONNECTION,
        BOARD,
        DEVICE,
        CONFIGURATION;

    }
}

