/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.events.internal;

import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.ITransaction;
import com.ti.debug.engine.events.data.IPriorityEventData;
import com.ti.debug.engine.scripting.events.internal.Callback;
import com.ti.xpcom.XPCOMException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

class CallbackExecutorDecorator<DataType>
extends Callback<DataType> {
    private final Callback<DataType> callback;
    private final IDspUser dspUser;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "dss callback thread - " + this.count++);
        }
    });

    CallbackExecutorDecorator(IDspUser dspUser, Callback<DataType> callback) {
        this.dspUser = dspUser;
        this.callback = callback;
    }

    @Override
    void onEvent(DataType data) {
        executor.execute(new RunnableCallback(this.callback, data, this.dspUser.beginRefresh()));
    }

    private class RunnableCallback
    implements Runnable {
        private final Callback<DataType> callback;
        private final DataType data;
        private final ITransaction refreshTransaction;

        public RunnableCallback(Callback<DataType> callback, DataType data, ITransaction refreshTransaction) {
            this.callback = callback;
            this.data = data;
            this.refreshTransaction = refreshTransaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.callback.onEvent(this.data);
            }
            catch (XPCOMException e) {
            }
            finally {
                try {
                    this.refreshTransaction.dispose();
                    if (this.data instanceof IPriorityEventData) {
                        ((IPriorityEventData)this.data).dispose();
                    }
                }
                catch (XPCOMException e) {}
            }
        }
    }
}

