/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.events.internal;

import com.ti.debug.engine.scripting.events.internal.CallbackAdapter;
import com.ti.debug.engine.scripting.events.internal.EventRegistrationMediator;
import com.ti.debug.engine.scripting.events.internal.IEvent;
import java.util.HashMap;
import java.util.Map;

class Event<CallbackType, UnderlyingCallbackType, UnderlyingEventType>
implements IEvent<CallbackType> {
    private final UnderlyingEventType event;
    private final CallbackAdapter<CallbackType, UnderlyingCallbackType> callbackAdapter;
    private final EventRegistrationMediator<UnderlyingCallbackType, UnderlyingEventType> eventRegistrationMediator;
    private Map<CallbackType, UnderlyingCallbackType> registeredListeners = new HashMap<CallbackType, UnderlyingCallbackType>();

    Event(UnderlyingEventType event, CallbackAdapter<CallbackType, UnderlyingCallbackType> callbackAdapter, EventRegistrationMediator<UnderlyingCallbackType, UnderlyingEventType> eventRegistrationMediator) {
        this.event = event;
        this.callbackAdapter = callbackAdapter;
        this.eventRegistrationMediator = eventRegistrationMediator;
    }

    @Override
    public synchronized void addListener(CallbackType listener) {
        if (!this.registeredListeners.containsKey(listener)) {
            UnderlyingCallbackType callback = this.callbackAdapter.adapt(listener);
            this.eventRegistrationMediator.addListener(callback, this.event);
            this.registeredListeners.put(listener, callback);
        }
    }

    @Override
    public synchronized void removeListener(CallbackType listener) {
        if (this.registeredListeners.containsKey(listener)) {
            UnderlyingCallbackType callback = this.registeredListeners.get(listener);
            this.registeredListeners.remove(listener);
            this.eventRegistrationMediator.removeListener(callback, this.event);
        }
    }
}

