/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.events.internal;

import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.events.data.IEventData;
import com.ti.debug.engine.events.data.IFileLoadedEventData;
import com.ti.debug.engine.events.data.IPriorityFileLoadedEventData;
import com.ti.debug.engine.events.types.IBooleanEvent;
import com.ti.debug.engine.events.types.IBooleanEventListener;
import com.ti.debug.engine.events.types.INumberEvent;
import com.ti.debug.engine.events.types.INumberEventListener;
import com.ti.debug.engine.events.types.IObjectEvent;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.events.types.ISimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.impl.IFilterStrategy;
import com.ti.debug.engine.impl.ObjectToSimpleEventAdapter;
import com.ti.debug.engine.scripting.events.internal.AdapterToIBooleanEventCallback;
import com.ti.debug.engine.scripting.events.internal.AdapterToIFileLoadedEventCallback;
import com.ti.debug.engine.scripting.events.internal.AdapterToIHaltEventCallback;
import com.ti.debug.engine.scripting.events.internal.AdapterToINumberEventCallback;
import com.ti.debug.engine.scripting.events.internal.AdapterToISimpleEventCallback;
import com.ti.debug.engine.scripting.events.internal.BooleanEventCallback;
import com.ti.debug.engine.scripting.events.internal.BooleanEventCallbackAdapter;
import com.ti.debug.engine.scripting.events.internal.BooleanEventRegistrationMediator;
import com.ti.debug.engine.scripting.events.internal.CallbackAdapter;
import com.ti.debug.engine.scripting.events.internal.CallbackExecutorDecorator;
import com.ti.debug.engine.scripting.events.internal.Event;
import com.ti.debug.engine.scripting.events.internal.FileLoadedEventCallback;
import com.ti.debug.engine.scripting.events.internal.FileLoadedEventCallbackAdapter;
import com.ti.debug.engine.scripting.events.internal.IEvent;
import com.ti.debug.engine.scripting.events.internal.NumberEventCallback;
import com.ti.debug.engine.scripting.events.internal.NumberEventCallbackAdapter;
import com.ti.debug.engine.scripting.events.internal.NumberEventRegistrationMediator;
import com.ti.debug.engine.scripting.events.internal.ObjectEventRegistrationMediator;
import com.ti.debug.engine.scripting.events.internal.SimpleEventCallback;
import com.ti.debug.engine.scripting.events.internal.SimpleEventCallbackAdapter;
import com.ti.debug.engine.scripting.events.internal.SimpleEventRegistrationMediator;

class EventFactory {
    private final IDspUser dspUser;

    EventFactory(IDspUser dspUser) {
        this.dspUser = dspUser;
    }

    IEvent<BooleanEventCallback> createBooleanEvent(IBooleanEvent underlyingEvent) {
        return new Event<BooleanEventCallback, IBooleanEventListener, IBooleanEvent>(underlyingEvent, new BooleanCallbackAdapter(), new BooleanEventRegistrationMediator());
    }

    IEvent<FileLoadedEventCallback> createFileLoadedEvent(IObjectEvent<IFileLoadedEventData> underlyingEvent) {
        return new Event(underlyingEvent, new FileLoadedCallbackAdapter(), new ObjectEventRegistrationMediator());
    }

    IEvent<FileLoadedEventCallback> createPriorityFileLoadedEvent(IObjectEvent<IPriorityFileLoadedEventData> underlyingEvent) {
        return new Event(underlyingEvent, new FileLoadedCallbackAdapter(), new ObjectEventRegistrationMediator());
    }

    IEvent<NumberEventCallback> createHaltEvent(IObjectEvent<IEventData<IDspValue>> underlyingEvent) {
        return new Event<NumberEventCallback, IObjectEventListener<IEventData<IDspValue>>, IObjectEvent<IEventData<IDspValue>>>(underlyingEvent, new HaltCallbackAdapter(), new ObjectEventRegistrationMediator());
    }

    IEvent<NumberEventCallback> createNumberEvent(INumberEvent underlyingEvent) {
        return new Event<NumberEventCallback, INumberEventListener, INumberEvent>(underlyingEvent, new NumberCallbackAdapter(), new NumberEventRegistrationMediator());
    }

    IEvent<SimpleEventCallback> createSimpleEvent(ISimpleEvent underlyingEvent) {
        return new Event<SimpleEventCallback, ISimpleEventListener, ISimpleEvent>(underlyingEvent, new SimpleCallbackAdapter(), new SimpleEventRegistrationMediator());
    }

    IEvent<SimpleEventCallback> createSimpleEvent(IObjectEvent underlyingEvent) {
        return new Event<SimpleEventCallback, ISimpleEventListener, ISimpleEvent>(new ObjectToSimpleEventAdapter(underlyingEvent, new IFilterStrategy(){

            public boolean filter(Object data) {
                return false;
            }
        }), new SimpleCallbackAdapter(), new SimpleEventRegistrationMediator());
    }

    private class SimpleCallbackAdapter
    extends CallbackAdapter<SimpleEventCallback, ISimpleEventListener> {
        private SimpleCallbackAdapter() {
        }

        @Override
        ISimpleEventListener adapt(SimpleEventCallback callback) {
            return new AdapterToISimpleEventCallback(new CallbackExecutorDecorator<Object>(EventFactory.this.dspUser, new SimpleEventCallbackAdapter(callback)));
        }
    }

    private class NumberCallbackAdapter
    extends CallbackAdapter<NumberEventCallback, INumberEventListener> {
        private NumberCallbackAdapter() {
        }

        @Override
        INumberEventListener adapt(NumberEventCallback callback) {
            return new AdapterToINumberEventCallback(new CallbackExecutorDecorator<Long>(EventFactory.this.dspUser, new NumberEventCallbackAdapter(callback)));
        }
    }

    private class HaltCallbackAdapter
    extends CallbackAdapter<NumberEventCallback, IObjectEventListener<IEventData<IDspValue>>> {
        private HaltCallbackAdapter() {
        }

        @Override
        IObjectEventListener<IEventData<IDspValue>> adapt(NumberEventCallback callback) {
            return new AdapterToIHaltEventCallback(new CallbackExecutorDecorator<Long>(EventFactory.this.dspUser, new NumberEventCallbackAdapter(callback)));
        }
    }

    private class FileLoadedCallbackAdapter<DataType extends IFileLoadedEventData>
    extends CallbackAdapter<FileLoadedEventCallback, IObjectEventListener<DataType>> {
        private FileLoadedCallbackAdapter() {
        }

        @Override
        IObjectEventListener<DataType> adapt(FileLoadedEventCallback callback) {
            return new AdapterToIFileLoadedEventCallback(new CallbackExecutorDecorator(EventFactory.this.dspUser, new FileLoadedEventCallbackAdapter(callback)));
        }
    }

    private class BooleanCallbackAdapter
    extends CallbackAdapter<BooleanEventCallback, IBooleanEventListener> {
        private BooleanCallbackAdapter() {
        }

        @Override
        IBooleanEventListener adapt(BooleanEventCallback callback) {
            return new AdapterToIBooleanEventCallback(new CallbackExecutorDecorator<Boolean>(EventFactory.this.dspUser, new BooleanEventCallbackAdapter(callback)));
        }
    }
}

