/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.events.internal;

import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.scripting.events.internal.BooleanEventCallback;
import com.ti.debug.engine.scripting.events.internal.EventFactory;
import com.ti.debug.engine.scripting.events.internal.FileLoadedEventCallback;
import com.ti.debug.engine.scripting.events.internal.IEvent;
import com.ti.debug.engine.scripting.events.internal.NumberEventCallback;
import com.ti.debug.engine.scripting.events.internal.SimpleEventCallback;

public class EventHandler {
    private final IEvent<SimpleEventCallback> onConnectedEvent;
    private final IEvent<BooleanEventCallback> onDisconnectingEvent;
    private final IEvent<NumberEventCallback> onHaltEvent;
    private final IEvent<SimpleEventCallback> onRunningEvent;
    private final IEvent<FileLoadedEventCallback> onPriorityFileLoaded;
    private final IEvent<FileLoadedEventCallback> onFileLoaded;
    private final IEvent<SimpleEventCallback> onRefresh;
    private final IEvent<NumberEventCallback> onReset;
    private final IEvent<NumberEventCallback> onRestart;

    public EventHandler(IDspUser user) {
        EventFactory factory = new EventFactory(user);
        this.onConnectedEvent = factory.createSimpleEvent(user.onConnected());
        this.onDisconnectingEvent = factory.createBooleanEvent(user.onDisconnecting());
        this.onHaltEvent = factory.createHaltEvent(user.onHalt());
        this.onRunningEvent = factory.createSimpleEvent(user.onRunning());
        this.onPriorityFileLoaded = factory.createPriorityFileLoadedEvent(user.onPriorityFileLoaded());
        this.onFileLoaded = factory.createFileLoadedEvent(user.onFileLoaded());
        this.onRefresh = factory.createSimpleEvent(user.onRefreshWithReason());
        this.onReset = factory.createNumberEvent(user.onReset());
        this.onRestart = factory.createNumberEvent(user.onRestart());
    }

    public IEvent<SimpleEventCallback> onConnected() {
        return this.onConnectedEvent;
    }

    public IEvent<BooleanEventCallback> onDisconnecting() {
        return this.onDisconnectingEvent;
    }

    public IEvent<NumberEventCallback> onHalt() {
        return this.onHaltEvent;
    }

    public IEvent<SimpleEventCallback> onRunning() {
        return this.onRunningEvent;
    }

    public IEvent<FileLoadedEventCallback> onPriorityProgramLoaded() {
        return this.onPriorityFileLoaded;
    }

    public IEvent<FileLoadedEventCallback> onProgramLoaded() {
        return this.onFileLoaded;
    }

    public IEvent<SimpleEventCallback> onRefresh() {
        return this.onRefresh;
    }

    public IEvent<NumberEventCallback> onReset() {
        return this.onReset;
    }

    public IEvent<NumberEventCallback> onRestart() {
        return this.onRestart;
    }
}

