/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.IFlatSystemSetupFile;
import com.ti.debug.engine.scripting.setup.ISystemSetupComponent;
import com.ti.debug.engine.scripting.setup.SystemSetupReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class FlatSystemSetupFile
implements IFlatSystemSetupFile {
    private SystemSetupReader.IHardwareDbCachedFile cachedFile;
    private ArrayList<SystemSetupReader.Cpu> cpus = null;
    private ArrayList<SystemSetupReader.Cpu> cpusNoRouters = null;
    private ArrayList<SystemSetupReader.Cpu> cpusNoSubPath = null;
    private ArrayList<SystemSetupReader.Device> devices = null;
    private SystemSetupReader.Board board;
    private String fileName;
    private String[] installDirectories;

    FlatSystemSetupFile(SystemSetupReader.IHardwareDbCachedFile cacheFile, ArrayList<ISystemSetupComponent> setupElements, String fileName, String[] installDirectories) {
        this.cachedFile = cacheFile;
        this.fileName = fileName;
        this.installDirectories = installDirectories;
        if (setupElements != null) {
            for (ISystemSetupComponent setupElement : setupElements) {
                if (setupElement instanceof SystemSetupReader.Cpu) {
                    if (this.cpus == null) {
                        this.cpus = new ArrayList();
                    }
                    this.cpus.add((SystemSetupReader.Cpu)setupElement);
                    continue;
                }
                if (setupElement instanceof SystemSetupReader.Device) {
                    if (this.devices == null) {
                        this.devices = new ArrayList();
                    }
                    this.devices.add((SystemSetupReader.Device)setupElement);
                    continue;
                }
                if (!(setupElement instanceof SystemSetupReader.Board) || this.board != null) continue;
                this.board = (SystemSetupReader.Board)setupElement;
            }
        }
        if (this.cpus != null) {
            this.cpusNoSubPath = new ArrayList(this.cpus.size());
            for (SystemSetupReader.Cpu cpu : this.cpus) {
                if (cpu.isSubpath() || !cpu.isDebuggable()) continue;
                this.cpusNoSubPath.add(cpu);
            }
            this.cpusNoRouters = new ArrayList(this.cpusNoSubPath.size());
            for (SystemSetupReader.Cpu cpu : this.cpusNoSubPath) {
                if (cpu.isRouter()) continue;
                this.cpusNoRouters.add(cpu);
            }
        }
    }

    @Override
    public Map<String, String> getCpuProperties(SystemSetupReader.Cpu cpu) {
        if (this.cachedFile != null && cpu != null) {
            return SystemSetupReader.Cpu.getProperties(cpu, this.cpus, this.cachedFile, this.fileName, this.installDirectories);
        }
        return new HashMap<String, String>();
    }

    @Override
    public String getCpuProperty(SystemSetupReader.Cpu cpu, String propertyName) {
        if (this.cachedFile != null && cpu != null) {
            Map<String, String> properties = SystemSetupReader.Cpu.getProperties(cpu, this.cpus, this.cachedFile, this.fileName, this.installDirectories);
            return properties.get(propertyName);
        }
        return null;
    }

    @Override
    public Map<String, String> getBoardProperties() {
        if (this.board != null) {
            return this.board.getProperties(this.cachedFile, this.fileName, this.installDirectories);
        }
        return Collections.unmodifiableMap(new HashMap());
    }

    @Override
    public Map<String, String> getDeviceProperties(String deviceFileNameFilter) {
        if (this.devices != null && this.devices.size() > 0) {
            for (SystemSetupReader.Device device : this.devices) {
                if (!new File(device.getFileName()).equals(new File(deviceFileNameFilter))) continue;
                return device.getProperties(this.cachedFile, this.fileName, this.installDirectories);
            }
        }
        return Collections.unmodifiableMap(new HashMap());
    }

    @Override
    public Map<String, String> getDeviceProperties(SystemSetupReader.Cpu cpuFilter) {
        if (this.devices != null && this.devices.size() > 0) {
            if (cpuFilter == null) {
                return this.devices.get(0).getProperties(this.cachedFile, this.fileName, this.installDirectories);
            }
            SystemSetupReader.Device device = cpuFilter.findParentDevice(this.devices);
            if (device != null) {
                return device.getProperties(this.cachedFile, this.fileName, this.installDirectories);
            }
        }
        return Collections.unmodifiableMap(new HashMap());
    }

    @Override
    public ArrayList<SystemSetupReader.Cpu> getListofCpus(boolean includeRouters) {
        if (!includeRouters) {
            return this.cpusNoRouters;
        }
        return this.cpusNoSubPath;
    }

    @Override
    public ArrayList<SystemSetupReader.Cpu> getListofCpus(String deviceFileNameFilter, boolean includeRouters) {
        ArrayList<SystemSetupReader.Cpu> allCpus = this.getListofCpus(includeRouters);
        if (allCpus == null) {
            return null;
        }
        if (!this.isBoard()) {
            return allCpus;
        }
        LinkedList<SystemSetupReader.Cpu> filteredCpus = new LinkedList<SystemSetupReader.Cpu>();
        if (this.devices != null && !this.devices.isEmpty()) {
            for (SystemSetupReader.Cpu cpu : allCpus) {
                SystemSetupReader.Device device = cpu.findParentDevice(this.devices);
                if (device == null || !new File(device.getFileName()).equals(new File(deviceFileNameFilter))) continue;
                filteredCpus.add(cpu);
            }
        }
        return new ArrayList<SystemSetupReader.Cpu>(filteredCpus);
    }

    @Override
    public SystemSetupReader.Cpu getParentCpu(SystemSetupReader.Cpu child) {
        return child.findParentCpu(this.cpusNoSubPath);
    }

    @Override
    public String getSubpathTypeProperty(SystemSetupReader.Cpu cpu) {
        try {
            return this.getSubpathProperty(cpu, "Type");
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public int getSubpathPortProperty(SystemSetupReader.Cpu cpu) {
        try {
            String propertyValue = this.getSubpathProperty(cpu, "Port Number");
            if (propertyValue != null) {
                return Integer.decode(propertyValue);
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public String getSubpathProperty(SystemSetupReader.Cpu cpu, String propertyName) {
        SystemSetupReader.Cpu subPath;
        if (this.cpus != null && (subPath = cpu.findParentSubPath(this.cpus)) != null) {
            return this.getCpuProperty(subPath, propertyName);
        }
        return null;
    }

    @Override
    public String getUniqueId() {
        if (this.isBoard()) {
            return this.cachedFile.getRootId();
        }
        return this.getPartNumber();
    }

    @Override
    public String getPartNumber() {
        if (this.devices != null && !this.devices.isEmpty()) {
            return this.devices.get(0).getPartNumber();
        }
        return null;
    }

    @Override
    public List<String> getIncludedDeviceFileNames() {
        LinkedList<String> fileNames = new LinkedList<String>();
        if (this.isBoard() && this.devices != null) {
            for (SystemSetupReader.Device device : this.devices) {
                fileNames.add(device.getFileName());
            }
        }
        return fileNames;
    }

    @Override
    public boolean isBoard() {
        return this.board != null;
    }

    @Override
    public boolean doesDeviceHaveProcessorsTag() {
        if (this.cachedFile != null) {
            return this.cachedFile.doesDeviceHaveProcessorsTag();
        }
        return false;
    }

    @Override
    public ArrayList<File> getInstances(String componentName) {
        ArrayList<File> result = new ArrayList<File>(1);
        if (this.cachedFile != null) {
            try {
                result = this.cachedFile.getInstances(componentName, this.fileName, this.installDirectories);
            }
            catch (HardwareDbException e) {
                result = null;
            }
        }
        return result;
    }
}

