/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.Tag;
import com.ti.debug.engine.scripting.setup.XMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class HardwareDatabaseReader {
    private ArrayList<String> tagNames = new ArrayList();
    private ArrayList<String> attributeNames = new ArrayList();
    private ArrayList<String> singletonTagNames = new ArrayList();

    public HardwareDatabaseReader() {
        this.singletonTagNames.add("driverProperties");
        this.singletonTagNames.add("jtag");
        this.singletonTagNames.add("driver");
        this.singletonTagNames.add("hierarchy");
        this.singletonTagNames.add("current");
    }

    public void addAttributesToFilter(String[] attributeNames) {
        int i = attributeNames.length;
        while (i-- > 0) {
            this.attributeNames.add(attributeNames[i]);
        }
    }

    public void addTagsToFilter(String[] tagNames) {
        int i = tagNames.length;
        while (i-- > 0) {
            this.tagNames.add(tagNames[i]);
        }
    }

    public static Tag newConfig() {
        return HardwareDatabaseReader.newConfig(true);
    }

    public static Tag newConfig(boolean createConfigurationTag) {
        XMLParser xmlParser = new XMLParser();
        Node root = xmlParser.CreateNewDocument("configurations");
        xmlParser.SetAttribute(root, "XML_version", "1.2");
        xmlParser.SetAttribute(root, "id", "configurations_0");
        if (createConfigurationTag) {
            Node configuration = xmlParser.CreateEntityNode("configuration");
            xmlParser.SetAttribute(configuration, "XML_version", "1.2");
            xmlParser.SetAttribute(configuration, "id", "configuration_0");
            root.appendChild(configuration);
            root = configuration;
        }
        return new Tag(xmlParser, root);
    }

    public Tag loadFlatConfig(String fileName, String[] rootDirectories, String schemaDirectory) throws HardwareDbException {
        Tag root = this.loadConfig(fileName, rootDirectories, schemaDirectory);
        return this.convertToFlatFile(root, fileName, rootDirectories);
    }

    public Tag loadConfig(String fileName, String[] rootDirectories, String schemaDirectory) throws HardwareDbException {
        try {
            FileInputStream xmlFile = new FileInputStream(fileName);
            Tag root = this.loadConfig(new InputSource(xmlFile), rootDirectories, schemaDirectory);
            ((InputStream)xmlFile).close();
            return root;
        }
        catch (FileNotFoundException e) {
            throw new HardwareDbException(e.getMessage());
        }
        catch (IOException e) {
            throw new HardwareDbException(e.getMessage());
        }
    }

    public Tag loadConfig(InputSource xmlFile, String[] rootDirectories, String schemaDirectory) throws HardwareDbException {
        XMLParser xmlParser = new XMLParser();
        File schemaPath = new File(schemaDirectory + "setup_parser.xsd");
        xmlParser.ParseAndValidate(xmlFile, schemaDirectory == null ? null : schemaPath.getAbsolutePath());
        Node rootNode = xmlParser.GetDocumentElement();
        if (rootNode == null) {
            throw new HardwareDbException("XML configuration file has no root node\n");
        }
        return new Tag(xmlParser, rootNode);
    }

    public Tag convertToFlatFile(Tag root, String fileName, String[] rootDirectories) throws HardwareDbException {
        XMLParser xmlFlatParser = new XMLParser();
        Node newRoot = xmlFlatParser.CreateNewDocument(root.getName());
        Tag result = new Tag(xmlFlatParser, newRoot);
        this.copyNode(root, result, new File(fileName).getParent(), rootDirectories, true, true);
        return result;
    }

    public static boolean isCompatibleISA(String name1, String name2) {
        int length = Math.min(name1.length(), name2.length());
        for (int i = 0; i < length; ++i) {
            char ch1 = Character.toUpperCase(name1.charAt(i));
            char ch2 = Character.toUpperCase(name2.charAt(i));
            if (ch1 == '*' || ch2 == '*') {
                return true;
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return name1.length() == name2.length();
    }

    public static Node getISA(Tag connection, String id) throws HardwareDbException {
        Node result = HardwareDatabaseReader.getDriver(connection, id);
        return result == null ? null : result.getParentNode();
    }

    private static Node getDriver(Tag connection, String id) throws HardwareDbException {
        Node drivers = connection.getChildByName("drivers", 0);
        if (drivers == null) {
            throw new HardwareDbException("XML configuration file has no drivers\n");
        }
        String sConnectionType = connection.getChildAttribute("connectionType", "Type");
        Node driver = null;
        boolean found = false;
        for (Node isaChild = XMLParser.GetFirstChild(drivers); isaChild != null; isaChild = isaChild.getNextSibling()) {
            if (XMLParser.GetName(isaChild) != "isa") continue;
            Tag isaNode = new Tag(connection, isaChild);
            int nDrivers = isaNode.countChildrenByName("driver");
            for (int i = 0; i < nDrivers; ++i) {
                Tag driverNode;
                String sDriverConnectionType;
                driver = isaNode.getChildByName("driver", i);
                if (driver != null && (sDriverConnectionType = (driverNode = new Tag(isaNode, driver)).getChildAttribute("connectionType", "Type")).length() > 0 && sDriverConnectionType.compareTo(sConnectionType) != 0) continue;
                String procID = XMLParser.GetAttributeString(isaChild, "id");
                if (procID == null || procID.length() == 0) {
                    procID = XMLParser.GetAttributeString(isaChild, "Type");
                }
                if (procID == null || !HardwareDatabaseReader.isCompatibleISA(procID, id)) break;
                found = true;
                break;
            }
            if (found) break;
        }
        return found ? driver : null;
    }

    public static Tag getISA(Tag processor) throws HardwareDbException {
        Tag driver = HardwareDatabaseReader.getDriver(processor);
        return driver == null ? null : new Tag(driver, driver.getParent(null));
    }

    public static Tag getDriver(Tag processor) throws HardwareDbException {
        Node connection = processor.getParent("connection");
        if (connection == null) {
            return null;
        }
        Tag conn = new Tag(processor, connection);
        Node isa = HardwareDatabaseReader.getDriver(conn, processor.getAttribute("isa"));
        if (isa != null) {
            return new Tag(processor, isa);
        }
        return null;
    }

    public static File convertToAbsPath(File fileName, String curDirectory, String[] rootDirectories) {
        if (!fileName.isAbsolute()) {
            File relFilename = new File(curDirectory, fileName.getPath());
            if (!relFilename.exists()) {
                for (int i = 0; i < rootDirectories.length && !(relFilename = new File(rootDirectories[i], fileName.getPath())).exists(); ++i) {
                }
            }
            fileName = relFilename;
        }
        return fileName;
    }

    private void copyAttributes(Tag from, Tag to, String curDirectory, String[] rootDirectories) {
        int i = this.attributeNames.size();
        while (i-- > 0) {
            String attr = this.attributeNames.get(i);
            to.copyAttribute(from, attr, curDirectory, rootDirectories);
        }
    }

    private void copyNode(Tag from, Tag to, String curDirectory, String[] rootDirectories, boolean topLevelNode, boolean topLevelChildren) throws HardwareDbException {
        this.copyAttributes(from, to, curDirectory, rootDirectories);
        if (!topLevelNode) {
            to.setAttribute("CanChildNodesBeMoved", "no");
        }
        Node child = from.getFirstChild();
        while (child != null) {
            Tag childNode;
            String tag = XMLParser.GetName(child);
            if (tag.compareTo("processors") == 0) {
                child = child.getFirstChild();
                continue;
            }
            String id = XMLParser.GetAttributeString(child, "id");
            if ((id == null || id.length() == 0) && tag.compareTo("property") == 0) {
                id = XMLParser.GetAttributeString(child, "Name");
            }
            File fileName = null;
            String href = null;
            if (tag.compareTo("instance") == 0 || tag.compareTo("include") == 0) {
                href = XMLParser.GetAttributeString(child, "href");
                fileName = new File(href);
                fileName = HardwareDatabaseReader.convertToAbsPath(fileName, curDirectory, rootDirectories);
                try {
                    childNode = this.loadConfig(fileName.getPath(), rootDirectories, null);
                }
                catch (HardwareDbException e) {
                    String errorPreamble = "Trouble parsing include or instance xml file\n";
                    if (e.getMessage().indexOf("Trouble parsing include or instance xml file\n") == 0) {
                        throw e;
                    }
                    throw new HardwareDbException("Trouble parsing include or instance xml file\n" + e.getMessage());
                }
                Tag includedTag = new Tag(from, child);
                if (tag.compareTo("include") == 0) {
                    id = childNode.getAttribute("id");
                    includedTag.setAttribute("id", id);
                }
                tag = childNode.getName();
                this.copyAttributes(includedTag, childNode, fileName.getParent(), rootDirectories);
            } else {
                childNode = new Tag(from, child);
            }
            int i = this.tagNames.size();
            while (i-- > 0) {
                Node driverPropertiesNode;
                if (tag.compareTo(this.tagNames.get(i)) != 0) continue;
                String identifier = id;
                String idAttribute = "id";
                if (childNode.getName().compareTo("choice") == 0) {
                    idAttribute = "Name";
                    identifier = childNode.getAttribute(idAttribute);
                    if (identifier == null || identifier.length() == 0) {
                        idAttribute = "value";
                        identifier = childNode.getAttribute(idAttribute);
                    }
                } else if (childNode.getName().compareTo("cchoice") == 0) {
                    idAttribute = "key";
                    identifier = childNode.getAttribute(idAttribute);
                }
                Node newChild = null;
                if (identifier != null && identifier.length() > 0) {
                    newChild = to.getFirstChild();
                    while (newChild != null && (tag.compareTo(XMLParser.GetName(newChild)) != 0 || identifier.compareTo(XMLParser.GetAttributeString(newChild, idAttribute)) != 0)) {
                        newChild = XMLParser.GetNextSibling(newChild);
                    }
                } else {
                    int j = this.singletonTagNames.size();
                    while (j-- > 0) {
                        if (tag.compareTo(this.singletonTagNames.get(j)) != 0) continue;
                        newChild = to.getChildByName(tag, 0);
                        break;
                    }
                }
                if (newChild == null) {
                    newChild = to.createChild(tag, id, null);
                }
                Tag newChildNode = new Tag(to, newChild);
                this.copyNode(childNode, newChildNode, fileName == null ? curDirectory : fileName.getParent(), rootDirectories, topLevelChildren, fileName == null ? topLevelChildren : false);
                if (tag.compareTo("isa") != 0 || (driverPropertiesNode = from.getChildByName("driverProperties", 0)) == null || newChildNode.getChildByName("driverProperties", 0) != null) break;
                Tag driverProperties = new Tag(from, driverPropertiesNode);
                Tag isaDriverProperties = new Tag(newChildNode, newChildNode.createChild("driverProperties", null, null));
                this.copyNode(driverProperties, isaDriverProperties, curDirectory, rootDirectories, topLevelChildren, topLevelChildren);
                break;
            }
            child = XMLParser.GetNextSibling(child);
        }
    }

    public static void includeFile(Tag atNode, File xmlFileToInclude, String id, String name, Node insertBefore) {
        Tag child = new Tag(atNode, atNode.createChild("instance", id, "1.2", insertBefore));
        String directory = xmlFileToInclude.getParent();
        child.setAttribute("xmlpath", directory == null || directory.length() == 0 ? "." : directory.replace('\\', '/'));
        child.setAttribute("xml", xmlFileToInclude.getName());
        child.setAttribute("href", xmlFileToInclude.getPath().replace('\\', '/'));
        if (name != null) {
            child.setAttribute("desc", name);
        }
    }

    public Tag createFlatNodeFromFile(Tag parent, String fileName, String id, String name, String[] rootDirectories, Node insertBefore) throws HardwareDbException {
        Tag includedRootNode = this.loadFlatConfig(fileName, rootDirectories, null);
        Node newChild = parent.getChildByID(includedRootNode.getName(), id);
        if (newChild == null) {
            newChild = parent.createChild(includedRootNode.getName(), null, null, insertBefore);
        }
        Tag newChildTag = new Tag(parent, newChild);
        this.copyNode(includedRootNode, newChildTag, new File(fileName).getParent(), rootDirectories, true, false);
        newChildTag.setAttribute("id", id);
        newChildTag.setAttribute("XML_version", "1.2");
        if (name != null) {
            newChildTag.setAttribute("desc", name);
        }
        return newChildTag;
    }
}

