/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

public class ProcessorID {
    static final long BITS_TYPE = 3L;
    static final long BITS_REV = 7L;
    static final long BITS_SUBFAMILY = 12L;
    static final long BITS_FAMILY = 10L;
    static final long MASK_TYPE = 7L;
    static final long MASK_REV = 127L;
    static final long MASK_SUBFAMILY = 4095L;
    static final long MASK_FAMILY = 1023L;
    static final long SHIFT_TYPE = 0L;
    static final long SHIFT_REV = 3L;
    static final long SHIFT_SUBFAMILY = 10L;
    static final long SHIFT_FAMILY = 22L;
    private long procID;
    private static final String ICEPick = "ICEPick_";
    private static final String DRP_SCRIPT = "DRP_SCRIPT_";
    private static final String TMS470R = "TMS470R";
    private static final String TMS370P = "TMS370P";
    private static final String TMS320C = "TMS320C";
    private static final String TMS = "TMS";
    private static final String MSP430 = "MSP430";
    private static final String ARM = "ARM";
    private static final String CORTEX = "Cortex ";

    public ProcessorID() {
    }

    public ProcessorID(long procID) {
        this.procID = procID;
    }

    public long getFamily() {
        return this.procID >> 22 & 0x3FFL;
    }

    public void setFamily(long family) {
        this.procID = this.procID & 0xFFFFFFFF003FFFFFL | (family & 0x3FFL) << 22;
    }

    public long getSubFamily() {
        return this.procID >> 10 & 0xFFFL;
    }

    public void setSubFamily(long subFamily) {
        this.procID = this.procID & 0xFFFFFFFFFFC003FFL | (subFamily & 0xFFFL) << 10;
    }

    public long getRevision() {
        return this.procID >> 3 & 0x7FL;
    }

    public void setRevision(long revision) {
        this.procID = this.procID & 0xFFFFFFFFFFFFFC07L | (revision & 0x7FL) << 3;
    }

    public long getType() {
        return this.procID >> 0 & 7L;
    }

    public void setType(long type) {
        this.procID = this.procID & 0xFFFFFFFFFFFFFFF8L | (type & 7L) << 0;
    }

    public long getProcessorID() {
        return this.procID;
    }

    public void setProcessorID(long newProcID) {
        this.procID = newProcID;
    }

    public boolean isNonDebug() {
        return this.getType() == 4L;
    }

    public boolean isRouter() {
        return this.getType() == 5L;
    }

    public String toString() {
        StringBuilder cstrOut = new StringBuilder();
        long family = this.getFamily();
        long subFamily = this.getSubFamily();
        if (family == 240L) {
            cstrOut.append(ICEPick);
            cstrOut.append((char)(65L + subFamily));
        } else if (family == 100L) {
            cstrOut.append(DRP_SCRIPT);
            cstrOut.append(Long.toString(subFamily));
        } else if (family == 430L) {
            cstrOut.append(MSP430);
        } else if (family == 470L && subFamily == 0L) {
            cstrOut.append(ARM);
        } else if (family == 470L && subFamily <= 3L) {
            cstrOut.append(ARM);
            cstrOut.append(Long.toString(subFamily * 2L + 5L));
        } else if (family == 470L && subFamily == 12L) {
            cstrOut.append(CORTEX);
            cstrOut.append("A");
        } else if (family == 470L && subFamily == 13L) {
            cstrOut.append(CORTEX);
            cstrOut.append("R");
        } else if (family == 470L && subFamily == 14L) {
            cstrOut.append(CORTEX);
            cstrOut.append("M");
        } else {
            cstrOut.append(TMS);
            cstrOut.append(Long.toString(family));
            cstrOut.append(family == 470L ? "R" : (family == 370L ? "P" : "C"));
            if (family == 320L) {
                if (subFamily == 86L) {
                    subFamily = 85L;
                }
                if (subFamily == 41L) {
                    subFamily = 40L;
                }
            }
            boolean bFoundNonZero = false;
            for (int i = 2; i >= 0; --i) {
                int nDigit = (int)(subFamily >> i * 4 & 0xFL);
                if (nDigit == 0) {
                    if (!bFoundNonZero && family != 370L) continue;
                    cstrOut.append('0');
                    continue;
                }
                if (nDigit >= 1 && nDigit <= 9) {
                    cstrOut.append((char)(48 + nDigit));
                    bFoundNonZero = true;
                    continue;
                }
                if (nDigit == 15) {
                    cstrOut.append("X");
                    bFoundNonZero = true;
                    continue;
                }
                cstrOut.append((char)(65 + (nDigit - 10)));
                bFoundNonZero = true;
            }
            long revision = this.getRevision();
            if (subFamily >= 1L && subFamily <= 9L) {
                if (revision >= 0L && revision <= 9L) {
                    cstrOut.append((char)(48L + revision));
                } else {
                    cstrOut.append("X");
                }
            } else {
                if (revision < 10L) {
                    cstrOut.append("0");
                }
                if (revision < 100L) {
                    cstrOut.append(Long.toString(revision));
                } else if (revision < 110L) {
                    cstrOut.append(Long.toString(revision - 100L) + "X");
                } else if (revision < 120L) {
                    cstrOut.append("X" + Long.toString(revision - 110L));
                } else {
                    cstrOut.append("XX");
                }
            }
        }
        return cstrOut.toString();
    }

    public String toStringProjectType() {
        long subFamily;
        long saveProcId = this.procID;
        long family = this.getFamily();
        if (family == 240L) {
            return "ICEPick";
        }
        if (family == 100L) {
            return "DRP_SCRIPT";
        }
        long mask = family != 320L ? 0x3FFFF8L : ((subFamily = this.getSubFamily()) < 80L || subFamily >= 95L ? 16376L : 1016L);
        this.procID &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        String result = this.toString();
        this.procID = saveProcId;
        if (result.startsWith("TMS320")) {
            return result.substring(6);
        }
        return result;
    }

    public void parse(String processorName) {
        this.procID = 0L;
        if (processorName.startsWith(ICEPick)) {
            this.setFamily(240L);
            this.setSubFamily(processorName.charAt(ICEPick.length()) - 65);
        } else if (processorName.startsWith(DRP_SCRIPT)) {
            this.setFamily(100L);
            this.setSubFamily(Long.parseLong(processorName.substring(DRP_SCRIPT.length()), 10));
        } else if (processorName.startsWith(MSP430)) {
            this.setFamily(430L);
        } else if (processorName.startsWith(ARM)) {
            this.setFamily(470L);
            Long subFamily = Long.parseLong(processorName.substring(ARM.length()), 10);
            this.setSubFamily((subFamily - 5L) / 2L);
        } else if (processorName.startsWith(CORTEX)) {
            this.setFamily(470L);
            if (processorName.substring(CORTEX.length() + 1).startsWith("M")) {
                this.setSubFamily(12L);
            } else if (processorName.substring(CORTEX.length() + 1).startsWith("R")) {
                this.setSubFamily(13L);
            } else if (processorName.substring(CORTEX.length() + 1).startsWith("A")) {
                this.setSubFamily(14L);
            } else {
                this.setSubFamily(0L);
            }
        } else if (processorName.startsWith(TMS)) {
            if (processorName.startsWith(TMS470R)) {
                this.setFamily(470L);
                processorName = processorName.substring(TMS470R.length());
            } else if (processorName.startsWith(TMS370P)) {
                this.setFamily(370L);
                processorName = processorName.substring(TMS370P.length());
            } else if (processorName.startsWith(TMS320C)) {
                this.setFamily(320L);
                processorName = processorName.substring(TMS320C.length());
            } else {
                this.setFamily(Long.parseLong(processorName.substring(TMS.length(), TMS.length() + 3)));
                processorName = processorName.substring(TMS.length() + 3);
            }
            processorName = processorName.toUpperCase();
            long revision = Long.parseLong(processorName.replaceAll("X", "F"), 16);
            if (revision <= 159L) {
                this.setSubFamily(revision >> 4);
                this.setRevision(revision & 0xFL);
            } else {
                this.setSubFamily(revision >> 8);
                if ((revision &= 0xFFL) == 255L) {
                    this.setRevision(revision);
                } else if (revision >= 240L) {
                    this.setRevision(110L + revision - 240L);
                } else if ((revision & 0xFL) == 15L) {
                    this.setRevision(100L + (revision >> 4));
                } else {
                    this.setRevision((revision >> 4) * 10L + (revision & 0xFL));
                }
            }
        }
    }

    public static void main(String[] args) {
        boolean passed = true;
        long[] family = new long[]{240L, 100L, 470L, 370L, 320L, 430L};
        long[] subFamily = new long[]{1L, 2L, 3L, 4L, 5L, 9L, 84L, 85L, 86L, 98L, 100L, 39L, 36L, 96L, 80L, 82L, 111L, 95L, 47L};
        long[] revision = new long[]{0L, 1L, 2L, 9L, 10L, 11L, 99L, 100L, 101L, 109L, 110L, 111L, 119L, 120L, 121L, 256L};
        ProcessorID procID = new ProcessorID();
        int i = family.length;
        while (i-- > 0) {
            int j = subFamily.length;
            while (j-- > 0) {
                int k = revision.length;
                while (k-- > 0) {
                    procID.setFamily(family[i]);
                    procID.setSubFamily(subFamily[j]);
                    procID.setRevision(revision[k]);
                    String name = procID.toString();
                    procID.parse(name);
                    String nameAgain = procID.toString();
                    if (name.compareTo(nameAgain) != 0) {
                        System.out.print("Test Case Failed: family=");
                        System.out.print(Long.toString(family[i]));
                        System.out.print(", subFamily=");
                        System.out.print(Long.toHexString(subFamily[j]));
                        System.out.print(", revision=");
                        System.out.print(Long.toString(revision[k]));
                        System.out.print(" should be ");
                        System.out.print(name);
                        System.out.print(" but was ");
                        System.out.println(nameAgain);
                        passed = false;
                    }
                    String familyGroup = procID.toStringProjectType();
                    String shouldBe = "";
                    if (family[i] == 470L) {
                        shouldBe = ARM;
                    } else if (family[i] == 320L && subFamily[j] > 15L) {
                        shouldBe = subFamily[j] >= 80L && subFamily[j] < 95L ? (subFamily[j] != 86L ? "C" + Long.toHexString(subFamily[j]) + "00" : "C5500") : "C" + (subFamily[j] >>> 4) + "000";
                    } else if (family[i] == 430L) {
                        shouldBe = MSP430;
                    } else if (family[i] == 240L) {
                        shouldBe = "ICEPick";
                    } else if (family[i] == 100L) {
                        shouldBe = "DRP_SCRIPT";
                    }
                    if (shouldBe.length() <= 0 || shouldBe.compareTo(familyGroup) == 0) continue;
                    System.out.print("Test Case Failed: family=");
                    System.out.print(Long.toString(family[i]));
                    System.out.print(", subFamily=");
                    System.out.print(Long.toHexString(subFamily[j]));
                    System.out.print(", revision=");
                    System.out.print(Long.toString(revision[k]));
                    System.out.print(" family group should be ");
                    System.out.print(shouldBe);
                    System.out.print(" but was ");
                    System.out.println(familyGroup);
                    passed = false;
                }
            }
        }
        if (passed) {
            System.out.println("Test Cases Passed");
        }
    }

    public static class DriverType {
        static final long EMU = 0L;
        static final long SIM = 1L;
        static final long DSK = 2L;
        static final long MOD = 3L;
        static final long NONDEBUG = 4L;
        static final long ROUTER = 5L;
    }
}

