/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.HardwareDatabaseReader;
import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.IFlatSystemSetupFile;
import com.ti.debug.engine.scripting.setup.SystemSetupReader;
import com.ti.debug.engine.scripting.setup.SystemSetupWriter;
import com.ti.debug.engine.scripting.setup.Tag;
import com.ti.debug.engine.scripting.setup.XMLParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SystemSetupEditor
extends SystemSetupWriter {
    private ArrayList<SystemSetupReader.ErrorReport> errorReports = null;
    private TreeElement rootTreeElement;
    private boolean hideConfigurations = true;
    private String fileName;
    private ArrayList<IChangedListener> changeHandlers;
    private Tag rootNode;
    private Tag flatRootNode;
    private HardwareDatabaseReader xmlReader = new HardwareDatabaseReader();
    private HashSet<String> nodesToShow;
    private HashSet<String> nodesToSuppress;
    private SystemSetupWriter.ComponentList cpus;
    private SystemSetupWriter.ComponentList routers;
    private SubpathComponentList subpaths;
    private SystemSetupWriter.ComponentList configurations;
    private HashMap<String, Tag> builtinProperties;
    private ConnectionDropListProperty connectionDropListProperty = null;
    private FilteredListProperty deviceDropListProperty = null;
    private InfoBoxProperty infoBoxProperty = null;
    private String defaultConnectionName;
    private String defaultConnectionType;

    public SystemSetupEditor() {
        this.xmlReader.addTagsToFilter(new String[]{"configurations", "configuration", "connection", "connectionType", "drivers", "isa", "driver", "platform", "board", "processors", "cpu", "core", "device", "subpath", "router", "property", "choice", "driverProperties", "choicelist", "current", "inference", "cchoice", "jtag"});
        this.xmlReader.addAttributesToFilter(new String[]{"id", "ProcID", "isa", "HW_revision", "partnum", "XML_version", "desc", "Name", "description", "Value", "key", "extn", "upper_range", "lower_range", "UpperBound", "LowerBound", "advice", "summary", "value", "type", "SubPath", "Type", "value2", "ID"});
        this.nodesToShow = new HashSet(10);
        if (!this.hideConfigurations) {
            this.nodesToShow.add("configuration");
        }
        this.nodesToShow.add("connection");
        this.nodesToShow.add("cpu");
        this.nodesToShow.add("core");
        this.nodesToShow.add("router");
        this.nodesToShow.add("subpath");
        this.nodesToShow.add("board");
        this.nodesToShow.add("device");
        this.nodesToSuppress = new HashSet(8);
        this.nodesToSuppress.add("configurations");
        if (this.hideConfigurations) {
            this.nodesToSuppress.add("configuration");
        }
        this.nodesToSuppress.add("platform");
        this.nodesToSuppress.add("processors");
    }

    public void reload(String xmlText) throws HardwareDbException {
        this.rootTreeElement = null;
        StringReader xmlInput = new StringReader(xmlText);
        this.load(new InputSource(xmlInput), this.fileName);
    }

    public void load(InputStream input, String fileName) throws HardwareDbException {
        this.load(new InputSource(input), fileName);
    }

    private void load(InputSource xmlInput, String fileName) throws HardwareDbException {
        this.fileName = fileName;
        String[] rootDirectories = this.getRootDirectories();
        this.rootNode = null;
        this.flatRootNode = null;
        this.rootNode = this.xmlReader.loadConfig(xmlInput, rootDirectories, this.getSchemaDirectory());
        this.flatRootNode = this.xmlReader.convertToFlatFile(this.rootNode, fileName, rootDirectories);
        this.generateErrorReports();
        this.fireChangedEvent(null, true);
    }

    public void save(OutputStream outputStream) {
    }

    private static boolean isLegacyProperty(String id) {
        return id.compareTo("portAddr1") == 0 || id.compareTo("portAddr2") == 0 || id.compareTo("irq") == 0 || id.compareTo("dma") == 0 || id.compareTo("driver") == 0 || id.compareTo("dataFile") == 0;
    }

    private void addProperties(Tag defaultNode, Tag overrideNode, ArrayList<AbstractProperty> properties, boolean subPathPropertiesOnly, PropertyDescriptor parentProperty) {
        this.addProperties(defaultNode, overrideNode, properties, true, subPathPropertiesOnly, parentProperty);
    }

    private void addProperties(Tag defaultNode, Tag overrideNode, ArrayList<AbstractProperty> properties, boolean excludeHiddenProperty, boolean subPathPropertiesOnly, PropertyDescriptor parentProperty) {
        int n = defaultNode.countChildrenByName("property");
        for (int i = 0; i < n; ++i) {
            String type;
            Node overriddenPropertyNode;
            String name;
            Node property = defaultNode.getChildByName("property", i);
            String subpathAttr = XMLParser.GetAttributeString(property, "SubPath");
            if (subpathAttr == null || !(subpathAttr.compareTo("true") == 0 ? subPathPropertiesOnly : !subPathPropertiesOnly)) continue;
            Tag defaultProperty = new Tag(defaultNode, property);
            String id = defaultProperty.getAttribute("id");
            if (id == null || id.length() == 0) {
                id = defaultProperty.getAttribute("ID");
            }
            if ((name = defaultProperty.getAttribute("Name")) == null || name.length() == 0) {
                name = defaultProperty.getAttribute("desc");
            }
            if (name == null || name.length() == 0) {
                name = id;
            }
            Node node = overriddenPropertyNode = overrideNode == null ? null : overrideNode.getChildByID("property", id);
            if (PropertyDescriptor.isDuplicateProperty(overriddenPropertyNode, properties) || SystemSetupEditor.isLegacyProperty(name)) continue;
            Tag overriddenProperty = overriddenPropertyNode == null ? null : new Tag(overrideNode, overriddenPropertyNode);
            PropertyDescriptor propStruct = new PropertyDescriptor(defaultProperty, overriddenProperty, overrideNode, parentProperty);
            String string = type = overriddenProperty == null ? null : overriddenProperty.getAttribute("Type");
            if (type == null || type.length() == 0) {
                type = defaultProperty.getAttribute("Type");
            }
            if (type.compareTo("stringfield") == 0) {
                TextProperty prop = new TextProperty();
                prop.id = propStruct;
                prop.description = name;
                prop.name = id;
                prop.toolTip = defaultProperty.getAttribute("description");
                properties.add(prop);
                continue;
            }
            if (type.compareTo("numericfield") == 0) {
                NumberProperty prop = new NumberProperty();
                prop.id = propStruct;
                prop.description = name;
                prop.name = id;
                prop.toolTip = defaultProperty.getAttribute("description");
                prop.upperbound = defaultProperty.getAttributeInteger("UpperBound", Long.MAX_VALUE);
                prop.lowerbound = defaultProperty.getAttributeInteger("LowerBound", Long.MIN_VALUE);
                properties.add(prop);
                continue;
            }
            if (type.compareTo("filepathfield") == 0) {
                FileProperty prop = new FileProperty();
                prop.id = propStruct;
                prop.description = name;
                prop.name = id;
                prop.toolTip = defaultProperty.getAttribute("description");
                prop.setExtensions(defaultProperty.getAttribute("Extensions"));
                properties.add(prop);
                continue;
            }
            if (type.compareTo("choicelist") == 0) {
                int nChoices = defaultProperty.countChildrenByName("choice");
                if (nChoices <= 0) continue;
                DropListProperty prop = new DropListProperty(defaultProperty, propStruct, name, nChoices);
                prop.toolTip = defaultProperty.getAttribute("description");
                prop.name = id;
                properties.add(prop);
                long curChoice = (overriddenProperty == null ? defaultProperty : overriddenProperty).getAttributeInteger("Value");
                if (curChoice < 0L || curChoice >= (long)nChoices) {
                    curChoice = 0L;
                }
                Tag defaultChoice = new Tag(defaultProperty, defaultProperty.getChildByName("choice", (int)curChoice));
                Node overriddenChoiceNode = null;
                if (overriddenProperty != null) {
                    String idAttribute = "Name";
                    String identifier = defaultChoice.getAttribute(idAttribute);
                    if (identifier == null || identifier.length() == 0) {
                        idAttribute = "value";
                        identifier = defaultChoice.getAttribute(idAttribute);
                    }
                    overriddenChoiceNode = overriddenProperty.getChildByID("choice", identifier, idAttribute);
                }
                Tag overriddenChoice = overriddenChoiceNode == null ? null : new Tag(overriddenProperty, overriddenChoiceNode);
                this.addProperties(defaultChoice, overriddenChoice, properties, excludeHiddenProperty, subPathPropertiesOnly, propStruct);
                continue;
            }
            if (type.compareTo("hiddenfield") != 0 || excludeHiddenProperty) continue;
            TextProperty prop = new TextProperty();
            prop.id = propStruct;
            prop.description = name;
            prop.name = id;
            prop.toolTip = defaultProperty.getAttribute("description");
            properties.add(prop);
        }
    }

    private static void addBulletToFormattedText(StringBuilder formattedText, String newBullet) {
        if (newBullet != null && newBullet.length() > 0) {
            formattedText.append("<li>");
            newBullet = newBullet.trim();
            if (newBullet.startsWith("-")) {
                newBullet = newBullet.substring(1);
                newBullet = newBullet.trim();
            }
            formattedText.append(newBullet);
            formattedText.append("</li>");
        }
    }

    private void addSimulatorDriverProperties(Tag driverProperties, Tag defaultValues, Tag overrideNode, ArrayList<AbstractProperty> properties, StringBuilder tips, StringBuilder summary) {
        int nProperties = driverProperties.countChildrenByName("choicelist");
        for (int i = 0; i < nProperties; ++i) {
            Tag property = new Tag(driverProperties, driverProperties.getChildByName("choicelist", i));
            String type = property.getAttribute("type");
            String name = property.getAttribute("id");
            Node overriddenProperty = overrideNode.getChildByID("property", name);
            if (overriddenProperty != null && XMLParser.GetAttributeString(overriddenProperty, "Type").compareTo("hiddenfield") == 0) continue;
            Tag defaultValue = new Tag(defaultValues, defaultValues.getChildByID("cchoice", name, "key"));
            SimulationPropertyDescriptor propStruct = new SimulationPropertyDescriptor(property, defaultValue, overriddenProperty != null ? new Tag(overrideNode, overriddenProperty) : null, overrideNode);
            if (type.compareTo("string_list") == 0) {
                int nChoices = property.countChildrenByName("choice");
                if (nChoices <= 0) continue;
                properties.add(new DropListProperty(property, propStruct, name, nChoices));
                String value = propStruct.getProperty().toString();
                Node currentChoice = property.getChildByID("choice", value, "value");
                if (currentChoice == null) continue;
                Tag choice = new Tag(property, currentChoice);
                this.addSimulatorDriverProperties(choice, defaultValues, overrideNode, properties, tips, summary);
                continue;
            }
            if (type.compareTo("string") == 0) {
                TextProperty prop = new TextProperty();
                prop.id = propStruct;
                prop.description = name;
                properties.add(prop);
                continue;
            }
            if (type.compareTo("FILE_PATH_EXTN") == 0) {
                FileProperty prop = new FileProperty();
                prop.id = propStruct;
                prop.description = name;
                prop.setExtensions(property.getAttribute("extn"));
                properties.add(prop);
                continue;
            }
            if (type.compareTo("numeric") != 0) continue;
            NumberProperty prop = new NumberProperty();
            prop.id = propStruct;
            prop.description = name;
            prop.upperbound = property.getAttributeInteger("upper_range", Long.MAX_VALUE);
            prop.lowerbound = property.getAttributeInteger("lower_range", Long.MIN_VALUE);
            properties.add(prop);
        }
        int nInferences = driverProperties.countChildrenByName("inference");
        for (int i = 0; i < nInferences; ++i) {
            Node inference = driverProperties.getChildByName("inference", i);
            String key = XMLParser.GetAttributeString(inference, "key");
            if (key.compareTo("advice") == 0) {
                SystemSetupEditor.addBulletToFormattedText(tips, XMLParser.GetAttributeString(inference, "value"));
                continue;
            }
            if (key.compareTo("summary") != 0) continue;
            SystemSetupEditor.addBulletToFormattedText(summary, XMLParser.GetAttributeString(inference, "value"));
        }
    }

    private void addSimulatorDriverProperties(Tag defaultNode, Tag overrideNode, ArrayList<AbstractProperty> properties) {
        Node driverPropertiesNode = defaultNode.getChildByName("driverProperties", 0);
        if (driverPropertiesNode != null) {
            Tag driverProperties = new Tag(defaultNode, driverPropertiesNode);
            Tag defaultValues = new Tag(driverProperties, driverProperties.getChildByName("current", 0));
            StringBuilder tips = new StringBuilder();
            StringBuilder summary = new StringBuilder();
            this.addSimulatorDriverProperties(driverProperties, defaultValues, overrideNode, properties, tips, summary);
            if (tips.length() != 0) {
                properties.add(new InfoBoxProperty("Tips", tips.toString()));
            }
            if (summary.length() != 0) {
                properties.add(new InfoBoxProperty("Summary", summary.toString()));
            }
        }
    }

    private void addBypassProperties(Tag flatNode, ArrayList<AbstractProperty> properties) {
        this.createFlatRootNode();
        NumberProperty prop = new NumberProperty();
        prop.id = new BypassBitsPropertyDescriptor(flatNode, this.flatRootNode);
        prop.description = "Bypass Bits";
        prop.upperbound = 1024L;
        prop.lowerbound = 1L;
        properties.add(prop);
    }

    private void addBuiltInProperties(Tag flatNode, ArrayList<AbstractProperty> properties) {
        this.addBuiltInProperties(flatNode, true, properties);
    }

    private void addBuiltInProperties(Tag flatNode, boolean excludeHiddenProperty, ArrayList<AbstractProperty> properties) {
        Tag defaultProperties;
        String componentName = flatNode.getName();
        if (this.builtinProperties == null) {
            this.builtinProperties = new HashMap(6);
        }
        if (!this.builtinProperties.containsKey(componentName)) {
            Tag builtinPropertiesRoot = null;
            try {
                File defaultPropertiesFile = new File(this.getTargetDbDirectory() + componentName + "s/defaultProperties.dat");
                XMLParser instanceParser = new XMLParser();
                instanceParser.ParseAndValidate(defaultPropertiesFile.getPath(), null);
                Node root = instanceParser.GetDocumentElement();
                if (root != null) {
                    builtinPropertiesRoot = new Tag(instanceParser, root);
                }
            }
            catch (HardwareDbException e) {
                // empty catch block
            }
            this.builtinProperties.put(componentName, builtinPropertiesRoot);
        }
        if ((defaultProperties = this.builtinProperties.get(componentName)) != null) {
            this.addProperties(defaultProperties, flatNode, properties, excludeHiddenProperty, false, null);
        }
    }

    private void addDriverProperties(Tag flatNode, ArrayList<AbstractProperty> properties) {
        this.addDriverProperties(flatNode, properties, true);
    }

    private void addDriverProperties(Tag flatNode, ArrayList<AbstractProperty> properties, boolean excludeHiddenProperty) {
        try {
            String type = flatNode.getName();
            Tag isaTag = null;
            boolean subPath = false;
            if (type.compareTo("cpu") == 0 || type.compareTo("router") == 0) {
                isaTag = HardwareDatabaseReader.getISA(flatNode);
            } else if (type.compareTo("subpath") == 0) {
                Node router = flatNode.getParent("router");
                if (router != null) {
                    isaTag = HardwareDatabaseReader.getISA(new Tag(flatNode, router));
                }
                subPath = true;
            }
            if (isaTag != null) {
                Node driverNode = isaTag.getChildByName("driver", 0);
                if (driverNode != null) {
                    this.addProperties(new Tag(isaTag, driverNode), flatNode, properties, excludeHiddenProperty, subPath, null);
                }
                if (type.compareTo("cpu") == 0) {
                    this.addSimulatorDriverProperties(isaTag, flatNode, properties);
                }
            }
        }
        catch (HardwareDbException e) {
            // empty catch block
        }
    }

    public ArrayList<AbstractProperty> getProperties(Object object) {
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>();
        if (object instanceof TreeElement && this.flatRootNode != null) {
            Tag flatNode = new Tag(this.flatRootNode, ((TreeElement)object).item);
            if (SystemSetupEditor.getBypassBits(flatNode) > 0) {
                this.addBypassProperties(flatNode, properties);
            } else {
                AbstractProperty prop;
                this.addBuiltInProperties(flatNode, properties);
                AbstractProperty abstractProperty = prop = properties.size() > 0 ? properties.get(0) : null;
                if (flatNode.getName().compareTo("connection") == 0) {
                    if (prop == null || !(prop instanceof DropListProperty) || prop.description.compareTo("dataFileRequired") != 0 || this.getProperty(prop.id).toString().compareTo("specify custom") != 0) {
                        this.addProperties(flatNode, flatNode, properties, false, null);
                    }
                } else if (prop != null && prop.description.compareToIgnoreCase("bypass") == 0) {
                    ((APropertyDescriptor)prop.id).setHasSubProperties(true);
                    if (this.getProperty(prop.id).toString().compareTo("Yes") == 0) {
                        while (properties.size() > 1) {
                            properties.remove(1);
                        }
                    } else {
                        this.addDriverProperties(flatNode, properties);
                    }
                } else {
                    this.addDriverProperties(flatNode, properties);
                }
            }
        }
        return properties;
    }

    public ArrayList<AbstractProperty> getProperties(Object object, boolean excludeHiddenProperty) {
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>();
        if (object instanceof TreeElement && this.flatRootNode != null) {
            Tag flatNode = new Tag(this.flatRootNode, ((TreeElement)object).item);
            if (SystemSetupEditor.getBypassBits(flatNode) > 0) {
                this.addBypassProperties(flatNode, properties);
            } else {
                AbstractProperty prop;
                this.addBuiltInProperties(flatNode, properties);
                AbstractProperty abstractProperty = prop = properties.size() > 0 ? properties.get(0) : null;
                if (flatNode.getName().compareTo("connection") == 0) {
                    if (prop == null || !(prop instanceof DropListProperty) || prop.description.compareTo("dataFileRequired") != 0 || this.getProperty(prop.id).toString().compareTo("specify custom") != 0) {
                        this.addProperties(flatNode, flatNode, properties, excludeHiddenProperty, false, null);
                    }
                } else if (prop != null && prop.description.compareToIgnoreCase("bypass") == 0) {
                    ((APropertyDescriptor)prop.id).setHasSubProperties(true);
                    if (this.getProperty(prop.id).toString().compareTo("Yes") == 0) {
                        while (properties.size() > 1) {
                            properties.remove(1);
                        }
                    } else {
                        this.addDriverProperties(flatNode, properties);
                    }
                } else {
                    this.addDriverProperties(flatNode, properties);
                }
            }
        }
        return properties;
    }

    public void resetProperty(Object id) {
        this.setProperty(id, "");
    }

    public boolean isPropertySet(Object id) {
        return ((Tag)id).getAttribute("Value").length() > 0;
    }

    public Object getProperty(Object id) {
        return this.validatePropertyInput(id, ((IPropertyDescriptor)id).getProperty().toString());
    }

    public String getBoardName(Object object) {
        Tag flatProperty;
        Node connectionNode;
        TreeElement connection;
        if (object instanceof TreeElement && this.flatRootNode != null && (connection = this.rootTreeElement.findElement(connectionNode = (flatProperty = new Tag(this.flatRootNode, ((TreeElement)object).item)).getParent("connection"))) != null) {
            return connection.getTextToDisplay(this);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public String getRecommendedBoardName(Object object) {
        boardName = null;
        flatNode = null;
        if (object instanceof TreeElement && this.flatRootNode != null) {
            flatNode = new Tag(this.flatRootNode, TreeElement.access$1000((TreeElement)object));
            type = flatNode.getName();
            isaTag = null;
            if (type.compareTo("cpu") == 0) {
                try {
                    isaTag = HardwareDatabaseReader.getISA(flatNode);
                    if (isaTag == null || (driverPropertiesNode = isaTag.getChildByName("driverProperties", 0)) == null) ** GOTO lbl22
                    driverProperties = new Tag(isaTag, driverPropertiesNode);
                    defaultValues = new Tag(driverProperties, driverProperties.getChildByName("current", 0));
                    nProperties = driverProperties.countChildrenByName("choicelist");
                    for (i = 0; i < nProperties && ((boardName = SimulationPropertyDescriptor.access$1100(defaultValues, flatNode, property = new Tag(driverProperties, driverProperties.getChildByName("choicelist", i)))) == null || boardName.length() <= 0); ++i) {
                    }
                }
                catch (HardwareDbException e) {}
            }
        } else if (object instanceof SimulationPropertyDescriptor) {
            boardName = ((SimulationPropertyDescriptor)object).getBoardName();
            flatNode = SimulationPropertyDescriptor.access$1200((SimulationPropertyDescriptor)object);
        }
lbl22:
        // 6 sources

        if (flatNode != null && boardName != null && boardName.length() > 0 && (configurationNode = flatNode.getParent("configuration")) != null && this.flatRootNode != null) {
            parent = new Tag(this.flatRootNode, configurationNode);
            boardName = this.createUniqueId(parent, boardName, this.getComponentNames(parent));
        }
        return boardName;
    }

    public void renameBoard(Object object, String recommendedBoardName) {
        if (object instanceof TreeElement && recommendedBoardName != null) {
            Tag cpuNode = new Tag(this.flatRootNode, ((TreeElement)object).item);
            Node connection = cpuNode.getParent("connection");
            TreeElement connectionNode = this.rootTreeElement.findElement(connection);
            this.rename(connectionNode, recommendedBoardName);
            this.fireChangedEvent(connectionNode, false);
        }
    }

    public String getNodeDescriptionToDisplay(Object object) {
        String description = this.getErrorMessage(object);
        if (description == null && object instanceof TreeElement && this.flatRootNode != null) {
            Tag flatNode = new Tag(this.flatRootNode, ((TreeElement)object).item);
            description = flatNode.getAttribute("description");
        }
        return description == null ? "" : description;
    }

    private Tag gotoNode(Tag flatNode, boolean createNode) {
        String idAttribute;
        boolean isChoiceTag;
        if (this.flatRootNode == null) {
            return null;
        }
        if (flatNode.getNode() == this.flatRootNode.getNode()) {
            return this.rootNode;
        }
        Tag parentTag = this.gotoNode(new Tag(flatNode, flatNode.getParent(null)), createNode);
        if (parentTag == null) {
            return null;
        }
        String nodeName = flatNode.getName();
        boolean bl = isChoiceTag = nodeName.compareTo("choice") == 0;
        if (isChoiceTag) {
            idAttribute = "Name";
            String propName = flatNode.getAttribute(idAttribute);
            if (propName == null || propName.length() == 0) {
                idAttribute = "value";
            }
        } else {
            idAttribute = "id";
        }
        String id = flatNode.getAttribute(idAttribute);
        Node child = parentTag.getChildByID(nodeName, id, idAttribute);
        if (!createNode && child == null) {
            return null;
        }
        if (child == null) {
            String version = flatNode.getAttribute("XML_version");
            version = version != null && version.length() > 0 ? "1.2" : null;
            child = parentTag.createChild(nodeName, null, version);
            Tag childTag = new Tag(parentTag, child);
            childTag.setAttribute(idAttribute, id);
            childTag.copyAttribute(flatNode, "partnum");
            childTag.copyAttribute(flatNode, "HW_revision");
            childTag.copyAttribute(flatNode, "isa");
            childTag.copyAttribute(flatNode, "Type");
            childTag.copyAttribute(flatNode, "description");
            if (isChoiceTag) {
                childTag.copyAttribute(flatNode, "value");
                childTag.copyAttribute(flatNode, "Name");
            } else {
                childTag.copyAttribute(flatNode, "Value");
            }
        }
        return new Tag(parentTag, child);
    }

    private ArrayList<Tag> findNodesOrIncludeTags(Tag flatNode) {
        ArrayList<Tag> retVal = null;
        Tag flatParent = new Tag(flatNode, flatNode.getParent(null));
        Tag parent = this.gotoNode(flatParent, false);
        if (parent != null && flatNode.getAttribute("CanChildNodesBeMoved").compareTo("no") != 0) {
            String id = flatNode.getAttribute("id");
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (id.compareTo(XMLParser.GetAttributeString(child, "id")) != 0) continue;
                if (retVal == null) {
                    retVal = new ArrayList<Tag>(2);
                }
                retVal.add(new Tag(parent, child));
            }
        }
        return retVal;
    }

    public String validatePropertyInput(Object id, String value) {
        File absFileName;
        IPropertyDescriptor prop = (IPropertyDescriptor)id;
        if (prop.isFilePathProperty() && value != null && (absFileName = new File(value)).isAbsolute()) {
            int nRootDirectories = this.getRootDirectories().length;
            File[] relativeTo = new File[nRootDirectories + 1];
            relativeTo[0] = new File(this.fileName).getParentFile();
            for (int i = 0; i < nRootDirectories; ++i) {
                relativeTo[i + 1] = new File(this.getRootDirectories()[i]);
            }
            String relPathValue = SystemSetupEditor.getRelativePath(new File(value), relativeTo).toString();
            if (relPathValue != value.toString()) {
                value = relPathValue;
            }
        }
        return value;
    }

    public void setPropertyByName(Object root, String cpuId, String propId, String value) {
        Object[] children;
        if (root == null) {
            root = this.getRoot();
        }
        if (root != null && root instanceof TreeElement) {
            ArrayList<AbstractProperty> properties;
            TreeElement r = (TreeElement)root;
            if ((cpuId == null || r.id != null && cpuId.compareTo(r.id) == 0) && (properties = this.getProperties(root)) != null) {
                for (AbstractProperty property : properties) {
                    if (propId.compareTo(property.getName()) != 0) continue;
                    this.setProperty(property.id, value);
                }
            }
        }
        if ((children = this.getChildren(root)) != null) {
            for (Object child : children) {
                this.setPropertyByName(child, cpuId, propId, value);
            }
        }
    }

    public boolean setProperty(Object id, Object value) {
        String newValue;
        IPropertyDescriptor prop = (IPropertyDescriptor)id;
        String curValue = this.getProperty(id).toString();
        if (curValue.compareTo(newValue = value.toString()) != 0) {
            Tag flatProperty = prop.setProperty(value);
            if (flatProperty != null) {
                Tag newProperty = this.gotoNode(flatProperty, true);
                newProperty.setAttribute(prop.getValueAttributeName(), flatProperty.getAttribute(prop.getValueAttributeName()));
                if (prop.hasSubProperties() && this.rootTreeElement != null) {
                    if (prop instanceof BypassBitsPropertyDescriptor) {
                        this.generateErrorReports();
                    }
                    this.fireChangedEvent(this.getParent(flatProperty.getNode()), false);
                }
            }
            return true;
        }
        return false;
    }

    public void setDefaultConnection(String type, String name) {
        this.defaultConnectionType = type;
        this.defaultConnectionName = name;
    }

    public void setConnection(SystemSetupWriter.SetupItem connection) {
        this.getBasicProperties();
        this.setProperty(this.connectionDropListProperty.id, connection.name);
    }

    public boolean isPropertyReadOnly(Object id) {
        IPropertyDescriptor prop = (IPropertyDescriptor)id;
        return prop.isReadOnly();
    }

    public void rename(Object element, String value) {
        if (element != null && element instanceof TreeElement && this.flatRootNode != null) {
            Tag node = new Tag(this.flatRootNode, ((TreeElement)element).item);
            node.setAttribute("desc", value);
            Tag topLevelNode = this.gotoNode(node, true);
            topLevelNode.setAttribute("desc", value);
            if (this.generateErrorReports()) {
                this.fireChangedEvent(null, true);
            }
        }
    }

    public Object getRoot() {
        if (this.rootTreeElement == null) {
            this.rootTreeElement = new TreeElement(null, null, null);
        }
        if (this.flatRootNode != null) {
            this.rootTreeElement.item = this.flatRootNode.getNode();
        }
        return this.rootTreeElement.item == null ? null : this.rootTreeElement;
    }

    public Object[] getChildren(Object object) {
        if (object != null && object instanceof TreeElement) {
            return ((TreeElement)object).getChildren(this, this.getChildNodes(((TreeElement)object).item));
        }
        return null;
    }

    private Node[] getChildNodes(Node parentNode) {
        int count = this.countChildNodes(parentNode);
        if (count > 0) {
            Node[] result = new Node[count];
            Node node = this.getFirstVisibleChild(parentNode);
            for (int i = 0; i < count; ++i) {
                result[i] = node;
                node = this.getNextVisibleChild(node);
            }
            return result;
        }
        return null;
    }

    private Node getFirstVisibleChild(Node parent) {
        return this.findNextVisibleChild(parent, XMLParser.GetFirstChild(parent));
    }

    private Node getNextVisibleChild(Node child) {
        if (child != null) {
            child = this.findNextVisibleChild(child.getParentNode(), child.getNextSibling());
        }
        return child;
    }

    private Node findNextVisibleChild(Node parent, Node child) {
        while (true) {
            if (child != null) {
                if (this.nodesToShow.contains(child.getNodeName())) break;
                if (this.nodesToSuppress.contains(child.getNodeName())) {
                    parent = child;
                    child = XMLParser.GetFirstChild(parent);
                    continue;
                }
                child = child.getNextSibling();
                continue;
            }
            if (parent == null || !this.nodesToSuppress.contains(parent.getNodeName())) break;
            child = parent.getNextSibling();
            parent = parent.getParentNode();
        }
        return child;
    }

    public int countChildren(Object object) {
        if (object instanceof TreeElement) {
            return this.countChildNodes(((TreeElement)object).item);
        }
        return 0;
    }

    private int countChildNodes(Node parentNode) {
        int count = 0;
        Node node = this.getFirstVisibleChild(parentNode);
        while (node != null) {
            ++count;
            node = this.getNextVisibleChild(node);
        }
        return count;
    }

    public Object getParent(Object object) {
        TreeElement parent = null;
        if (object instanceof TreeElement) {
            parent = ((TreeElement)object).getParent();
        } else if (object instanceof Node) {
            Node parentNode = null;
            for (parentNode = ((Node)object).getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                if (!this.nodesToShow.contains(parentNode.getNodeName())) continue;
                if (this.rootTreeElement == null) break;
                parent = this.rootTreeElement.findElement(parentNode);
                break;
            }
        }
        return parent == null ? this.getRoot() : parent;
    }

    private Object findErrorLocation(String errorLocation, Object parent) {
        Object result = null;
        if (parent != null && parent instanceof TreeElement) {
            String thisErrorLocation = ((TreeElement)parent).getErrorLocation(this);
            if (thisErrorLocation != null && thisErrorLocation.compareTo(errorLocation) == 0) {
                return parent;
            }
            Object[] children = this.getChildren(parent);
            if (children != null) {
                for (int i = 0; result == null && i < children.length; ++i) {
                    result = this.findErrorLocation(errorLocation, children[i]);
                }
            }
        }
        return result;
    }

    public Object findErrorLocation(String errorLocation) {
        return this.findErrorLocation(errorLocation, this.getRoot());
    }

    public String getErrorMessage(Object id) {
        if (this.errorReports != null && id instanceof TreeElement) {
            String location = ((TreeElement)id).getErrorLocation(this);
            if (location != null) {
                for (SystemSetupReader.ErrorReport errorReport : this.errorReports) {
                    if (errorReport.getLocation() == null || errorReport.getLocation().compareToIgnoreCase(location) != 0) continue;
                    return errorReport.getErrorMessage();
                }
            }
        } else if (id == null && this.errorReports != null && this.errorReports.size() > 0) {
            return this.errorReports.get(0).getErrorMessage();
        }
        return null;
    }

    public boolean hasErrors() {
        return this.errorReports != null && this.errorReports.size() > 0;
    }

    public String getXmlText() {
        ByteArrayOutputStream xmlOutput = new ByteArrayOutputStream();
        if (this.rootNode != null) {
            this.rootNode.writeXMLDocument(xmlOutput);
            return xmlOutput.toString();
        }
        return "";
    }

    public String getTextToDisplay(Object element) {
        String text = "";
        if (element != null && element instanceof TreeElement) {
            text = ((TreeElement)element).getTextToDisplay(this);
        }
        return text;
    }

    public String getDecoratorText(Object element) {
        if (element != null && element instanceof TreeElement) {
            return ((TreeElement)element).getDecoratorText(this);
        }
        return null;
    }

    private static int getBypassBits(Tag node) {
        String isa = node.getAttribute("isa");
        if (isa != null && isa.startsWith("BYPASS")) {
            return Integer.parseInt(isa.substring(6), 10);
        }
        return -1;
    }

    private static void setBypassBits(Tag node, Tag flatRootNode, int bits) {
        node.setAttribute("isa", (bits < 10 ? "BYPASS0" : "BYPASS") + Integer.toString(bits));
    }

    public String getIconNameToDisplay(Object element) {
        Tag node;
        String iconName;
        String string = iconName = this.hideConfigurations ? "connection" : "configuration";
        if (element != null && element instanceof TreeElement && (iconName = XMLParser.GetName(((TreeElement)element).item)).compareTo("cpu") == 0 && this.flatRootNode != null && (SystemSetupEditor.getBypassBits(node = new Tag(this.flatRootNode, ((TreeElement)element).item)) > 0 || node.getPropertyString("bypass", "0").compareTo("1") == 0)) {
            iconName = "bypass";
        }
        return iconName;
    }

    public ArrayList<SystemSetupWriter.IComponentList> getComponents(Object node) {
        ArrayList<SystemSetupWriter.IComponentList> componentLists = null;
        if (node == null) {
            componentLists = new ArrayList<SystemSetupWriter.IComponentList>(2);
            componentLists.add(this.getListOfConfigurations());
            if (this.hideConfigurations) {
                componentLists.add(this.getListOfConnections());
            }
        } else if (node instanceof TreeElement) {
            Node element = ((TreeElement)node).item;
            String type = XMLParser.GetName(element);
            if (type.compareTo("configuration") == 0) {
                componentLists = new ArrayList(1);
                componentLists.add(this.getListOfConnections());
            } else if (type.compareTo("cpu") != 0) {
                if (type.compareTo("router") == 0) {
                    componentLists = new ArrayList(1);
                    componentLists.add(this.getListOfSubpaths());
                } else {
                    FilteredComponentListAllISAs routers;
                    if (type.compareTo("connection") != 0 && this.flatRootNode != null) {
                        Tag device = new Tag(this.flatRootNode, element);
                        element = device.getParent("connection");
                    }
                    String connectionType = null;
                    if (element != null && this.flatRootNode != null) {
                        Tag connection = new Tag(this.flatRootNode, element);
                        connectionType = connection.getChildAttribute("connectionType", "Type");
                    }
                    componentLists = new ArrayList(4);
                    if (type.compareTo("core") != 0 && type.compareTo("device") != 0) {
                        if (type.compareTo("board") != 0 && type.compareTo("subpath") != 0) {
                            componentLists.add(new FilteredComponentList(this.getListOfBoards(), connectionType));
                        }
                        componentLists.add(new FilteredComponentList(this.getListOfDevices(), connectionType));
                    }
                    componentLists.add(new FilteredComponentList(this.getListOfCpus(), connectionType));
                    if (type.compareTo("core") != 0 && !(routers = new FilteredComponentListAllISAs(this.getListOfRouters(), connectionType)).getComponents().isEmpty()) {
                        componentLists.add(routers);
                    }
                }
            }
        }
        return componentLists;
    }

    public Set<String> getIsaFilters(Object node) {
        Node element;
        String type;
        String connectionType = null;
        if (node != null && node instanceof TreeElement && (type = XMLParser.GetName(element = ((TreeElement)node).item)).compareTo("configuration") != 0) {
            if (type.compareTo("connection") != 0 && this.flatRootNode != null) {
                Tag device = new Tag(this.flatRootNode, element);
                element = device.getParent("connection");
            }
            if (element != null && this.flatRootNode != null) {
                Tag connection = new Tag(this.flatRootNode, element);
                connectionType = connection.getChildAttribute("connectionType", "Type");
            }
        }
        return this.getListOfISAs(connectionType);
    }

    public void paste(Object source, Object destination, boolean insertAfter) {
        if (source instanceof TreeElement && destination instanceof TreeElement && !insertAfter) {
            ((TreeElement)destination).item.insertBefore(((TreeElement)source).item.cloneNode(true), ((TreeElement)destination).item);
        }
    }

    public boolean canMoveUp(Object node) {
        return this.doMove(node, true, false);
    }

    public boolean canMoveDown(Object node) {
        return this.doMove(node, false, false);
    }

    public void moveUp(Object node) {
        this.doMove(node, true, true);
    }

    public void moveDown(Object node) {
        this.doMove(node, false, true);
    }

    private boolean doMove(Object node, boolean up, boolean doit) {
        ArrayList<Tag> siblingTags;
        block4: {
            Tag flatSiblingTag;
            Tag flatChildTag;
            block5: {
                ArrayList<Tag> childTags;
                block6: {
                    block7: {
                        Node nextFlatSibling;
                        siblingTags = null;
                        if (node == null || !(node instanceof TreeElement)) break block4;
                        Node flatChild = ((TreeElement)node).item;
                        Object flatParent = this.getParent(node);
                        Object[] siblings = this.getChildren(flatParent);
                        Node flatSibling = ((TreeElement)siblings[up ? 0 : siblings.length - 1]).item;
                        if (flatSibling == flatChild || this.flatRootNode == null) break block4;
                        int i = 1;
                        while ((nextFlatSibling = ((TreeElement)siblings[up ? i : siblings.length - 1 - i]).item) != flatChild) {
                            flatSibling = nextFlatSibling;
                            ++i;
                        }
                        flatChildTag = new Tag(this.flatRootNode, flatChild);
                        flatSiblingTag = new Tag(this.flatRootNode, flatSibling);
                        childTags = this.findNodesOrIncludeTags(flatChildTag);
                        if (childTags == null || childTags.size() == 0 || (siblingTags = this.findNodesOrIncludeTags(flatSiblingTag)) == null) break block5;
                        if (flatChildTag.getName().compareTo("connection") != 0) break block6;
                        if (childTags.get(0).getName().compareTo(siblingTags.get(0).getName()) == 0) break block7;
                        siblingTags = null;
                        break block5;
                    }
                    if (!doit) break block5;
                    this.swap(childTags.get(0), siblingTags.get(0));
                    break block5;
                }
                if (doit) {
                    Tag insertBefore = (up ? siblingTags : childTags).get(0);
                    ArrayList<Tag> TagsToMove = up ? childTags : siblingTags;
                    Node parent = insertBefore.getParent(null);
                    for (int i = 0; i < TagsToMove.size(); ++i) {
                        parent.insertBefore(TagsToMove.get(i).getNode(), insertBefore.getNode());
                    }
                }
            }
            if (doit && siblingTags != null) {
                this.swap(flatChildTag, flatSiblingTag);
                this.fireChangedEvent(this.getParent(node), true);
            }
        }
        return siblingTags != null;
    }

    private void swap(Tag tag1, Tag tag2) {
        Node tmp = tag1.m_pXmlParser.CreateEntityNode("junk");
        Node tag2Parent = tag2.getParent(null);
        tag2Parent.replaceChild(tmp, tag2.getNode());
        Node tag1Parent = tag1.getParent(null);
        tag1Parent.replaceChild(tag2.getNode(), tag1.getNode());
        tag2Parent.replaceChild(tag1.getNode(), tmp);
    }

    public String addComponent(Object parent, SystemSetupWriter.SetupItem newComponent, String id, File xmlSystemSetupFile) {
        String errMsg = null;
        Node parentNode = null;
        if (parent != null && parent instanceof TreeElement) {
            parentNode = ((TreeElement)parent).item;
        } else if (parent != null && parent instanceof Node) {
            parentNode = (Node)parent;
            parent = null;
        }
        if (!(id != null && id.length() != 0 || (id = newComponent.name).endsWith("_0") || parentNode == null && (newComponent.connectionType == null || newComponent.connectionType.length() == 0))) {
            id = id + "_0";
        }
        this.createFlatRootNode();
        if (parentNode == null) {
            parentNode = newComponent.connectionType == null || newComponent.connectionType.length() == 0 ? this.flatRootNode.getNode() : this.flatRootNode.createChild("configuration", this.createUniqueId(this.flatRootNode, id, null), "1.2");
        }
        if (parentNode != null) {
            Tag flatParent = new Tag(this.flatRootNode, parentNode);
            if (newComponent instanceof SubpathComponentList.SubPathSetupItem) {
                this.addSubPath(flatParent, id, parent);
            } else {
                errMsg = this.includeComponent(flatParent, newComponent, id, xmlSystemSetupFile, parent);
                if (errMsg == null) {
                    this.setAllDefaultJtagProperties();
                }
            }
        }
        return errMsg;
    }

    public String addBypassComponent(Object parentNode, String id) {
        if (parentNode != null && parentNode instanceof TreeElement) {
            this.createFlatRootNode();
            Tag flatParent = new Tag(this.flatRootNode, ((TreeElement)parentNode).item);
            if (id == null || id.length() == 0) {
                id = "bypass_0";
            }
            if (flatParent.getName().compareTo("connection") == 0) {
                Node platform = flatParent.getChildByName("platform", 0);
                if (platform == null) {
                    platform = flatParent.createChild("platform", 0, "1.2");
                }
                flatParent = new Tag(flatParent, platform);
            }
            id = this.createUniqueId(flatParent, id, this.getComponentNames(flatParent));
            Node newChild = flatParent.createChild("cpu", id, "1.2");
            Tag bypass = new Tag(flatParent, newChild);
            bypass.setAttribute("isa", "BYPASS08");
            bypass.setAttribute("description", "Bypass Cpu");
            bypass.setAttribute("HW_revision", "1.0");
            this.gotoNode(bypass, true);
            this.fireChangedEvent(parentNode, true);
            this.fireExpandEvent(parentNode, bypass);
        }
        return null;
    }

    private String includeComponent(Tag flatParent, SystemSetupWriter.SetupItem device, String id, File xmlFileName, Object parentTreeNode) {
        String errMsg = null;
        try {
            Tag connection = null;
            int nRootDirectories = this.getRootDirectories().length;
            File[] relativeTo = new File[nRootDirectories + 1];
            relativeTo[0] = xmlFileName.getParentFile();
            for (int i = 0; i < nRootDirectories; ++i) {
                relativeTo[i + 1] = new File(this.getRootDirectories()[i]);
            }
            if (flatParent.getName().compareTo("connection") == 0) {
                Node platform = flatParent.getChildByName("platform", 0);
                if (platform == null) {
                    platform = flatParent.createChild("platform", 0, "1.2");
                }
                connection = flatParent;
                flatParent = new Tag(flatParent, platform);
            } else {
                Node connectionNode = flatParent.getParent("connection");
                if (connectionNode != null) {
                    connection = new Tag(flatParent, connectionNode);
                }
            }
            if (connection != null) {
                errMsg = this.addDeviceDrivers(connection, connection.getChildAttribute("connectionType", "Type"), device, relativeTo);
            }
            if (errMsg == null) {
                Tag parent = this.gotoNode(flatParent, true);
                File relFilePath = SystemSetupEditor.getRelativePath(new File(device.fileName), relativeTo);
                Node insertBefore = parent.getChildByName("configuration", 0);
                if (insertBefore == null) {
                    insertBefore = parent.getChildByName("connection", 0);
                }
                ArrayList<String> existingNames = this.getComponentNames(flatParent);
                id = this.createUniqueId(flatParent, id, existingNames);
                HardwareDatabaseReader.includeFile(parent, relFilePath, id, id, insertBefore);
                if (insertBefore != null) {
                    insertBefore = flatParent.getChildByID(null, XMLParser.GetAttributeString(insertBefore, "id"));
                }
                Tag newFlatChild = this.xmlReader.createFlatNodeFromFile(flatParent, device.fileName, id, id, this.getRootDirectories(), insertBefore);
                this.createUniqueNames(newFlatChild.getNode(), existingNames);
                if (this.generateErrorReports()) {
                    this.fireChangedEvent(null, true);
                } else {
                    this.fireChangedEvent(parentTreeNode, true);
                }
                this.fireExpandEvent(parentTreeNode, newFlatChild);
            }
        }
        catch (HardwareDbException e) {
            errMsg = e.getMessage();
        }
        return errMsg;
    }

    @Override
    protected String addDeviceDriver(Tag flatConnection, File relDriverXmlFile, File absDriverXmlFile) {
        try {
            Tag connection = this.gotoNode(flatConnection, true);
            this.xmlReader.createFlatNodeFromFile(flatConnection, absDriverXmlFile.getPath(), "drivers", null, this.getRootDirectories(), flatConnection.getChildByName("platform", 0));
            return super.addDeviceDriver(connection, relDriverXmlFile, absDriverXmlFile);
        }
        catch (HardwareDbException e) {
            return "Can't use device driver due to parsing errors in " + relDriverXmlFile.getName() + ".\nPlease select a different driver or a different device.";
        }
    }

    private ArrayList<String> getComponentNames(Tag parent) {
        Node connection = parent.getParent("connection");
        ArrayList<String> result = new ArrayList<String>();
        this.getComponentNames(connection == null ? (this.flatRootNode != null ? this.flatRootNode.getNode() : null) : connection, result, connection != null);
        return result;
    }

    private void getComponentNames(Node parent, ArrayList<String> elementNames, boolean recursive) {
        Node child = this.getFirstVisibleChild(parent);
        while (child != null) {
            String childName = XMLParser.GetAttributeString(child, "desc");
            if (childName == null || childName.length() == 0) {
                childName = XMLParser.GetAttributeString(child, "id");
            }
            if (childName != null && childName.length() > 0) {
                elementNames.add(childName.toLowerCase());
            }
            if (recursive) {
                this.getComponentNames(child, elementNames, true);
            }
            child = this.getNextVisibleChild(child);
        }
    }

    private void createUniqueNames(Node parent, ArrayList<String> existingNames) {
        Node child = this.getFirstVisibleChild(parent);
        while (child != null) {
            String childName = XMLParser.GetAttributeString(child, "desc");
            if (childName == null || childName.length() == 0) {
                childName = XMLParser.GetAttributeString(child, "id");
            }
            if (childName != null && childName.length() > 0) {
                boolean nameChanged = false;
                while (existingNames.contains(childName.toLowerCase())) {
                    childName = SystemSetupEditor.generateUniqueString(childName);
                    nameChanged = true;
                }
                if (nameChanged && this.flatRootNode != null) {
                    Tag flatNode = new Tag(this.flatRootNode, child);
                    flatNode.setAttribute("desc", childName);
                    Tag topLevelNode = this.gotoNode(flatNode, true);
                    topLevelNode.setAttribute("desc", childName);
                }
                existingNames.add(childName.toLowerCase());
            }
            this.createUniqueNames(child, existingNames);
            child = XMLParser.GetNextSibling(child);
        }
    }

    private static String generateUniqueString(String name) {
        String newSuffix;
        block3: {
            int t = name.lastIndexOf(95);
            newSuffix = "_0";
            if (t > 0) {
                String suffix = name.substring(t + 1);
                try {
                    newSuffix = Integer.toString(Integer.parseInt(suffix) + 1);
                    name = name.substring(0, t + 1);
                }
                catch (NumberFormatException e) {
                    char lastCh;
                    if (suffix.length() != 1 || ((lastCh = suffix.charAt(0)) >= 'Z' || lastCh < 'A') && (lastCh >= 'z' || lastCh < 'a')) break block3;
                    name = name.substring(0, t + 1);
                    lastCh = (char)(lastCh + '\u0001');
                    newSuffix = "" + lastCh;
                }
            }
        }
        return name + newSuffix;
    }

    private String createUniqueId(Tag parent, String name, ArrayList<String> existingNames) {
        while (parent.getChildByID(null, name) != null || existingNames != null && existingNames.contains(name.toLowerCase())) {
            name = SystemSetupEditor.generateUniqueString(name);
        }
        if (existingNames != null) {
            existingNames.add(name.toLowerCase());
        }
        return name;
    }

    public void addChangedListener(IChangedListener newChangeListener) {
        if (newChangeListener != null) {
            if (this.changeHandlers == null) {
                this.changeHandlers = new ArrayList(2);
            }
            this.changeHandlers.add(newChangeListener);
        }
    }

    public void removeChangeListener(IChangedListener oldChangeListener) {
        if (oldChangeListener != null && this.changeHandlers != null) {
            this.changeHandlers.remove(oldChangeListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean generateErrorReports() {
        ArrayList<SystemSetupReader.ErrorReport> newErrorReports = this.getErrorMessages(this.flatRootNode, this.fileName);
        if (newErrorReports != null) {
            if (this.errorReports == null) {
                this.errorReports = newErrorReports;
                return true;
            }
            if (this.errorReports.size() != newErrorReports.size()) {
                this.errorReports = newErrorReports;
                return true;
            }
            int i = this.errorReports.size();
            while (i-- > 0) {
                if (this.errorReports.get(i).compareTo(newErrorReports.get(i)) == 0) continue;
                this.errorReports = newErrorReports;
                return true;
            }
            return false;
        } else {
            if (this.errorReports == null) return false;
            this.errorReports = null;
            return true;
        }
    }

    private void fireChangedEvent(Object changedNode, boolean refreshChildren) {
        if (this.changeHandlers != null) {
            for (IChangedListener listener : this.changeHandlers) {
                listener.changedEvent(changedNode, refreshChildren);
            }
        }
    }

    private void fireExpandEvent(Object parentNode, Tag newChild) {
        if (parentNode == null) {
            parentNode = this.rootTreeElement;
        }
        if (this.changeHandlers != null && newChild != null && parentNode != null && parentNode instanceof TreeElement) {
            TreeElement newChildNode;
            Node visibleChild;
            TreeElement parentTreeNode = (TreeElement)parentNode;
            if (parentTreeNode.children == null) {
                for (IChangedListener listener : this.changeHandlers) {
                    listener.expandEvent(parentTreeNode, false);
                }
            }
            if ((visibleChild = this.findNextVisibleChild(parentTreeNode.item, newChild.getNode())) != null && (newChildNode = parentTreeNode.findElement(visibleChild)) != null) {
                for (IChangedListener listener : this.changeHandlers) {
                    listener.expandEvent(newChildNode, true);
                }
            }
        }
    }

    public synchronized SystemSetupWriter.IComponentList getListOfCpus() {
        if (this.cpus == null) {
            this.cpus = new SystemSetupWriter.ComponentList(this, "cpu");
        }
        return this.cpus;
    }

    public synchronized SystemSetupWriter.IComponentList getListOfRouters() {
        if (this.routers == null) {
            this.routers = new SystemSetupWriter.ComponentList(this, "router");
        }
        return this.routers;
    }

    private synchronized SystemSetupWriter.IComponentList getListOfSubpaths() {
        if (this.subpaths == null) {
            this.subpaths = new SubpathComponentList();
        }
        return this.subpaths;
    }

    @Override
    public synchronized SystemSetupWriter.IComponentList getListOfConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SystemSetupWriter.ComponentList(this, "configuration");
        }
        return this.configurations;
    }

    private void addSubPath(Tag flatRouter, String id, Object parentTreeNode) {
        id = this.createUniqueId(flatRouter, id, this.getComponentNames(flatRouter));
        Tag flatSubpath = new Tag(flatRouter, flatRouter.createChild("subpath", id, null));
        this.gotoNode(flatSubpath, true);
        this.fireChangedEvent(parentTreeNode, true);
        this.fireExpandEvent(parentTreeNode, flatSubpath);
    }

    public boolean canDelete(Object node) {
        return this.doDelete(node, false, true);
    }

    public void delete(Object node) {
        this.doDelete(node, true, true);
    }

    public void delete(Object node, boolean refreshNow) {
        this.doDelete(node, true, refreshNow);
    }

    private boolean doDelete(Object node, boolean doit, boolean refreshNow) {
        ArrayList<Tag> childTags = null;
        if (node != null && node instanceof TreeElement && this.flatRootNode != null) {
            Tag configurationTag;
            Node configuration;
            Node flatChild = ((TreeElement)node).item;
            Tag flatChildTag = new Tag(this.flatRootNode, flatChild);
            if (this.hideConfigurations && flatChildTag.getName() == "connection" && (configuration = flatChildTag.getParent("configuration")) != null && this.flatRootNode != null && (configurationTag = new Tag(this.flatRootNode, configuration)).countChildrenByName("connection") == 1) {
                flatChild = configuration;
                flatChildTag = configurationTag;
            }
            if ((childTags = this.findNodesOrIncludeTags(flatChildTag)) != null && childTags.size() != 0) {
                if (doit && childTags != null) {
                    int i = childTags.size();
                    while (i-- > 0) {
                        Tag childTag = childTags.get(i);
                        Node parent = childTag.getParent(null);
                        if (parent == null) continue;
                        parent.removeChild(childTag.getNode());
                    }
                    Node flatParent = flatChildTag.getParent(null);
                    if (flatParent != null) {
                        flatParent.removeChild(flatChild);
                    }
                    if (this.generateErrorReports()) {
                        if (refreshNow) {
                            this.fireChangedEvent(null, true);
                        }
                    } else if (refreshNow) {
                        this.fireChangedEvent(this.getParent(node), true);
                    }
                }
            } else {
                childTags = null;
            }
        }
        return childTags != null;
    }

    public boolean getHideConfigurations() {
        return this.hideConfigurations;
    }

    public void setHideConfigurations(boolean hide) {
        this.hideConfigurations = hide;
    }

    public ArrayList<AbstractProperty> getBasicProperties() {
        if (this.connectionDropListProperty == null) {
            this.connectionDropListProperty = new ConnectionDropListProperty();
            this.connectionDropListProperty.description = "Connection";
            this.connectionDropListProperty.toolTip = "Select a single connection from the list";
            List<SystemSetupWriter.SetupItem> simulators = null;
            boolean initialConnectionSet = false;
            boolean defaultLabelSet = false;
            if (this.defaultConnectionType != null && this.defaultConnectionType.length() > 0 && this.defaultConnectionName != null && this.defaultConnectionName.length() > 0 && (simulators = this.getListOfConnections().getFilteredListOfComponents(null, this.defaultConnectionType)) != null && simulators.size() > 0) {
                for (SystemSetupWriter.SetupItem simulator : simulators) {
                    if (!simulator.name.equals(this.defaultConnectionName)) continue;
                    this.connectionDropListProperty.initialValue = simulator.name;
                    this.connectionDropListProperty.initialConnectionType = this.defaultConnectionType;
                    initialConnectionSet = true;
                    break;
                }
            }
            if ((simulators = this.getListOfConnections().getFilteredListOfComponents(null, "MSP430")) != null && simulators.size() > 0) {
                for (SystemSetupWriter.SetupItem simulator : simulators) {
                    if (!simulator.name.endsWith("USB1")) continue;
                    if (!initialConnectionSet) {
                        this.connectionDropListProperty.initialValue = simulator.name;
                        this.connectionDropListProperty.initialConnectionType = simulator.connectionType;
                        initialConnectionSet = true;
                    }
                    this.connectionDropListProperty.defaultValue = simulator.name;
                    this.connectionDropListProperty.setDefaultLabel(simulator.name + " [Default]");
                    defaultLabelSet = true;
                    break;
                }
                if (!initialConnectionSet) {
                    this.connectionDropListProperty.initialValue = simulators.get((int)0).name;
                    this.connectionDropListProperty.initialConnectionType = simulators.get((int)0).connectionType;
                    initialConnectionSet = true;
                }
                if (!defaultLabelSet) {
                    this.connectionDropListProperty.setDefaultLabel(simulators.get((int)0).name + " [Default]");
                    this.connectionDropListProperty.defaultValue = simulators.get((int)0).name;
                    defaultLabelSet = true;
                }
            }
            if (!initialConnectionSet) {
                simulators = this.getListOfConnections().getFilteredListOfComponents(null, "TISIM");
                if (simulators == null || simulators.size() <= 0) {
                    simulators = this.getListOfConnections().getComponents();
                }
                if (simulators != null && simulators.size() > 0) {
                    this.connectionDropListProperty.initialValue = simulators.get((int)0).name;
                    this.connectionDropListProperty.initialConnectionType = simulators.get((int)0).connectionType;
                } else {
                    this.connectionDropListProperty.initialValue = "Texas Instruments Simulator";
                    this.connectionDropListProperty.initialConnectionType = "TISIM";
                }
                this.connectionDropListProperty.defaultValue = this.connectionDropListProperty.initialValue;
            }
        }
        if (this.deviceDropListProperty == null) {
            this.deviceDropListProperty = new FilteredListProperty();
            this.deviceDropListProperty.toolTip = "Select a single board or device from the list";
        }
        if (this.infoBoxProperty == null) {
            this.infoBoxProperty = new InfoBoxProperty(null, "Note: Support for more devices may be available from the update manager.");
        }
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>();
        if (this.getConnectionAndDevice(null)) {
            properties.add(this.connectionDropListProperty);
            properties.add(this.deviceDropListProperty);
            properties.add(this.infoBoxProperty);
        } else {
            properties.add(new InfoBoxProperty(null, "<p>You have a complicated system.  Please use Advanced Setup to configure your system.</p>"));
        }
        return properties;
    }

    public boolean showAdvancedPropertiesByDefault() {
        return this.getBasicProperties().get(0) instanceof InfoBoxProperty;
    }

    public String replaceComponent(Object oldComponentNode, SystemSetupWriter.SetupItem newComponent, File xmlSystemSetupFile) {
        String errMsg = null;
        if (oldComponentNode != null && oldComponentNode instanceof TreeElement) {
            Object parent = this.getParent(oldComponentNode);
            this.delete(oldComponentNode);
            errMsg = this.addComponent(parent, newComponent, null, xmlSystemSetupFile);
            this.setAllDefaultJtagProperties();
        }
        return errMsg;
    }

    private void setAllDefaultJtagProperties() {
        int nConfigurations = this.flatRootNode.countChildrenByName("configuration");
        for (int i = 0; i < nConfigurations; ++i) {
            Tag flatConfiguration = new Tag(this.flatRootNode, this.flatRootNode.getChildByName("configuration", i));
            int nConnections = flatConfiguration.countChildrenByName("connection");
            for (int j = 0; j < nConnections; ++j) {
                Tag flatConnection = new Tag(flatConfiguration, flatConfiguration.getChildByName("connection", j));
                this.setDefaultJtagProperties(flatConnection, this.gotoNode(flatConnection, true));
            }
        }
    }

    private ArrayList<Node> getFlatConnections() {
        ArrayList<Node> retVal = new ArrayList<Node>(1);
        if (this.flatRootNode != null) {
            int nConfigurations = this.flatRootNode.countChildrenByName("configuration");
            for (int i = 0; i < nConfigurations; ++i) {
                Tag flatConfiguration = new Tag(this.flatRootNode, this.flatRootNode.getChildByName("configuration", i));
                int nConnections = flatConfiguration.countChildrenByName("connection");
                for (int j = 0; j < nConnections; ++j) {
                    retVal.add(flatConfiguration.getChildByName("connection", 0));
                }
            }
        }
        return retVal;
    }

    public SystemSetupWriter.SetupItem findSetupItem(Object object, List<SystemSetupWriter.SetupItem> listOfComponents) {
        if (this.flatRootNode == null) {
            return null;
        }
        if (object instanceof Tag) {
            return this.findSetupItem((Tag)object, listOfComponents);
        }
        if (object instanceof TreeElement) {
            Tag flatNode = new Tag(this.flatRootNode, ((TreeElement)object).item);
            return this.findSetupItem(flatNode, listOfComponents);
        }
        return null;
    }

    private SystemSetupWriter.SetupItem findSetupItem(Tag device, List<SystemSetupWriter.SetupItem> listOfComponents) {
        block4: {
            block3: {
                String relIncludeFilename;
                ArrayList<Tag> deviceTags = this.findNodesOrIncludeTags(device);
                if (deviceTags == null || deviceTags.size() <= 0) break block3;
                Tag instanceTag = deviceTags.get(0);
                if (instanceTag.getName().compareTo("instance") != 0 || (relIncludeFilename = instanceTag.getAttribute("href")) == null || relIncludeFilename.length() <= 0) break block4;
                File absIncludeFile = HardwareDatabaseReader.convertToAbsPath(new File(relIncludeFilename), new File(this.fileName).getParent(), this.getRootDirectories());
                String absIncludeFilename = absIncludeFile.getPath();
                int i = listOfComponents.size();
                while (i-- > 0) {
                    SystemSetupWriter.SetupItem item = listOfComponents.get(i);
                    if (item.fileName.compareToIgnoreCase(absIncludeFilename) != 0) continue;
                    return item;
                }
                break block4;
            }
            String connectionName = this.getConnectionName(this.rootNode, this.fileName);
            if (connectionName != null) {
                int i = listOfComponents.size();
                while (i-- > 0) {
                    SystemSetupWriter.SetupItem item = listOfComponents.get(i);
                    if (item.name.compareToIgnoreCase(connectionName) != 0) continue;
                    return item;
                }
            }
        }
        return null;
    }

    private boolean getConnectionAndDevice(String isaFilter) {
        boolean simpleSetup = false;
        String connectionType = null;
        String connectionName = null;
        Tag flatConnection = null;
        Tag flatDevice = null;
        ArrayList<Node> flatConnectionNodes = this.getFlatConnections();
        if (flatConnectionNodes != null && flatConnectionNodes.size() == 1 && this.flatRootNode != null) {
            flatConnection = new Tag(this.flatRootNode, flatConnectionNodes.get(0));
            connectionType = flatConnection.getChildAttribute("connectionType", "Type");
            connectionName = this.getConnectionName(this.rootNode, this.fileName);
            if (this.rootNode != null && this.rootNode.countChildrenByName("instance") == 1) {
                simpleSetup = true;
                flatDevice = new Tag(this.flatRootNode, this.flatRootNode.getChildByName("configuration", 0));
            } else if (this.rootNode != null && this.rootNode.countChildrenByName("include") == 1) {
                simpleSetup = true;
                flatDevice = new Tag(this.flatRootNode, this.flatRootNode.getChildByName("configuration", 0));
            } else {
                Node[] children = this.getChildNodes(flatConnectionNodes.get(0));
                if (children != null && children.length == 1) {
                    Node deviceNode = children[0];
                    String tag = XMLParser.GetName(deviceNode);
                    if (connectionType.compareTo("TISIM") == 0) {
                        if (tag.compareTo("device") == 0 || tag.compareTo("cpu") == 0) {
                            simpleSetup = true;
                            flatDevice = new Tag(this.flatRootNode, children[0]);
                        }
                    } else if (tag.compareTo("device") == 0 || tag.compareTo("board") == 0) {
                        simpleSetup = true;
                        flatDevice = new Tag(this.flatRootNode, children[0]);
                    }
                } else if (children == null || children.length == 0) {
                    simpleSetup = true;
                }
            }
        } else if (flatConnectionNodes == null || flatConnectionNodes.size() == 0) {
            simpleSetup = true;
        }
        if (simpleSetup) {
            List<SystemSetupWriter.SetupItem> connections = this.getListOfConnections().getFilteredListOfComponents(isaFilter, null);
            this.connectionDropListProperty.id = new ComponentPropertyDescriptor(this.flatRootNode, flatConnection, connections, this.connectionDropListProperty.initialValue);
            this.connectionDropListProperty.choices = new String[connections.size()];
            int i = connections.size();
            while (i-- > 0) {
                this.connectionDropListProperty.choices[i] = connections.get(i).toString();
                if (!this.connectionDropListProperty.choices[i].equals(this.connectionDropListProperty.getDefaultChoiceValue())) continue;
                this.connectionDropListProperty.choices[i] = this.connectionDropListProperty.getDefaultChoiceLabel();
            }
            ArrayList<SystemSetupWriter.SetupItem> boardsAndDevices = this.getBoardsAndDevices(isaFilter, connectionType != null ? connectionType : this.connectionDropListProperty.initialConnectionType, connectionName != null ? connectionName : this.connectionDropListProperty.initialValue);
            this.deviceDropListProperty.id = new ComponentPropertyDescriptor(flatConnection, flatDevice, boardsAndDevices);
            this.deviceDropListProperty.elements = new SystemSetupWriter.SetupItem[boardsAndDevices.size()];
            int i2 = boardsAndDevices.size();
            while (i2-- > 0) {
                this.deviceDropListProperty.elements[i2] = boardsAndDevices.get(i2);
            }
        }
        return simpleSetup;
    }

    public ArrayList<SystemSetupWriter.SetupItem> getBoardsAndDevices(String isaFilter, String connectionType, String connectionName) {
        ArrayList<SystemSetupWriter.SetupItem> boardsAndDevices = new ArrayList<SystemSetupWriter.SetupItem>(30);
        if (connectionType != null && connectionType.length() > 0) {
            List<SystemSetupWriter.SetupItem> devices = this.getListOfDevices().getFilteredListOfComponents(isaFilter, connectionType);
            if (connectionType.compareTo("TISIM") == 0) {
                boardsAndDevices.addAll(devices);
                if (this.deviceDropListProperty != null) {
                    this.deviceDropListProperty.description = "Device";
                }
            } else {
                List<SystemSetupWriter.SetupItem> boards = this.getListOfBoards().getFilteredListOfComponents(isaFilter, connectionType);
                boardsAndDevices.addAll(boards);
                boardsAndDevices.addAll(devices);
                if (this.deviceDropListProperty != null) {
                    this.deviceDropListProperty.description = "Board or Device";
                }
            }
            if (connectionName != null) {
                List<SystemSetupWriter.SetupItem> configurations = this.getListOfConfigurations().getFilteredListOfComponents(isaFilter, connectionType, connectionName);
                boardsAndDevices.addAll(configurations);
            }
        }
        return boardsAndDevices;
    }

    private void regenerateSystemSetup() {
        ArrayList<Node> connectionNodes;
        String errMsg;
        SystemSetupWriter.SetupItem connection = ((ComponentPropertyDescriptor)this.connectionDropListProperty.id).getSetupItem();
        SystemSetupWriter.SetupItem device = null;
        String deviceName = null;
        if (connection != null && connection.connectionType != null) {
            device = ((ComponentPropertyDescriptor)this.deviceDropListProperty.id).getSetupItem();
        }
        if (connection != null && connection.connectionType != null && device != null) {
            ArrayList<SystemSetupWriter.SetupItem> boardsAndDevices;
            deviceName = device.toString();
            if (device.componentType == SystemSetupWriter.SetupItem.Type.CONFIGURATION) {
                String connectionName = this.getConnectionName(device.fileName);
                if (connectionName == null || connection.name == null || connection.name.compareTo(connectionName) != 0) {
                    device = null;
                }
            } else if (connection.connectionType.compareTo("TISIM") == 0) {
                if (device.componentType == SystemSetupWriter.SetupItem.Type.EMU_DEVICE || device.componentType == SystemSetupWriter.SetupItem.Type.BOARD) {
                    device = null;
                }
            } else if (device.componentType == SystemSetupWriter.SetupItem.Type.SIM_DEVICE || device.componentType == SystemSetupWriter.SetupItem.Type.CPU) {
                device = null;
            }
            if (device == null && deviceName != null && deviceName.length() > 0 && (boardsAndDevices = this.getBoardsAndDevices(null, connection.connectionType, this.getConnectionName(connection.fileName))) != null) {
                int nChoices = boardsAndDevices.size();
                for (int i = 0; i < nChoices; ++i) {
                    SystemSetupWriter.SetupItem item = boardsAndDevices.get(i);
                    if (deviceName.compareTo(item.toString()) != 0) continue;
                    device = item;
                    break;
                }
            }
        }
        this.createFlatRootNode();
        Object[] connections = this.getChildren(this.getRoot());
        if (connections != null && connections.length > 0) {
            this.delete(connections[0], false);
        }
        if (device != null && device.componentType == SystemSetupWriter.SetupItem.Type.CONFIGURATION) {
            this.addComponent(null, device, null, new File(this.fileName));
        } else if (connection != null && (errMsg = this.addComponent(null, connection, null, new File(this.fileName))) == null && (connectionNodes = this.getFlatConnections()) != null && connectionNodes.size() > 0 && device != null && this.rootTreeElement != null && (errMsg = this.addComponent(connectionNodes.get(0), device, null, new File(this.fileName))) == null) {
            this.setAllDefaultJtagProperties();
        }
    }

    private void createFlatRootNode() {
        if (this.flatRootNode == null) {
            System.out.println("SystemSetupEditor.regenerateSystemSetup()");
            XMLParser xmlParser = new XMLParser();
            Node root = xmlParser.CreateNewDocument("configurations");
            xmlParser.SetAttribute(root, "XML_version", "1.2");
            xmlParser.SetAttribute(root, "id", "configurations_0");
            this.flatRootNode = new Tag(xmlParser, root);
            XMLParser xmlParser1 = new XMLParser();
            Node root1 = xmlParser1.CreateNewDocument("configurations");
            xmlParser1.SetAttribute(root1, "XML_version", "1.2");
            xmlParser1.SetAttribute(root1, "id", "configurations_0");
            this.rootNode = new Tag(xmlParser1, root1);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 1) {
            System.out.println("Usage: SystemSetupEditor systemSetupDir hwDataBaseDir");
        } else {
            long startTime = System.currentTimeMillis();
            File hwDataBaseDir = new File(args[1]);
            System.out.println("Hardware database root directory = " + hwDataBaseDir.getPath());
            SystemSetupEditor setup = new SystemSetupEditor();
            setup.setInstallDirectory(args.length == 2 ? args[1] : null);
            setup.setUserDirectory(args[0]);
            setup.loadHardwareDatabaseCache();
            long loadTime = System.currentTimeMillis();
            List<SystemSetupWriter.SetupItem> configurations = setup.getListOfConfigurations().getComponents();
            if (configurations.size() == 0) {
                System.out.println("No Configurations Found");
            } else {
                System.out.println("Available Configurations");
                for (int i = 0; i < configurations.size(); ++i) {
                    System.out.println("\t" + configurations.get(i).toString());
                }
            }
            List<SystemSetupWriter.SetupItem> connections = setup.getListOfConnections().getComponents();
            if (connections.size() == 0) {
                System.out.println("No Connections Found");
            } else {
                System.out.println("Available Connections");
                for (int i = 0; i < connections.size(); ++i) {
                    System.out.println("\t" + connections.get(i).toString());
                }
            }
            List<SystemSetupWriter.SetupItem> devices = setup.getListOfDevices().getComponents();
            if (connections.size() == 0) {
                System.out.println("No Devices Found");
            } else {
                System.out.println("Available Devices");
                for (int i = 0; i < devices.size(); ++i) {
                    System.out.println("\t" + devices.get(i).toString());
                }
            }
            long endTime = System.currentTimeMillis();
            System.out.format("\nElapsed Time = %d milliseconds", endTime - startTime);
            System.out.format(" (load time = %d milliseconds)\n", loadTime - startTime);
            setup.storeHardwareDatabaseCache();
        }
    }

    private class ComponentPropertyDescriptor
    extends APropertyDescriptor {
        private String curComponentName;
        private Tag existingComponent;
        private List<SystemSetupWriter.SetupItem> listOfComponents;

        public ComponentPropertyDescriptor(Tag parent, Tag existingComponent, List<SystemSetupWriter.SetupItem> components) {
            this(parent, existingComponent, components, "");
        }

        public ComponentPropertyDescriptor(Tag parent, Tag existingComponent, List<SystemSetupWriter.SetupItem> components, String defaultComponentName) {
            this.curComponentName = null;
            this.listOfComponents = components;
            this.existingComponent = existingComponent;
            this.getProperty();
            if (this.curComponentName == null || this.curComponentName.length() == 0) {
                this.curComponentName = defaultComponentName;
            }
        }

        @Override
        public Tag setProperty(Object value) {
            String newComponentName = value.toString();
            if (newComponentName.compareTo(this.curComponentName) != 0) {
                this.curComponentName = newComponentName;
                SystemSetupEditor.this.regenerateSystemSetup();
            }
            return null;
        }

        public SystemSetupWriter.SetupItem getSetupItem() {
            int i = this.listOfComponents.size();
            while (i-- > 0) {
                SystemSetupWriter.SetupItem item = this.listOfComponents.get(i);
                if (this.curComponentName.compareTo(item.toString()) != 0) continue;
                return item;
            }
            return null;
        }

        @Override
        public Object getProperty() {
            SystemSetupWriter.SetupItem component;
            if (this.existingComponent != null && (component = SystemSetupEditor.this.findSetupItem(this.existingComponent, (List<SystemSetupWriter.SetupItem>)this.listOfComponents)) != null) {
                this.curComponentName = component.toString();
            }
            return this.curComponentName == null ? "" : this.curComponentName;
        }

        @Override
        public String getValueAttributeName() {
            return null;
        }

        @Override
        public boolean isFilePathProperty() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return this.listOfComponents == null || this.listOfComponents.size() == 0;
        }
    }

    private static class SimulationPropertyDescriptor
    extends PropertyDescriptor {
        private Tag driverProperty;

        SimulationPropertyDescriptor(Tag driverProperty, Tag defaultPropertyValue, Tag overriddenProperty, Tag overrideParent) {
            super(defaultPropertyValue, overriddenProperty, overrideParent, null);
            this.simulationProperty = true;
            this.driverProperty = driverProperty;
        }

        String getBoardName() {
            Node defaults;
            if (this.driverProperty != null && (defaults = this.defaultProperty.getParent(null)) != null) {
                return SimulationPropertyDescriptor.getBoardName(new Tag(this.defaultProperty, defaults), this.overrideParent, this.driverProperty);
            }
            return null;
        }

        private static String getBoardName(Tag defaults, Tag overrides, Tag property) {
            String type = property.getAttribute("type");
            if (type.compareTo("string_list") == 0) {
                Node currentChoice;
                String name = property.getAttribute("id");
                Node overriddenProperty = null;
                if (overrides != null) {
                    overriddenProperty = overrides.getChildByID("property", name);
                }
                String value = null;
                if (overriddenProperty != null) {
                    value = XMLParser.GetAttributeString(overriddenProperty, "Value");
                } else {
                    Node defaultProperty = defaults.getChildByID("cchoice", name, "key");
                    if (defaultProperty != null) {
                        value = XMLParser.GetAttributeString(defaultProperty, "value");
                    }
                }
                if (value != null && value.length() > 0 && (currentChoice = property.getChildByID("choice", value, "value")) != null) {
                    Tag choice = new Tag(property, currentChoice);
                    int nInferences = choice.countChildrenByName("inference");
                    for (int i = 0; i < nInferences; ++i) {
                        String var;
                        Node inference = choice.getChildByName("inference", i);
                        String key = XMLParser.GetAttributeString(inference, "key");
                        if (key == null || key.compareTo("FixedEntry") != 0 || (var = XMLParser.GetAttributeString(inference, "value")) == null || var.compareTo("BOARDNAME") != 0) continue;
                        return XMLParser.GetAttributeString(inference, "value2");
                    }
                    int nProperties = choice.countChildrenByName("choicelist");
                    for (int i = 0; i < nProperties; ++i) {
                        Tag subProperty = new Tag(choice, choice.getChildByName("choicelist", i));
                        String boardName = SimulationPropertyDescriptor.getBoardName(defaults, overrides, subProperty);
                        if (boardName == null || boardName.length() <= 0) continue;
                        return boardName;
                    }
                }
            }
            return null;
        }

        static /* synthetic */ String access$1100(Tag x0, Tag x1, Tag x2) {
            return SimulationPropertyDescriptor.getBoardName(x0, x1, x2);
        }

        static /* synthetic */ Tag access$1200(SimulationPropertyDescriptor x0) {
            return x0.driverProperty;
        }
    }

    private static class PropertyDescriptor
    extends APropertyDescriptor {
        protected Tag defaultProperty;
        private Tag overriddenProperty;
        protected Tag overrideParent;
        private PropertyDescriptor parentProperty;
        protected boolean simulationProperty;

        PropertyDescriptor(Tag defaultProperty, Tag overriddenProperty, Tag overrideParent, PropertyDescriptor parentProperty) {
            this.defaultProperty = defaultProperty;
            this.overriddenProperty = overriddenProperty;
            this.overrideParent = overrideParent;
            this.parentProperty = parentProperty;
        }

        private Tag createDefaultProperty() {
            if (this.overriddenProperty == null) {
                if (this.overrideParent == null) {
                    this.overrideParent = this.parentProperty.createDefaultProperty();
                    Node defaultParentNode = this.defaultProperty.getParent(null);
                    this.overrideParent = new Tag(this.overrideParent, this.overrideParent.createChild("choice", null, null));
                    this.overrideParent.setAttribute("value", XMLParser.GetAttributeString(defaultParentNode, "value"));
                    String name = XMLParser.GetAttributeString(defaultParentNode, "Name");
                    if (name != null && name.length() > 0) {
                        this.overrideParent.setAttribute("Name", name);
                    }
                }
                this.overriddenProperty = new Tag(this.overrideParent, this.overrideParent.createChild("property", null, null));
                this.overriddenProperty.setAttribute("id", this.defaultProperty.getAttribute(this.simulationProperty ? "key" : "id"));
                if (!this.simulationProperty) {
                    this.overriddenProperty.setAttribute("ID", this.defaultProperty.getAttribute("ID"));
                    this.overriddenProperty.setAttribute("Value", this.defaultProperty.getAttribute("Value"));
                }
                String type = this.simulationProperty ? "stringfield" : this.defaultProperty.getAttribute("Type");
                this.overriddenProperty.setAttribute("Type", type);
            }
            return this.overriddenProperty;
        }

        @Override
        public Tag setProperty(Object value) {
            this.createDefaultProperty();
            String valueToWrite = null;
            String type = this.defaultProperty.getAttribute("Type");
            if (type.compareTo("choicelist") == 0 && !this.simulationProperty) {
                valueToWrite = "0";
                int i = this.defaultProperty.countChildrenByName("choice");
                while (i-- > 0) {
                    Node choice = this.defaultProperty.getChildByName("choice", i);
                    String val = XMLParser.GetAttributeString(choice, "Name");
                    if (val == null || val.length() == 0) {
                        val = XMLParser.GetAttributeString(choice, "value");
                    }
                    if (val == null || val.compareTo(value.toString()) != 0) continue;
                    valueToWrite = Integer.toString(i);
                    break;
                }
            }
            if (valueToWrite == null) {
                valueToWrite = value.toString();
            }
            this.overriddenProperty.setAttribute("Value", valueToWrite);
            return this.overriddenProperty;
        }

        @Override
        public Object getProperty() {
            String value = null;
            value = this.overriddenProperty != null ? this.overriddenProperty.getAttribute("Value") : this.defaultProperty.getAttribute(this.simulationProperty ? "value" : "Value");
            if (!this.simulationProperty && this.defaultProperty.getAttribute("Type").compareTo("choicelist") == 0) {
                Node choice;
                int index;
                try {
                    index = value.startsWith("0x") ? Integer.parseInt(value.substring(2), 16) : Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    index = 0;
                }
                if (index < 0 || index >= this.defaultProperty.countChildrenByName("choice")) {
                    index = 0;
                }
                if ((value = XMLParser.GetAttributeString(choice = this.defaultProperty.getChildByName("choice", index), "Name")) == null || value.length() == 0) {
                    value = XMLParser.GetAttributeString(choice, "value");
                }
            }
            return value;
        }

        @Override
        public String getValueAttributeName() {
            return "Value";
        }

        private static boolean isDuplicateProperty(Node override, ArrayList<AbstractProperty> properties) {
            if (override == null) {
                return false;
            }
            for (int i = 0; i < properties.size(); ++i) {
                Tag overrideProperty;
                Object id = properties.get((int)i).id;
                if (!(id instanceof PropertyDescriptor) || (overrideProperty = ((PropertyDescriptor)id).overriddenProperty) == null || overrideProperty.getNode() != override) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isFilePathProperty() {
            String type = this.defaultProperty.getAttribute("Type");
            return type.compareTo("filepathfield") == 0 || type.compareTo("FILE_PATH_EXTN") == 0;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    private static class BypassBitsPropertyDescriptor
    extends APropertyDescriptor {
        private Tag node;
        private Tag root;

        BypassBitsPropertyDescriptor(Tag node, Tag rootNode) {
            this.node = node;
            this.root = rootNode;
        }

        @Override
        public Object getProperty() {
            return Integer.toString(SystemSetupEditor.getBypassBits(this.node));
        }

        @Override
        public Tag setProperty(Object value) {
            String bypassBits = value.toString();
            SystemSetupEditor.setBypassBits(this.node, this.root, bypassBits.startsWith("0x") ? Integer.parseInt(bypassBits.substring(2), 16) : Integer.parseInt(bypassBits));
            return this.node;
        }

        @Override
        public String getValueAttributeName() {
            return "isa";
        }

        @Override
        public boolean isFilePathProperty() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    private static abstract class APropertyDescriptor
    implements IPropertyDescriptor {
        private boolean fireEvent = false;

        private APropertyDescriptor() {
        }

        @Override
        public boolean hasSubProperties() {
            return this.fireEvent;
        }

        @Override
        public void setHasSubProperties(boolean hasSubProperties) {
            this.fireEvent = hasSubProperties;
        }
    }

    private static interface IPropertyDescriptor {
        public Tag setProperty(Object var1);

        public Object getProperty();

        public String getValueAttributeName();

        public boolean hasSubProperties();

        public void setHasSubProperties(boolean var1);

        public boolean isFilePathProperty();

        public boolean isReadOnly();
    }

    public static class SelectAndBrowseProperty
    extends DropListProperty {
        public String[] extensions;

        SelectAndBrowseProperty(IPropertyDescriptor propStruct, String name, String[] choices, String[] extensions) {
            super(null, propStruct, name, 0);
            this.choices = choices;
            this.extensions = extensions;
        }
    }

    public static class InfoBoxProperty
    extends AbstractProperty {
        public String infoText;
        public String imageFileName;

        public InfoBoxProperty(String title, String content) {
            this(title, content, null);
        }

        public InfoBoxProperty(String title, String content, String image) {
            this.description = title;
            this.infoText = content;
            this.imageFileName = image;
        }
    }

    public static class NumberProperty
    extends AbstractProperty {
        public long upperbound;
        public long lowerbound;
    }

    public static class FileProperty
    extends AbstractProperty {
        public String[] extensions;
        public String[] extensionNames;

        private void setExtensions(String extensionAttribute) {
            String[] exts;
            if (extensionAttribute != null && extensionAttribute.length() > 0 && (exts = extensionAttribute.split("[,;|]")) != null && exts.length > 0) {
                int nExts = exts.length / 2;
                if (nExts == 0) {
                    this.extensions = new String[1];
                    this.extensions[0] = exts[0];
                } else {
                    this.extensionNames = new String[nExts];
                    this.extensions = new String[nExts];
                    for (int j = 0; j < nExts; ++j) {
                        this.extensionNames[j] = exts[2 * j];
                        this.extensions[j] = exts[2 * j + 1];
                    }
                }
            }
        }
    }

    public static class FilteredListProperty
    extends DropListProperty {
        public String filter;
        public Object[] elements;

        private FilteredListProperty() {
        }

        private FilteredListProperty(Tag property, IPropertyDescriptor propStruct, String name, int nChoices) {
            super(property, propStruct, name, nChoices);
        }
    }

    public static class DropListProperty
    extends AbstractProperty {
        public String[] choices;

        private DropListProperty() {
        }

        private DropListProperty(Tag property, IPropertyDescriptor propStruct, String name, int nChoices) {
            boolean hasSubProperties = false;
            this.id = propStruct;
            this.description = name;
            if (nChoices > 0) {
                this.choices = new String[nChoices];
            }
            for (int j = 0; j < nChoices; ++j) {
                Tag choice = new Tag(property, property.getChildByName("choice", j));
                String value = choice.getAttribute("Name");
                if (value == null || value.length() == 0) {
                    value = choice.getAttribute("value");
                }
                this.choices[j] = value;
                for (Node child = choice.getFirstChild(); child != null && !hasSubProperties; child = child.getNextSibling()) {
                    String key;
                    String tag = XMLParser.GetName(child);
                    if (tag.compareTo("property") == 0 || tag.compareTo("choicelist") == 0) {
                        hasSubProperties = true;
                        continue;
                    }
                    if (tag.compareTo("inference") != 0 || (key = XMLParser.GetAttributeString(child, "key")).compareTo("advice") != 0 && key.compareTo("summary") != 0) continue;
                    hasSubProperties = true;
                }
            }
            if (nChoices > 0) {
                this.initialValue = this.choices[0];
            }
            propStruct.setHasSubProperties(hasSubProperties);
        }

        public String getDefaultChoiceLabel() {
            return this.getDefaultChoiceValue();
        }

        public String getDefaultChoiceValue() {
            return this.initialValue;
        }
    }

    public static class ConnectionDropListProperty
    extends DropListProperty {
        public String initialConnectionType;
        protected String defaultValueLabel;
        protected String defaultValue;

        public void setDefaultLabel(String label) {
            this.defaultValueLabel = label;
        }

        @Override
        public String getDefaultChoiceLabel() {
            if (this.defaultValueLabel == null) {
                return super.getDefaultChoiceLabel();
            }
            return this.defaultValueLabel;
        }

        @Override
        public String getDefaultChoiceValue() {
            return this.defaultValue;
        }
    }

    public static class TextProperty
    extends AbstractProperty {
    }

    public static abstract class AbstractProperty {
        public static final int TEXT_PROPERTY = 0;
        public static final int NUMBER_PROPERTY = 1;
        public static final int DROPLIST_PROPERTY = 2;
        public static final int CHECKBOX_PROPERTY = 3;
        public static final int DISPLAY_PROPERTY = 4;
        public Object id;
        public String name;
        public String description;
        public String toolTip;
        public String initialValue;

        public String getName() {
            return this.name == null ? this.description : this.name;
        }
    }

    public static interface IChangedListener {
        public void changedEvent(Object var1, boolean var2);

        public void expandEvent(Object var1, boolean var2);
    }

    private class SubpathComponentList
    implements SystemSetupWriter.IComponentList {
        ArrayList<SystemSetupWriter.SetupItem> subpaths = new ArrayList(1);

        SubpathComponentList() {
            this.subpaths.add(new SubPathSetupItem());
        }

        @Override
        public SystemSetupWriter.SetupItem addToList(File file) throws HardwareDbException {
            return null;
        }

        public ArrayList<SystemSetupWriter.SetupItem> getComponents() {
            return this.subpaths;
        }

        @Override
        public SystemSetupWriter.SetupItem findComponent(String componentFileName) {
            throw new UnsupportedOperationException();
        }

        public ArrayList<SystemSetupWriter.SetupItem> getFilteredListOfComponents(String isa, String connectionType) {
            return this.subpaths;
        }

        public ArrayList<SystemSetupWriter.SetupItem> getFilteredListOfComponents(String isa, String connectionType, String connectionName) {
            return this.subpaths;
        }

        @Override
        public String getComponentName() {
            return "subpath";
        }

        public String toString() {
            return "subpath";
        }

        @Override
        public List<SystemSetupWriter.SetupItem> findComponents(IFlatSystemSetupFile setupFile) {
            return new ArrayList<SystemSetupWriter.SetupItem>(1);
        }

        private class SubPathSetupItem
        extends SystemSetupWriter.SetupItem {
            SubPathSetupItem() {
                this.name = "subpath";
            }

            @Override
            public String toString() {
                return this.name;
            }
        }
    }

    private class FilteredComponentListAllISAs
    extends FilteredComponentList {
        public FilteredComponentListAllISAs(SystemSetupWriter.IComponentList componentsToFilter, String connectionType) {
            super(componentsToFilter, connectionType);
        }

        @Override
        public List<SystemSetupWriter.SetupItem> getFilteredListOfComponents(String isa, String connectionType) {
            return super.getFilteredListOfComponents(null, connectionType);
        }
    }

    public class FilteredComponentList
    implements SystemSetupWriter.IComponentList {
        private SystemSetupWriter.IComponentList originalList;
        private String connectionTypeFilter;

        FilteredComponentList(SystemSetupWriter.IComponentList componentsToFilter, String connectionType) {
            this.originalList = componentsToFilter;
            this.connectionTypeFilter = connectionType;
        }

        @Override
        public SystemSetupWriter.SetupItem addToList(File file) throws HardwareDbException {
            return this.originalList.addToList(file);
        }

        @Override
        public List<SystemSetupWriter.SetupItem> getComponents() {
            return this.getFilteredListOfComponents(null, this.connectionTypeFilter);
        }

        @Override
        public SystemSetupWriter.SetupItem findComponent(String componentFileName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SystemSetupWriter.SetupItem> getFilteredListOfComponents(String isa, String connectionType, String connectionName) {
            return this.getFilteredListOfComponents(isa, connectionType);
        }

        @Override
        public List<SystemSetupWriter.SetupItem> getFilteredListOfComponents(String isa, String connectionType) {
            return this.originalList.getFilteredListOfComponents(isa, this.connectionTypeFilter);
        }

        @Override
        public String getComponentName() {
            return this.originalList.getComponentName();
        }

        public String toString() {
            return this.originalList.toString();
        }

        @Override
        public List<SystemSetupWriter.SetupItem> findComponents(IFlatSystemSetupFile setupFile) {
            return this.originalList.findComponents(setupFile);
        }
    }

    private static class DriverSelectPropertyDescriptor
    extends APropertyDescriptor {
        private Tag driverInstance;
        private Tag flatFileInstance;

        private DriverSelectPropertyDescriptor() {
        }

        @Override
        public Object getProperty() {
            return null;
        }

        @Override
        public String getValueAttributeName() {
            return null;
        }

        @Override
        public boolean isFilePathProperty() {
            return false;
        }

        @Override
        public Tag setProperty(Object value) {
            return null;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    private static class TreeElement {
        private Node item;
        private TreeElement[] children;
        private TreeElement parent;
        String id;

        TreeElement(String id, Node item, TreeElement parent) {
            this.item = item;
            this.parent = parent;
            this.children = null;
            this.id = id == null ? "" : id;
        }

        TreeElement[] getChildren(SystemSetupEditor systemSetup, Node[] rawChildren) {
            if (rawChildren == null || rawChildren.length == 0) {
                this.children = null;
                return null;
            }
            TreeElement[] newChildren = new TreeElement[rawChildren.length];
            int nOldChildren = this.children == null ? 0 : this.children.length;
            int i = rawChildren.length;
            while (i-- > 0) {
                TreeElement newChild = null;
                String childID = XMLParser.GetAttributeString(rawChildren[i], "id");
                if (this.children != null) {
                    int j = nOldChildren;
                    while (j-- > 0) {
                        if (this.children[j].id.compareTo(childID) != 0) continue;
                        newChild = this.children[j];
                        newChild.item = rawChildren[i];
                        this.children[j] = this.children[--nOldChildren];
                        break;
                    }
                }
                if (newChild == null) {
                    newChild = new TreeElement(childID, rawChildren[i], this);
                }
                newChildren[i] = newChild;
            }
            this.children = newChildren;
            return this.children;
        }

        TreeElement getParent() {
            return this.parent;
        }

        String getErrorLocation(SystemSetupEditor systemSetup) {
            if (this.parent != null) {
                String type = XMLParser.GetName(this.item);
                if (type.compareTo("cpu") == 0 || type.compareTo("subpath") == 0 || type.compareTo("router") == 0) {
                    for (TreeElement parentConnection = this; parentConnection != null; parentConnection = parentConnection.getParent()) {
                        type = XMLParser.GetName(parentConnection.item);
                        if (type.compareTo("connection") != 0) continue;
                        StringBuilder location = new StringBuilder();
                        location.append(TreeElement.getLabel(parentConnection.item, systemSetup));
                        location.append("\\");
                        location.append(TreeElement.getLabel(this.item, systemSetup));
                        return location.toString();
                    }
                } else if (type.compareTo("connection") == 0) {
                    return TreeElement.getLabel(this.item, systemSetup);
                }
            }
            return null;
        }

        String getTextToDisplay(SystemSetupEditor systemSetup) {
            return TreeElement.getLabel(this.item, systemSetup);
        }

        private static String getLabel(Node item, SystemSetupEditor systemSetup) {
            Tag node;
            String label = "";
            if (item != null && systemSetup.flatRootNode != null && ((label = (node = new Tag(systemSetup.flatRootNode, item)).getAttribute("desc")) == null || label.length() == 0)) {
                label = node.getAttribute("id");
            }
            return label;
        }

        String getDecoratorText(SystemSetupEditor systemSetup) {
            Tag node;
            if (this.item != null && systemSetup.flatRootNode != null && (node = new Tag(systemSetup.flatRootNode, this.item)).getName().compareTo("cpu") == 0 && node.getName().compareTo("cpu") == 0 && node.getPropertyString("bypass", "0").compareTo("1") == 0) {
                return "(bypassed)";
            }
            return null;
        }

        TreeElement findElement(Node node) {
            TreeElement found = null;
            if (this.item == node) {
                return this;
            }
            if (this.children != null && this.children.length > 0) {
                int i = this.children.length;
                while (i-- > 0 && found == null) {
                    found = this.children[i].findElement(node);
                }
            }
            return found;
        }

        String getErrorMessage() {
            String tag = this.item.getNodeName();
            if (tag.compareTo("connection") == 0) {
                if (this.parent != null) {
                    int i = this.parent.children.length;
                    while (i-- > 0) {
                        TreeElement treeElement = this.parent.children[i];
                    }
                }
            } else if (tag.compareTo("cpu") == 0 || tag.compareTo("router") == 0 || tag.compareTo("subpath") == 0) {
                // empty if block
            }
            return null;
        }

        public String toString() {
            String result = null;
            if (this.item != null) {
                result = XMLParser.GetAttributeString(this.item, "desc");
            }
            if (result == null || result.length() == 0) {
                result = this.id;
            }
            return result == null ? super.toString() : result;
        }
    }
}

