/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.FlatSystemSetupFile;
import com.ti.debug.engine.scripting.setup.HardwareDatabaseReader;
import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.IFlatSystemSetupFile;
import com.ti.debug.engine.scripting.setup.ISystemSetupComponent;
import com.ti.debug.engine.scripting.setup.ProcessorID;
import com.ti.debug.engine.scripting.setup.Tag;
import com.ti.debug.engine.scripting.setup.XMLParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class SystemSetupReader {
    private static final String SchemaDir = "/../schemas";
    private String[] installDirectories = new String[1];
    private String schemaDirectory;
    private String userDirectory;
    private static CpuCache cacheOfCpus = new CpuCache();
    private IFlatSystemSetupFile cachedFlatSystemSetupFile = null;
    private String cachedFlatSystemSetupFilename = null;
    private long cachedFlatSystemSetupFileLastModified;
    private final String cpuCacheFilename = "/targetdb.cache";

    public SystemSetupReader() {
    }

    public SystemSetupReader(String installDir) {
        this.setInstallDirectory(installDir);
    }

    protected String getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public String getTargetDbDirectory() {
        return this.installDirectories[0] + "/";
    }

    public String[] getRootDirectories() {
        return this.installDirectories;
    }

    public void setInstallDirectory(String installDir) {
        this.installDirectories[0] = installDir;
        if (installDir != null) {
            File file = new File(this.installDirectories[0]);
            this.schemaDirectory = file.getParent() + SchemaDir;
            file = new File(this.schemaDirectory + "/" + "setup_parser.xsd");
            if (!file.isFile()) {
                this.schemaDirectory = this.installDirectories[0];
            }
            this.schemaDirectory = this.schemaDirectory + '/';
        } else {
            this.installDirectories[0] = null;
            this.schemaDirectory = null;
        }
    }

    public String getUserDirectory() {
        return this.userDirectory == null ? "" : this.userDirectory;
    }

    public void setUserDirectory(String userDir) {
        this.userDirectory = userDir;
        SystemSetupReader.cacheOfCpus.loadCachedCpus(userDir + "/targetdb.cache", true);
    }

    public File[] getListOfSetupXMLFiles(String directory) {
        File curDir = new File(directory);
        File[] curFiles = curDir.listFiles();
        ArrayList<File> setupFiles = new ArrayList<File>();
        for (int i = 0; i < curFiles.length; ++i) {
            if (!curFiles[i].getName().endsWith(".xml") && !curFiles[i].getName().endsWith(".ccxml")) continue;
            HardwareDatabaseReader xmlReader = new HardwareDatabaseReader();
            xmlReader.addTagsToFilter(new String[]{"configurations", "configuration"});
            try {
                Tag root = xmlReader.loadFlatConfig(curFiles[i].getAbsolutePath(), this.installDirectories, this.schemaDirectory);
                if (root == null || root.getName().compareTo("configurations") != 0) {
                    throw new HardwareDbException("XML configuration file has no configurations root node\n", 1, 1);
                }
                Node configuration = root.getChildByName("configuration", 0);
                if (configuration == null) {
                    throw new HardwareDbException("XML configuration file has no configuration\n", 1, 1);
                }
                setupFiles.add(curFiles[i]);
                continue;
            }
            catch (HardwareDbException e) {
                System.out.println("Non System Setup XML File - " + curFiles[i].getName());
                System.out.println("\t" + e.getMessage());
            }
        }
        return setupFiles.size() > 0 ? setupFiles.toArray(new File[setupFiles.size()]) : null;
    }

    public ArrayList<Cpu> getListOfCpus(String systemSetupXmlFilename, boolean includeRouters) throws HardwareDbException {
        String schemaFilename = this.getSchemaDirectory() + "setup_parser.xsd";
        ArrayList<Cpu> results = null;
        ArrayList<ISystemSetupComponent> setupElements = cacheOfCpus.getFilteredListOfSetupElements(systemSetupXmlFilename, null, this.installDirectories, schemaFilename);
        if (setupElements != null) {
            results = new ArrayList<Cpu>();
            for (ISystemSetupComponent setupElement : setupElements) {
                Cpu cpu;
                if (!(setupElement instanceof Cpu) || (cpu = (Cpu)setupElement).isSubpath() || !cpu.isDebuggable() || !includeRouters && cpu.isRouter()) continue;
                results.add(cpu);
            }
        }
        return results;
    }

    protected ArrayList<Cpu> getFilteredListOfCpus(String fileName, String connectionName) throws HardwareDbException {
        ArrayList<Cpu> results = null;
        ArrayList<ISystemSetupComponent> setupElements = cacheOfCpus.getFilteredListOfSetupElements(fileName, connectionName, this.installDirectories, null);
        if (setupElements != null) {
            results = new ArrayList<Cpu>();
            for (ISystemSetupComponent setupElement : setupElements) {
                Cpu cpu;
                if (!(setupElement instanceof Cpu) || (cpu = (Cpu)setupElement).isSubpath()) continue;
                results.add(cpu);
            }
        }
        return results;
    }

    protected HardwareDbFileInfo getHardwareDbFileInfo(String fileName) throws HardwareDbException {
        return SystemSetupReader.cacheOfCpus.getListOfCpus(fileName, null);
    }

    protected String getConnectionName(String fileName) {
        return cacheOfCpus.getConnectionName(fileName, this.installDirectories);
    }

    protected String getConnectionName(Tag rootNode, String fileName) {
        if (rootNode != null) {
            File file;
            Tag instance = null;
            if (rootNode.countChildrenByName("instance") > 0) {
                instance = new Tag(rootNode, rootNode.getChildByName("instance", 0));
            } else if (rootNode.countChildrenByName("instance") > 0) {
                instance = new Tag(rootNode, rootNode.getChildByName("instance", 0));
            } else if (rootNode.countChildrenByName("configuration") > 0) {
                Tag configuration = new Tag(rootNode, rootNode.getChildByName("configuration", 0));
                if (configuration.countChildrenByName("instance") > 0) {
                    instance = new Tag(configuration, configuration.getChildByName("instance", 0));
                } else if (configuration.countChildrenByName("include") > 0) {
                    instance = new Tag(configuration, configuration.getChildByName("instance", 0));
                }
            }
            if (instance != null && (file = instance.getAttributeFile("href", new File(fileName).getPath(), this.installDirectories)) != null) {
                return this.getConnectionName(file.getPath());
            }
        }
        return null;
    }

    public ArrayList<ErrorReport> getErrorMessages(String systemSetupXmlFilename) throws HardwareDbException {
        String schemaFilename = this.getSchemaDirectory() + "setup_parser.xsd";
        CpuCache.CpuCacheItem cpuCacheItem = SystemSetupReader.cacheOfCpus.getListOfCpus(systemSetupXmlFilename, schemaFilename);
        return this.getErrorMessages(cpuCacheItem, systemSetupXmlFilename);
    }

    protected ArrayList<ErrorReport> getErrorMessages(Tag flatRootNode, String fileName) {
        try {
            CpuCache.CpuCacheItem cpuCacheItem = null;
            if (flatRootNode != null) {
                cpuCacheItem = new CpuCache.CpuCacheItem(flatRootNode);
                CpuCache.addToListOfCpuOperations(flatRootNode, null, cpuCacheItem, true, null);
            }
            return this.getErrorMessages(cpuCacheItem, fileName);
        }
        catch (HardwareDbException e) {
            ArrayList<ErrorReport> errors = new ArrayList<ErrorReport>(1);
            errors.add(new ErrorReport(e.getLocalizedMessage(), null));
            return errors;
        }
    }

    private ArrayList<ErrorReport> getErrorMessages(CpuCache.CpuCacheItem cpuCacheItem, String fileName) throws HardwareDbException {
        ArrayList<String> connectionNames = new ArrayList<String>();
        ArrayList<String> cpuNames = new ArrayList<String>();
        ArrayList<String> subpathNames = new ArrayList<String>();
        ArrayList<ErrorReport> errorMessages = new ArrayList<ErrorReport>();
        int debuggableCpuCount = 0;
        Cpu lastMultiBoardCapableCpu = null;
        Cpu lastMultiProcessorCapableCpu = null;
        if (cpuCacheItem != null) {
            ArrayList<ISystemSetupComponent> setupElements = cpuCacheItem.getSetupElements(null, fileName, this.installDirectories);
            if (setupElements != null) {
                for (ISystemSetupComponent setupElement : setupElements) {
                    Connection connection;
                    String connectionName;
                    if (!(setupElement instanceof Connection) || (connectionName = (connection = (Connection)setupElement).toString()) == null || connectionName.length() <= 0) continue;
                    if (connectionNames.contains(connectionName = connectionName.toLowerCase())) {
                        errorMessages.add(new ErrorReport("More that one connection is named " + connectionName, connectionName));
                        continue;
                    }
                    connectionNames.add(connectionName);
                }
            }
            if (setupElements != null) {
                String driverLocation = null;
                boolean capableMultiProcessor = true;
                boolean capableMultiBoard = true;
                for (ISystemSetupComponent setupElement : setupElements) {
                    if (!(setupElement instanceof Cpu)) continue;
                    driverLocation = ((Cpu)setupElement).getDriverLocation();
                    if (driverLocation != null) break;
                    driverLocation = "";
                    break;
                }
                int i = setupElements.size();
                while (i-- > 0) {
                    ISystemSetupComponent setupElement;
                    setupElement = setupElements.get(i);
                    if (!(setupElement instanceof Cpu)) continue;
                    Cpu cpu = (Cpu)setupElement;
                    String name = cpu.getName();
                    if (name.length() > 16) {
                        errorMessages.add(new ErrorReport("Name is too long.  Cpu, router, and subpath names must be 16 characters or less.", cpu.toString()));
                    } else if (!Character.isLetter(name.charAt(0))) {
                        errorMessages.add(new ErrorReport("Name has invalid characters.  Cpu, router, and subpath names must begin with an alphabetic letter", cpu.toString()));
                    } else {
                        for (int j = name.length() - 1; j > 0; --j) {
                            char ch = name.charAt(j);
                            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '+') continue;
                            errorMessages.add(new ErrorReport("Name has invalid characters.  Cpu, router, and subpath names must contain only alpanumeric and underscore characters.", cpu.toString()));
                            break;
                        }
                    }
                    name = cpu.toString().toLowerCase();
                    if (cpu.isSubpath()) {
                        if (subpathNames.contains(name)) {
                            errorMessages.add(new ErrorReport("More than one subpath is named " + cpu.getName(), cpu.toString()));
                            continue;
                        }
                        subpathNames.add(name);
                        continue;
                    }
                    if (cpuNames.contains(name)) {
                        errorMessages.add(new ErrorReport("More than one cpu is named " + cpu.getName(), cpu.toString()));
                    } else {
                        cpuNames.add(name);
                    }
                    if (cpu.isMissingDriver()) {
                        errorMessages.add(new ErrorReport("Cannot find a driver for Cpu " + cpu.getName(), cpu.toString()));
                        ++debuggableCpuCount;
                        continue;
                    }
                    if (!cpu.isDebuggable() || cpu.isRouter()) continue;
                    ++debuggableCpuCount;
                    if (capableMultiProcessor) {
                        capableMultiProcessor = capableMultiProcessor && cpu.isMultiProcessor();
                        lastMultiProcessorCapableCpu = cpu;
                    }
                    if (!capableMultiBoard) continue;
                    capableMultiBoard = capableMultiBoard && cpu.isMultiBoard(driverLocation);
                    lastMultiBoardCapableCpu = cpu;
                }
                if (!capableMultiBoard) {
                    errorMessages.add(new ErrorReport("One or more drivers does not support hetrogeneous multiprocessing.\nPlease bypass one or more processors.", lastMultiBoardCapableCpu.toString()));
                } else if (!capableMultiProcessor && debuggableCpuCount > 1) {
                    errorMessages.add(new ErrorReport("One or more drivers does not support multiple processors.\nPlease bypass all but one processor.", lastMultiProcessorCapableCpu.toString()));
                }
            }
        }
        if (debuggableCpuCount == 0) {
            errorMessages.add(new ErrorReport("There are no debuggable cpus", null));
        }
        if (errorMessages.size() == 0) {
            return null;
        }
        return errorMessages;
    }

    public synchronized IFlatSystemSetupFile openFlatSystemSetupFile(String ccxmlFilename) throws HardwareDbException {
        long lastModified = new File(ccxmlFilename).lastModified();
        if (this.cachedFlatSystemSetupFile != null && (ccxmlFilename.compareTo(this.cachedFlatSystemSetupFilename) != 0 || lastModified != this.cachedFlatSystemSetupFileLastModified)) {
            this.cachedFlatSystemSetupFile = null;
        }
        if (this.cachedFlatSystemSetupFile == null) {
            this.cachedFlatSystemSetupFilename = ccxmlFilename;
            this.cachedFlatSystemSetupFileLastModified = lastModified;
            CpuCache.CpuCacheItem cachedFile = SystemSetupReader.cacheOfCpus.getListOfCpus(ccxmlFilename, null);
            if (cachedFile != null) {
                this.cachedFlatSystemSetupFile = new FlatSystemSetupFile(cachedFile, cachedFile.getSetupElements(null, ccxmlFilename, this.installDirectories), ccxmlFilename, this.installDirectories);
            }
        }
        return this.cachedFlatSystemSetupFile;
    }

    private static Node findNode(Tag flatParent, CpuIdentifier id) {
        if (id.parent != null) {
            Node flatParentNode = SystemSetupReader.findNode(flatParent, id.parent);
            if (flatParentNode == null) {
                return null;
            }
            flatParent = new Tag(flatParent, flatParentNode);
        }
        return flatParent.getChildByID(null, id.id);
    }

    protected static Node findNode(Tag flatRoot, Cpu forCpu) {
        return SystemSetupReader.findNode(flatRoot, forCpu.id);
    }

    public Map<String, String> getDeviceProperties(String ccxmlFilename, Cpu cpuFilter) {
        try {
            IFlatSystemSetupFile flatFile = this.openFlatSystemSetupFile(ccxmlFilename);
            if (flatFile != null) {
                return flatFile.getDeviceProperties(cpuFilter);
            }
        }
        catch (HardwareDbException hardwareDbException) {
            // empty catch block
        }
        return Collections.unmodifiableMap(new HashMap());
    }

    public ISystemSetupFileStamp getSystemSetupFileStamp(String ccxmlFilename) {
        String schemaFilename = this.getSchemaDirectory() + "setup_parser.xsd";
        return cacheOfCpus.getSystemSetupFileStamp(ccxmlFilename, this.installDirectories, schemaFilename);
    }

    public void storeHardwareDatabaseCache() {
        SystemSetupReader.cacheOfCpus.storeCachedCpus(this.userDirectory + "/targetdb.cache");
    }

    public void loadHardwareDatabaseCache() {
        SystemSetupReader.cacheOfCpus.loadCachedCpus(this.userDirectory + "/targetdb.cache", true);
    }

    public static void printCachedFileDetails(String cpuCacheFilename, String filter) {
        SystemSetupReader.cacheOfCpus.loadCachedCpus(cpuCacheFilename, false);
        cacheOfCpus.printCachedCpus(filter);
    }

    public ISystemSetupComponent getSystemSetupRootComponent(String ccxmlFilename) throws HardwareDbException {
        String schemaFilename = this.getSchemaDirectory() + "setup_parser.xsd";
        CpuCache.CpuCacheItem cpuList = SystemSetupReader.cacheOfCpus.getListOfCpus(ccxmlFilename, schemaFilename);
        ArrayList<ISystemSetupComponent> setupElements = cpuList.getSetupElements(null, ccxmlFilename, this.installDirectories);
        SystemRoot root = new SystemRoot();
        for (int i = 0; i < setupElements.size(); ++i) {
            AbstractSystemSetupComponent element = (AbstractSystemSetupComponent)setupElements.get(i);
            AbstractSystemSetupComponent parent = element.findParent(setupElements);
            if (parent == null) {
                root.addChild(element);
                continue;
            }
            parent.addChild(element);
        }
        return root;
    }

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 2) {
            System.out.println("Usage: SystemSetupReader targetdb.cache filterString");
        } else {
            SystemSetupReader.printCachedFileDetails(args[0], args.length == 2 ? args[1] : null);
        }
    }

    private static class CpuCache {
        private int dirtyCount = 0;
        private Hashtable<String, CpuCacheItem> cacheOfCpuListsByFilename = null;

        private CpuCache() {
        }

        private synchronized void storeCachedCpus(String cpuCacheFilename) {
            if (this.cacheOfCpuListsByFilename != null && this.dirtyCount > 0) {
                try {
                    FileOutputStream fos = new FileOutputStream(cpuCacheFilename);
                    BufferedOutputStream buffer = new BufferedOutputStream(fos);
                    ObjectOutputStream out = new ObjectOutputStream(buffer);
                    out.writeObject(this.cacheOfCpuListsByFilename);
                    out.close();
                    this.dirtyCount = 0;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private synchronized void loadCachedCpus(String cpuCacheFilename, boolean doPurgeAfter) {
            if (this.cacheOfCpuListsByFilename == null) {
                long start = System.currentTimeMillis();
                if (!Boolean.parseBoolean(System.getProperty("ccs.inCleanMode"))) {
                    try {
                        FileInputStream fis = new FileInputStream(cpuCacheFilename);
                        BufferedInputStream buffer = new BufferedInputStream(fis);
                        ObjectInputStream in = new ObjectInputStream(buffer);
                        this.cacheOfCpuListsByFilename = (Hashtable)in.readObject();
                        in.close();
                    }
                    catch (InvalidClassException icx) {
                        this.cacheOfCpuListsByFilename = null;
                    }
                    catch (IOException ex) {
                        this.cacheOfCpuListsByFilename = null;
                    }
                    catch (ClassNotFoundException ex) {
                        this.cacheOfCpuListsByFilename = null;
                    }
                }
                if (this.cacheOfCpuListsByFilename == null) {
                    this.cacheOfCpuListsByFilename = new Hashtable();
                }
                this.dirtyCount = 0;
                if (doPurgeAfter) {
                    start = System.currentTimeMillis();
                    Iterator<Map.Entry<String, CpuCacheItem>> elements = this.cacheOfCpuListsByFilename.entrySet().iterator();
                    while (elements.hasNext()) {
                        Map.Entry<String, CpuCacheItem> element = elements.next();
                        CpuCacheItem item = element.getValue();
                        if (item.lastModified == 0L || new File(element.getKey()).lastModified() != item.lastModified) {
                            elements.remove();
                            ++this.dirtyCount;
                            continue;
                        }
                        item.setReadOnly(new File(element.getKey()));
                    }
                }
            }
        }

        private synchronized CpuCacheItem getListOfCachedCpus(File file) {
            CpuCacheItem cpus = this.cacheOfCpuListsByFilename.get(file.getPath());
            if (cpus != null && !cpus.readOnly && file.lastModified() != cpus.lastModified) {
                this.cacheOfCpuListsByFilename.remove(file.getPath());
                cpus = null;
            }
            return cpus;
        }

        ArrayList<ISystemSetupComponent> getFilteredListOfSetupElements(String fileName, String connectionName, String[] installDirectories, String schemaFilename) throws HardwareDbException {
            CpuCacheItem cpus = this.getListOfCpus(fileName, schemaFilename);
            if (cpus != null) {
                return cpus.getSetupElements(connectionName, fileName, installDirectories);
            }
            return null;
        }

        private synchronized CpuCacheItem updateListOfCachedCpus(Tag node, File fileName, HardwareDbException error) {
            CpuCacheItem cpus = new CpuCacheItem(fileName.lastModified(), fileName, node);
            cpus.lastErrorMessage = error;
            if (node != null) {
                try {
                    CpuCache.addToListOfCpuOperations(node, null, cpus, true, null);
                }
                catch (HardwareDbException e) {
                    cpus.clear();
                    cpus.lastErrorMessage = e;
                }
            }
            this.cacheOfCpuListsByFilename.put(fileName.getPath(), cpus);
            ++this.dirtyCount;
            return cpus;
        }

        private CpuCacheItem getListOfCpus(String systemSetupXmlFilename, String schemaFile) throws HardwareDbException {
            CpuCacheItem cachedCpus = this.getListOfCachedCpus(new File(systemSetupXmlFilename));
            if (cachedCpus == null) {
                HardwareDbException error = null;
                Tag rootNode = null;
                try {
                    XMLParser instanceParser = new XMLParser();
                    instanceParser.ParseAndValidate(systemSetupXmlFilename, schemaFile);
                    Node root = instanceParser.GetDocumentElement();
                    if (root != null) {
                        rootNode = new Tag(instanceParser, root);
                    }
                }
                catch (HardwareDbException e) {
                    error = new HardwareDbException(e.getLocalizedMessage() + " in file " + systemSetupXmlFilename, e.getLineNumber(), e.getColumnNumber());
                }
                cachedCpus = this.updateListOfCachedCpus(rootNode, new File(systemSetupXmlFilename), error);
            }
            if (cachedCpus.lastErrorMessage != null) {
                throw cachedCpus.lastErrorMessage;
            }
            return cachedCpus;
        }

        private static void addToListOfCpuOperations(Tag node, CpuIdentifier parentId, CpuCacheItem cpus, boolean includeRouters, Connection connection) throws HardwareDbException {
            String tag = node.getName();
            if (tag.compareTo("module") == 0) {
                return;
            }
            if (tag.compareTo("connection") == 0) {
                connection = new Connection(node.getAttribute("desc"), node.getChildAttribute("connectionType", "Type"), node.getAttribute("id"), parentId);
                cpus.add(new AddConnectionOperation(connection));
            } else {
                if (tag.compareTo("isa") == 0) {
                    String isaType = node.getAttribute("id");
                    if (isaType == null || isaType.length() == 0) {
                        isaType = node.getAttribute("Type");
                    }
                    String isaDescription = node.getAttribute("description");
                    long procId = node.getAttributeInteger("ProcID");
                    CpuIdentifier driverId = new CpuIdentifier(isaType, parentId);
                    int nDrivers = node.countChildrenByName("driver");
                    for (int i = 0; i < nDrivers; ++i) {
                        String driverFilename = node.getChildAttribute("driver", "file");
                        boolean debuggable = true;
                        if (driverFilename != null && driverFilename.endsWith("NONE")) {
                            debuggable = false;
                        }
                        Tag driverTag = new Tag(node, node.getChildByName("driver", i));
                        int nConnectionTypes = driverTag.countChildrenByName("connectionType");
                        for (int j = 0; j < nConnectionTypes; ++j) {
                            Tag connectionTypeTag = new Tag(driverTag, driverTag.getChildByName("connectionType", j));
                            if (driverTag.getPropertyString("multiBoard", "yes").compareToIgnoreCase("yes") == 0) {
                                driverFilename = null;
                            }
                            boolean capableMultiProccessor = driverTag.getPropertyString("multiProcessor", "yes").compareToIgnoreCase("yes") == 0;
                            Driver driver = new Driver(isaType, procId, driverId, debuggable, isaDescription, driverFilename, capableMultiProccessor);
                            cpus.add(new AddDriverOperation(connectionTypeTag.getAttribute("Type"), driver, connection != null ? connection.id : null));
                        }
                        int nProperties = driverTag.countChildrenByName("property");
                        for (int p = 0; p < nProperties; ++p) {
                            Tag property = new Tag(driverTag, driverTag.getChildByName("property", p));
                            CpuCache.addToListOfCpuOperations(property, new CpuIdentifier(property.getAttribute("id"), driverId), cpus, includeRouters, connection);
                        }
                    }
                    return;
                }
                if (tag.compareTo("cpu") == 0 || includeRouters && tag.compareTo("router") == 0) {
                    String isaType = node.getAttribute("isa");
                    if (node.getPropertyString("bypass", "0").compareTo("1") == 0) {
                        isaType = "BYPASS";
                    }
                    cpus.add(new AddCpuOperation(new Cpu(parentId, node.getAttribute("desc"), isaType, connection)));
                } else if (tag.compareTo("subpath") == 0) {
                    cpus.add(new AddCpuOperation(new Cpu(parentId, node.getAttribute("desc"), "<subpath>", connection)));
                } else if (tag.compareTo("device") == 0) {
                    cpus.add(new AddDeviceOperation(parentId, node.getAttribute("desc"), node.getAttribute("partnum"), node.countChildrenByName("processors") != 0));
                } else if (tag.compareTo("board") == 0) {
                    cpus.add(new AddBoardOperation(parentId, node.getAttribute("desc"), node.countChildrenByName("processors") != 0));
                } else {
                    if (tag.compareTo("property") == 0) {
                        String subpathAttr = node.getAttribute("SubPath");
                        boolean subPathProperty = subpathAttr != null && subpathAttr.compareTo("true") == 0;
                        cpus.add(new AddPropertyOperation(CpuCache.createPropertyOperation(node, parentId == null ? new CpuIdentifier("", null) : parentId), subPathProperty));
                        return;
                    }
                    if (tag.compareTo("jtag") == 0) {
                        return;
                    }
                }
            }
            Node childNode = node.getFirstChild();
            while (childNode != null) {
                Tag child = new Tag(node, childNode);
                tag = child.getName();
                if (tag.compareTo("processors") == 0) {
                    childNode = child.getFirstChild();
                    continue;
                }
                if (tag.compareTo("instance") == 0 || tag.compareTo("include") == 0) {
                    String href = child.getAttribute("href");
                    if (!(href.contains("/Modules/") || href.contains("\\Modules\\") || href.startsWith("Modules\\") || href.startsWith("Modules/"))) {
                        IncludeFileOperation newOp = new IncludeFileOperation(child, parentId, connection);
                        cpus.add(newOp);
                    }
                } else {
                    CpuCache.addToListOfCpuOperations(child, new CpuIdentifier(child.getAttribute("id"), parentId), cpus, includeRouters, connection);
                }
                childNode = childNode.getNextSibling();
            }
        }

        private static Property createPropertyOperation(Tag node, CpuIdentifier parentId) throws HardwareDbException {
            String propertyType = node.getAttribute("Type");
            String propertyName = node.getAttribute("Name");
            if (parentId.id == null || parentId.id.length() == 0) {
                parentId.id = propertyName;
            }
            if (parentId.id == null || parentId.id.length() == 0) {
                parentId.id = node.getAttribute("ID");
            }
            if (propertyName == null || propertyName.length() == 0) {
                propertyName = node.getAttribute("desc");
            }
            if (propertyName == null || propertyName.length() == 0) {
                propertyName = parentId.id;
            }
            if (propertyType.compareTo("choicelist") != 0) {
                return new Property(parentId, propertyName, node.getAttribute("Value"));
            }
            ChoiceListProperty choiceList = new ChoiceListProperty(parentId, propertyName, node.getAttribute("Value"));
            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                Tag child = new Tag(node, childNode);
                String tag = child.getName();
                if (tag.compareTo("choice") != 0) continue;
                String value = child.getAttribute("Name");
                if (value == null || value.length() == 0) {
                    value = child.getAttribute("value");
                }
                ChoiceListProperty.Choice choice = choiceList.addChoice(value);
                for (Node subPropertyNode = childNode.getFirstChild(); subPropertyNode != null; subPropertyNode = subPropertyNode.getNextSibling()) {
                    Tag subProperty = new Tag(node, subPropertyNode);
                    tag = subProperty.getName();
                    if (tag.compareTo("property") != 0) continue;
                    choice.addSubProperty(CpuCache.createPropertyOperation(subProperty, parentId));
                }
            }
            return choiceList;
        }

        String getConnectionName(String fileName, String[] installDirectories) {
            try {
                ArrayList<Connection> connections;
                CpuCacheItem cachedConnection = this.getListOfCpus(fileName, null);
                if (cachedConnection != null && (connections = cachedConnection.getConnections(fileName, installDirectories)) != null && connections.size() > 0) {
                    return connections.get(0).connectionName;
                }
            }
            catch (HardwareDbException hardwareDbException) {
                // empty catch block
            }
            return null;
        }

        ISystemSetupFileStamp getSystemSetupFileStamp(String ccxmlFilename, String[] installDirectories, String schemaFile) {
            FileStamp result = new FileStamp();
            try {
                CpuCacheItem cachedFile = this.getListOfCpus(ccxmlFilename, schemaFile);
                result.addIncludeFile(cachedFile);
                cachedFile.addToFileStamp(this, result, ccxmlFilename, installDirectories);
            }
            catch (HardwareDbException e) {
                // empty catch block
            }
            return result;
        }

        protected synchronized void printCachedCpus(String filter) {
            for (Map.Entry<String, CpuCacheItem> element : this.cacheOfCpuListsByFilename.entrySet()) {
                if (filter != null && !element.getKey().contains(filter)) continue;
                CpuCacheItem item = element.getValue();
                System.out.print(element.getKey());
                System.out.print(" hash = ");
                System.out.print(element.getKey().hashCode());
                System.out.print(item.toString());
            }
        }

        private static class CpuCacheItem
        extends HardwareDbFileInfo
        implements ICpuOperation,
        IHardwareDbCachedFile {
            private static final long serialVersionUID = 2L;
            private long lastModified = 0L;
            private transient boolean readOnly = false;
            private ArrayList<ICpuOperation> cpuOperations;
            private HardwareDbException lastErrorMessage;

            private CpuCacheItem(long lastModified, File file, Tag root) {
                super(root);
                this.lastModified = lastModified;
                this.setReadOnly(file);
                this.cpuOperations = null;
            }

            private CpuCacheItem(Tag root) {
                super(root);
                this.lastModified = 0L;
                this.readOnly = false;
                this.cpuOperations = null;
            }

            @Override
            protected HardwareDbFileInfo.IDriverIterator getDrivers() {
                return new DriverIterator(this.cpuOperations == null ? null : this.cpuOperations.iterator());
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String newName, String newIsa, Connection newConnection, String filterByConnectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) throws HardwareDbException {
                if (this.cpuOperations != null) {
                    for (ICpuOperation operation : this.cpuOperations) {
                        operation.addToListOfSetupElements(setupElements, newName, newIsa, newConnection, filterByConnectionName, parentId, fileName, installDirectories);
                    }
                }
            }

            @Override
            public void addToListOfProperties(ArrayList<Property> properties, CpuIdentifier parentId, boolean subPathPropertiesOnly, String fileName, String[] installDirectories) {
                if (this.cpuOperations != null) {
                    for (ICpuOperation operation : this.cpuOperations) {
                        operation.addToListOfProperties(properties, parentId, subPathPropertiesOnly, fileName, installDirectories);
                    }
                }
            }

            @Override
            public ArrayList<ISystemSetupComponent> getSetupElements(String connectionNameFilter, String fileName, String[] installDirectories) throws HardwareDbException {
                if (this.cpuOperations != null && this.cpuOperations.size() > 0) {
                    ArrayList<ISystemSetupComponent> elements = new ArrayList<ISystemSetupComponent>(8);
                    this.addToListOfSetupElements(elements, null, null, null, connectionNameFilter, null, fileName, installDirectories);
                    if (elements.size() > 0) {
                        return elements;
                    }
                }
                return null;
            }

            @Override
            public ArrayList<Connection> getConnections(String fileName, String[] installDirectories) throws HardwareDbException {
                ArrayList<Connection> connections = null;
                if (this.cpuOperations != null && this.cpuOperations.size() > 0) {
                    connections = new ArrayList<Connection>(1);
                    ArrayList<ISystemSetupComponent> setupElements = new ArrayList<ISystemSetupComponent>();
                    this.addToListOfSetupElements(setupElements, null, null, null, null, null, fileName, installDirectories);
                    for (ISystemSetupComponent setupElement : setupElements) {
                        if (!(setupElement instanceof Connection)) continue;
                        connections.add((Connection)setupElement);
                    }
                    if (connections.size() == 0) {
                        connections = null;
                    }
                }
                return connections;
            }

            @Override
            public ArrayList<Property> getListOfProperties(CpuIdentifier id, boolean subPathPropertiesOnly, String fileName, String[] installDirectories) {
                ArrayList<Property> properties = null;
                if (this.cpuOperations != null && this.cpuOperations.size() > 0) {
                    properties = new ArrayList<Property>(5);
                    this.addToListOfProperties(properties, id, subPathPropertiesOnly, fileName, installDirectories);
                    if (properties.size() == 0) {
                        properties = null;
                    }
                }
                return properties;
            }

            @Override
            public String getDevicePartNum() {
                for (ICpuOperation cpuOperation : this.cpuOperations) {
                    if (!(cpuOperation instanceof AddDeviceOperation)) continue;
                    return ((AddDeviceOperation)cpuOperation).partnum;
                }
                return null;
            }

            @Override
            public boolean doesDeviceHaveProcessorsTag() {
                for (ICpuOperation cpuOperation : this.cpuOperations) {
                    if (cpuOperation instanceof AddBoardOperation) {
                        return ((AddBoardOperation)cpuOperation).hasProcessorsTag;
                    }
                    if (!(cpuOperation instanceof AddDeviceOperation)) continue;
                    return ((AddDeviceOperation)cpuOperation).hasProcessorsTag;
                }
                return false;
            }

            private void clear() {
                this.cpuOperations = null;
            }

            @Override
            public String getRootId() {
                return this.rootId;
            }

            private void add(ICpuOperation newOperation) {
                if (this.cpuOperations == null) {
                    this.cpuOperations = new ArrayList(2);
                }
                this.cpuOperations.add(newOperation);
            }

            private void addToFileStamp(CpuCache cpuCache, FileStamp fileStamp, String fileName, String[] installDirectories) {
                if (this.cpuOperations != null) {
                    for (ICpuOperation operation : this.cpuOperations) {
                        if (!(operation instanceof IncludeFileOperation)) continue;
                        try {
                            File includeFile = ((IncludeFileOperation)operation).getAbsolutePath(fileName, installDirectories);
                            String includeFilePath = includeFile.getPath();
                            CpuCacheItem cacheItem = cpuCache.getListOfCpus(includeFilePath, null);
                            if (cacheItem == null) continue;
                            fileStamp.addIncludeFile(cacheItem);
                            cacheItem.addToFileStamp(cpuCache, fileStamp, includeFilePath, installDirectories);
                        }
                        catch (HardwareDbException e) {}
                    }
                }
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                result.append(" last modified = ");
                result.append(this.lastModified);
                if (this.lastErrorMessage != null) {
                    result.append("\n\tException = ");
                    result.append(this.lastErrorMessage.getMessage());
                    result.append("\n\tClass = ");
                    result.append(this.lastErrorMessage.getClass().toString());
                    result.append("\n");
                } else {
                    result.append("\n<");
                    result.append(this.rootTagName);
                    if (this.rootId != null) {
                        result.append(" id=");
                        result.append(this.rootId);
                    }
                    if (this.rootName != null) {
                        result.append(" desc=");
                        result.append(this.rootName);
                    }
                    if (this.rootDescription != null) {
                        result.append(" description=");
                        result.append(this.rootDescription);
                    }
                    if (this.simulation != null) {
                        result.append(" simulation=");
                        result.append(this.simulation);
                    }
                    result.append(">\n");
                    if (this.rootConnectionType != null) {
                        result.append("\t<connectionType type=");
                        result.append(this.rootConnectionType);
                        result.append(">\n");
                    }
                    if (this.cpuOperations != null) {
                        for (ICpuOperation operation : this.cpuOperations) {
                            result.append("\t");
                            result.append(operation.toString());
                            result.append("\n");
                        }
                    }
                }
                return result.toString();
            }

            void setReadOnly(File file) {
                this.readOnly = file.getPath().endsWith(".ccxml") ? false : !file.canWrite();
            }

            @Override
            public ArrayList<File> getInstances(String type, String fileName, String[] installDirectories) throws HardwareDbException {
                ArrayList<File> result = new ArrayList<File>(1);
                if (this.cpuOperations != null) {
                    for (ICpuOperation operation : this.cpuOperations) {
                        if (!(operation instanceof IncludeFileOperation)) continue;
                        File file = ((IncludeFileOperation)operation).getAbsolutePath(fileName, installDirectories);
                        String includeFilePath = file.getPath();
                        CpuCacheItem cpuCacheItem = cacheOfCpus.getListOfCpus(includeFilePath, null);
                        if (cpuCacheItem == null) continue;
                        if (cpuCacheItem.rootTagName.compareTo(type) == 0) {
                            result.add(file);
                            continue;
                        }
                        result.addAll(cpuCacheItem.getInstances(type, includeFilePath, installDirectories));
                    }
                }
                return result;
            }

            private static class DriverIterator
            implements HardwareDbFileInfo.IDriverIterator {
                private Iterator<ICpuOperation> it;
                private AddDriverOperation cur;

                private DriverIterator(Iterator<ICpuOperation> listOfOperations) {
                    this.it = listOfOperations;
                }

                @Override
                public boolean next() {
                    if (this.it != null) {
                        while (this.it.hasNext()) {
                            ICpuOperation op = this.it.next();
                            if (!(op instanceof AddDriverOperation)) continue;
                            this.cur = (AddDriverOperation)op;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public String getConnectionType() {
                    return this.cur.connectionType;
                }

                @Override
                public String getName() {
                    return this.cur.driverToAdd.isa;
                }

                @Override
                public String getDescription() {
                    return this.cur.driverToAdd.description;
                }

                @Override
                public long getProcId() {
                    return this.cur.driverToAdd.procId;
                }
            }
        }

        private static class IncludeFileOperation
        implements ICpuOperation {
            private String newName;
            private String newId;
            private String newIsa;
            private String includeFile;
            private CpuIdentifier parentId;
            private Connection newConnection;

            IncludeFileOperation(Tag instanceTag, CpuIdentifier parentId, Connection connection) throws HardwareDbException {
                this.newName = instanceTag.getAttribute("desc");
                if (this.newName == null || this.newName.length() == 0) {
                    this.newName = null;
                }
                this.newId = instanceTag.getAttribute("id");
                if (this.newId == null || this.newId.length() == 0) {
                    this.newId = null;
                }
                this.newIsa = instanceTag.getAttribute("isa");
                if (this.newIsa == null || this.newIsa.length() == 0) {
                    this.newIsa = null;
                }
                this.includeFile = instanceTag.getAttribute("href");
                this.newConnection = connection;
                this.parentId = parentId;
            }

            File getAbsolutePath(String fileName, String[] installDirectories) throws HardwareDbException {
                File file = new File(this.includeFile);
                File curDirectory = new File(fileName);
                file = HardwareDatabaseReader.convertToAbsPath(file, curDirectory.getParent(), installDirectories);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!file.exists()) {
                    throw new HardwareDbException("File " + this.includeFile + " does not exist.  Was included by file " + fileName);
                }
                return file;
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String name, String isa, Connection connection, String connectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) throws HardwareDbException {
                if (this.includeFile != null) {
                    File file = this.getAbsolutePath(fileName, installDirectories);
                    String includeFilePath = file.getPath();
                    CpuCacheItem cpuCacheItem = cacheOfCpus.getListOfCpus(includeFilePath, null);
                    if (cpuCacheItem != null) {
                        if (cpuCacheItem.lastErrorMessage != null) {
                            throw cpuCacheItem.lastErrorMessage;
                        }
                        String id = this.newId != null && this.newId.length() > 0 ? this.newId : cpuCacheItem.getRootId();
                        CpuIdentifier newParentId = new CpuIdentifier(id, new CpuIdentifier(this.parentId, parentId));
                        if (this.newConnection != null) {
                            connection = Connection.findConnectionInList(setupElements, new CpuIdentifier(this.newConnection.id, parentId));
                        }
                        cpuCacheItem.addToListOfSetupElements(setupElements, this.newName, this.newIsa, connection, connectionName, newParentId, includeFilePath, installDirectories);
                    }
                }
            }

            @Override
            public void addToListOfProperties(ArrayList<Property> properties, CpuIdentifier parentId, boolean subPathPropertiesOnly, String fileName, String[] installDirectories) {
                try {
                    if (this.includeFile != null) {
                        File file = this.getAbsolutePath(fileName, installDirectories);
                        String includeFilePath = file.getPath();
                        CpuCacheItem cpuCacheItem = cacheOfCpus.getListOfCpus(includeFilePath, null);
                        if (cpuCacheItem != null && cpuCacheItem.lastErrorMessage == null) {
                            String id = this.newId != null && this.newId.length() > 0 ? this.newId : cpuCacheItem.getRootId();
                            CpuIdentifier newParentId = new CpuIdentifier(id, this.parentId);
                            int score = parentId.isChildOf(newParentId);
                            if (score > 0) {
                                cpuCacheItem.addToListOfProperties(properties, new CpuIdentifier(parentId, score - 1), subPathPropertiesOnly, includeFilePath, installDirectories);
                            } else if (newParentId.compareTo(parentId) == 0) {
                                cpuCacheItem.addToListOfProperties(properties, new CpuIdentifier("", null), subPathPropertiesOnly, fileName, installDirectories);
                            }
                        }
                    }
                }
                catch (HardwareDbException e) {
                    // empty catch block
                }
            }

            public String toString() {
                return "Instance " + this.includeFile.toString();
            }
        }

        private static class AddConnectionOperation
        extends AbstractCpuOperation {
            private Connection connectionToAdd;

            AddConnectionOperation(Connection connectionToAdd) {
                this.connectionToAdd = connectionToAdd;
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String newName, String newIsa, Connection connection, String filterByConnectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) {
                Connection newConnection = new Connection(this.connectionToAdd);
                if (newName != null && newConnection.id == null) {
                    newConnection.name = newName;
                }
                if (parentId != null) {
                    newConnection.id = new CpuIdentifier(newConnection.id, parentId);
                }
                this.addConnection(setupElements, newConnection);
            }

            private void addConnection(ArrayList<ISystemSetupComponent> connectionList, Connection newConnection) {
                if (newConnection != null && connectionList != null) {
                    for (ISystemSetupComponent item : connectionList) {
                        if (((AbstractSystemSetupComponent)item).id.compareTo(newConnection.id) != 0) continue;
                        ((Connection)item).assign(newConnection);
                        return;
                    }
                    connectionList.add(newConnection);
                }
            }

            public String toString() {
                return "Add Connection " + this.connectionToAdd.id.toString();
            }
        }

        private static class AddBoardOperation
        extends AbstractCpuOperation {
            private CpuIdentifier id;
            private String name;
            private boolean hasProcessorsTag;

            AddBoardOperation(CpuIdentifier id, String name, boolean hasProcessorsTag) {
                this.id = id;
                this.name = name == null || name.length() == 0 ? null : name;
                this.hasProcessorsTag = hasProcessorsTag;
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String newName, String newIsa, Connection connection, String filterByConnectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) throws HardwareDbException {
                if (setupElements != null) {
                    CpuIdentifier newId = new CpuIdentifier(this.id, parentId);
                    this.addBoard(setupElements, new Board(newName != null && this.id == null ? newName : this.name, newId));
                }
            }

            private void addBoard(ArrayList<ISystemSetupComponent> setupElements, Board newBoard) {
                for (ISystemSetupComponent item : setupElements) {
                    if (((AbstractSystemSetupComponent)item).id.compareTo(newBoard.id) != 0) continue;
                    ((Board)item).assign(newBoard);
                    return;
                }
                setupElements.add(newBoard);
            }

            public String toString() {
                return "Add Board " + this.id.toString();
            }
        }

        private static class AddDeviceOperation
        extends AbstractCpuOperation {
            private CpuIdentifier id;
            private String name;
            private String partnum;
            private boolean hasProcessorsTag;

            AddDeviceOperation(CpuIdentifier id, String name, String partnum, boolean hasProcessorsTag) {
                this.id = id;
                this.name = name == null || name.length() == 0 ? null : name;
                this.partnum = partnum;
                this.hasProcessorsTag = hasProcessorsTag;
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String newName, String newIsa, Connection connection, String filterByConnectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) throws HardwareDbException {
                if (setupElements != null) {
                    CpuIdentifier newId = new CpuIdentifier(this.id, parentId);
                    this.addDevice(setupElements, new Device(newId, newName != null && this.id == null ? newName : this.name, fileName, this.partnum));
                }
            }

            private void addDevice(ArrayList<ISystemSetupComponent> setupElements, Device newDevice) {
                for (ISystemSetupComponent item : setupElements) {
                    if (((AbstractSystemSetupComponent)item).id.compareTo(newDevice.id) != 0) continue;
                    ((Device)item).assign(newDevice);
                    return;
                }
                setupElements.add(newDevice);
            }

            public String toString() {
                return "Add Device " + this.id.toString();
            }
        }

        private static class AddPropertyOperation
        extends AbstractCpuOperation {
            private Property propertyToAdd;
            private boolean subPathProperty;

            AddPropertyOperation(Property propertyToAdd, boolean subPathProperty) {
                this.propertyToAdd = propertyToAdd;
                this.subPathProperty = subPathProperty;
            }

            @Override
            public void addToListOfProperties(ArrayList<Property> properties, CpuIdentifier parentId, boolean subPathPropertiesOnly, String fileName, String[] installDirectories) {
                if (parentId.compareTo(this.propertyToAdd.id.parent) == 0 && this.subPathProperty == subPathPropertiesOnly) {
                    properties.add(this.propertyToAdd);
                }
            }

            public String toString() {
                return "Add Property " + this.propertyToAdd.id.toString();
            }
        }

        private static class AddDriverOperation
        extends AbstractCpuOperation {
            private Driver driverToAdd;
            private String connectionType;
            private CpuIdentifier connectionId;

            AddDriverOperation(String connectionType, Driver driverToAdd, CpuIdentifier connectionId) {
                this.connectionType = connectionType;
                this.driverToAdd = driverToAdd;
                this.connectionId = connectionId;
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String newName, String newIsa, Connection connection, String filterByConnectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) {
                if (connection == null) {
                    connection = Connection.findConnectionInList(setupElements, new CpuIdentifier(this.connectionId, parentId));
                }
                if (connection != null && connection.connectionType != null && connection.connectionType.compareTo(this.connectionType) == 0) {
                    Driver newDriver = new Driver(this.driverToAdd);
                    if (parentId != null) {
                        newDriver.id = new CpuIdentifier(newDriver.id, parentId);
                    }
                    connection.addDriver(newDriver);
                }
            }

            public String toString() {
                return "Add Driver " + this.driverToAdd.id.toString();
            }
        }

        private static class AddCpuOperation
        extends AbstractCpuOperation {
            private Cpu cpuToAdd;

            AddCpuOperation(Cpu cpuToAdd) {
                this.cpuToAdd = cpuToAdd;
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> cpus, String newName, String newIsa, Connection connection, String connectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) {
                if (cpus == null) {
                    return;
                }
                Cpu newCpu = new Cpu(this.cpuToAdd);
                if (newName != null && newCpu.id == null) {
                    newCpu.name = newName;
                }
                if (newIsa != null && newCpu.id == null) {
                    newCpu.isa = newIsa;
                }
                if (parentId != null) {
                    newCpu.id = new CpuIdentifier(newCpu.id, parentId);
                }
                if (newCpu.connection != null) {
                    newCpu.connection = Connection.findConnectionInList(cpus, new CpuIdentifier(((Cpu)newCpu).connection.id, parentId));
                } else {
                    newCpu.connection = connection;
                }
                if (connectionName == null || newCpu.connection != null && newCpu.connection.connectionName != null && connectionName.compareTo(newCpu.connection.connectionName) == 0) {
                    this.addCpu(cpus, newCpu);
                }
            }

            private void addCpu(ArrayList<ISystemSetupComponent> cpuList, Cpu newCpu) {
                for (ISystemSetupComponent item : cpuList) {
                    if (((AbstractSystemSetupComponent)item).id.compareTo(newCpu.id) != 0) continue;
                    ((Cpu)item).assign(newCpu);
                    return;
                }
                cpuList.add(newCpu);
            }

            public String toString() {
                if (this.cpuToAdd.isSubpath()) {
                    return "Add subpath " + this.cpuToAdd.getName();
                }
                return "Add Cpu " + this.cpuToAdd.getName();
            }
        }

        private static abstract class AbstractCpuOperation
        implements ICpuOperation {
            private AbstractCpuOperation() {
            }

            @Override
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> setupElements, String name, String isa, Connection connection, String filterByConnectionName, CpuIdentifier parentId, String fileName, String[] installDirectories) throws HardwareDbException {
            }

            @Override
            public void addToListOfProperties(ArrayList<Property> properties, CpuIdentifier parentId, boolean subPathPropertiesOnly, String fileName, String[] installDirectories) {
            }
        }

        private static interface ICpuOperation
        extends Serializable {
            public void addToListOfSetupElements(ArrayList<ISystemSetupComponent> var1, String var2, String var3, Connection var4, String var5, CpuIdentifier var6, String var7, String[] var8) throws HardwareDbException;

            public void addToListOfProperties(ArrayList<Property> var1, CpuIdentifier var2, boolean var3, String var4, String[] var5);
        }

        private static class FileStamp
        implements ISystemSetupFileStamp {
            private ArrayList<CpuCacheItem> includedFiles = new ArrayList(5);

            FileStamp() {
            }

            void addIncludeFile(CpuCacheItem file) {
                this.includedFiles.add(file);
            }

            @Override
            public int compareTo(ISystemSetupFileStamp obj) {
                if (obj instanceof FileStamp) {
                    FileStamp fileStamp = (FileStamp)obj;
                    if (this.includedFiles.size() != fileStamp.includedFiles.size()) {
                        return -1;
                    }
                    int i = this.includedFiles.size();
                    while (i-- > 0) {
                        if (this.includedFiles.get(i).lastModified == fileStamp.includedFiles.get(i).lastModified) continue;
                        return -1;
                    }
                    return 0;
                }
                return -1;
            }
        }
    }

    protected static abstract class HardwareDbFileInfo
    implements Serializable {
        protected String rootId = null;
        protected String rootName = null;
        protected String rootDescription = null;
        protected String rootConnectionType = null;
        protected String rootTagName = null;
        protected String simulation = null;

        protected abstract IDriverIterator getDrivers();

        protected HardwareDbFileInfo(Tag root) {
            if (root != null) {
                Node connection;
                this.rootId = root.getAttribute("id");
                if (this.rootId != null && this.rootId.length() == 0) {
                    this.rootId = null;
                }
                this.rootName = root.getAttribute("desc");
                if (this.rootName != null && this.rootName.length() == 0) {
                    this.rootName = this.rootId;
                }
                if (this.rootName != null && this.rootName.compareTo("configuration_0") == 0 && (connection = root.getChildByName("connection", 0)) != null) {
                    this.rootName = XMLParser.GetAttributeString(connection, "desc");
                    if (this.rootName == null || this.rootName.length() == 0) {
                        this.rootName = XMLParser.GetAttributeString(connection, "id");
                    }
                }
                this.rootDescription = root.getAttribute("description");
                if (this.rootDescription != null && this.rootDescription.length() == 0) {
                    this.rootDescription = null;
                }
                this.rootConnectionType = root.getChildAttribute("connectionType", "Type");
                if (this.rootConnectionType != null && this.rootConnectionType.length() == 0) {
                    this.rootConnectionType = null;
                }
                this.rootTagName = root.getName();
                if (this.rootTagName != null && this.rootTagName.length() == 0) {
                    this.rootTagName = null;
                }
                this.simulation = root.getAttribute("simulation");
                if (this.simulation != null && this.simulation.length() == 0) {
                    this.simulation = null;
                }
            }
        }

        protected static interface IDriverIterator {
            public boolean next();

            public String getConnectionType();

            public String getName();

            public String getDescription();

            public long getProcId();
        }
    }

    public static class Cpu
    extends AbstractSystemSetupComponent {
        private static final String SUB_PATH = "<subpath>";
        private Connection connection;
        public String isa;

        private Cpu(CpuIdentifier id, String name, String isa, Connection connection) {
            this.id = id;
            this.name = name == null || name.length() == 0 ? null : name;
            this.isa = isa == null || isa.length() == 0 ? null : isa;
            this.connection = connection;
        }

        public Cpu(Cpu cpu) {
            this.assign(cpu);
        }

        @Override
        public String toString() {
            if (this.name == null && this.id == null) {
                return "";
            }
            if (this.connection == null) {
                return this.name == null ? this.id.id : this.name;
            }
            return this.connection.toString() + '\\' + (this.name == null ? this.id.id : this.name);
        }

        @Override
        public String getDecoratedLabelText() {
            if (this.isBypassed() && !this.isRouter() && !this.isSubpath()) {
                return this.getName() + " (bypassed)";
            }
            return this.getName();
        }

        public String getBoardName() {
            return this.connection == null ? null : this.connection.toString();
        }

        public Cpu findParentCpu(ArrayList<Cpu> potentialParents) {
            int highScore = Integer.MAX_VALUE;
            Cpu result = null;
            for (Cpu parent : potentialParents) {
                int score;
                if (this.id.compareTo(parent.id) == 0 || parent.isSubpath() || (score = this.id.isChildOf(parent.id)) <= 0 || score >= highScore) continue;
                highScore = score;
                result = parent;
            }
            return result;
        }

        Cpu findParentSubPath(ArrayList<Cpu> potentialParents) {
            int highScore = Integer.MAX_VALUE;
            Cpu result = null;
            for (Cpu parent : potentialParents) {
                int score;
                if (this.id.compareTo(parent.id) == 0 || !parent.isSubpath() || (score = this.id.isChildOf(parent.id)) <= 0 || score >= highScore) continue;
                highScore = score;
                result = parent;
            }
            return result;
        }

        Device findParentDevice(ArrayList<Device> devices) {
            int highScore = Integer.MAX_VALUE;
            Device result = null;
            for (Device device : devices) {
                int score = this.id.isChildOf(device.id);
                if (score <= 0 || score >= highScore) continue;
                highScore = score;
                result = device;
            }
            return result;
        }

        private void assign(Cpu from) {
            if (from != null) {
                super.assign(from);
                this.isa = from.isa == null ? this.isa : from.isa;
                this.connection = from.connection == null ? this.connection : from.connection;
            }
        }

        boolean isSubpath() {
            return this.isa == null ? false : this.isa.compareTo(SUB_PATH) == 0;
        }

        boolean isDebuggable() {
            if (this.isa != null && !this.isa.startsWith("BYPASS")) {
                if (this.connection == null) {
                    return true;
                }
                Driver driver = this.connection.findDriver(this.isa);
                if (driver != null) {
                    return driver.isDebuggable();
                }
            }
            return false;
        }

        boolean isBypassed() {
            return this.isa != null && this.isa.startsWith("BYPASS");
        }

        boolean isMissingDriver() {
            if (this.connection != null && this.isa != null && !this.isa.startsWith("BYPASS")) {
                Driver driver = this.connection.findDriver(this.isa);
                return driver == null;
            }
            return false;
        }

        boolean isMultiBoard(String boardLocation) {
            Driver driver;
            if (this.connection != null && this.isa != null && !this.isa.startsWith("BYPASS") && (driver = this.connection.findDriver(this.isa)) != null) {
                return driver.isMultiBoard(boardLocation);
            }
            return true;
        }

        boolean isMultiProcessor() {
            Driver driver;
            if (this.connection != null && this.isa != null && !this.isa.startsWith("BYPASS") && (driver = this.connection.findDriver(this.isa)) != null) {
                return driver.isMultiProcessor();
            }
            return true;
        }

        String getDriverLocation() {
            Driver driver;
            if (this.connection != null && this.isa != null && !this.isa.startsWith("BYPASS") && (driver = this.connection.findDriver(this.isa)) != null) {
                return driver.getDriverLocation();
            }
            return null;
        }

        public boolean isRouter() {
            Driver driver;
            if (this.connection != null && this.isa != null && (driver = this.connection.findDriver(this.isa)) != null) {
                return driver.isRouter();
            }
            return false;
        }

        public ProcessorID getProcID() {
            Driver driver;
            if (this.connection != null && this.isa != null && (driver = this.connection.findDriver(this.isa)) != null) {
                return new ProcessorID(driver.procId);
            }
            return null;
        }

        public boolean isNonDebug() {
            ProcessorID procID = this.getProcID();
            return procID == null ? false : procID.isNonDebug();
        }

        static Map<String, String> getProperties(Cpu cpu, ArrayList<Cpu> cpusAndRouters, IHardwareDbCachedFile cacheFile, String fileName, String[] installDirectories) {
            Cpu router;
            ArrayList<Property> defaultProperties = null;
            Cpu cpu2 = router = cpu.isSubpath() ? cpu.findParentCpu(cpusAndRouters) : cpu;
            if (router != null && router.connection != null && router.isa != null) {
                Driver driver = router.connection.findDriver(router.isa);
                if (driver != null && (defaultProperties = cacheFile.getListOfProperties(driver.id, cpu.isSubpath(), fileName, installDirectories)) != null) {
                    ArrayList<Property> overrideProperties = cacheFile.getListOfProperties(cpu.id, false, fileName, installDirectories);
                    return Property.getProperties(defaultProperties, overrideProperties);
                }
            } else if (router != null && (defaultProperties = cacheFile.getListOfProperties(cpu.id, false, fileName, installDirectories)) != null) {
                return Property.getProperties(defaultProperties, null);
            }
            return Collections.unmodifiableMap(new HashMap());
        }

        @Override
        public String getIconDescriptor() {
            if (this.isRouter()) {
                return "router";
            }
            if (this.isSubpath()) {
                return "subpath";
            }
            if (this.isBypassed()) {
                return "bypass";
            }
            if (this.isNonDebug()) {
                return "nondebug";
            }
            if (this.isDebuggable()) {
                return "cpu";
            }
            return "nodriver";
        }
    }

    protected static class ChoiceListProperty
    extends NumericProperty {
        ArrayList<Choice> choices;

        private ChoiceListProperty(CpuIdentifier id, String name, String value) {
            super(id, name, value);
        }

        String[] getChoices() {
            if (this.choices.size() > 0) {
                String[] result = new String[this.choices.size()];
                for (int i = 0; i < this.choices.size(); ++i) {
                    result[i] = this.choices.get(i).getValue();
                }
                return result;
            }
            return null;
        }

        @Override
        Property[] getSubProperties(String overrideValue) {
            return this.getChoice(overrideValue).getSubProperties();
        }

        private Choice getChoice(String overrideValue) {
            long index = this.getIntValue(overrideValue);
            if (index < 0L || index > (long)this.choices.size()) {
                index = 0L;
            }
            return this.choices.get((int)index);
        }

        @Override
        String getValue(String overrideValue) {
            return this.getChoice(overrideValue).getValue();
        }

        Choice addChoice(String value) {
            Choice choice = new Choice(value);
            if (this.choices == null) {
                this.choices = new ArrayList(2);
            }
            this.choices.add(choice);
            return choice;
        }

        Property[] findSubProperties(String choiceValue) {
            for (Choice choice : this.choices) {
                if (choice.getValue().compareTo(choiceValue) != 0) continue;
                return choice.getSubProperties();
            }
            return null;
        }

        protected static class Choice
        implements Serializable {
            private String value;
            private ArrayList<Property> subProperties;

            private Choice(String value) {
                this.value = value;
            }

            void addSubProperty(Property subProperty) {
                if (this.subProperties == null) {
                    this.subProperties = new ArrayList(2);
                }
                this.subProperties.add(subProperty);
            }

            Property[] getSubProperties() {
                return this.subProperties.toArray(new Property[this.subProperties.size()]);
            }

            String getValue() {
                return this.value;
            }

            public String toString() {
                return "Choice " + this.value;
            }
        }
    }

    protected static class NumericProperty
    extends Property {
        private NumericProperty(CpuIdentifier id, String name, String value) {
            super(id, name, value);
        }

        long getIntValue(String overrideValue) {
            String value;
            String string = value = overrideValue == null || overrideValue.length() == 0 ? this.defaultValue : overrideValue;
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            return Long.parseLong(value);
        }
    }

    protected static class Property
    implements Serializable {
        protected CpuIdentifier id;
        protected String name;
        protected String defaultValue;

        private Property(CpuIdentifier id, String name, String defaultValue) {
            this.id = id;
            this.name = name;
            this.defaultValue = defaultValue;
        }

        Property[] getSubProperties(String overrideValue) {
            return null;
        }

        String getValue(String overrideValue) {
            return overrideValue == null || overrideValue.length() == 0 ? this.defaultValue : overrideValue;
        }

        String getName() {
            return this.name;
        }

        public String toString() {
            return "Property " + this.name + " = " + this.defaultValue;
        }

        private static Property findLastProperty(ArrayList<Property> properties, String id) {
            int i = properties.size();
            while (i-- > 0) {
                Property property = properties.get(i);
                if (property.id.id.compareTo(id) != 0) continue;
                return property;
            }
            return null;
        }

        private static Map<String, String> getProperties(ArrayList<Property> defaults, ArrayList<Property> overrides) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Property property : defaults) {
                Property override = null;
                if (overrides != null) {
                    override = Property.findLastProperty(overrides, property.id.id);
                }
                result.put(property.getName(), property.getValue(override == null ? null : override.defaultValue));
            }
            return result;
        }
    }

    private static class Driver
    implements Serializable {
        private String isa;
        private long procId;
        private CpuIdentifier id;
        private boolean debuggable;
        private String description;
        private String driverFilename;
        private boolean multiProcessorSupport;

        Driver(String isa, long procId, CpuIdentifier id, boolean debuggable, String description, String driverFilename, boolean multiProcessorSupport) {
            this.isa = isa == null || isa.length() == 0 ? null : isa;
            this.procId = procId;
            this.id = id;
            this.debuggable = debuggable;
            this.description = description == null || description.length() == 0 ? null : description;
            this.driverFilename = driverFilename;
            this.multiProcessorSupport = multiProcessorSupport;
        }

        Driver(Driver copyFrom) {
            this.debuggable = true;
            this.assign(copyFrom);
        }

        private void assign(Driver obj) {
            if (obj != null) {
                this.id = obj.id;
                if (obj.isa != null && obj.isa.length() > 0) {
                    this.isa = obj.isa;
                }
                if (obj.procId != 0L) {
                    this.procId = obj.procId;
                }
                if (!obj.debuggable) {
                    this.debuggable = false;
                }
                this.description = obj.description;
                this.driverFilename = obj.driverFilename;
                this.multiProcessorSupport = obj.multiProcessorSupport;
            }
        }

        boolean isDebuggable() {
            return this.debuggable;
        }

        boolean isRouter() {
            return new ProcessorID(this.procId).isRouter();
        }

        boolean isMultiProcessor() {
            return this.multiProcessorSupport;
        }

        boolean isMultiBoard(String driverLocation) {
            return this.driverFilename == null ? true : this.driverFilename.compareTo(driverLocation) == 0;
        }

        String getDriverLocation() {
            return this.driverFilename;
        }

        public String toString() {
            return "Driver for " + this.isa;
        }
    }

    public static class SystemRoot
    extends AbstractSystemSetupComponent {
        @Override
        public String getName() {
            return "System";
        }

        @Override
        public String getIconDescriptor() {
            return "system";
        }
    }

    public static class Device
    extends AbstractSystemSetupComponent {
        private String fileName;
        private String partnum;

        Device(CpuIdentifier id, String name, String fileName, String partnum) {
            this.id = id;
            this.name = name == null || name.length() == 0 ? null : name;
            this.fileName = fileName;
            this.partnum = partnum;
        }

        Device(Device copyFrom) {
            this.assign(copyFrom);
        }

        private void assign(Device from) {
            if (from != null) {
                super.assign(from);
                this.partnum = from.partnum;
            }
        }

        Map<String, String> getProperties(IHardwareDbCachedFile cacheFile, String fileName, String[] installDirectories) {
            ArrayList<Property> properties = cacheFile.getListOfProperties(this.id, false, fileName, installDirectories);
            if (properties != null) {
                return Property.getProperties(properties, null);
            }
            return Collections.unmodifiableMap(new HashMap());
        }

        String getFileName() {
            return this.fileName;
        }

        String getPartNumber() {
            return this.partnum;
        }

        @Override
        public String getIconDescriptor() {
            return "device";
        }
    }

    public static class Connection
    extends AbstractSystemSetupComponent {
        private String connectionName;
        private String connectionType;
        private ArrayList<Driver> drivers;

        private Connection(String name, String connectionType, String connectionName, CpuIdentifier id) {
            this.name = name == null || name.length() == 0 ? null : name;
            this.id = id;
            this.connectionName = connectionName == null || connectionName.length() == 0 ? null : connectionName;
            this.connectionType = connectionType == null || connectionType.length() == 0 ? null : connectionType;
        }

        private Connection(Connection copy) {
            this.name = null;
            this.connectionName = null;
            this.connectionType = null;
            this.assign(copy);
        }

        private void assign(Connection from) {
            if (from != null) {
                super.assign(from);
                if (this.connectionName == null) {
                    this.connectionName = from.connectionName;
                }
                if (this.connectionType == null) {
                    this.connectionType = from.connectionType;
                }
            }
        }

        private void addDriver(Driver driver) {
            if (this.drivers == null) {
                this.drivers = new ArrayList(3);
            }
            for (Driver item : this.drivers) {
                if (item.id.compareTo(driver.id) != 0) continue;
                item.assign(driver);
                return;
            }
            this.drivers.add(driver);
        }

        private Driver findDriver(String isaType) {
            if (this.drivers != null) {
                for (Driver driver : this.drivers) {
                    if (driver.isa == null || !HardwareDatabaseReader.isCompatibleISA(driver.isa, isaType)) continue;
                    return driver;
                }
            }
            return null;
        }

        private static Connection findConnectionInList(ArrayList<ISystemSetupComponent> setupElements, CpuIdentifier setupElementId) {
            ISystemSetupComponent connection = AbstractSystemSetupComponent.findElementInList(setupElements, setupElementId);
            if (connection != null && connection instanceof Connection) {
                return (Connection)connection;
            }
            return null;
        }

        @Override
        public String getIconDescriptor() {
            return "connection";
        }
    }

    public static class Board
    extends AbstractSystemSetupComponent {
        private Board(String name, CpuIdentifier id) {
            this.name = name == null || name.length() == 0 ? null : name;
            this.id = id;
        }

        Map<String, String> getProperties(IHardwareDbCachedFile cacheFile, String fileName, String[] installDirectories) {
            ArrayList<Property> properties = cacheFile.getListOfProperties(this.id, false, fileName, installDirectories);
            if (properties != null) {
                return Property.getProperties(properties, null);
            }
            return Collections.unmodifiableMap(new HashMap());
        }

        @Override
        public String getIconDescriptor() {
            return "board";
        }
    }

    static abstract class AbstractSystemSetupComponent
    implements ISystemSetupComponent,
    Serializable {
        protected String name;
        protected CpuIdentifier id;
        private transient ArrayList<ISystemSetupComponent> children = null;

        AbstractSystemSetupComponent() {
        }

        @Override
        public String getName() {
            return this.name == null || this.name.length() == 0 ? (this.id == null ? "" : this.id.id) : this.name;
        }

        @Override
        public String getDecoratedLabelText() {
            return this.getName();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public ArrayList<ISystemSetupComponent> getChildren() {
            return this.children;
        }

        void addChild(ISystemSetupComponent child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        AbstractSystemSetupComponent findParent(ArrayList<ISystemSetupComponent> elements) {
            int highScore = Integer.MAX_VALUE;
            AbstractSystemSetupComponent result = null;
            for (ISystemSetupComponent element : elements) {
                int score = this.id.isChildOf(((AbstractSystemSetupComponent)element).id);
                if (score <= 0 || score >= highScore) continue;
                highScore = score;
                result = (AbstractSystemSetupComponent)element;
            }
            return result;
        }

        protected void assign(AbstractSystemSetupComponent from) {
            if (from != null) {
                this.id = from.id;
                if (from.name != null && from.name.length() > 0) {
                    this.name = from.name;
                }
            }
        }

        protected static ISystemSetupComponent findElementInList(ArrayList<ISystemSetupComponent> setupElements, CpuIdentifier setupElementId) {
            for (ISystemSetupComponent setupElement : setupElements) {
                if (((AbstractSystemSetupComponent)setupElement).id.compareTo(setupElementId) != 0) continue;
                return setupElement;
            }
            return null;
        }

        @Override
        public abstract String getIconDescriptor();
    }

    private static class CpuIdentifier
    implements Comparable<CpuIdentifier>,
    Serializable {
        private String id;
        private CpuIdentifier parent;

        CpuIdentifier(String id, CpuIdentifier parent) {
            this.id = id == null ? "" : id;
            this.parent = parent != null && parent.id.length() == 0 ? parent.parent : parent;
        }

        CpuIdentifier(CpuIdentifier copy, CpuIdentifier newParent) {
            if (copy == null || copy.id.length() == 0) {
                if (newParent == null) {
                    this.id = "";
                    this.parent = null;
                } else {
                    this.id = newParent.id;
                    this.parent = newParent.parent;
                }
            } else {
                this.id = copy.id;
                this.parent = newParent;
                CpuIdentifier prev = null;
                CpuIdentifier cur = copy.parent;
                while (cur != null) {
                    CpuIdentifier tmp = new CpuIdentifier(cur.id, newParent);
                    if (prev != null) {
                        prev.parent = tmp;
                    } else {
                        this.parent = tmp;
                    }
                    prev = tmp;
                    cur = cur.parent;
                }
            }
        }

        public CpuIdentifier(CpuIdentifier copy, int num_parents) {
            CpuIdentifier cur = this;
            cur.id = copy.id;
            cur.parent = null;
            int i = num_parents;
            while (i-- > 0) {
                cur = cur.parent = new CpuIdentifier(copy.parent.id, null);
                copy = copy.parent;
            }
        }

        @Override
        public int compareTo(CpuIdentifier to) {
            if (to == null) {
                return (this.id == null || this.id.length() == 0) && this.parent == null ? 0 : 1;
            }
            int result = this.id.compareTo(to.id);
            if (result == 0) {
                result = this.parent == null ? (to.parent == null ? 0 : -1) : (to.parent == null ? 1 : this.parent.compareTo(to.parent));
            }
            return result;
        }

        public int isChildOf(CpuIdentifier obj) {
            int result = 0;
            if (obj == null) {
                return result;
            }
            CpuIdentifier cur = this.parent;
            while (cur != null) {
                ++result;
                if (obj.compareTo(cur) == 0) {
                    return result;
                }
                cur = cur.parent;
            }
            return 0;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.id);
            CpuIdentifier cur = this.parent;
            while (cur != null) {
                result.append('.');
                result.append(cur.id);
                cur = cur.parent;
            }
            return result.toString();
        }
    }

    public static interface ISystemSetupFileStamp
    extends Comparable<ISystemSetupFileStamp> {
    }

    public static class ErrorReport
    implements Comparable<ErrorReport> {
        private String errorMessage;
        private String location;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getLocation() {
            return this.location;
        }

        protected ErrorReport(String errorMessage, String location) {
            this.location = location;
            this.errorMessage = errorMessage;
        }

        @Override
        public int compareTo(ErrorReport errorReport) {
            int result = this.errorMessage.compareTo(errorReport.errorMessage);
            if (result == 0) {
                result = this.location == null ? (errorReport.location == null ? 0 : -1) : (errorReport.location == null ? (this.location == null ? 0 : 1) : this.location.compareTo(errorReport.location));
            }
            return result;
        }
    }

    static interface IHardwareDbCachedFile {
        public ArrayList<ISystemSetupComponent> getSetupElements(String var1, String var2, String[] var3) throws HardwareDbException;

        public ArrayList<Connection> getConnections(String var1, String[] var2) throws HardwareDbException;

        public ArrayList<Property> getListOfProperties(CpuIdentifier var1, boolean var2, String var3, String[] var4);

        public String getRootId();

        public String getDevicePartNum();

        public boolean doesDeviceHaveProcessorsTag();

        public ArrayList<File> getInstances(String var1, String var2, String[] var3) throws HardwareDbException;
    }
}

