/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.HardwareDatabaseReader;
import com.ti.debug.engine.scripting.setup.HardwareDbException;
import com.ti.debug.engine.scripting.setup.IFlatSystemSetupFile;
import com.ti.debug.engine.scripting.setup.ProcessorID;
import com.ti.debug.engine.scripting.setup.SystemSetupReader;
import com.ti.debug.engine.scripting.setup.Tag;
import com.ti.debug.engine.scripting.setup.XMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Node;

public class SystemSetupWriter
extends SystemSetupReader {
    private ComponentList devices;
    private ComponentList boards;
    private ComponentList configurations;
    private HashMap<String, DriverInfo> drivers;
    private ConnectionList connections;
    private ISelectDriverCallback selectDriverCallbackHandler = null;

    public Set<String> getListOfISAs() {
        HashMap<String, DriverInfo> drivers = this.getListOfDrivers();
        LinkedHashSet<String> isas = new LinkedHashSet<String>();
        for (DriverInfo driverInfo : drivers.values()) {
            isas.addAll(driverInfo.isas);
        }
        return isas;
    }

    public Set<String> getListOfISAs(String connectionType) {
        if (connectionType == null || connectionType.length() == 0) {
            return this.getListOfISAs();
        }
        HashMap<String, DriverInfo> drivers = this.getListOfDrivers();
        DriverInfo driver = drivers.get(connectionType);
        if (driver == null) {
            return new LinkedHashSet<String>();
        }
        return driver.isas;
    }

    private List<SetupItem> getListOfDrivers(String connectionType) {
        HashMap<String, DriverInfo> drivers = this.getListOfDrivers();
        if (connectionType == null) {
            ArrayList<SetupItem> allDrivers = new ArrayList<SetupItem>();
            for (DriverInfo driverList : drivers.values()) {
                allDrivers.addAll(driverList.drivers);
            }
            return allDrivers;
        }
        DriverInfo driverInfo = drivers.get(connectionType);
        return driverInfo == null ? null : driverInfo.drivers;
    }

    private synchronized HashMap<String, DriverInfo> getListOfDrivers() {
        if (this.drivers == null) {
            this.drivers = new HashMap();
            try {
                File curDir = new File(this.getUserDirectory());
                File installDir = new File(this.getTargetDbDirectory() + "drivers");
                File[] curFiles = curDir.listFiles();
                int j = 0;
                while (j++ < 2) {
                    for (int i = 0; curFiles != null && i < curFiles.length; ++i) {
                        if (!curFiles[i].getName().endsWith(".xml")) continue;
                        try {
                            SystemSetupReader.HardwareDbFileInfo driverFile = this.getHardwareDbFileInfo(curFiles[i].getAbsolutePath());
                            if (driverFile.rootTagName.compareTo("drivers") != 0) continue;
                            SystemSetupReader.HardwareDbFileInfo.IDriverIterator it = driverFile.getDrivers();
                            while (it.next()) {
                                ProcessorID nProcessorID = new ProcessorID(it.getProcId());
                                nProcessorID.setRevision(255L);
                                SetupItem component = new SetupItem();
                                component.fileName = curFiles[i].getAbsolutePath();
                                component.name = it.getName();
                                component.connectionType = it.getConnectionType();
                                component.isa = nProcessorID.toString();
                                component.description = it.getDescription();
                                if (component.connectionType == null || component.name == null) continue;
                                DriverInfo driverList = this.drivers.get(component.connectionType);
                                if (driverList == null) {
                                    driverList = new DriverInfo();
                                    this.drivers.put(component.connectionType, driverList);
                                }
                                driverList.drivers.add(component);
                                if (nProcessorID.getType() >= 4L) continue;
                                driverList.isas.add(nProcessorID.toString());
                            }
                            continue;
                        }
                        catch (HardwareDbException e) {
                            // empty catch block
                        }
                    }
                    curFiles = installDir.listFiles();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.drivers;
    }

    public synchronized IComponentList getListOfConnections() {
        if (this.connections == null) {
            this.connections = new ConnectionList("connection");
        }
        return this.connections;
    }

    public ArrayList<SetupItem> getFilteredListOfConnections(SetupItem boardOrDevice) {
        List<SetupItem> connections = this.getListOfConnections().getComponents();
        ArrayList<SetupItem> result = new ArrayList<SetupItem>(connections.size());
        for (SetupItem connection : connections) {
            if (connection.connectionType != null) {
                if (connection.connectionType.compareTo("TISIM") != 0 ? boardOrDevice.componentType == SetupItem.Type.SIM_DEVICE : boardOrDevice.componentType == SetupItem.Type.EMU_DEVICE) continue;
                if (boardOrDevice.componentType == SetupItem.Type.CONFIGURATION && boardOrDevice.name.contains("Simulator") && connection.connectionType.compareTo("TISIM") != 0) continue;
            }
            if (this.addDeviceDrivers(null, connection.connectionType, boardOrDevice, null) != null) continue;
            result.add(connection);
        }
        return result;
    }

    public synchronized IComponentList getListOfDevices() {
        if (this.devices == null) {
            this.devices = new ComponentList("device");
        }
        return this.devices;
    }

    public synchronized IComponentList getListOfBoards() {
        if (this.boards == null) {
            this.boards = new ComponentList("board");
        }
        return this.boards;
    }

    public synchronized IComponentList getListOfConfigurations() {
        if (this.configurations == null) {
            this.configurations = new ComponentList("configuration");
        }
        return this.configurations;
    }

    public SetupItem findBoard(String boardFilePath) {
        if (boardFilePath == null || boardFilePath.length() == 0) {
            return null;
        }
        return this.getListOfBoards().findComponent(boardFilePath);
    }

    public SetupItem findDevice(String deviceFilePath) {
        if (deviceFilePath == null || deviceFilePath.length() == 0) {
            return null;
        }
        return this.getListOfDevices().findComponent(deviceFilePath);
    }

    public SetupItem findConnection(String connectionFilePath) {
        if (connectionFilePath == null || connectionFilePath.length() == 0) {
            return null;
        }
        return this.getListOfConnections().findComponent(connectionFilePath);
    }

    public ArrayList<SystemSetupReader.Cpu> filterListOfCpus(ArrayList<SystemSetupReader.Cpu> allCpus, String isaFilter, String connectionType) {
        ArrayList<SystemSetupReader.Cpu> result = allCpus;
        if (allCpus != null && (connectionType != null || isaFilter != null)) {
            result = new ArrayList(allCpus.size());
            List<SetupItem> driverList = this.getListOfDrivers(connectionType);
            ArrayList<SetupItem> foundDrivers = new ArrayList<SetupItem>();
            if (driverList != null) {
                for (SetupItem driver : driverList) {
                    if (driver.isa == null || !HardwareDatabaseReader.isCompatibleISA(driver.isa, isaFilter)) continue;
                    foundDrivers.add(driver);
                }
            }
            block1: for (SystemSetupReader.Cpu cpu : allCpus) {
                for (SetupItem driver : foundDrivers) {
                    if (!HardwareDatabaseReader.isCompatibleISA(cpu.isa, driver.name)) continue;
                    result.add(cpu);
                    continue block1;
                }
            }
        }
        return result;
    }

    private List<SetupItem> findDeviceDriver(String connectionType, String isaName) {
        ArrayList<SetupItem> foundDrivers = new ArrayList<SetupItem>();
        List<SetupItem> driverList = this.getListOfDrivers(connectionType);
        if (driverList != null) {
            for (SetupItem driver : driverList) {
                if (!HardwareDatabaseReader.isCompatibleISA(driver.name, isaName)) continue;
                foundDrivers.add(driver);
            }
        }
        return foundDrivers;
    }

    protected String addDeviceDriver(Tag connection, File relDriverXmlFile, File absDriverXmlFile) {
        Node insertBefore = connection.getChildByName("connectionType", 0);
        if (insertBefore == null) {
            insertBefore = connection.getChildByName("property", 0);
        }
        if (insertBefore == null) {
            insertBefore = connection.getChildByName("drivers", 0);
        }
        if (insertBefore == null) {
            insertBefore = connection.getChildByName("platform", 0);
        }
        HardwareDatabaseReader.includeFile(connection, relDriverXmlFile, "drivers", null, insertBefore);
        return null;
    }

    String addDeviceDrivers(Tag connection, String connectionType, SetupItem boardOrDevice, File[] relativeTo) {
        ArrayList<SystemSetupReader.Cpu> cpus = null;
        try {
            cpus = this.getFilteredListOfCpus(boardOrDevice.fileName, null);
        }
        catch (HardwareDbException e) {
            return "Device or Board xml file contains errors\n" + e.getMessage() + "\nPlease select a different device or board";
        }
        if (cpus == null) {
            return "Device or Board does not contain any debuggable CPU's\nPlease select a different device or board";
        }
        HashSet<String> driversAlreadyIncluded = new HashSet<String>(3);
        for (int i = 0; i < cpus.size(); ++i) {
            SystemSetupReader.Cpu cpu = cpus.get(i);
            if (cpu.isBypassed()) continue;
            Node isa = null;
            try {
                if (connection != null) {
                    isa = HardwareDatabaseReader.getISA(connection, cpu.isa);
                }
            }
            catch (HardwareDbException e) {
                // empty catch block
            }
            if (isa != null) continue;
            List<SetupItem> driversToPickFrom = this.findDeviceDriver(connectionType, cpu.isa);
            if (driversToPickFrom.size() == 0) {
                return "Unable to find an appropriate device driver for the connection type \"" + connectionType + "\" and isa \"" + cpu.isa + "\"";
            }
            SetupItem driverXmlFilename = driversToPickFrom.get(0);
            if (driversToPickFrom.size() > 1 && this.selectDriverCallbackHandler != null && connection != null) {
                driverXmlFilename = this.selectDriverCallbackHandler.selectDriver(driversToPickFrom);
            }
            if (driverXmlFilename == null) {
                return "User Aborted";
            }
            if (connection == null || driversAlreadyIncluded.contains(driverXmlFilename.fileName)) continue;
            driversAlreadyIncluded.add(driverXmlFilename.fileName);
            File driverXmlFile = new File(driverXmlFilename.fileName);
            String errMsg = this.addDeviceDriver(connection, SystemSetupWriter.getRelativePath(driverXmlFile, relativeTo), driverXmlFile);
            if (errMsg == null) continue;
            return errMsg;
        }
        return null;
    }

    public String createNewConfiguration(String xmlFilename, SetupItem connection, SetupItem boardOrDevice) {
        try {
            return this.createNewConfiguration(new FileOutputStream(xmlFilename), xmlFilename, connection, boardOrDevice);
        }
        catch (FileNotFoundException e) {
            return e.getLocalizedMessage();
        }
    }

    public String createNewConfiguration(OutputStream outputStream, String xmlFilename, SetupItem connection, SetupItem boardOrDevice) {
        int nRootDirectories = this.getRootDirectories().length;
        File[] relativeTo = new File[nRootDirectories + 1];
        relativeTo[0] = new File(xmlFilename).getParentFile();
        for (int i = 0; i < nRootDirectories; ++i) {
            relativeTo[i + 1] = new File(this.getRootDirectories()[i]);
        }
        Tag configuration = HardwareDatabaseReader.newConfig(boardOrDevice.componentType != SetupItem.Type.CONFIGURATION);
        if (boardOrDevice.componentType == SetupItem.Type.CONFIGURATION) {
            HardwareDatabaseReader.includeFile(configuration, SystemSetupWriter.getRelativePath(new File(boardOrDevice.fileName), relativeTo), "configuration_0", null, configuration.getChildByName("configuration", 0));
        } else {
            HardwareDatabaseReader.includeFile(configuration, SystemSetupWriter.getRelativePath(new File(connection.fileName), relativeTo), connection.name, connection.name, configuration.getChildByName("connection", 0));
            Tag emulator = new Tag(configuration, configuration.createChild("connection", connection.name, "1.2"));
            String errMsg = this.addDeviceDrivers(emulator, connection.connectionType, boardOrDevice, relativeTo);
            if (errMsg != null) {
                return errMsg;
            }
            Tag platform = new Tag(emulator, emulator.createChild("platform", 0, "1.2"));
            HardwareDatabaseReader.includeFile(platform, SystemSetupWriter.getRelativePath(new File(boardOrDevice.fileName), relativeTo), boardOrDevice.name, boardOrDevice.name, null);
            try {
                HardwareDatabaseReader flatFileGenerator = new HardwareDatabaseReader();
                flatFileGenerator.addTagsToFilter(new String[]{"connection", "platform", "board", "processors", "cpu", "device", "router", "subpath", "property", "choice", "jtag"});
                flatFileGenerator.addAttributesToFilter(new String[]{"id", "desc", "Name", "Value", "value", "Type", "ID"});
                Tag flatConfiguation = flatFileGenerator.convertToFlatFile(configuration, xmlFilename, this.getRootDirectories());
                Node flatConnection = flatConfiguation.getChildByName("connection", 0);
                if (flatConnection != null) {
                    this.setDefaultJtagProperties(new Tag(flatConfiguation, flatConnection), emulator);
                }
            }
            catch (HardwareDbException e) {
                // empty catch block
            }
        }
        configuration.writeXMLDocument(outputStream);
        return null;
    }

    public static File getRelativePath(File absPath, File[] relativeTo) {
        try {
            String absFile = absPath.getCanonicalPath();
            String commonRoot = "";
            int upDirCount = 0;
            int i = relativeTo.length;
            while (i-- > 0) {
                int tmpDirCount = 0;
                File tmpRoot = relativeTo[i].getCanonicalFile();
                while (tmpRoot != null && !absFile.startsWith(tmpRoot.getPath())) {
                    tmpRoot = tmpRoot.getParentFile();
                    ++tmpDirCount;
                }
                if (tmpRoot == null || tmpRoot.getPath().length() <= commonRoot.length() && (tmpRoot.getPath().length() != commonRoot.length() || tmpDirCount >= upDirCount)) continue;
                upDirCount = tmpDirCount;
                commonRoot = tmpRoot.getPath();
            }
            StringBuilder result = new StringBuilder();
            if (commonRoot.length() > 0) {
                while (upDirCount-- > 0) {
                    result.append(".." + File.separator);
                }
                if ((absFile = absFile.substring(commonRoot.length())).startsWith(File.separator)) {
                    absFile = absFile.substring(File.separator.length());
                }
            }
            result.append(absFile);
            return new File(result.toString());
        }
        catch (IOException e) {
            return absPath;
        }
    }

    private static void createCpuXmlFile(String isaType, String location) {
        XMLParser parser;
        Node root;
        File xmlFile;
        String cpuName = isaType.trim();
        if (cpuName.startsWith("TMS320")) {
            cpuName = cpuName.substring(6);
        }
        if (!(xmlFile = new File(location + "/new/" + cpuName.toLowerCase() + ".xml")).exists() && (root = (parser = new XMLParser()).CreateNewDocument("cpu")) != null) {
            Tag cpu = new Tag(parser, root);
            cpu.setAttribute("id", cpuName);
            cpu.setAttribute("XML_version", "1.2");
            cpu.setAttribute("HW_revision", "1.0");
            cpu.setAttribute("isa", isaType);
            cpu.writeXMLDocument(xmlFile.getPath());
        }
    }

    protected void setDefaultJtagProperties(Tag connectionDefaults, Tag connectionOverrides) {
        Node platformNode = connectionDefaults.getChildByName("platform", 0);
        if (platformNode != null) {
            Tag platform = new Tag(connectionDefaults, platformNode);
            this.setDefaultJtagPropertyForDevices(platform, connectionDefaults, connectionOverrides);
        }
    }

    private void setDefaultJtagPropertyForDevices(Tag parent, Tag connectionDefaults, Tag connectionOverrides) {
        if (parent != null) {
            for (Node deviceNode = parent.getFirstChild(); deviceNode != null; deviceNode = deviceNode.getNextSibling()) {
                Tag device = new Tag(parent, deviceNode);
                Node jtagNode = device.getChildByName("jtag", 0);
                if (jtagNode != null) {
                    this.setDefaultJtagProperties(connectionDefaults, connectionOverrides, new Tag(device, jtagNode));
                }
                this.setDefaultJtagPropertyForDevices(device, connectionDefaults, connectionOverrides);
            }
        }
    }

    private void setDefaultJtagProperties(Tag connectionDefaults, Tag connectionOverrides, Tag jtagDefaults) {
        int nProperties = connectionDefaults.countChildrenByName("property");
        for (int i = 0; i < nProperties; ++i) {
            Node jtagDefaultChoiceNode;
            long choice;
            Node connectionDefaultChoiceNode;
            Node connectionOverrideNode;
            String ID;
            Node jtagDefaultNode;
            String idAttribute;
            Tag connectionDefault = new Tag(connectionDefaults, connectionDefaults.getChildByName("property", i));
            String id = connectionDefault.getAttribute(idAttribute = "id");
            if (id == null || id.length() == 0) {
                idAttribute = "Name";
                id = connectionDefault.getAttribute(idAttribute);
            }
            if ((jtagDefaultNode = jtagDefaults.getChildByID("property", id)) == null && (ID = connectionDefault.getAttribute("ID")) != null && ID.length() > 0) {
                jtagDefaultNode = jtagDefaults.getChildByID("property", ID);
            }
            if (jtagDefaultNode == null || (connectionOverrideNode = connectionOverrides.getChildByID("property", id, idAttribute)) != null) continue;
            Tag jtagDefault = new Tag(jtagDefaults, jtagDefaultNode);
            String value = jtagDefault.getAttribute("Value");
            String type = jtagDefault.getAttribute("Type");
            value = value.trim();
            if (type.compareTo("choicelist") == 0 && !Character.isDigit(value.charAt(0))) {
                int choice2 = connectionDefault.getChildIndexByID("choice", value, "value");
                if (choice2 < 0) continue;
                value = Integer.toString(choice2);
            }
            connectionDefault.setAttribute("Value", value);
            connectionDefault.setAttribute("Type", type);
            connectionOverrideNode = connectionOverrides.createChild("property", id, null);
            Tag connectionOverride = new Tag(connectionOverrides, connectionOverrideNode);
            connectionOverride.setAttribute("Value", value);
            connectionOverride.setAttribute("Type", type);
            if (type.compareTo("choicelist") != 0 || (connectionDefaultChoiceNode = connectionDefault.getChildByName("choice", (int)(choice = connectionDefault.getAttributeInteger("Value").longValue()))) == null) continue;
            Tag connectionDefaultChoice = new Tag(connectionDefault, connectionDefaultChoiceNode);
            idAttribute = "Name";
            id = connectionDefaultChoice.getAttribute(idAttribute);
            if (id == null || id.length() == 0) {
                idAttribute = "value";
                id = connectionDefaultChoice.getAttribute(idAttribute);
            }
            if ((jtagDefaultChoiceNode = jtagDefault.getChildByID("choice", id, idAttribute)) == null) continue;
            Tag connectionOverrideChoice = new Tag(connectionOverride, connectionOverride.createChild("choice", null, null));
            connectionOverrideChoice.copyAttribute(connectionDefaultChoice, "value");
            connectionOverrideChoice.copyAttribute(connectionDefaultChoice, "Name");
            this.setDefaultJtagProperties(connectionDefaultChoice, connectionOverrideChoice, new Tag(jtagDefault, jtagDefaultChoiceNode));
        }
    }

    public void setSelectDriverCallbackHandler(ISelectDriverCallback handler) {
        this.selectDriverCallbackHandler = handler;
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 1) {
            System.out.println("Usage: SystemSetupWriter systemSetupDir hwDataBaseDir");
        } else {
            Set<String> isaList;
            String errorMsg;
            File[] fileArray;
            long startTime = System.currentTimeMillis();
            SystemSetupWriter setup = new SystemSetupWriter();
            setup.setInstallDirectory(args.length == 2 ? args[1] : null);
            File systemSetupDir = new File(args[0]);
            setup.setUserDirectory(systemSetupDir.getAbsolutePath());
            setup.loadHardwareDatabaseCache();
            long loadTime = System.currentTimeMillis();
            if (systemSetupDir.isDirectory()) {
                fileArray = setup.getListOfSetupXMLFiles(args[0]);
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = systemSetupDir;
            }
            File[] setupFiles = fileArray;
            if (setupFiles == null) {
                System.out.println("No system setup xml files found in directory " + args[0]);
            } else {
                for (int i = 0; i < setupFiles.length; ++i) {
                    System.out.println("System Setup xml file " + setupFiles[i]);
                    try {
                        ArrayList<SystemSetupReader.Cpu> debuggableCpus = setup.getListOfCpus(setupFiles[i].getPath(), false);
                        if (debuggableCpus == null || debuggableCpus.size() == 0) {
                            System.out.println("\tThere are no Debuggable Cpus.");
                            continue;
                        }
                        for (int j = 0; j < debuggableCpus.size(); ++j) {
                            System.out.println("\t" + debuggableCpus.get(j).toString());
                        }
                        Map<String, String> deviceProperties = setup.getDeviceProperties(setupFiles[i].getPath(), null);
                        if (deviceProperties == null || deviceProperties.size() == 0) continue;
                        System.out.println("\tDevice Properties");
                        Set<String> propNames = deviceProperties.keySet();
                        for (String name : propNames) {
                            System.out.println("\t\t" + name + " = " + deviceProperties.get(name).toString());
                        }
                        continue;
                    }
                    catch (HardwareDbException e) {
                        System.out.print("\tError Parsing file (");
                        System.out.print(setupFiles[i].getPath());
                        System.out.print(" @ line ");
                        System.out.print(Integer.toString(e.getLineNumber()));
                        System.out.print(")\n\t\t");
                        System.out.println(e.getMessage());
                    }
                }
            }
            List<SetupItem> connections = setup.getListOfConnections().getComponents();
            if (connections.size() == 0) {
                System.out.println("No Connections Found");
            } else {
                System.out.println("Available Connections");
                for (int i = 0; i < connections.size(); ++i) {
                    System.out.println("\t" + connections.get(i).toString());
                }
            }
            List<SetupItem> devices = setup.getListOfDevices().getComponents();
            if (devices.size() == 0) {
                System.out.println("No Devices Found");
            } else {
                System.out.println("Available Devices");
                for (int i = 0; i < devices.size(); ++i) {
                    System.out.println("\t" + devices.get(i).toString());
                }
            }
            List<SetupItem> deviceDrivers = setup.getListOfDrivers(null);
            if (deviceDrivers.size() == 0) {
                System.out.println("No Drivers Found");
            } else {
                System.out.println("Device Drivers");
                for (int i = 0; i < deviceDrivers.size(); ++i) {
                    System.out.println("\t" + deviceDrivers.get(i).toString() + " - " + deviceDrivers.get((int)i).connectionType);
                }
            }
            if (connections.size() > 0 && devices.size() > 0 && (errorMsg = setup.createNewConfiguration(setup.getUserDirectory() + "/systemSetupTest.xml", connections.get(connections.size() - 1), devices.get(devices.size() - 5))) != null) {
                System.out.println("Trouble writing system setup XML file\n\t" + errorMsg);
            }
            if ((isaList = setup.getListOfISAs()).size() == 0) {
                System.out.println("No ISAs found");
            } else {
                System.out.println("ISAs");
                for (String isa : isaList) {
                    System.out.println("\t" + isa);
                    if (args.length != 2) continue;
                    SystemSetupWriter.createCpuXmlFile(isa, args[1] + "/TargetDB/Cpus");
                }
            }
            long endTime = System.currentTimeMillis();
            System.out.format("\nElapsed Time = %d milliseconds", endTime - startTime);
            System.out.format(" (load time = %d milliseconds)\n", loadTime - startTime);
            setup.storeHardwareDatabaseCache();
        }
    }

    private static class DriverInfo {
        private ArrayList<SetupItem> drivers = new ArrayList();
        private TreeSet<String> isas = new TreeSet();

        private DriverInfo() {
        }
    }

    public static interface ISelectDriverCallback {
        public SetupItem selectDriver(List<SetupItem> var1);
    }

    private class ConnectionList
    extends ComponentList {
        ConnectionList(String componentName) {
            super(componentName);
        }

        @Override
        public ArrayList<SetupItem> getFilteredListOfComponents(String byIsa, String byConnectionType, String byConnectionName) {
            if (byIsa == null && byConnectionType == null) {
                return this.getComponents();
            }
            HashMap drivers = SystemSetupWriter.this.getListOfDrivers();
            LinkedHashSet<String> connectionTypes = new LinkedHashSet<String>();
            if (byIsa == null) {
                connectionTypes.add(byConnectionType);
            } else {
                for (String connectType : drivers.keySet()) {
                    DriverInfo driverList;
                    if (byConnectionType != null) {
                        connectType = byConnectionType;
                    }
                    if ((driverList = (DriverInfo)drivers.get(connectType)) != null) {
                        for (SetupItem driver : driverList.drivers) {
                            if (!HardwareDatabaseReader.isCompatibleISA(driver.isa, byIsa)) continue;
                            connectionTypes.add(driver.connectionType);
                            break;
                        }
                    }
                    if (byConnectionType == null) continue;
                    break;
                }
            }
            ArrayList<SetupItem> retVal = new ArrayList<SetupItem>();
            List connections = this.getComponents();
            for (int i = 0; i < ((ArrayList)connections).size(); ++i) {
                if (!connectionTypes.contains(((SetupItem)((ArrayList)connections).get((int)i)).connectionType)) continue;
                retVal.add((SetupItem)((ArrayList)connections).get(i));
            }
            return retVal;
        }
    }

    protected class ComponentList
    implements IComponentList {
        private ArrayList<SetupItem> components;
        private Map<File, SetupItem> componentIndex;
        private String componentName;
        private SetupItem.Type componentType;

        ComponentList(String componentName) {
            this.SetComponentName(componentName);
            this.initialize();
        }

        private void initialize() {
            try {
                this.components = new ArrayList();
                this.componentIndex = new HashMap<File, SetupItem>();
                File curDir = new File(SystemSetupWriter.this.getUserDirectory());
                File installDir = new File(SystemSetupWriter.this.getTargetDbDirectory() + this.componentName + "s");
                LinkedHashSet<File> dirs = new LinkedHashSet<File>();
                if (curDir.exists()) {
                    dirs.add(curDir);
                }
                if (installDir.exists()) {
                    dirs.add(installDir);
                }
                for (File dir : dirs) {
                    File[] curFiles = dir.listFiles();
                    for (int i = 0; i < curFiles.length; ++i) {
                        if (!curFiles[i].getName().endsWith(".xml")) continue;
                        try {
                            this.addToListSorted(curFiles[i], false);
                            continue;
                        }
                        catch (HardwareDbException e) {
                            // empty catch block
                        }
                    }
                }
                Collections.sort(this.components);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private void SetComponentName(String componentName) {
            this.componentName = componentName;
            this.componentType = componentName.compareTo("configuration") == 0 ? SetupItem.Type.CONFIGURATION : (componentName.compareTo("connection") == 0 ? SetupItem.Type.CONNECTION : (componentName.compareTo("board") == 0 ? SetupItem.Type.BOARD : (componentName.compareTo("cpu") == 0 ? SetupItem.Type.CPU : (componentName.compareTo("device") == 0 ? SetupItem.Type.DEVICE : (componentName.compareTo("router") == 0 ? SetupItem.Type.ROUTER : (componentName.compareTo("driver") == 0 ? SetupItem.Type.DRIVER : null))))));
        }

        public ArrayList<SetupItem> getComponents() {
            return this.components;
        }

        @Override
        public SetupItem findComponent(String componentFileName) {
            return this.componentIndex.get(new File(componentFileName));
        }

        public ArrayList<SetupItem> getFilteredListOfComponents(String isa, String connectionType) {
            return this.getFilteredListOfComponents(isa, connectionType, null);
        }

        public ArrayList<SetupItem> getFilteredListOfComponents(String isa, String connectionType, String connectionName) {
            if (isa == null && connectionType == null) {
                return this.components;
            }
            ArrayList<SetupItem> retVal = new ArrayList<SetupItem>();
            for (int i = 0; i < this.components.size(); ++i) {
                SetupItem component = this.components.get(i);
                if (connectionType != null && (connectionType.compareTo("TISIM") != 0 ? component.componentType == SetupItem.Type.SIM_DEVICE : component.componentType == SetupItem.Type.EMU_DEVICE) || component.fileName == null) continue;
                ArrayList<SystemSetupReader.Cpu> cpus = null;
                try {
                    cpus = SystemSetupWriter.this.getFilteredListOfCpus(component.fileName, connectionName);
                }
                catch (HardwareDbException e) {
                    cpus = null;
                }
                if (cpus == null || cpus.size() <= 0) continue;
                boolean keep = isa == null;
                int j = cpus.size();
                while (j-- > 0) {
                    SystemSetupReader.Cpu cpu = cpus.get(j);
                    if (keep && connectionType == null || cpu.isBypassed() || cpu.isSubpath()) continue;
                    List drivers = SystemSetupWriter.this.findDeviceDriver(connectionType, cpu.isa);
                    if (drivers.size() == 0) {
                        keep = false;
                        break;
                    }
                    for (int n = 0; !keep && n < drivers.size(); ++n) {
                        if (!HardwareDatabaseReader.isCompatibleISA(((SetupItem)drivers.get((int)n)).isa, isa)) continue;
                        keep = true;
                    }
                }
                if (!keep) continue;
                retVal.add(component);
            }
            return retVal;
        }

        @Override
        public SetupItem addToList(File file) throws HardwareDbException {
            return this.addToListSorted(file, true);
        }

        private SetupItem addToListSorted(File file, boolean sort) throws HardwareDbException {
            SetupItem component = this.componentIndex.get(file);
            if (component != null) {
                return component;
            }
            String filename = file.getAbsolutePath();
            SystemSetupReader.HardwareDbFileInfo cachedFile = SystemSetupWriter.this.getHardwareDbFileInfo(filename);
            if (cachedFile != null && cachedFile.rootTagName.compareToIgnoreCase(this.componentName) == 0) {
                component = new SetupItem();
                component.fileName = filename;
                component.name = cachedFile.rootName;
                if (component.name == null || component.name.length() == 0) {
                    throw new HardwareDbException("blank name for " + this.componentName + " xml file.");
                }
                component.description = cachedFile.rootDescription;
                component.connectionType = cachedFile.rootConnectionType;
                component.componentType = this.componentType;
                if (this.componentType == SetupItem.Type.DEVICE) {
                    if (cachedFile.simulation == null || cachedFile.simulation.compareToIgnoreCase("no") == 0) {
                        component.componentType = SetupItem.Type.EMU_DEVICE;
                    } else if (cachedFile.simulation.compareToIgnoreCase("only") == 0) {
                        component.componentType = SetupItem.Type.SIM_DEVICE;
                    }
                }
                if (sort) {
                    int insertPos = 1 + Collections.binarySearch(this.components, component);
                    this.components.add(Math.abs(insertPos), component);
                } else {
                    this.components.add(component);
                }
                this.componentIndex.put(file, component);
                return component;
            }
            return null;
        }

        public String toString() {
            StringBuilder text = new StringBuilder(this.componentName);
            text.replace(0, 1, text.substring(0, 1).toUpperCase());
            text.append('s');
            return text.toString();
        }

        @Override
        public String getComponentName() {
            return this.componentName;
        }

        @Override
        public List<SetupItem> findComponents(IFlatSystemSetupFile setupFile) {
            ArrayList<File> instances;
            ArrayList<SetupItem> result = new ArrayList<SetupItem>(1);
            if (setupFile != null && (instances = setupFile.getInstances(this.componentName)) != null) {
                for (File include : instances) {
                    try {
                        SetupItem found = this.addToList(include);
                        if (found == null) continue;
                        result.add(found);
                    }
                    catch (HardwareDbException e) {}
                }
            }
            return result;
        }
    }

    public static interface IComponentList {
        public List<SetupItem> getComponents();

        public List<SetupItem> findComponents(IFlatSystemSetupFile var1);

        public List<SetupItem> getFilteredListOfComponents(String var1, String var2);

        public List<SetupItem> getFilteredListOfComponents(String var1, String var2, String var3);

        public SetupItem addToList(File var1) throws HardwareDbException;

        public SetupItem findComponent(String var1);

        public String getComponentName();
    }

    public static class SetupItem
    implements Comparable<SetupItem> {
        public String fileName;
        public String name;
        public String description;
        public String connectionType;
        public String isa;
        Type componentType;

        public String toString() {
            return this.name == null ? "" : this.name;
        }

        public String getDescription() {
            return this.description == null ? "" : this.description;
        }

        @Override
        public int compareTo(SetupItem obj) {
            return this.toString().compareTo(obj.toString());
        }

        static enum Type {
            CONFIGURATION,
            CONNECTION,
            CPU,
            BOARD,
            DEVICE,
            EMU_DEVICE,
            SIM_DEVICE,
            DRIVER,
            ROUTER;

        }
    }
}

