/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.HardwareDatabaseReader;
import com.ti.debug.engine.scripting.setup.XMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Tag {
    XMLParser m_pXmlParser;
    private Node m_pNode;
    private static final String[] connectionChildTagNames = new String[]{"include", "instance", "connectionType", "property", "drivers", "platform"};

    public Tag(XMLParser xmlParser, Node node) {
        this.m_pXmlParser = xmlParser;
        this.m_pNode = node;
    }

    public Tag(Tag tag, Node node) {
        this.m_pXmlParser = tag.m_pXmlParser;
        this.m_pNode = node;
    }

    public Node getFirstChild() {
        return XMLParser.GetFirstChild(this.m_pNode);
    }

    public int countChildrenByName(String name) {
        return XMLParser.CountChildrenByName(this.m_pNode, name);
    }

    public String getName() {
        return XMLParser.GetName(this.m_pNode);
    }

    public Node getParent(String nameOfParent) {
        Node result;
        for (result = this.m_pNode.getParentNode(); nameOfParent != null && result != null && XMLParser.GetName(result) != nameOfParent; result = result.getParentNode()) {
        }
        return result;
    }

    public Node getChildByName(String name, int nIndex) {
        return XMLParser.FindChildByName(this.m_pNode, name, nIndex);
    }

    public Node getChildByID(String name, String id) {
        return this.getChildByID(name, id, "id");
    }

    public Node getChildByID(String name, String id, String idAttributeName) {
        Node newChild = null;
        if (id != null && id.length() > 0) {
            newChild = this.getFirstChild();
            while (newChild != null && (name != null && name.compareTo(XMLParser.GetName(newChild)) != 0 || id.compareTo(XMLParser.GetAttributeString(newChild, idAttributeName)) != 0)) {
                newChild = XMLParser.GetNextSibling(newChild);
            }
        }
        return newChild;
    }

    public int getChildIndexByID(String name, String id, String idAttributeName) {
        int i = -1;
        if (id != null && id.length() > 0) {
            Node newChild = this.getFirstChild();
            while (newChild != null) {
                if (name == null || name.compareTo(XMLParser.GetName(newChild)) == 0) {
                    ++i;
                    if (id.compareToIgnoreCase(XMLParser.GetAttributeString(newChild, idAttributeName)) == 0) {
                        return i;
                    }
                }
                newChild = XMLParser.GetNextSibling(newChild);
            }
        }
        return -1;
    }

    public Node createChild(String name, String id, String version) {
        return this.createChild(name, id, version, null);
    }

    public Node createChild(String name, String id, String version, Node insertBefore) {
        if (insertBefore == null && this.getName().compareTo("connection") == 0) {
            int i = connectionChildTagNames.length;
            while (i-- > 0 && name.compareTo(connectionChildTagNames[i]) != 0) {
                Node nextInsertBefore = this.getChildByName(connectionChildTagNames[i], 0);
                insertBefore = nextInsertBefore == null ? insertBefore : nextInsertBefore;
            }
        }
        Node child = this.m_pXmlParser.CreateEntityNode(name);
        if (id != null) {
            this.m_pXmlParser.SetAttribute(child, "id", id);
        }
        if (version != null) {
            this.m_pXmlParser.SetAttribute(child, "XML_version", version);
        }
        this.m_pNode.insertBefore(child, insertBefore);
        return child;
    }

    public Node createChild(String name, int instance, String version) {
        return this.createChild(name, name + '_' + Integer.toString(instance), version);
    }

    public Node getProperty(String name) {
        int n = XMLParser.CountChildrenByName(this.m_pNode, "property");
        for (int i = 0; i < n; ++i) {
            Node child = XMLParser.FindChildByName(this.m_pNode, "property", i);
            if (XMLParser.GetAttributeString(child, "id").compareTo(name) != 0 && XMLParser.GetAttributeString(child, "Name").compareTo(name) != 0) continue;
            return child;
        }
        return null;
    }

    public long getPropertyInteger(String name, long defaultValue) {
        long value = defaultValue;
        Node child = this.getProperty(name);
        if (child != null) {
            try {
                String sValue = XMLParser.GetAttributeString(child, "Value");
                value = sValue.startsWith("0x") ? Long.parseLong(sValue.substring(2), 16) : Long.parseLong(sValue);
            }
            catch (NumberFormatException e) {
                value = 0L;
            }
        }
        return value;
    }

    public boolean setPropertyInteger(String name, long value, long defaultValue) {
        if (value != defaultValue) {
            this.setProperty(name, "numericfield", value > 256L ? Long.toHexString(value) : Long.toString(value), null);
            return true;
        }
        return false;
    }

    public String getPropertyString(String name, String defaultValue) {
        return this.getProperty(name, "stringfield", defaultValue);
    }

    public boolean setPropertyString(String name, String value, String defaultValue) {
        return this.setProperty(name, "stringfield", value, defaultValue);
    }

    public String getPropertyFile(String name, String defaultValue) {
        return this.getProperty(name, "filepathfield", defaultValue);
    }

    public boolean setPropertyFile(String name, String value, String defaultValue) {
        return this.setProperty(name, "filepathfield", value, defaultValue);
    }

    public String getProperty(String name, String type, String defaultValue) {
        String value = defaultValue;
        Node child = this.getProperty(name);
        if (child != null) {
            value = XMLParser.GetAttributeString(child, "Value");
        }
        return value;
    }

    boolean setProperty(String name, String type, String value, String defaultValue) {
        value = value.trim();
        if (defaultValue == null || value != defaultValue) {
            Node child = this.getProperty(name);
            if (child == null) {
                child = this.m_pXmlParser.CreateEntityNode("property");
                this.m_pNode.appendChild(child);
                this.m_pXmlParser.SetAttribute(child, "id", name);
                this.m_pXmlParser.SetAttribute(child, "Type", type);
            }
            this.m_pXmlParser.SetAttribute(child, "Value", value);
            return true;
        }
        return false;
    }

    public String getAttribute(String name) {
        return this.getChildAttribute(null, name);
    }

    public void setAttribute(Node node, String attrName, String attrValue) {
        this.m_pXmlParser.SetAttribute(node, attrName, attrValue);
    }

    public void setAttribute(String name, String value) {
        this.setChildAttribute(null, name, value);
    }

    public String getChildAttribute(String childName, String attrName) {
        Node child;
        String value = "";
        Node node = child = childName == null ? this.m_pNode : XMLParser.FindChildByName(this.m_pNode, childName);
        if (child != null) {
            value = XMLParser.GetAttributeString(child, attrName);
        }
        return value;
    }

    public void setChildAttribute(String childName, String attrName, String value) {
        if (value != null) {
            Node child;
            Node node = child = childName == null ? this.m_pNode : XMLParser.FindChildByName(this.m_pNode, childName);
            if (child == null) {
                if (value.length() > 1 || value.length() == 1 && value.charAt(0) != ' ') {
                    return;
                }
                child = this.m_pXmlParser.CreateEntityNode(childName);
                this.m_pNode.appendChild(child);
            }
            this.m_pXmlParser.SetAttribute(child, attrName, value);
        }
    }

    public Long getAttributeInteger(String attrName) {
        return this.getAttributeInteger(attrName, 0L);
    }

    public Long getAttributeInteger(String attrName, Long defaultValue) {
        try {
            String attrValue = this.getAttribute(attrName);
            if (attrValue.length() == 0) {
                return defaultValue;
            }
            if (attrValue.startsWith("0x")) {
                return Long.parseLong(attrValue.substring(2), 16);
            }
            return Long.parseLong(attrValue);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public File getAttributeFile(String attrName, String curDirectory, String[] rootDirectories) {
        String filename = this.getAttribute(attrName);
        if (filename != null && filename.length() > 0) {
            File file = new File(filename);
            file = HardwareDatabaseReader.convertToAbsPath(file, curDirectory, rootDirectories);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            return file;
        }
        return null;
    }

    public void setAttributeInteger(String attrName, long nValue) {
        this.setAttribute(attrName, nValue > 256L ? "0x" + Long.toHexString(nValue) : Long.toString(nValue));
    }

    public String getPropertyAttribute(String name, String attrName, String defaultValue) {
        String value = defaultValue;
        Node property = this.getProperty(name);
        if (property != null) {
            value = XMLParser.GetAttributeString(property, attrName);
        }
        return value;
    }

    public boolean setPropertyAttribute(String name, String attrName, String value, String defaultValue) {
        if (value.compareTo(defaultValue) != 0) {
            Node property = this.getProperty(name);
            if (property == null) {
                property = this.m_pXmlParser.CreateEntityNode("property");
                this.m_pNode.appendChild(property);
                this.m_pXmlParser.SetAttribute(property, "id", name);
            }
            this.m_pXmlParser.SetAttribute(property, attrName, value);
            return true;
        }
        return false;
    }

    void writeXMLDocument(String fileName) {
        if (this.m_pXmlParser != null) {
            try {
                this.writeXMLDocument(new FileOutputStream(fileName));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    void writeXMLDocument(OutputStream output) {
        if (this.m_pXmlParser != null) {
            try {
                this.m_pXmlParser.WriteDocument(output);
                output.flush();
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("<");
        result.append(this.getName());
        NamedNodeMap attributes = this.m_pNode.getAttributes();
        int nAttributes = attributes.getLength();
        for (int i = 0; i < nAttributes; ++i) {
            result.append(" ");
            Node attribute = attributes.item(i);
            result.append(attribute.getNodeName());
            result.append("=\"");
            result.append(attribute.getNodeValue());
            result.append("\"");
        }
        result.append(">");
        return result.toString();
    }

    public Node getNode() {
        return this.m_pNode;
    }

    public void copyAttribute(Tag from, String attrName) {
        this.copyAttribute(from, attrName, null, null);
    }

    public void copyAttribute(Tag from, String attrName, String curDirectory, String[] rootDirectories) {
        Node attribute;
        NamedNodeMap attributes = from.m_pNode.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(attrName)) != null) {
            String attrValue = attribute.getNodeValue();
            if (curDirectory != null && rootDirectories != null) {
                String type;
                if (attrName.compareTo("file") == 0) {
                    attrValue = HardwareDatabaseReader.convertToAbsPath(new File(attrValue), curDirectory, rootDirectories).getPath();
                } else if (attrName.compareTo("Value") == 0 && (type = from.getAttribute("Type")) != null && type.compareTo("filepathfield") == 0) {
                    attrValue = HardwareDatabaseReader.convertToAbsPath(new File(attrValue), curDirectory, rootDirectories).getPath();
                }
            }
            this.m_pXmlParser.SetAttribute(this.m_pNode, attrName, attrValue);
        }
    }
}

