/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.scripting.setup;

import com.ti.debug.engine.scripting.setup.HardwareDbException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser {
    private Document m_pWorkingDoc;

    public Node CreateStringNode(String name, String value) {
        Element newNode = this.m_pWorkingDoc.createElement(name);
        Text textNode = this.m_pWorkingDoc.createTextNode(value);
        newNode.appendChild(textNode);
        return newNode;
    }

    public Node CreateIntegerNode(String name, long value) {
        return this.CreateStringNode(name, Long.toString(value));
    }

    public Node CreateBooleanNode(String name, boolean value) {
        return this.CreateIntegerNode(name, value ? 1L : 0L);
    }

    public Node CreateEntityNode(String name) {
        return this.m_pWorkingDoc.createElement(name);
    }

    public Node CreateNewDocument(String docName) {
        try {
            this.createDocument(null, null);
            return this.m_pWorkingDoc.appendChild(this.m_pWorkingDoc.createElement(docName));
        }
        catch (HardwareDbException e) {
            return null;
        }
    }

    public static String GetName(Node element) {
        return element.getNodeName();
    }

    public static String GetStringValue(Node elementWithStringValue) {
        Node textChild = XMLParser.GetFirstChild(elementWithStringValue);
        String str = null;
        if (textChild != null) {
            str = textChild.getNodeValue();
        }
        return str;
    }

    public static long GetIntegerValue(Node elementWithIntegerValue) {
        Node textChild = XMLParser.GetFirstChild(elementWithIntegerValue);
        return Integer.parseInt(textChild.getNodeValue());
    }

    public static boolean GetBooleanValue(Node elementWithIntegerValue) {
        return 0L != XMLParser.GetIntegerValue(elementWithIntegerValue);
    }

    public static Node GetFirstChild(Node elementWithChild) {
        Node child;
        for (child = elementWithChild.getFirstChild(); child != null && 8 == child.getNodeType(); child = child.getNextSibling()) {
        }
        return child;
    }

    public static Node GetNextSibling(Node elementWithSibling) {
        Node sibling;
        for (sibling = elementWithSibling.getNextSibling(); sibling != null && 8 == sibling.getNodeType(); sibling = sibling.getNextSibling()) {
        }
        return sibling;
    }

    public static int CountChildrenByName(Node elementWithChildren, String pszNameOfChildrenToCount) {
        Node child = XMLParser.GetFirstChild(elementWithChildren);
        int count = 0;
        while (child != null) {
            if (XMLParser.GetName(child) == pszNameOfChildrenToCount) {
                ++count;
            }
            child = XMLParser.GetNextSibling(child);
        }
        return count;
    }

    public static Node FindChildByName(Node elementWithChildren, String pszNameOfChild) {
        return XMLParser.FindChildByName(elementWithChildren, pszNameOfChild, 0);
    }

    public static Node FindChildByName(Node elementWithChildren, String pszNameOfChild, int n) {
        Node child = XMLParser.GetFirstChild(elementWithChildren);
        while (child != null && (XMLParser.GetName(child) != pszNameOfChild || n-- != 0)) {
            child = XMLParser.GetNextSibling(child);
        }
        return child;
    }

    public void SetAttribute(Node elementWithAttribute, String name, String value) {
        Attr attribute = this.m_pWorkingDoc.createAttribute(name);
        attribute.setValue(value);
        elementWithAttribute.getAttributes().setNamedItem(attribute);
    }

    public static String GetAttributeString(Node elementWithAttribute, String name) {
        NamedNodeMap attributes = elementWithAttribute.getAttributes();
        if (attributes != null) {
            Node attribute = attributes.getNamedItem(name);
            String str = attribute == null ? "" : attribute.getNodeValue();
            return str;
        }
        return "";
    }

    public Node GetDocumentElement() {
        return this.m_pWorkingDoc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ParseAndValidate(String pszFileName, String pszXsdName) throws HardwareDbException {
        try {
            FileInputStream xmlFile = new FileInputStream(pszFileName);
            try {
                this.createDocument(new InputSource(xmlFile), pszXsdName);
            }
            finally {
                ((InputStream)xmlFile).close();
            }
        }
        catch (FileNotFoundException e) {
            throw new HardwareDbException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new HardwareDbException(e.getLocalizedMessage());
        }
    }

    public void ParseAndValidate(InputSource xmlInput, String pszXsdName) throws HardwareDbException {
        this.createDocument(xmlInput, pszXsdName);
    }

    public static String Validate(String xmlFileName, String xsdFileName) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File schemaLocation = new File(xsdFileName);
        Schema schema = factory.newSchema(schemaLocation);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(xmlFileName);
        try {
            validator.validate(source);
            return null;
        }
        catch (SAXException ex) {
            return ex.getMessage();
        }
        catch (IOException e) {
            return "IOException - " + e.getMessage();
        }
    }

    private void createDocument(InputSource xmlFileName, String pszXsdName) throws HardwareDbException {
        try {
            this.m_pWorkingDoc = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setIgnoringElementContentWhitespace(false);
            if (pszXsdName != null) {
                SchemaFactory schemafactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource schemaFile = new StreamSource(new File(pszXsdName));
                Schema schema = schemafactory.newSchema(schemaFile);
                factory.setSchema(schema);
            }
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                }

                @Override
                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public void warning(SAXParseException err) throws SAXParseException {
                    System.out.println("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println("   " + err.getMessage());
                }
            });
            this.m_pWorkingDoc = xmlFileName != null ? parser.parse(xmlFileName) : parser.newDocument();
        }
        catch (SAXParseException exception) {
            throw new HardwareDbException(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber());
        }
        catch (SAXException sxe) {
            throw new HardwareDbException(sxe.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new HardwareDbException(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new HardwareDbException(ioe.getLocalizedMessage());
        }
    }

    void WriteDocument(OutputStream xmlFile) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("indent-number", 4);
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.m_pWorkingDoc);
            StreamResult result = new StreamResult(new OutputStreamWriter(xmlFile));
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            System.out.println("* Transformer Factory error");
            System.out.println("  " + tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            System.out.println("* Transformation error");
            System.out.println("  " + te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
    }
}

