/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.tracing;

import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IServerObject;
import com.ti.debug.engine.tracing.ITraceController;
import com.ti.debug.engine.tracing.TraceNotifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TraceManager {
    public static final TraceManager INSTANCE = new TraceManager();
    private List<IServerObject> serverObjects = Collections.synchronizedList(new LinkedList());
    private Map<IServerObject, StackTraceElement[]> serverObjectDebugInfos = Collections.synchronizedMap(new IdentityHashMap());
    private TraceNotifier traceNotifier = new TraceNotifier();
    private ITraceController controller;

    private TraceManager() {
    }

    public TraceNotifier getTraceNotifier() {
        return this.traceNotifier;
    }

    public void setController(ITraceController controller) {
        this.controller = controller;
    }

    public boolean isOptionEnabled(String option) {
        if (this.controller == null) {
            return false;
        }
        return this.controller.isOptionEnabled(option);
    }

    public void print(String traceOutput) {
        this.controller.getTraceStream().print(traceOutput);
    }

    public void println(String traceOutput) {
        this.controller.getTraceStream().println(traceOutput);
    }

    public void registerServerObjectCreation(IServerObject serverObject) {
        this.serverObjects.add(serverObject);
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        int length = Math.min(10, elements.length);
        StackTraceElement[] stackEls = new StackTraceElement[length];
        for (int i = 0; i < length; ++i) {
            stackEls[i] = elements[i];
        }
        this.serverObjectDebugInfos.put(serverObject, stackEls);
    }

    public void registerServerObjectDisposal(IServerObject serverObject) {
        this.serverObjects.remove(serverObject);
        this.serverObjectDebugInfos.remove(serverObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpServerObjectCounts() {
        final class IntegerObject {
            public int i = 1;

            IntegerObject() {
            }
        }
        IntegerObject intObject;
        HashMap<String, IntegerObject> objectCounts = new HashMap<String, IntegerObject>();
        LinkedHashSet<IServerObject> serverObjectsCopy = null;
        List<IServerObject> list = this.serverObjects;
        synchronized (list) {
            serverObjectsCopy = new LinkedHashSet<IServerObject>(this.serverObjects);
        }
        for (IServerObject serverObject : serverObjectsCopy) {
            String className = serverObject.getClass().getName();
            if (objectCounts.containsKey(className)) {
                intObject = (IntegerObject)objectCounts.get(className);
                ++intObject.i;
                continue;
            }
            objectCounts.put(className, new IntegerObject());
        }
        StringBuffer buf = new StringBuffer();
        Object[] keys = objectCounts.keySet().toArray();
        if (keys.length > 0) {
            for (int key = 0; keys != null && key < keys.length; ++key) {
                intObject = (IntegerObject)objectCounts.get(keys[key]);
                buf.append(keys[key] + " = " + intObject.i + "\n");
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpServerObjectOrigins(boolean showDetail) {
        StringBuffer buf = new StringBuffer();
        LinkedHashMap<IServerObject, StackTraceElement[]> serverObjectDebugInfosCopy = null;
        Map<IServerObject, StackTraceElement[]> map = this.serverObjectDebugInfos;
        synchronized (map) {
            serverObjectDebugInfosCopy = new LinkedHashMap<IServerObject, StackTraceElement[]>(this.serverObjectDebugInfos);
        }
        for (StackTraceElement[] elements : serverObjectDebugInfosCopy.values()) {
            if (showDetail) {
                for (int element = 0; element < elements.length; ++element) {
                    for (int nTab = 0; nTab < element; ++nTab) {
                        if (nTab == 0) {
                            buf.append("|");
                        }
                        buf.append("-");
                    }
                    buf.append(TraceManager.constructObjectStackframeMsg(elements[element]) + "\n");
                }
                buf.append("\n");
                continue;
            }
            buf.append(TraceManager.constructObjectStackframeMsg(elements[elements.length - 1]) + "\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAll(IApplication coApplication) {
        String COMDumpString = this.dumpServerObjectCounts();
        if (COMDumpString.length() != 0) {
            System.out.println("COM object leak detected...\n");
            COMDumpString = COMDumpString + "\n" + INSTANCE.dumpServerObjectOrigins(true) + "\n";
            System.out.println(COMDumpString);
        }
        LinkedHashSet<IServerObject> serverObjectsCopy = null;
        List<IServerObject> list = this.serverObjects;
        synchronized (list) {
            serverObjectsCopy = new LinkedHashSet<IServerObject>(this.serverObjects);
        }
        Iterator it = serverObjectsCopy.iterator();
        while (it.hasNext()) {
            IServerObject next = (IServerObject)it.next();
            if (next == coApplication) continue;
            it.remove();
        }
        this.serverObjects.clear();
    }

    private static String constructObjectStackframeMsg(StackTraceElement element) {
        String filename = element.getFileName();
        int lineNumber = element.getLineNumber();
        String className = element.getClassName();
        String methodName = element.getMethodName();
        return filename + ", line " + Integer.toString(lineNumber) + " {" + className + "::" + methodName + "}" + ")";
    }
}

