/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.tracing;

import com.ti.debug.engine.tracing.ITraceListener;
import java.util.LinkedHashSet;
import java.util.Set;

public class TraceNotifier {
    private Set<ITraceListener> listeners = new LinkedHashSet<ITraceListener>();

    public synchronized void addTraceListener(ITraceListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeTraceListener(ITraceListener listener) {
        this.listeners.remove(listener);
    }

    public boolean anyListenersRegistered() {
        return !this.listeners.isEmpty();
    }

    public synchronized void fireTraceOutput(String output) {
        for (ITraceListener listener : this.listeners) {
            listener.handleTraceOutput(output);
        }
    }
}

