/*
 * Decompiled with CFR 0.152.
 */
package com.ti.debug.engine.xpcom;

import com.ti.debug.engine.cce.IXPCOMRuntime;
import com.ti.utility.filesystem.FSUtil;
import com.ti.utility.filesystem.SWIGTYPE_p_FSUtil;
import com.ti.xpcom.Mozilla;
import com.ti.xpcom.XPCOMException;
import com.ti.xpcom.interfaces.nsIComponentManager;
import com.ti.xpcom.interfaces.nsISupports;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;

public class Runtime
implements IXPCOMRuntime {
    private static Runtime instance = null;
    private static SWIGTYPE_p_FSUtil fsutil_instance = null;
    private Mozilla cachedRuntime = null;
    private String cachedRuntimePath = null;
    static boolean preXPCOMInitRun = false;

    public static synchronized Runtime getInstance() {
        if (null == instance) {
            instance = new Runtime();
        }
        return instance;
    }

    public static synchronized SWIGTYPE_p_FSUtil getFSUtil() {
        if (null == fsutil_instance) {
            String runtimeLocation = Runtime.getRuntimeLocation();
            Runtime.getInstance().preXPCOMInit(new File(runtimeLocation));
            if (System.getProperty("os.name").contains("Windows")) {
                System.load(runtimeLocation + "/../../common/bin/fsutiljni.dll");
            } else {
                System.load(runtimeLocation + "/../../common/bin/libfsutiljni.so");
            }
            fsutil_instance = FSUtil.CreateFSUtil();
        }
        return fsutil_instance;
    }

    @Override
    public void setRuntimeLocation(String path) {
    }

    private static String getRuntimeLocation() {
        String path = System.getProperty("XPCOM.RUNTIME");
        if (path == null) {
            File jarPath;
            URL jarUrl = Runtime.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                jarPath = new File(jarUrl.toURI());
            }
            catch (URISyntaxException e) {
                jarPath = new File(jarUrl.getPath());
            }
            jarPath = jarPath.getParentFile();
            jarPath = jarPath.getParentFile();
            jarPath = jarPath.getParentFile();
            path = jarPath.getParentFile().getParent();
            path = path + File.separator + "bin";
        }
        return path;
    }

    private Runtime() {
    }

    private synchronized void startBare() throws IllegalArgumentException, XPCOMException {
        File runtimePath;
        String sXPCOMRuntimePath = Runtime.getRuntimeLocation();
        try {
            runtimePath = new File(sXPCOMRuntimePath);
            if (!runtimePath.exists()) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Path not found: '" + sXPCOMRuntimePath + "'");
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid path specified for XPCOM Runtime.");
        }
        if (null == this.cachedRuntime) {
            try {
                this.preXPCOMInit(runtimePath);
                this.cachedRuntime = Mozilla.getInstance();
                this.cachedRuntimePath = runtimePath.getAbsolutePath();
                this.cachedRuntime.initialize(runtimePath);
            }
            catch (RuntimeException e) {
                this.cachedRuntime = null;
                this.cachedRuntimePath = null;
                e.printStackTrace();
                throw e;
            }
        } else if (!this.cachedRuntimePath.equals(runtimePath.getAbsolutePath())) {
            throw new IllegalArgumentException("XPCOM Runtime has alread been started in \"" + this.cachedRuntimePath + "\"");
        }
    }

    @Override
    public void initialize() {
    }

    private void preXPCOMInit(File runtimePath) {
        if (!preXPCOMInitRun) {
            preXPCOMInitRun = true;
            File component = new File(runtimePath + File.separator + "LibraryLoader.dll");
            if (component.exists()) {
                System.load(component.getPath());
            }
        }
    }

    public nsISupports createComponent(String componentContractID, String componentInterfaceIID) throws IllegalArgumentException {
        this.startBare();
        nsISupports newComponent = null;
        try {
            nsIComponentManager componentManager = this.cachedRuntime.getComponentManager();
            newComponent = componentManager.createInstanceByContractID(componentContractID, null, componentInterfaceIID);
        }
        catch (XPCOMException e) {
            throw new XPCOMException("Could not createInstance(" + componentContractID + "," + componentInterfaceIID + ")" + e.getMessage());
        }
        return newComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Runtime.getInstance().startBare();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public static boolean isASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public String getAppDataDir() {
        return FSUtil.FSUtil_Get_AppData_Dir(Runtime.getFSUtil());
    }

    public String getSharedAppDataDir() {
        return FSUtil.FSUtil_Get_AppData_Dir(Runtime.getFSUtil()) + File.separator + "..";
    }
}

