/*
 * Decompiled with CFR 0.152.
 */
package com.ti.license.impl;

import com.ti.license.ILicenseAction;
import com.ti.license.impl.LicenseAction_Licensed;
import com.ti.license.impl.LicenseAction_LicensedEvaluation;
import com.ti.license.impl.LicenseAction_LicensedExtension;
import com.ti.license.impl.LicenseAction_UnlicensedAllowed;
import com.ti.license.impl.LicenseAction_UnlicensedDisallowed;
import com.ti.license.impl.LicenseAction_UnlicensedEvaluationCompleted;
import com.ti.license.impl.LicenseAction_UnlicensedInitial;
import com.ti.license.impl.LicenseException;

public abstract class LicenseAction {
    protected static final int TRIAL_DAYS = 90;
    protected static final int TRIAL_EXTENSION_DAYS = 90;
    protected static final int MIN_STANDARD_ERROR = -49999;
    protected String sRegisterURL = "http://www.ti.com/activatesoftware";
    protected String sBundleURL = "https://focus-webapps.ti.com/licreg/productactivation.tsp?toPerform=firstTimeActivation&orderablePartNumber=TMDSCCS-HWN01A&FNOPartNumber=TMDSCCS-HWN01A-v4.0";
    protected String sExtensionURL = "https://focus-webapps.ti.com/licreg/productactivation.tsp?toPerform=firstTimeActivation&orderablePartNumber=TMDFCCS-ALLT90A&FNOPartNumber=TMDFCCS-ALLT90A-v5";
    protected boolean bInitialized = false;
    protected boolean bLicensed = false;
    protected int nDaysRemaining = 0;
    protected String sDialogMessage = "";
    protected String sExtendedMessage = "";
    protected int licenseState = 3;
    protected static final int CONNECTION_ALL_FEATURE = 0;
    protected static final int ISA_ALL_FEATURE = 1;
    protected static final int LINKER_FULL_FEATURE = 2;
    protected boolean isConnectionAll = false;
    protected boolean isISAAll = false;
    protected boolean isLinkerFull = false;

    public static ILicenseAction createLicenseAction(LicenseException le) {
        if (le.getErrorCode() >= 0) {
            return new LicenseAction_Licensed(le.getErrorCode());
        }
        if (le.getFeature() == "CCS_ARM_SIM") {
            return new LicenseAction_UnlicensedDisallowed(le);
        }
        switch (le.getErrorCode()) {
            case -1: {
                return new LicenseAction_UnlicensedInitial(le);
            }
            case -21: 
            case -5: {
                return new LicenseAction_UnlicensedDisallowed(le);
            }
            case -34: 
            case -11: 
            case -10: {
                return new LicenseAction_UnlicensedEvaluationCompleted(le);
            }
        }
        return new LicenseAction_UnlicensedAllowed(le);
    }

    public static ILicenseAction createLicenseAction(int daysRemaining, String fulfillmentID, boolean isConnectionAll, boolean isISAAll, boolean isLinkerFull) {
        LicenseAction curAction = fulfillmentID.equals("CCSTUDIO4-EVAL") ? new LicenseAction_LicensedEvaluation(daysRemaining) : (daysRemaining <= 90 ? new LicenseAction_LicensedExtension(daysRemaining) : new LicenseAction_Licensed(daysRemaining));
        curAction.setLicenseType(0, isConnectionAll);
        curAction.setLicenseType(1, isISAAll);
        curAction.setLicenseType(2, isLinkerFull);
        return (ILicenseAction)((Object)curAction);
    }

    protected LicenseAction(int daysRemaining) {
        this.nDaysRemaining = daysRemaining;
    }

    protected LicenseAction(LicenseException le) {
        this.nDaysRemaining = le.getErrorCode();
        this.sExtendedMessage = this.formatExtendedMessage(le.getErrorMessage());
    }

    private String formatExtendedMessage(String message) {
        int index = message.indexOf("For further information,");
        if (index > 0) {
            return message.substring(0, index);
        }
        return message;
    }

    public boolean isInitialized() {
        return this.bInitialized;
    }

    public boolean isLicensed() {
        return this.bLicensed;
    }

    public String getDialogMessage() {
        return this.sDialogMessage;
    }

    public String getExtendedMessage() {
        return this.sExtendedMessage;
    }

    public String getStatusMessage() {
        StringBuffer result = new StringBuffer();
        if (this.bLicensed) {
            result.append("Licensed");
            if (this.nDaysRemaining > 1 && this.nDaysRemaining <= 90) {
                result.append(" : ").append(this.nDaysRemaining).append(" Days Remaining");
            } else if (this.nDaysRemaining == 1) {
                result.append(" : ").append(this.nDaysRemaining).append(" Day Remaining");
            } else if (this.nDaysRemaining == 0) {
                result.append(" : Final Day");
            }
        } else {
            result.append("Unlicensed");
        }
        return result.toString();
    }

    public String getRegisterURL() {
        return this.sRegisterURL;
    }

    public String getBundleURL() {
        return this.sBundleURL;
    }

    public String getEvalExtensionURL() {
        return this.sExtensionURL;
    }

    public int getEvalDuration() {
        return 90;
    }

    public int getEvalExtensionDuration() {
        return 90;
    }

    public int getState() {
        return this.licenseState;
    }

    public void setLicenseType(int featureType, boolean value) {
        if (featureType == 0) {
            this.isConnectionAll = value;
        } else if (featureType == 1) {
            this.isISAAll = value;
        } else if (featureType == 2) {
            this.isLinkerFull = value;
        }
    }

    public String getLicenseType() {
        String licenseType = "";
        if (this.isConnectionAll && this.isISAAll) {
            licenseType = this.nDaysRemaining <= 90 ? "Evaluation License" : "Full License";
        } else if (!this.isConnectionAll && this.isISAAll) {
            licenseType = "Free License";
        } else if (this.isConnectionAll && !this.isISAAll) {
            licenseType = "Microcontroller License";
        }
        if (!licenseType.equals("") && !this.isLinkerFull) {
            licenseType = licenseType + " - Code Size Limited";
        }
        return licenseType;
    }

    public boolean isLinkerLimited() {
        return !this.isLinkerFull;
    }

    protected static String extraDialogInformation() {
        String rtnStr = "";
        if (LicenseAction.isEnvironmentVariableSet("LM_LICENSE_FILE")) {
            rtnStr = "\n\n(NOTE: Environment variable, LM_LICENSE_FILE, detected. This can modify the default location we are searching for licenses. Please check the licensing section of the FAQ to find out more on this topic, http://processors.wiki.ti.com/index.php/FAQ_-_CCSv5)";
        } else if (LicenseAction.isEnvironmentVariableSet("TIDSPSSW_LICENSE_FILE")) {
            rtnStr = "\n\n(NOTE: Environment variable, TIDSPSSW_LICENSE_FILE, detected. This can modify the default location we are searching for licenses. Please check the licensing section of the FAQ to find out more on this topic, http://processors.wiki.ti.com/index.php/FAQ_-_CCSv5)";
        }
        return rtnStr;
    }

    private static boolean isEnvironmentVariableSet(String varName) {
        try {
            String varString = System.getenv(varName);
            return varString != null;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

