/*
 * Decompiled with CFR 0.152.
 */
package com.ti.license.impl;

import com.ti.debug.engine.IApplication;
import com.ti.debug.engine.IDspBoard;
import com.ti.debug.engine.IDspBoards;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspTasks;
import com.ti.debug.engine.IProcessorInfo;
import com.ti.debug.engine.cce.CCEDebugEngine;
import com.ti.debug.engine.events.data.IExpressionEvaluationData;
import com.ti.debug.engine.events.types.IObjectEventListener;
import com.ti.debug.engine.xpcom.Runtime;
import com.ti.license.ILicenseAction;
import com.ti.license.ILicenseManager;
import com.ti.license.impl.AComparableDisposable;
import com.ti.license.impl.LicenseAction;
import com.ti.license.impl.LicenseException;
import com.ti.utility.filesystem.DirectoryService;
import com.ti.xpcom.interfaces.dsIMdex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class LicenseManager
extends AComparableDisposable<dsIMdex>
implements ILicenseManager {
    private static volatile boolean withinTINetwork = false;
    private static final String topSecretPassword = "805D08820BCC4ee695E51C710F409C18";
    private static final String topSecretPassword2 = "1AA4AE1F902E4ffdAB606E76D0169273";
    private static final String topSecretPassword3 = "C5FE007F73CB4FD2A8BC9814EA46C2E8";
    protected static long instanceRefCnt = 0L;
    protected static ILicenseManager instance;
    private static final String NS_MDEXCONTRACTID = "@ti.com/Mdex;1";
    private static final String LICENSEFILELIST_FILE = "licenselocation.txt";
    private static final String TI_PORT = "9990";
    private static final String TI_HOST = "flames-usa8.sc.ti.com";
    private static final String GLOBAL_DEFAULT_PATH = "./ti/license";
    public static final String FEATURE_DEBUGGER = "CCS_DEBUGGER";
    public static final String FEATURE_LINKER_FULL = "CCS_LINKER_FULL";
    public static final String FEATURE_LINKER_LIMITED = "CCS_LINKER_LIMITED";
    public static final String FEATURE_ISA_ALL = "CCS_ISA_ALL";
    public static final String FEATURE_ISA_CONTROLLER = "CCS_ISA_CONTROLLER";
    public static final String FEATURE_CONNECTION_ALL = "CCS_CONNECTION_ALL";
    public static final String FEATURE_CONNECTION_RESTRICTED = "CCS_CONNECTION_RESTRICTED";
    public static final String FEATURE_ARM_SIM_MODEL = "CCS_ARM_SIM";
    public static final String FORCEREG = "FORCE.REG";
    public static final String TS_EVALUATION = "CCSTUDIO4-EVAL";
    private HashMap<String, AcquiredLicense> m_acquiredLicenses;
    private boolean m_bISANonController = false;
    private boolean m_bConnectionEmulator = false;
    private boolean m_bIsCortexA15Sim = false;
    private static boolean m_bEvalActivated;
    private int m_activationExitValue = -1;
    private static String m_sCachedErrStr;
    public static final String FAQ_URL = "http://processors.wiki.ti.com/index.php/FAQ_-_CCSv5";
    private String m_sCachedDefaultLicenseFileList = "";
    private String m_sCachedCombinedList = "";

    protected LicenseManager() {
        super((dsIMdex)Runtime.getInstance().createComponent(NS_MDEXCONTRACTID, "{35c74645-d260-4189-bce7-e021204de763}"));
        this.logMessage("lmlog.txt", "LM construction");
        this.m_acquiredLicenses = new HashMap();
        ((dsIMdex)this.wrappedObject).initialize("");
        this.logMessage("lmlog.txt", "Before iWTNC");
        this.isWithinTINetworkCheck();
        this.logMessage("lmlog.txt", "After iWTNC");
        this.m_sCachedDefaultLicenseFileList = this.readDefaultLicenseList();
        if (withinTINetwork) {
            this.activateTILicense();
        }
    }

    public void logMessage(String fileName, String message) {
        Date date = new Date();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
            out.println(new Timestamp(date.getTime()) + ": " + message + "\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(String sList) {
        this.writeLicenseList(sList);
        ((dsIMdex)this.wrappedObject).initialize(sList);
    }

    LicenseManager(dsIMdex mdex) {
        super(mdex);
    }

    public static synchronized boolean hasInstance() {
        return null != instance;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public synchronized int activateEvaluation() {
        if (m_bEvalActivated) {
            return this.m_activationExitValue;
        }
        m_bEvalActivated = true;
        String localPath = DirectoryService.instance().getLicenseDir();
        ArrayList<String> processArgs = new ArrayList<String>();
        processArgs.add(localPath + File.separator + "tiactutil");
        processArgs.add("-local");
        processArgs.add(localPath + File.separator + "ccseval.asr");
        ProcessBuilder pb = new ProcessBuilder(processArgs);
        pb.directory(new File(localPath));
        try {
            Process p = pb.start();
            this.m_activationExitValue = p.waitFor();
            InputStream processIS = p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(processIS, "UTF-8"));
            String strBuffer = reader.readLine();
            while (strBuffer != null) {
                if (strBuffer.length() > 5 && strBuffer.substring(0, 5).equals("ERROR")) {
                    int indexOfOpenBracket = strBuffer.indexOf(40);
                    String flexErrorCode = strBuffer.substring(indexOfOpenBracket + 1, strBuffer.indexOf(44, indexOfOpenBracket));
                    m_sCachedErrStr = "Error activating the evaluation license: " + this.decodeFlexErrorCode(flexErrorCode);
                    this.m_activationExitValue = -1;
                    break;
                }
                strBuffer = reader.readLine();
            }
        }
        catch (IOException e) {
            m_sCachedErrStr = "Error activating the evaluation license: The required files are either missing or corrupted.";
        }
        catch (InterruptedException e) {
            m_sCachedErrStr = "Error activating the evaluation license: Operation was unexpectedly interrupted.";
        }
        return this.m_activationExitValue;
    }

    private String decodeFlexErrorCode(String flexErrorCode) {
        String rtnStr = "Error code (" + flexErrorCode + ")";
        if (flexErrorCode.equals("50002")) {
            return rtnStr + " - Insufficient memory.";
        }
        if (flexErrorCode.equals("50012")) {
            return rtnStr + " - Corrupt or incomplete trusted storage or ASR.";
        }
        if (flexErrorCode.equals("50016")) {
            return rtnStr + " - Required file for activating evaluation license is missing.";
        }
        if (flexErrorCode.equals("50017")) {
            return rtnStr + " - Failed to add evaluation to trusted storage.";
        }
        if (flexErrorCode.equals("50021")) {
            return rtnStr + " - This evaluation has already been activated. It can only be activated once, so this request has been refused. \n\n" + "For more information on how to extend the CCS evaluation license for 90 more days, check out the Licensing section of the FAQ, " + FAQ_URL;
        }
        return rtnStr;
    }

    @Override
    public String getHostID() {
        return ((dsIMdex)this.wrappedObject).getHostID();
    }

    @Override
    public String getFulfillmentID() {
        return ((dsIMdex)this.wrappedObject).getFulfillmentID();
    }

    private String addTILicenseServerToPath(String existingPath) {
        String s = "9990@flames-usa8.sc.ti.com" + File.pathSeparatorChar;
        existingPath = s.concat(existingPath);
        return existingPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLicenseList() {
        String licenseList = "";
        String appDataDir_LicenseLocationTxt = this.toAbsolutePath(Runtime.getInstance().getSharedAppDataDir(), LICENSEFILELIST_FILE);
        File f_appDataDir = new File(appDataDir_LicenseLocationTxt);
        if (f_appDataDir.exists()) {
            BufferedReader br = null;
            try {
                FileReader fr = new FileReader(f_appDataDir);
                br = new BufferedReader(fr);
                String currentLine = br.readLine();
                while (currentLine != null) {
                    licenseList = licenseList + currentLine + File.pathSeparatorChar;
                    currentLine = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (licenseList.endsWith(File.pathSeparator)) {
            licenseList = licenseList.substring(0, licenseList.length() - 1);
        }
        return licenseList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readDefaultLicenseList() {
        String licenseList = "";
        String localDefaultPath = DirectoryService.instance().getLicenseDir();
        licenseList = licenseList + localDefaultPath + File.pathSeparatorChar;
        licenseList = licenseList + this.getGlobalDefaultLocation() + File.pathSeparatorChar;
        String installDir_LicenseLocationTxt = this.toAbsolutePath(localDefaultPath, LICENSEFILELIST_FILE);
        File f_installDir = new File(installDir_LicenseLocationTxt);
        if (f_installDir.exists()) {
            BufferedReader br = null;
            try {
                FileReader fr = new FileReader(f_installDir);
                br = new BufferedReader(fr);
                String currentLine = br.readLine();
                while (currentLine != null) {
                    String parsedLine = this.toAbsolutePath(localDefaultPath, currentLine);
                    licenseList = new File(parsedLine).exists() ? licenseList + parsedLine + File.pathSeparatorChar : licenseList + currentLine + File.pathSeparatorChar;
                    currentLine = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (withinTINetwork) {
            licenseList = this.addTILicenseServerToPath(licenseList);
        }
        if (licenseList.endsWith(File.pathSeparator)) {
            licenseList = licenseList.substring(0, licenseList.length() - 1);
        }
        return licenseList;
    }

    private String getGlobalDefaultLocation() {
        if (System.getProperty("os.name").contains("Windows")) {
            return this.toAbsolutePath("c:\\", GLOBAL_DEFAULT_PATH);
        }
        return this.toAbsolutePath(System.getProperty("user.home"), GLOBAL_DEFAULT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLicenseList(String sList) {
        File f = new File(this.toAbsolutePath(Runtime.getInstance().getSharedAppDataDir(), LICENSEFILELIST_FILE));
        if (f.exists() && !f.canWrite()) {
            return;
        }
        String[] sListArray = sList.split(File.pathSeparator);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            for (String currentLine : sListArray) {
                pw.println(currentLine);
            }
        }
        catch (FileNotFoundException e) {
        }
        finally {
            this.m_acquiredLicenses.clear();
            pw.flush();
            pw.close();
        }
    }

    @Override
    public synchronized ILicenseAction acquireLicense(String version) {
        return this.acquireLicense(version, null);
    }

    @Override
    public synchronized ILicenseAction acquireLicense(String version, Map<String, String> attribMap) {
        this.logMessage("lmlog.txt", "AL");
        m_bEvalActivated = false;
        String licenseFileList = this.readLicenseList();
        String combineList = "";
        combineList = licenseFileList.equals("") ? this.m_sCachedDefaultLicenseFileList : this.m_sCachedDefaultLicenseFileList + File.pathSeparator + licenseFileList;
        this.logMessage("lmlog.txt", "Step 1");
        if (!combineList.equals(this.m_sCachedCombinedList)) {
            ((dsIMdex)this.wrappedObject).initialize(combineList);
            this.m_sCachedCombinedList = combineList;
        }
        ((dsIMdex)this.wrappedObject).setLocation(combineList);
        this.logMessage("lmlog.txt", "Step 2");
        int debuggerDaysRemaining = 0;
        try {
            debuggerDaysRemaining = this.doActualAcquire(FEATURE_DEBUGGER, version);
        }
        catch (LicenseException e) {
            this.logMessage("lmlog.txt", "Finish AL");
            return LicenseAction.createLicenseAction(e);
        }
        this.logMessage("lmlog.txt", "Step 3");
        if (this.queryTargets(attribMap)) {
            this.logMessage("lmlog.txt", "DS available");
            int connectionDaysRemaining = 0;
            if (this.m_bIsCortexA15Sim) {
                try {
                    connectionDaysRemaining = this.doActualAcquire(FEATURE_ARM_SIM_MODEL, version);
                }
                catch (LicenseException e) {
                    this.logMessage("lmlog.txt", "Finish AL");
                    return LicenseAction.createLicenseAction(e);
                }
            }
            if (this.m_bConnectionEmulator) {
                try {
                    this.logMessage("lmlog.txt", "Step 3A");
                    connectionDaysRemaining = this.doActualAcquire(FEATURE_CONNECTION_ALL, version);
                    this.logMessage("lmlog.txt", "Step 3A2");
                }
                catch (LicenseException e) {
                    this.logMessage("lmlog.txt", "Finish AL");
                    return LicenseAction.createLicenseAction(e);
                }
            }
            boolean bNeedExtraCheck = false;
            try {
                this.logMessage("lmlog.txt", "Step 3B");
                if (((dsIMdex)this.wrappedObject).featureExists(FEATURE_CONNECTION_ALL) && ((dsIMdex)this.wrappedObject).featureExists(FEATURE_CONNECTION_RESTRICTED)) {
                    bNeedExtraCheck = true;
                    connectionDaysRemaining = this.doActualAcquire(FEATURE_CONNECTION_RESTRICTED, version);
                } else {
                    connectionDaysRemaining = ((dsIMdex)this.wrappedObject).featureExists(FEATURE_CONNECTION_ALL) ? this.doActualAcquire(FEATURE_CONNECTION_ALL, version) : (((dsIMdex)this.wrappedObject).featureExists(FEATURE_CONNECTION_RESTRICTED) ? this.doActualAcquire(FEATURE_CONNECTION_RESTRICTED, version) : this.doActualAcquire(FEATURE_CONNECTION_ALL, version));
                }
                this.logMessage("lmlog.txt", "Step 3B2");
            }
            catch (LicenseException e) {
                if (!bNeedExtraCheck) {
                    this.logMessage("lmlog.txt", "Finish AL");
                    return LicenseAction.createLicenseAction(e);
                }
                try {
                    connectionDaysRemaining = this.doActualAcquire(FEATURE_CONNECTION_ALL, version);
                }
                catch (LicenseException e2) {
                    this.logMessage("lmlog.txt", "Finish AL");
                    return LicenseAction.createLicenseAction(e2);
                }
            }
            int isaDaysRemaining = 0;
            this.logMessage("lmlog.txt", "Step 3C");
            if (this.m_bISANonController) {
                try {
                    isaDaysRemaining = this.doActualAcquire(FEATURE_ISA_ALL, version);
                }
                catch (LicenseException e) {
                    this.logMessage("lmlog.txt", "Finish AL");
                    return LicenseAction.createLicenseAction(e);
                }
            }
            if (((dsIMdex)this.wrappedObject).featureExists(FEATURE_ISA_CONTROLLER)) {
                try {
                    isaDaysRemaining = this.doActualAcquire(FEATURE_ISA_CONTROLLER, version);
                }
                catch (LicenseException e) {
                    try {
                        isaDaysRemaining = this.doActualAcquire(FEATURE_ISA_ALL, version);
                    }
                    catch (LicenseException ee) {
                        this.logMessage("lmlog.txt", "Finish AL");
                        return LicenseAction.createLicenseAction(ee);
                    }
                }
            } else {
                try {
                    isaDaysRemaining = this.doActualAcquire(FEATURE_ISA_ALL, version);
                }
                catch (LicenseException ee) {
                    this.logMessage("lmlog.txt", "Finish AL");
                    return LicenseAction.createLicenseAction(ee);
                }
            }
            this.logMessage("lmlog.txt", "Step 3C2");
            int[] dateArray = new int[]{debuggerDaysRemaining, connectionDaysRemaining, isaDaysRemaining};
            int minDate = dateArray[0];
            for (int i = 1; i < dateArray.length; ++i) {
                if (dateArray[i] >= minDate) continue;
                minDate = dateArray[i];
            }
            this.logMessage("lmlog.txt", "Step 3D");
            String fid = this.getFulfillmentID();
            this.logMessage("lmlog.txt", "Step 3E");
            boolean isConnectionAll = this.LookupFeature(FEATURE_CONNECTION_ALL);
            this.logMessage("lmlog.txt", "Step 3F");
            boolean isISAAll = this.LookupFeature(FEATURE_ISA_ALL);
            this.logMessage("lmlog.txt", "Step 3G");
            boolean isLinkerFull = this.LookupFeature(FEATURE_LINKER_FULL);
            this.logMessage("lmlog.txt", "Finish AL");
            return LicenseAction.createLicenseAction(minDate, fid, isConnectionAll, isISAAll, isLinkerFull);
        }
        this.logMessage("lmlog.txt", "Step 4");
        String fid = this.getFulfillmentID();
        this.logMessage("lmlog.txt", "Step 4.1");
        boolean isConnectionAll = this.LookupFeature(FEATURE_CONNECTION_ALL);
        this.logMessage("lmlog.txt", "Step 4.2");
        boolean isISAAll = this.LookupFeature(FEATURE_ISA_ALL);
        this.logMessage("lmlog.txt", "Step 4.3");
        boolean isLinkerFull = this.LookupFeature(FEATURE_LINKER_FULL);
        this.logMessage("lmlog.txt", "Step 5");
        this.logMessage("lmlog.txt", "Finish AL");
        return LicenseAction.createLicenseAction(debuggerDaysRemaining, fid, isConnectionAll, isISAAll, isLinkerFull);
    }

    private boolean LookupFeature(String feature) {
        if (this.m_acquiredLicenses.containsKey(feature)) {
            return true;
        }
        if (feature.equals(FEATURE_LINKER_FULL) && this.m_acquiredLicenses.containsKey(FEATURE_LINKER_LIMITED)) {
            return false;
        }
        if (feature.equals(FEATURE_LINKER_LIMITED) && this.m_acquiredLicenses.containsKey(FEATURE_LINKER_FULL)) {
            return false;
        }
        if (feature.equals(FEATURE_ISA_ALL) && this.m_acquiredLicenses.containsKey(FEATURE_ISA_CONTROLLER)) {
            return false;
        }
        if (feature.equals(FEATURE_ISA_CONTROLLER) && this.m_acquiredLicenses.containsKey(FEATURE_ISA_ALL)) {
            return false;
        }
        if (feature.equals(FEATURE_CONNECTION_ALL) && this.m_acquiredLicenses.containsKey(FEATURE_CONNECTION_RESTRICTED)) {
            return false;
        }
        if (feature.equals(FEATURE_CONNECTION_RESTRICTED) && this.m_acquiredLicenses.containsKey(FEATURE_CONNECTION_ALL)) {
            return false;
        }
        return ((dsIMdex)this.wrappedObject).featureExists(feature);
    }

    private boolean queryTargets(Map<String, String> attribMap) {
        IApplication debugServer;
        this.m_bISANonController = false;
        this.m_bConnectionEmulator = false;
        this.m_bIsCortexA15Sim = false;
        int maximumConnectionClass = 282383;
        try {
            debugServer = CCEDebugEngine.instance();
        }
        catch (Exception e) {
            return false;
        }
        if (debugServer.isConfigured()) {
            int boardCount;
            IDspBoards boards;
            try {
                boards = debugServer.getDspBoards();
            }
            catch (Exception e) {
                return false;
            }
            if (boards != null && (boardCount = boards.getCount()) > 0) {
                for (int i = 0; i < boardCount; ++i) {
                    int taskCount;
                    IDspBoard board = boards.getItem(i);
                    if (board == null) continue;
                    int connnectionClass = board.getConnectionClass();
                    IDspTasks tasks = board.getDspTasks();
                    if (tasks == null || (taskCount = tasks.getCount()) <= 0) continue;
                    for (int j = 0; j < taskCount; ++j) {
                        IDspTask task = tasks.getItem(j);
                        if (task == null) continue;
                        IProcessorInfo info = task.getProcessorInfo();
                        int family = info.getTargetFamilyID();
                        int subFamily = info.getTargetSubFamilyID();
                        int platform = info.getTargetType();
                        int targetType = info.getTargetType();
                        if (family == 470 && subFamily == 21 && targetType == 1) {
                            this.m_bIsCortexA15Sim = true;
                        }
                        if (family == 470) {
                            if (subFamily != 13 && subFamily != 14) {
                                this.m_bISANonController = true;
                            }
                        } else if (family == 320 && subFamily != 36 && subFamily != 39 && subFamily != 40) {
                            this.m_bISANonController = true;
                        }
                        if (family == 430 && attribMap != null && this.containsKeyValue(attribMap, "mdex_f", "true") && ((dsIMdex)this.wrappedObject).featureExists(FEATURE_CONNECTION_RESTRICTED) && !((dsIMdex)this.wrappedObject).featureExists(FEATURE_CONNECTION_ALL)) {
                            ExprEvalListener exprEvalListener = new ExprEvalListener();
                            task.getExpressionEvaluator().requestEvaluation("GEL_DriverString(\"mdex_f\")", exprEvalListener, false);
                            exprEvalListener.waitForEvent();
                        }
                        if (platform != 0) continue;
                        if (attribMap != null && this.containsKeyValue(attribMap, "mdex_f", "true")) {
                            this.m_bConnectionEmulator = false;
                            continue;
                        }
                        if (connnectionClass < 97 || connnectionClass >= maximumConnectionClass) {
                            this.m_bConnectionEmulator = true;
                            continue;
                        }
                        int result = connnectionClass % 97;
                        if (result == 0) continue;
                        this.m_bConnectionEmulator = true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private int doActualAcquire(String feature, String version) throws LicenseException {
        if (this.m_acquiredLicenses.containsKey(feature)) {
            return this.m_acquiredLicenses.get(feature).getDaysRemaining();
        }
        int daysRemaining = Integer.MIN_VALUE;
        try {
            daysRemaining = ((dsIMdex)this.wrappedObject).acquireLicense(feature, version);
        }
        catch (Exception e) {
            LicenseException le = new LicenseException(feature, version, daysRemaining, e.getMessage());
            throw le;
        }
        if (daysRemaining < 0) {
            String lastError = ((dsIMdex)this.wrappedObject).getLastErrorDetails();
            String hostID = this.getHostID();
            String fulfillmentID = this.getFulfillmentID();
            LicenseException le = new LicenseException(feature, version, daysRemaining, lastError, hostID, fulfillmentID);
            throw le;
        }
        AcquiredLicense acquired = new AcquiredLicense(feature, version, daysRemaining);
        if (!this.m_acquiredLicenses.containsKey(feature) && System.getProperty("NoLicenseCache") == null) {
            this.m_acquiredLicenses.put(feature, acquired);
        }
        return daysRemaining;
    }

    private synchronized String toAbsolutePath(String currentPath, String appendedPath) {
        File f = new File(appendedPath);
        if (f.isAbsolute()) {
            File parent;
            if (f.isDirectory()) {
                return appendedPath;
            }
            String parentFolderName = f.getParent();
            if (parentFolderName != null && (parent = new File(parentFolderName)).exists()) {
                return appendedPath;
            }
        }
        f = currentPath != null ? new File(currentPath + File.separator + appendedPath) : new File(appendedPath);
        try {
            String myPath = f.getCanonicalPath();
            return myPath;
        }
        catch (IOException e) {
            String myPath = f.getAbsolutePath();
            return myPath;
        }
    }

    @Override
    public String getLastError() {
        return m_sCachedErrStr;
    }

    @Override
    public boolean isWithinTINetwork() {
        return withinTINetwork;
    }

    public void isWithinTINetworkCheck() {
        String force = System.getProperty(FORCEREG);
        if (force == null) {
            this.logMessage("lmlog.txt", "FR is not defined");
            TILicenseCheck p = new TILicenseCheck();
            p.start();
            try {
                p.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logMessage("lmlog.txt", "End NC");
        } else {
            this.logMessage("lmlog.txt", "FR is defined");
        }
    }

    @Override
    public boolean activateTILicense() {
        String sHiddenFreeLicenseFileName = "LicenseHelper2";
        String fromFileName = DirectoryService.instance().getLicenseDir() + File.separator + sHiddenFreeLicenseFileName;
        String sFreeLicenseFileName = "TI_CCS_Internal_License.lic";
        String toFileName = this.toAbsolutePath(Runtime.getInstance().getSharedAppDataDir(), sFreeLicenseFileName);
        File f = new File(toFileName);
        if (!f.exists()) {
            if (!this.decryptFile(fromFileName, toFileName, topSecretPassword2)) {
                m_sCachedErrStr = "Error activating the TI License. Required files missing or corrupted.";
                return false;
            }
            String sLicenseList = this.readLicenseList();
            if (!sLicenseList.contains(toFileName)) {
                sLicenseList = sLicenseList.equals("") ? toFileName : toFileName + File.pathSeparator + sLicenseList;
                this.writeLicenseList(sLicenseList);
            }
        }
        return true;
    }

    @Override
    public boolean activateFreeLicense() {
        String sHiddenFreeLicenseFileName = "LicenseHelper1";
        String fromFileName = DirectoryService.instance().getLicenseDir() + File.separator + sHiddenFreeLicenseFileName;
        String sFreeLicenseFileName = "TI_CCS_Free_License.lic";
        String toFileName = this.toAbsolutePath(Runtime.getInstance().getSharedAppDataDir(), sFreeLicenseFileName);
        if (!this.decryptFile(fromFileName, toFileName, topSecretPassword)) {
            m_sCachedErrStr = "Error activating the Free License. Required files missing or corrupted.";
            return false;
        }
        String sLicenseList = this.readLicenseList();
        if (!sLicenseList.contains(toFileName)) {
            sLicenseList = sLicenseList.equals("") ? toFileName : toFileName + File.pathSeparator + sLicenseList;
            this.writeLicenseList(sLicenseList);
        }
        return true;
    }

    @Override
    public boolean activateCodeSizeLimitedLicense() {
        String sHiddenLicenseFileName = "LicenseHelper3";
        String fromFileName = DirectoryService.instance().getLicenseDir() + File.separator + sHiddenLicenseFileName;
        String sCodeSizeLimitedLicenseFileName = "TI_CCS_CSL_License.lic";
        String toFileName = this.toAbsolutePath(Runtime.getInstance().getSharedAppDataDir(), sCodeSizeLimitedLicenseFileName);
        if (!this.decryptFile(fromFileName, toFileName, topSecretPassword3)) {
            m_sCachedErrStr = "Error activating the Code Size Limited License. Required files missing or corrupted.";
            return false;
        }
        String sLicenseList = this.readLicenseList();
        if (!sLicenseList.contains(toFileName)) {
            sLicenseList = sLicenseList.equals("") ? toFileName : toFileName + File.pathSeparator + sLicenseList;
            this.writeLicenseList(sLicenseList);
        }
        return true;
    }

    private boolean decryptFile(String inFile, String outFile, String password) {
        try {
            byte[] output;
            int bytesRead;
            FileInputStream fileInput = new FileInputStream(inFile);
            FileOutputStream fileOutput = new FileOutputStream(outFile);
            byte[] key = password.getBytes();
            DESKeySpec desKeySpec = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey desKey = keyFactory.generateSecret(desKeySpec);
            DataInputStream din = new DataInputStream(fileInput);
            int ivSize = din.readInt();
            byte[] iv = new byte[ivSize];
            din.readFully(iv);
            IvParameterSpec ivps = new IvParameterSpec(iv);
            Cipher desCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            desCipher.init(2, (Key)desKey, ivps);
            byte[] input = new byte[64];
            while ((bytesRead = fileInput.read(input)) != -1) {
                output = desCipher.update(input, 0, bytesRead);
                if (output == null) continue;
                fileOutput.write(output);
            }
            output = desCipher.doFinal();
            if (output != null) {
                fileOutput.write(output);
            }
            fileInput.close();
            fileOutput.flush();
            fileOutput.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean containsKeyValue(Map<String, String> attribMap, String key, String value) {
        if (attribMap.containsKey(key)) {
            return attribMap.get(key).equals(value);
        }
        return false;
    }

    static {
        m_bEvalActivated = false;
        m_sCachedErrStr = "";
    }

    private class ExprEvalListener
    implements IObjectEventListener<IExpressionEvaluationData> {
        private boolean m_bExpressionEvaluated = false;

        private ExprEvalListener() {
        }

        @Override
        public synchronized void onEvent(IExpressionEvaluationData result) {
            this.m_bExpressionEvaluated = true;
            this.notify();
        }

        private synchronized void waitForEvent() {
            if (!this.m_bExpressionEvaluated) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static class TILicenseCheck
    extends Thread {
        private TILicenseCheck() {
        }

        @Override
        public void run() {
            try {
                this.logMessage("lmlog.txt", "Start LT");
                InetAddress server = InetAddress.getByName(LicenseManager.TI_HOST);
                this.logMessage("lmlog.txt", "LT1");
                withinTINetwork = server.isReachable(3000);
                this.logMessage("lmlog.txt", "LT2 = " + withinTINetwork);
                this.logMessage("lmlog.txt", "LT3");
            }
            catch (UnknownHostException e) {
                withinTINetwork = false;
            }
            catch (IOException e) {
                withinTINetwork = false;
            }
        }

        public void logMessage(String fileName, String message) {
            Date date = new Date();
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
                out.println(new Timestamp(date.getTime()) + ": " + message + "\n");
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class AcquiredLicense {
        private final String featureName;
        private final String featureVersion;
        private final int daysRemaining;

        public AcquiredLicense(String featureName, String featureVersion, int daysRemaining) {
            this.featureName = featureName;
            this.featureVersion = featureVersion;
            this.daysRemaining = daysRemaining;
        }

        public int getDaysRemaining() {
            return this.daysRemaining;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public String getFeatureVersion() {
            return this.featureVersion;
        }
    }
}

