/*
 * Decompiled with CFR 0.152.
 */
package com.ti.logger.impl;

import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.events.impl.ManagedSimpleEvent;
import com.ti.debug.engine.events.types.ISimpleEventListener;
import com.ti.debug.engine.framework.AComparableDisposable;
import com.ti.debug.engine.xpcom.Runtime;
import com.ti.logger.DSLoggerTypes;
import com.ti.logger.IDSLogger;
import com.ti.logger.IDSLoggerConfiguration;
import com.ti.xpcom.Mozilla;
import com.ti.xpcom.interfaces.dsILogger;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class DSLogger
extends AComparableDisposable<dsILogger>
implements IDSLogger,
IDSLoggerConfiguration {
    private static final String NS_DSLOGGERCODERCONTRACTID = "@ti.com/DSLogger;1";
    private EnabledCache enabledCache = new EnabledCache();
    private static WeakReference<DSLogger> instance = new WeakReference<Object>(null);

    private DSLogger() {
        super((dsILogger)Runtime.getInstance().createComponent(NS_DSLOGGERCODERCONTRACTID, "{88de5d06-9f14-4628-bc1c-9cef687a039e}"));
    }

    static DSLogger instance() {
        if (null == instance.get()) {
            instance = new WeakReference<DSLogger>(new DSLogger());
        }
        return (DSLogger)instance.get();
    }

    public static IDSLogger getLogger() {
        return DSLogger.instance();
    }

    public static IDSLoggerConfiguration getLoggerConfiguration() {
        return DSLogger.instance();
    }

    @Override
    public void log(IDspTask context, DSLoggerTypes.LogComponent eComponent, int level, DSLoggerTypes.LogMessageType eType, String msg) {
        if (this.isEnabled()) {
            Mozilla.getInstance().logMessage(eComponent.getValue(), level, eType.getValue(), msg);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.enabledCache.isCacheDirty()) {
            boolean enabled = false;
            enabled = ((dsILogger)this.wrappedObject).isEnabled();
            this.enabledCache.cacheEnableValue(enabled);
        }
        return this.enabledCache.isEnabled();
    }

    @Override
    public void enable(boolean enable) {
        if (this.enabledCache.isCacheDirty() || enable != this.enabledCache.isEnabled()) {
            this.enabledCache.markCacheDirty();
            ((dsILogger)this.wrappedObject).enable(enable);
            this.enabledCache.cacheEnableValue(enable);
        }
    }

    @Override
    public void setLogFile(File file) throws IOException {
        String absPath = "";
        if (file != null) {
            File virtStore;
            File virtRepresentation;
            String localAppData;
            File parent = file.getParentFile();
            if (!file.exists()) {
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            } else {
                if (file.isDirectory()) {
                    throw new IOException("The file specified is a directory: " + file.getAbsolutePath());
                }
                if (!file.canWrite()) {
                    throw new IOException("File is not writable: " + file.getAbsolutePath());
                }
            }
            absPath = file.getAbsolutePath();
            if (System.getProperty("os.name").contains("Windows") && null != (localAppData = System.getenv("LOCALAPPDATA")) && (virtRepresentation = new File((virtStore = new File(localAppData, "virtualStore")).getAbsolutePath() + absPath.substring(2))).exists()) {
                throw new IOException("File is not writable: " + absPath);
            }
        }
        ((dsILogger)this.wrappedObject).redirect(absPath);
    }

    @Override
    public void redirectToStdOut(boolean enable) {
        if (enable) {
            ((dsILogger)this.wrappedObject).redirect("stdout");
        } else {
            ((dsILogger)this.wrappedObject).redirect("");
        }
    }

    @Override
    public File getLogFile() {
        String logFileName = ((dsILogger)this.wrappedObject).getLogFile();
        return new File(logFileName);
    }

    @Override
    public void bufferInMemory(long bufferSize) {
        ((dsILogger)this.wrappedObject).bufferInMemory(bufferSize);
    }

    @Override
    public void writeBufferedOutput() {
        ((dsILogger)this.wrappedObject).writeBufferedOutput();
    }

    private class EnabledCache {
        private boolean isEnabledCacheDirty = true;
        private volatile boolean isEnabledCachedValue = false;
        private ManagedSimpleEvent managedEnableEvent = new ManagedSimpleEvent(((dsILogger)DSLogger.this.getWrappedObject()).onEnabledChanged());
        private ISimpleEventListener enableChangedListner = new ISimpleEventListener(){

            @Override
            public void onEvent() {
                DSLogger.this.enabledCache.markCacheDirty();
            }
        };

        private EnabledCache() {
        }

        public void cacheEnableValue(boolean value) {
            this.isEnabledCachedValue = value;
            this.isEnabledCacheDirty = false;
            this.managedEnableEvent.addISimpleEventListener(this.enableChangedListner);
        }

        public void markCacheDirty() {
            this.isEnabledCacheDirty = true;
            this.managedEnableEvent.removeISimpleEventListener(this.enableChangedListner);
        }

        public boolean isEnabled() {
            return this.isEnabledCachedValue;
        }

        public boolean isCacheDirty() {
            return this.isEnabledCacheDirty;
        }
    }
}

